/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.core;

public enum ODataVersion {
    V1("1.0"),
    V2("2.0");

    public final String asString;

    private ODataVersion(String asString) {
        this.asString = asString;
    }

    public static ODataVersion parse(String str) {
        if (ODataVersion.V1.asString.equals(str)) {
            return V1;
        }
        if (ODataVersion.V2.asString.equals(str)) {
            return V2;
        }
        throw new IllegalArgumentException("Unknown ODataVersion " + str);
    }

    public static boolean isVersionGreaterThan(ODataVersion v, ODataVersion target) {
        return v.compareTo(target) > 0;
    }

    public static boolean isVersionGreaterThanOrEqualTo(ODataVersion v, ODataVersion target) {
        return v.compareTo(target) >= 0;
    }
}

