/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.odata4j.core.Guid;
import org.odata4j.core.OCollection;
import org.odata4j.core.OObject;
import org.odata4j.core.OProperty;
import org.odata4j.core.OSimpleObject;
import org.odata4j.core.OSimpleObjects;
import org.odata4j.core.UnsignedByte;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;

public class OProperties {
    private OProperties() {
    }

    public static <T> OProperty<T> simple(String name, T value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot infer EdmType if value is null");
        }
        EdmSimpleType type = EdmSimpleType.forJavaType(value.getClass());
        if (type == null) {
            throw new IllegalArgumentException("Cannot infer EdmType for java type: " + value.getClass().getName());
        }
        return OProperties.simple(name, type, value);
    }

    public static <T> OProperty<T> simple(String name, EdmSimpleType<T> type, Object value) {
        OSimpleObject<T> simple = OSimpleObjects.create(type, value);
        return new Impl<T>(name, type, simple.getValue());
    }

    public static OProperty<?> null_(String name, EdmSimpleType<?> type) {
        return new Impl<Object>(name, type, null);
    }

    public static OProperty<?> null_(String name, String fqSimpleTypeName) {
        return new Impl<Object>(name, EdmType.getSimple(fqSimpleTypeName), null);
    }

    public static OProperty<List<OProperty<?>>> complex(String name, EdmComplexType type, List<OProperty<?>> value) {
        return new Impl(name, type, value);
    }

    public static OProperty<OCollection<? extends OObject>> collection(String name, EdmCollectionType type, OCollection<? extends OObject> value) {
        return new Impl<OCollection<? extends OObject>>(name, type, value);
    }

    public static OProperty<?> parseSimple(String name, EdmSimpleType type, String value) {
        if (type == null) {
            type = EdmSimpleType.STRING;
        }
        OSimpleObject<String> simple = OSimpleObjects.parse(type, value);
        return new Impl<String>(name, type, simple.getValue());
    }

    public static OProperty<Short> int16(String name, Short value) {
        return new Impl<Short>(name, EdmSimpleType.INT16, value);
    }

    public static OProperty<Integer> int32(String name, Integer value) {
        return new Impl<Integer>(name, EdmSimpleType.INT32, value);
    }

    public static OProperty<Long> int64(String name, Long value) {
        return new Impl<Long>(name, EdmSimpleType.INT64, value);
    }

    public static OProperty<String> string(String name, String value) {
        return new Impl<String>(name, EdmSimpleType.STRING, value);
    }

    public static OProperty<String> string(String name, char value) {
        return new Impl<String>(name, EdmSimpleType.STRING, Character.toString(value));
    }

    public static OProperty<Character> character(String name, Character value) {
        return new Impl<Character>(name, EdmSimpleType.STRING, value);
    }

    public static OProperty<Guid> guid(String name, String value) {
        return OProperties.guid(name, Guid.fromString(value));
    }

    public static OProperty<Guid> guid(String name, Guid value) {
        return new Impl<Guid>(name, EdmSimpleType.GUID, value);
    }

    public static OProperty<Boolean> boolean_(String name, Boolean value) {
        return new Impl<Boolean>(name, EdmSimpleType.BOOLEAN, value);
    }

    public static OProperty<Float> single(String name, Float value) {
        return new Impl<Float>(name, EdmSimpleType.SINGLE, value);
    }

    public static OProperty<Double> double_(String name, Double value) {
        return new Impl<Double>(name, EdmSimpleType.DOUBLE, value);
    }

    public static OProperty<LocalDateTime> datetime(String name, LocalDateTime value) {
        return new Impl<LocalDateTime>(name, EdmSimpleType.DATETIME, value);
    }

    public static OProperty<LocalDateTime> datetime(String name, Instant value) {
        return new Impl<LocalDateTime>(name, EdmSimpleType.DATETIME, value != null ? new LocalDateTime((Object)value) : null);
    }

    public static OProperty<LocalDateTime> datetime(String name, java.util.Date value) {
        return new Impl<LocalDateTime>(name, EdmSimpleType.DATETIME, value != null ? LocalDateTime.fromDateFields((java.util.Date)value) : null);
    }

    public static OProperty<LocalDateTime> datetime(String name, Calendar value) {
        return new Impl<LocalDateTime>(name, EdmSimpleType.DATETIME, value != null ? LocalDateTime.fromCalendarFields((Calendar)value) : null);
    }

    public static OProperty<LocalDateTime> datetime(String name, Timestamp value) {
        return new Impl<LocalDateTime>(name, EdmSimpleType.DATETIME, value != null ? new LocalDateTime((Object)value) : null);
    }

    public static OProperty<LocalDateTime> datetime(String name, Date value) {
        return new Impl<LocalDateTime>(name, EdmSimpleType.DATETIME, value != null ? new LocalDateTime((Object)value) : null);
    }

    public static OProperty<LocalDateTime> datetime(String name, Time value) {
        return new Impl<LocalDateTime>(name, EdmSimpleType.DATETIME, value != null ? new LocalDateTime((Object)value) : null);
    }

    public static OProperty<DateTime> datetimeOffset(String name, DateTime value) {
        return new Impl<DateTime>(name, EdmSimpleType.DATETIMEOFFSET, value);
    }

    public static OProperty<LocalTime> time(String name, LocalTime value) {
        return new Impl<LocalTime>(name, EdmSimpleType.TIME, value);
    }

    public static OProperty<LocalTime> time(String name, java.util.Date value) {
        return new Impl<LocalTime>(name, EdmSimpleType.TIME, value != null ? LocalTime.fromDateFields((java.util.Date)value) : null);
    }

    public static OProperty<LocalTime> time(String name, Calendar value) {
        return new Impl<LocalTime>(name, EdmSimpleType.TIME, value != null ? LocalTime.fromCalendarFields((Calendar)value) : null);
    }

    public static OProperty<LocalTime> time(String name, Timestamp value) {
        return new Impl<LocalTime>(name, EdmSimpleType.TIME, value != null ? new LocalTime((Object)value) : null);
    }

    public static OProperty<LocalTime> time(String name, Time value) {
        return new Impl<LocalTime>(name, EdmSimpleType.TIME, value != null ? new LocalTime((Object)value) : null);
    }

    public static OProperty<BigDecimal> decimal(String name, BigDecimal value) {
        return new Impl<BigDecimal>(name, EdmSimpleType.DECIMAL, value);
    }

    public static OProperty<BigDecimal> decimal(String name, BigInteger value) {
        return new Impl<Object>(name, EdmSimpleType.DECIMAL, (value != null ? BigDecimal.valueOf(value.longValue()) : null));
    }

    public static OProperty<BigDecimal> decimal(String name, long value) {
        return new Impl<BigDecimal>(name, EdmSimpleType.DECIMAL, BigDecimal.valueOf(value));
    }

    public static OProperty<BigDecimal> decimal(String name, double value) {
        return new Impl<BigDecimal>(name, EdmSimpleType.DECIMAL, BigDecimal.valueOf(value));
    }

    public static OProperty<byte[]> binary(String name, byte[] value) {
        return new Impl<byte[]>(name, EdmSimpleType.BINARY, value);
    }

    public static OProperty<Byte[]> binary(String name, Byte[] value) {
        return new Impl<Byte[]>(name, EdmSimpleType.BINARY, value);
    }

    public static OProperty<UnsignedByte> byte_(String name, UnsignedByte value) {
        return new Impl<UnsignedByte>(name, EdmSimpleType.BYTE, value);
    }

    public static OProperty<Byte> sbyte_(String name, byte value) {
        return new Impl<Byte>(name, EdmSimpleType.SBYTE, value);
    }

    private static class Impl<T>
    implements OProperty<T> {
        private final String name;
        private final EdmType type;
        private final T value;

        Impl(String name, EdmType type, T value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public EdmType getType() {
            return this.type;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("OProperty[%s,%s,%s]", this.name, this.getType(), OSimpleObjects.getValueDisplayString(this.value));
        }
    }
}

