/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.cxf.consumer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.core4j.Enumerable;
import org.odata4j.consumer.AbstractODataClient;
import org.odata4j.consumer.ODataClientRequest;
import org.odata4j.consumer.ODataClientResponse;
import org.odata4j.consumer.behaviors.OClientBehavior;
import org.odata4j.consumer.behaviors.OClientBehaviors;
import org.odata4j.core.ODataHttpMethod;
import org.odata4j.core.OError;
import org.odata4j.core.Throwables;
import org.odata4j.cxf.consumer.CxfClientResponse;
import org.odata4j.exceptions.ODataProducerException;
import org.odata4j.exceptions.ODataProducerExceptions;
import org.odata4j.format.Entry;
import org.odata4j.format.FormatParserFactory;
import org.odata4j.format.FormatType;
import org.odata4j.format.FormatWriter;
import org.odata4j.format.FormatWriterFactory;
import org.odata4j.format.SingleLink;
import org.odata4j.internal.BOMWorkaroundReader;
import org.odata4j.stax2.XMLEventReader2;
import org.odata4j.stax2.util.StaxUtil;

public class ODataCxfClient
extends AbstractODataClient {
    private final OClientBehavior[] requiredBehaviors = new OClientBehavior[]{OClientBehaviors.methodTunneling("MERGE")};
    private final OClientBehavior[] behaviors;
    private final HttpClient httpClient;

    public ODataCxfClient(FormatType type, OClientBehavior ... behaviors) {
        super(type);
        this.behaviors = Enumerable.create(this.requiredBehaviors).concat((Iterable<OClientBehavior>)Enumerable.create(behaviors)).toArray(OClientBehavior.class);
        this.httpClient = new DefaultHttpClient();
        if (System.getProperties().containsKey("http.proxyHost") && System.getProperties().containsKey("http.proxyPort")) {
            String hostName = System.getProperties().getProperty("http.proxyHost");
            String hostPort = System.getProperties().getProperty("http.proxyPort");
            HttpHost proxy = new HttpHost(hostName, Integer.parseInt(hostPort));
            this.httpClient.getParams().setParameter("http.route.default-proxy", proxy);
        }
    }

    @Override
    public Reader getFeedReader(ODataClientResponse response) {
        HttpResponse httpResponse = ((CxfClientResponse)response).getHttpResponse();
        try {
            InputStream textEntity = httpResponse.getEntity().getContent();
            return new BOMWorkaroundReader(new InputStreamReader(textEntity, "UTF-8"));
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public String requestBody(FormatType formatType, ODataClientRequest request) throws ODataProducerException {
        ODataClientResponse response = this.doRequest(formatType, request, Response.Status.OK);
        String string = this.entityToString(((CxfClientResponse)response).getHttpResponse().getEntity());
        response.close();
        return string;
    }

    @Override
    protected ODataClientResponse doRequest(FormatType reqType, ODataClientRequest request, Response.StatusType ... expectedResponseStatus) throws ODataProducerException {
        RuntimeException exception;
        UriBuilder uriBuilder = UriBuilder.fromPath(request.getUrl());
        for (String key : request.getQueryParams().keySet()) {
            uriBuilder = uriBuilder.queryParam(key, request.getQueryParams().get(key));
        }
        URI uri = uriBuilder.build(new Object[0]);
        if (this.behaviors != null) {
            for (OClientBehavior behavior : this.behaviors) {
                request = behavior.transform(request);
            }
        }
        HttpUriRequest httpRequest = this.getRequestByMethod(request.getMethod(), uri);
        String acceptHeader = "";
        for (int i = 0; i < reqType.getAcceptableMediaTypes().length; ++i) {
            acceptHeader = acceptHeader + reqType.getAcceptableMediaTypes()[i];
            if (i >= reqType.getAcceptableMediaTypes().length - 1) continue;
            acceptHeader = acceptHeader + ", ";
        }
        if (acceptHeader.length() > 0) {
            httpRequest.addHeader("Accept", acceptHeader);
        }
        for (String header : request.getHeaders().keySet()) {
            httpRequest.addHeader(header, request.getHeaders().get(header));
        }
        if (!request.getHeaders().containsKey("User-Agent")) {
            httpRequest.addHeader("User-Agent", "odata4j.org");
        }
        if (request.getPayload() != null && httpRequest instanceof HttpEntityEnclosingRequest) {
            Class payloadClass;
            HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)((Object)httpRequest);
            if (request.getPayload() instanceof Entry) {
                payloadClass = Entry.class;
            } else if (request.getPayload() instanceof SingleLink) {
                payloadClass = SingleLink.class;
            } else {
                throw new IllegalArgumentException("Unsupported payload: " + request.getPayload());
            }
            StringWriter sw = new StringWriter();
            FormatWriter<Entry> fw = FormatWriterFactory.getFormatWriter(payloadClass, null, this.getFormatType().toString(), null);
            fw.write(null, sw, (Entry)request.getPayload());
            String entityString = sw.toString();
            String contentType = request.getHeaders().containsKey("Content-Type") ? request.getHeaders().get("Content-Type") : fw.getContentType();
            try {
                StringEntity entity = new StringEntity(entityString);
                entity.setContentType(contentType);
                entityRequest.setEntity(entity);
            }
            catch (UnsupportedEncodingException e) {
                Throwables.propagate(e);
            }
        }
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.httpClient.execute(httpRequest);
        }
        catch (IOException e) {
            Throwables.propagate(e);
        }
        Response.StatusType status = Response.Status.fromStatusCode(httpResponse.getStatusLine().getStatusCode());
        if (status == null) {
            final StatusLine statusLine = httpResponse.getStatusLine();
            status = new Response.StatusType(){

                @Override
                public int getStatusCode() {
                    return statusLine.getStatusCode();
                }

                @Override
                public Response.Status.Family getFamily() {
                    return null;
                }

                @Override
                public String getReasonPhrase() {
                    return statusLine.getReasonPhrase();
                }
            };
        }
        for (Response.StatusType expStatus : expectedResponseStatus) {
            if (expStatus.getStatusCode() != status.getStatusCode()) continue;
            return new CxfClientResponse(httpResponse);
        }
        String textEntity = this.entityToString(httpResponse.getEntity());
        try {
            MediaType contentType = MediaType.valueOf(httpResponse.getEntity().getContentType().getValue());
            OError error = FormatParserFactory.getParser(OError.class, contentType, null).parse(new StringReader(textEntity));
            exception = ODataProducerExceptions.create(status, error);
        }
        catch (RuntimeException e) {
            exception = new RuntimeException(String.format("Expected status %s, found %s. Server response:", Enumerable.create(expectedResponseStatus).join(" or "), status) + "\n" + textEntity, e);
        }
        throw exception;
    }

    @Override
    protected XMLEventReader2 toXml(ODataClientResponse response) {
        HttpResponse httpResponse = ((CxfClientResponse)response).getHttpResponse();
        try {
            InputStream textEntity = httpResponse.getEntity().getContent();
            return StaxUtil.newXMLEventReader(new BOMWorkaroundReader(new InputStreamReader(textEntity, "UTF-8")));
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    private HttpUriRequest getRequestByMethod(String method, URI uri) {
        switch (ODataHttpMethod.fromString(method)) {
            case GET: {
                return new HttpGet(uri);
            }
            case PUT: {
                return new HttpPut(uri);
            }
            case POST: {
                return new HttpPost(uri);
            }
            case DELETE: {
                return new HttpDelete(uri);
            }
            case OPTIONS: {
                return new HttpOptions(uri);
            }
            case HEAD: {
                return new HttpHead(uri);
            }
        }
        throw new RuntimeException("Method unknown: " + method);
    }

    private String entityToString(HttpEntity entity) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(entity.getContent(), "UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (IOException e) {
            Throwables.propagate(e);
            return null;
        }
    }
}

