/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.edm;

import org.core4j.Func1;
import org.odata4j.core.ImmutableList;
import org.odata4j.core.Named;
import org.odata4j.edm.EdmAnnotation;
import org.odata4j.edm.EdmAssociationEnd;
import org.odata4j.edm.EdmDocumentation;
import org.odata4j.edm.EdmItem;

public class EdmAssociation
extends EdmItem {
    private final String namespace;
    private final String alias;
    private final String name;
    private final EdmAssociationEnd end1;
    private final EdmAssociationEnd end2;

    private EdmAssociation(String namespace, String alias, String name, EdmAssociationEnd end1, EdmAssociationEnd end2, EdmDocumentation doc, ImmutableList<EdmAnnotation<?>> annots) {
        super(doc, annots);
        this.namespace = namespace;
        this.alias = alias;
        this.name = name;
        this.end1 = end1;
        this.end2 = end2;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getName() {
        return this.name;
    }

    public EdmAssociationEnd getEnd1() {
        return this.end1;
    }

    public EdmAssociationEnd getEnd2() {
        return this.end2;
    }

    public String getFQNamespaceName() {
        return this.namespace + "." + this.name;
    }

    public String getFQAliasName() {
        return this.alias == null ? null : this.alias + "." + this.name;
    }

    public String toString() {
        StringBuilder rt = new StringBuilder();
        rt.append("EdmAssociation[");
        if (this.namespace != null) {
            rt.append(this.namespace + ".");
        }
        rt.append(this.name);
        if (this.alias != null) {
            rt.append(",alias=" + this.alias);
        }
        rt.append(",end1=" + this.end1);
        rt.append(",end2=" + this.end2);
        rt.append(']');
        return rt.toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static Builder newBuilder(EdmAssociation association, EdmItem.BuilderContext context) {
        return context.newBuilder(association, new Builder());
    }

    public static class Builder
    extends EdmItem.Builder<EdmAssociation, Builder>
    implements Named {
        private String namespace;
        private String alias;
        private String name;
        private EdmAssociationEnd.Builder end1;
        private EdmAssociationEnd.Builder end2;

        @Override
        Builder newBuilder(EdmAssociation association, EdmItem.BuilderContext context) {
            this.name = association.name;
            this.alias = association.alias;
            this.namespace = association.namespace;
            this.end1 = EdmAssociationEnd.newBuilder(association.end1, context);
            this.end2 = EdmAssociationEnd.newBuilder(association.end2, context);
            return this;
        }

        public EdmAssociation build() {
            return new EdmAssociation(this.namespace, this.alias, this.name, this.end1.build(), this.end2.build(), this.getDocumentation(), ImmutableList.copyOf(this.getAnnotations()));
        }

        public EdmAssociationEnd.Builder getEnd1() {
            return this.end1;
        }

        public EdmAssociationEnd.Builder getEnd2() {
            return this.end2;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getAlias() {
            return this.alias;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public String getFQNamespaceName() {
            return this.namespace + "." + this.name;
        }

        public String getFQAliasName() {
            return this.alias == null ? null : this.alias + "." + this.name;
        }

        public Builder setEnds(EdmAssociationEnd.Builder end1, EdmAssociationEnd.Builder end2) {
            this.end1 = end1;
            this.end2 = end2;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public static Func1<Builder, String> func1_getFQNamespaceName() {
            return new Func1<Builder, String>(){

                @Override
                public String apply(Builder input) {
                    return input.getFQNamespaceName();
                }
            };
        }
    }
}

