/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.edm;

import java.util.ArrayList;
import java.util.List;
import org.core4j.Enumerable;
import org.core4j.Predicate1;
import org.odata4j.core.ImmutableList;
import org.odata4j.core.ODataConstants;
import org.odata4j.core.ODataVersion;
import org.odata4j.core.OPredicates;
import org.odata4j.core.PrefixedNamespace;
import org.odata4j.edm.EdmAssociation;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmEntityContainer;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmItem;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmPropertyBase;
import org.odata4j.edm.EdmSchema;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmStructuralType;
import org.odata4j.edm.EdmType;
import org.odata4j.exceptions.NotFoundException;
import org.odata4j.internal.AndroidCompat;

public class EdmDataServices {
    public static final EdmDataServices EMPTY = new EdmDataServices(null, ImmutableList.create(new EdmSchema[0]), ImmutableList.create(new PrefixedNamespace[0]));
    private final ODataVersion version;
    private final ImmutableList<EdmSchema> schemas;
    private final ImmutableList<PrefixedNamespace> namespaces;

    protected EdmDataServices(ODataVersion version, ImmutableList<EdmSchema> schemas, ImmutableList<PrefixedNamespace> namespaces) {
        this.version = version;
        this.schemas = schemas;
        this.namespaces = namespaces;
    }

    public String getVersion() {
        return this.version != null ? this.version.asString : null;
    }

    public ImmutableList<EdmSchema> getSchemas() {
        return this.schemas;
    }

    public ImmutableList<PrefixedNamespace> getNamespaces() {
        return this.namespaces;
    }

    public EdmEntitySet getEdmEntitySet(String entitySetName) {
        EdmEntitySet ees = this.findEdmEntitySet(entitySetName);
        if (ees != null) {
            return ees;
        }
        throw new NotFoundException("EdmEntitySet " + entitySetName + " is not found");
    }

    public EdmEntitySet getEdmEntitySet(final EdmEntityType type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        EdmEntitySet ees = Enumerable.create(this.getEntitySets()).firstOrNull(new Predicate1<EdmEntitySet>(){

            @Override
            public boolean apply(EdmEntitySet input) {
                return type.equals(input.getType());
            }
        });
        if (ees != null) {
            return ees;
        }
        throw new NotFoundException("EdmEntitySet " + type.getName() + " is not found");
    }

    public EdmEntitySet findEdmEntitySet(String entitySetName) {
        for (EdmSchema schema : this.schemas) {
            for (EdmEntityContainer eec : schema.getEntityContainers()) {
                for (EdmEntitySet ees : eec.getEntitySets()) {
                    if (!ees.getName().equals(entitySetName)) continue;
                    return ees;
                }
            }
        }
        return null;
    }

    public EdmFunctionImport findEdmFunctionImport(String functionImportName) {
        for (EdmSchema schema : this.schemas) {
            for (EdmEntityContainer eec : schema.getEntityContainers()) {
                for (EdmFunctionImport efi : eec.getFunctionImports()) {
                    if (!efi.getName().equals(functionImportName)) continue;
                    return efi;
                }
            }
        }
        return null;
    }

    public EdmComplexType findEdmComplexType(String complexTypeFQName) {
        for (EdmSchema schema : this.schemas) {
            for (EdmComplexType ect : schema.getComplexTypes()) {
                if (!ect.getFullyQualifiedTypeName().equals(complexTypeFQName)) continue;
                return ect;
            }
        }
        return null;
    }

    public EdmType findEdmEntityType(String fqName) {
        for (EdmSchema schema : this.schemas) {
            for (EdmEntityType et : schema.getEntityTypes()) {
                if (!et.getFullyQualifiedTypeName().equals(fqName)) continue;
                return et;
            }
        }
        return null;
    }

    public EdmPropertyBase findEdmProperty(String propName) {
        for (EdmSchema schema : this.schemas) {
            for (EdmEntityContainer eec : schema.getEntityContainers()) {
                for (EdmEntitySet ees : eec.getEntitySets()) {
                    for (EdmNavigationProperty edmNavigationProperty : ees.getType().getNavigationProperties()) {
                        if (!edmNavigationProperty.getName().equals(propName)) continue;
                        return edmNavigationProperty;
                    }
                    for (EdmProperty edmProperty : ees.getType().getProperties()) {
                        if (!edmProperty.getName().equals(propName)) continue;
                        return edmProperty;
                    }
                }
            }
        }
        return null;
    }

    public Iterable<EdmEntityType> getEntityTypes() {
        ArrayList<EdmEntityType> rt = new ArrayList<EdmEntityType>();
        for (EdmSchema schema : this.schemas) {
            rt.addAll(schema.getEntityTypes());
        }
        return rt;
    }

    public Iterable<EdmComplexType> getComplexTypes() {
        ArrayList<EdmComplexType> rt = new ArrayList<EdmComplexType>();
        for (EdmSchema schema : this.schemas) {
            rt.addAll(schema.getComplexTypes());
        }
        return rt;
    }

    public Iterable<EdmStructuralType> getStructuralTypes() {
        return Enumerable.create(this.getEntityTypes()).cast(EdmStructuralType.class).concat((Iterable<EdmStructuralType>)Enumerable.create(this.getComplexTypes()).cast(EdmStructuralType.class));
    }

    public Iterable<EdmAssociation> getAssociations() {
        ArrayList<EdmAssociation> rt = new ArrayList<EdmAssociation>();
        for (EdmSchema schema : this.schemas) {
            rt.addAll(schema.getAssociations());
        }
        return rt;
    }

    public Iterable<EdmEntitySet> getEntitySets() {
        ArrayList<EdmEntitySet> rt = new ArrayList<EdmEntitySet>();
        for (EdmSchema schema : this.schemas) {
            for (EdmEntityContainer eec : schema.getEntityContainers()) {
                rt.addAll(eec.getEntitySets());
            }
        }
        return rt;
    }

    public EdmSchema findSchema(String namespace) {
        for (EdmSchema schema : this.schemas) {
            if (!schema.getNamespace().equals(namespace)) continue;
            return schema;
        }
        return null;
    }

    public Iterable<EdmStructuralType> getSubTypes(EdmStructuralType t) {
        return Enumerable.create(this.getStructuralTypes()).where(OPredicates.edmSubTypeOf(t));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(EdmDataServices metadata) {
        Builder builder = new Builder();
        EdmItem.BuilderContext context = new EdmItem.BuilderContext(builder);
        ArrayList<EdmSchema.Builder> schemas = new ArrayList<EdmSchema.Builder>();
        for (EdmSchema schema : metadata.schemas) {
            schemas.add(EdmSchema.newBuilder(schema, context));
        }
        return builder.setVersion(metadata.version).addSchemas(schemas).addNamespaces(metadata.namespaces);
    }

    public EdmType resolveType(String fqTypeName) {
        EdmType t = EdmType.getSimple(fqTypeName);
        if (t == null && (t = this.findEdmComplexType(fqTypeName)) == null) {
            t = this.findEdmEntityType(fqTypeName);
        }
        return t;
    }

    public static class Builder {
        private ODataVersion version = ODataConstants.DATA_SERVICE_VERSION;
        private final List<EdmSchema.Builder> schemas = new ArrayList<EdmSchema.Builder>();
        private final List<PrefixedNamespace> namespaces = new ArrayList<PrefixedNamespace>();

        public EdmDataServices build() {
            ArrayList<EdmSchema> schemas = new ArrayList<EdmSchema>(this.schemas.size());
            for (EdmSchema.Builder schema : this.schemas) {
                schemas.add(schema.build());
            }
            return new EdmDataServices(this.version, ImmutableList.copyOf(schemas), ImmutableList.copyOf(this.namespaces));
        }

        public Builder setVersion(ODataVersion version) {
            this.version = version;
            return this;
        }

        public Builder addSchemas(List<EdmSchema.Builder> schemas) {
            this.schemas.addAll(schemas);
            return this;
        }

        public Builder addNamespaces(List<PrefixedNamespace> namespaces) {
            if (namespaces != null) {
                this.namespaces.addAll(namespaces);
            }
            return this;
        }

        public Builder addSchemas(EdmSchema.Builder ... schemas) {
            for (EdmSchema.Builder schema : schemas) {
                this.schemas.add(schema);
            }
            return this;
        }

        public List<EdmSchema.Builder> getSchemas() {
            return this.schemas;
        }

        public EdmComplexType.Builder findEdmComplexType(String complexTypeFQName) {
            for (EdmSchema.Builder schema : this.schemas) {
                for (EdmComplexType.Builder ect : schema.getComplexTypes()) {
                    if (!ect.getFullyQualifiedTypeName().equals(complexTypeFQName)) continue;
                    return ect;
                }
            }
            return null;
        }

        public Iterable<EdmEntityType.Builder> getEntityTypes() {
            ArrayList<EdmEntityType.Builder> rt = new ArrayList<EdmEntityType.Builder>();
            for (EdmSchema.Builder schema : this.schemas) {
                rt.addAll(schema.getEntityTypes());
            }
            return rt;
        }

        public Iterable<EdmAssociation.Builder> getAssociations() {
            ArrayList<EdmAssociation.Builder> rt = new ArrayList<EdmAssociation.Builder>();
            for (EdmSchema.Builder schema : this.schemas) {
                rt.addAll(schema.getAssociations());
            }
            return rt;
        }

        public EdmEntityType.Builder findEdmEntityType(String fqName) {
            if (fqName == null) {
                return null;
            }
            for (EdmSchema.Builder schema : this.schemas) {
                for (EdmEntityType.Builder et : schema.getEntityTypes()) {
                    if (!fqName.equals(et.getFQAliasName()) && !et.getFullyQualifiedTypeName().equals(fqName)) continue;
                    return et;
                }
            }
            return null;
        }

        public EdmSchema.Builder findSchema(String namespace) {
            for (EdmSchema.Builder schema : this.schemas) {
                if (!schema.getNamespace().equals(namespace)) continue;
                return schema;
            }
            return null;
        }

        public EdmType.Builder<?, ?> resolveType(String fqTypeName) {
            if (fqTypeName == null || AndroidCompat.String_isEmpty(fqTypeName)) {
                return null;
            }
            EdmSimpleType<?> type = EdmType.getSimple(fqTypeName);
            EdmStructuralType.Builder builder = null;
            if (type != null) {
                builder = EdmSimpleType.newBuilder(type);
            } else {
                builder = this.findEdmEntityType(fqTypeName);
                if (builder == null) {
                    builder = this.findEdmComplexType(fqTypeName);
                }
            }
            return builder;
        }
    }
}

