/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.edm;

import org.core4j.Func;
import org.odata4j.core.ImmutableList;
import org.odata4j.core.Named;
import org.odata4j.edm.EdmAnnotation;
import org.odata4j.edm.EdmDocumentation;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmItem;

public class EdmEntitySet
extends EdmItem
implements Named {
    private final String name;
    private final Func<EdmEntityType> type;

    private EdmEntitySet(String name, Func<EdmEntityType> type, EdmDocumentation doc, ImmutableList<EdmAnnotation<?>> annots) {
        super(doc, annots);
        this.name = name;
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public EdmEntityType getType() {
        return this.type == null ? null : this.type.apply();
    }

    public String toString() {
        return String.format("EdmEntitySet[%s,%s]", this.name, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static Builder newBuilder(EdmEntitySet entitySet, EdmItem.BuilderContext context) {
        return context.newBuilder(entitySet, new Builder());
    }

    public static class Builder
    extends EdmItem.Builder<EdmEntitySet, Builder>
    implements Named {
        protected String name;
        protected String entityTypeName;
        protected EdmEntityType.Builder entityType;
        private EdmEntitySet builtEntitySet;

        @Override
        Builder newBuilder(EdmEntitySet entitySet, EdmItem.BuilderContext context) {
            this.name = entitySet.name;
            EdmEntityType et = (EdmEntityType)entitySet.type.apply();
            this.entityType = EdmEntityType.newBuilder(et, context);
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setEntityType(EdmEntityType.Builder entityType) {
            this.entityType = entityType;
            return this;
        }

        public EdmEntitySet build() {
            if (this.builtEntitySet == null) {
                this.builtEntitySet = new EdmEntitySet(this.name, this.entityType == null ? null : this.entityType.builtFunc(), this.getDocumentation(), ImmutableList.copyOf(this.getAnnotations()));
            }
            return this.builtEntitySet;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getEntityTypeName() {
            return this.entityTypeName;
        }

        public Builder setEntityTypeName(String entityTypeName) {
            this.entityTypeName = entityTypeName;
            return this;
        }
    }
}

