/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.edm;

import org.odata4j.core.ImmutableList;
import org.odata4j.core.Named;
import org.odata4j.edm.EdmAnnotation;
import org.odata4j.edm.EdmDocumentation;
import org.odata4j.edm.EdmItem;
import org.odata4j.edm.EdmPropertyBase;
import org.odata4j.edm.EdmStructuralType;
import org.odata4j.edm.EdmType;

public class EdmProperty
extends EdmPropertyBase {
    private final EdmStructuralType declaringType;
    private final EdmType type;
    private final boolean nullable;
    private final Integer maxLength;
    private final Boolean unicode;
    private final Boolean fixedLength;
    private final String storeGeneratedPattern;
    private final String concurrencyMode;
    private final CollectionKind collectionKind;
    private final String defaultValue;
    private final Integer precision;
    private final Integer scale;
    private final String fcTargetPath;
    private final String fcContentKind;
    private final String fcKeepInContent;
    private final String fcEpmContentKind;
    private final String fcEpmKeepInContent;
    private final String fcNsPrefix;
    private final String fcNsUri;
    private final String mimeType;

    private EdmProperty(EdmDocumentation documentation, ImmutableList<EdmAnnotation<?>> annotations, String name, EdmStructuralType declaringType, EdmType type, boolean nullable, Integer maxLength, Boolean unicode, Boolean fixedLength, String storeGeneratedPattern, String concurrencyMode, String fcTargetPath, String fcContentKind, String fcKeepInContent, String fcEpmContentKind, String fcEpmKeepInContent, String fcNsPrefix, String fcNsUri, CollectionKind collectionKind, String defaultValue, Integer precision, Integer scale, String mimeType) {
        super(documentation, annotations, name);
        this.declaringType = declaringType;
        this.type = type;
        this.nullable = nullable;
        this.maxLength = maxLength;
        this.unicode = unicode;
        this.fixedLength = fixedLength;
        this.storeGeneratedPattern = storeGeneratedPattern;
        this.collectionKind = collectionKind;
        this.defaultValue = defaultValue;
        this.precision = precision;
        this.scale = scale;
        this.fcTargetPath = fcTargetPath;
        this.fcContentKind = fcContentKind;
        this.fcKeepInContent = fcKeepInContent;
        this.fcEpmContentKind = fcEpmContentKind;
        this.fcEpmKeepInContent = fcEpmKeepInContent;
        this.fcNsPrefix = fcNsPrefix;
        this.fcNsUri = fcNsUri;
        this.mimeType = mimeType;
        this.concurrencyMode = concurrencyMode;
    }

    public EdmType getType() {
        return this.type;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Boolean getUnicode() {
        return this.unicode;
    }

    public Boolean getFixedLength() {
        return this.fixedLength;
    }

    public String getStoreGeneratedPattern() {
        return this.storeGeneratedPattern;
    }

    public CollectionKind getCollectionKind() {
        return this.collectionKind;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public String getFcTargetPath() {
        return this.fcTargetPath;
    }

    public String getFcContentKind() {
        return this.fcContentKind;
    }

    public String getFcKeepInContent() {
        return this.fcKeepInContent;
    }

    public String getFcEpmContentKind() {
        return this.fcEpmContentKind;
    }

    public String getFcEpmKeepInContent() {
        return this.fcEpmKeepInContent;
    }

    public String getFcNsPrefix() {
        return this.fcNsPrefix;
    }

    public String getFcNsUri() {
        return this.fcNsUri;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getConcurrencyMode() {
        return this.concurrencyMode;
    }

    public String toString() {
        return String.format("EdmProperty[%s,%s]", this.getName(), this.type);
    }

    public EdmStructuralType getDeclaringType() {
        return this.declaringType;
    }

    public static Builder newBuilder(String name) {
        return new Builder(name);
    }

    static Builder newBuilder(EdmProperty property, EdmItem.BuilderContext context) {
        return context.newBuilder(property, new Builder(property.getName()));
    }

    public static class Builder
    extends EdmPropertyBase.Builder<EdmProperty, Builder>
    implements Named {
        private EdmStructuralType declaringType;
        private EdmType type;
        private EdmType.Builder<?, ?> typeBuilder;
        private boolean nullable;
        private Integer maxLength;
        private Boolean unicode;
        private Boolean fixedLength;
        private String storeGeneratedPattern;
        private CollectionKind collectionKind = CollectionKind.NONE;
        private String defaultValue;
        private Integer precision;
        private Integer scale;
        private String fcTargetPath;
        private String fcContentKind;
        private String fcKeepInContent;
        private String fcEpmContentKind;
        private String fcEpmKeepInContent;
        private String fcNsPrefix;
        private String fcNsUri;
        private String mimeType;
        private String concurrencyMode;
        private EdmProperty builtProperty;

        private Builder(String name) {
            super(name);
        }

        @Override
        Builder newBuilder(EdmProperty property, EdmItem.BuilderContext context) {
            this.declaringType = property.declaringType;
            this.type = property.type;
            if (this.type != null && !this.type.isSimple()) {
                this.typeBuilder = EdmType.newDeferredBuilder(this.type.getFullyQualifiedTypeName(), context.getDataServices());
                this.type = null;
            }
            this.nullable = property.nullable;
            this.maxLength = property.maxLength;
            this.unicode = property.unicode;
            this.fixedLength = property.fixedLength;
            this.storeGeneratedPattern = property.storeGeneratedPattern;
            this.collectionKind = property.collectionKind;
            this.defaultValue = property.defaultValue;
            this.precision = property.precision;
            this.scale = property.scale;
            this.fcTargetPath = property.fcTargetPath;
            this.fcContentKind = property.fcContentKind;
            this.fcKeepInContent = property.fcKeepInContent;
            this.fcEpmContentKind = property.fcEpmContentKind;
            this.fcEpmKeepInContent = property.fcEpmKeepInContent;
            this.fcNsPrefix = property.fcNsPrefix;
            this.fcNsUri = property.fcNsUri;
            this.mimeType = property.mimeType;
            this.concurrencyMode = property.concurrencyMode;
            return this;
        }

        public EdmProperty build() {
            if (this.builtProperty == null) {
                EdmType type = this.type != null ? this.type : this.typeBuilder.build();
                this.builtProperty = new EdmProperty(this.getDocumentation(), ImmutableList.copyOf(this.getAnnotations()), this.getName(), this.declaringType, type, this.nullable, this.maxLength, this.unicode, this.fixedLength, this.storeGeneratedPattern, this.concurrencyMode, this.fcTargetPath, this.fcContentKind, this.fcKeepInContent, this.fcEpmContentKind, this.fcEpmKeepInContent, this.fcNsPrefix, this.fcNsUri, this.collectionKind, this.defaultValue, this.precision, this.scale, this.mimeType);
            }
            return this.builtProperty;
        }

        public Builder setType(EdmType type) {
            this.type = type;
            return this;
        }

        public Builder setType(EdmType.Builder<?, ?> type) {
            this.typeBuilder = type;
            return this;
        }

        public Builder setNullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public Builder setDeclaringType(EdmStructuralType declaringType) {
            this.declaringType = declaringType;
            return this;
        }

        public Builder setMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder setUnicode(Boolean unicode) {
            this.unicode = unicode;
            return this;
        }

        public Builder setFixedLength(Boolean fixedLength) {
            this.fixedLength = fixedLength;
            return this;
        }

        public Builder setStoreGeneratedPattern(String storeGeneratedPattern) {
            this.storeGeneratedPattern = storeGeneratedPattern;
            return this;
        }

        public Builder setFcTargetPath(String fcTargetPath) {
            this.fcTargetPath = fcTargetPath;
            return this;
        }

        public Builder setFcContentKind(String fcContentKind) {
            this.fcContentKind = fcContentKind;
            return this;
        }

        public Builder setFcKeepInContent(String fcKeepInContent) {
            this.fcKeepInContent = fcKeepInContent;
            return this;
        }

        public Builder setFcEpmContentKind(String fcEpmContentKind) {
            this.fcEpmContentKind = fcEpmContentKind;
            return this;
        }

        public Builder setFcEpmKeepInContent(String fcEpmKeepInContent) {
            this.fcEpmKeepInContent = fcEpmKeepInContent;
            return this;
        }

        public Builder setFcNsPrefix(String fcNsPrefix) {
            this.fcNsPrefix = fcNsPrefix;
            return this;
        }

        public Builder setFcNsUri(String fcNsUri) {
            this.fcNsUri = fcNsUri;
            return this;
        }

        public Builder setCollectionKind(CollectionKind collectionKind) {
            this.collectionKind = collectionKind;
            return this;
        }

        public Builder setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder setPrecision(Integer precision) {
            this.precision = precision;
            return this;
        }

        public Builder setScale(Integer scale) {
            this.scale = scale;
            return this;
        }

        public Builder setMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder setConcurrencyMode(String concurrencyMode) {
            this.concurrencyMode = concurrencyMode;
            return this;
        }

        public EdmType getType() {
            return this.type;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public Boolean getUnicode() {
            return this.unicode;
        }

        public Boolean getFixedLength() {
            return this.fixedLength;
        }

        public String getStoreGeneratedPattern() {
            return this.storeGeneratedPattern;
        }

        public CollectionKind getCollectionKind() {
            return this.collectionKind;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public Integer getPrecision() {
            return this.precision;
        }

        public Integer getScale() {
            return this.scale;
        }

        public String getFcTargetPath() {
            return this.fcTargetPath;
        }

        public String getFcContentKind() {
            return this.fcContentKind;
        }

        public String getFcKeepInContent() {
            return this.fcKeepInContent;
        }

        public String getFcEpmContentKind() {
            return this.fcEpmContentKind;
        }

        public String getFcEpmKeepInContent() {
            return this.fcEpmKeepInContent;
        }

        public String getFcNsPrefix() {
            return this.fcNsPrefix;
        }

        public String getFcNsUri() {
            return this.fcNsUri;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getConcurrencyMode() {
            return this.concurrencyMode;
        }
    }

    public static enum CollectionKind {
        NONE,
        List,
        Bag,
        Collection;

    }
}

