/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.command;

import java.util.Map;
import org.odata4j.command.Command;
import org.odata4j.command.CommandExecution;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityId;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OExtension;
import org.odata4j.core.OFunctionParameter;
import org.odata4j.core.Throwables;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmDataServicesProvider;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.producer.BaseResponse;
import org.odata4j.producer.CountResponse;
import org.odata4j.producer.EntitiesResponse;
import org.odata4j.producer.EntityIdResponse;
import org.odata4j.producer.EntityQueryInfo;
import org.odata4j.producer.EntityResponse;
import org.odata4j.producer.ODataProducer;
import org.odata4j.producer.QueryInfo;
import org.odata4j.producer.command.CallFunctionCommandContext;
import org.odata4j.producer.command.CloseCommandContext;
import org.odata4j.producer.command.CommandProducerBackend;
import org.odata4j.producer.command.CreateEntityAtPropertyCommandContext;
import org.odata4j.producer.command.CreateEntityCommandContext;
import org.odata4j.producer.command.CreateLinkCommandContext;
import org.odata4j.producer.command.DeleteEntityCommandContext;
import org.odata4j.producer.command.DeleteLinkCommandContext;
import org.odata4j.producer.command.GetEntitiesCommandContext;
import org.odata4j.producer.command.GetEntitiesCountCommandContext;
import org.odata4j.producer.command.GetEntityCommandContext;
import org.odata4j.producer.command.GetLinksCommandContext;
import org.odata4j.producer.command.GetMetadataCommandContext;
import org.odata4j.producer.command.GetMetadataProducerCommandContext;
import org.odata4j.producer.command.GetNavPropertyCommandContext;
import org.odata4j.producer.command.GetNavPropertyCountCommandContext;
import org.odata4j.producer.command.MergeEntityCommandContext;
import org.odata4j.producer.command.ProducerCommandContext;
import org.odata4j.producer.command.UpdateEntityCommandContext;
import org.odata4j.producer.command.UpdateLinkCommandContext;
import org.odata4j.producer.edm.MetadataProducer;

public class CommandProducer
implements ODataProducer {
    private final CommandProducerBackend backend;

    public CommandProducer(CommandProducerBackend backend) {
        this.backend = backend;
    }

    private <TResult, TContext extends ProducerCommandContext<TResult>> TResult executeCommand(Class<TContext> contextType, Class<TResult> resultType, TContext context) {
        Command<TContext> command = this.backend.getCommand(contextType);
        CommandExecution execution = this.backend.getCommandExecution();
        try {
            execution.execute(command, context);
            TResult result = context.getResult();
            if (result != null) {
                return result;
            }
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
        if (resultType.equals(Void.class)) {
            return null;
        }
        throw new RuntimeException("Command " + contextType.getSimpleName() + " implementation did not return result, expected " + resultType.getSimpleName());
    }

    @Override
    public EdmDataServices getMetadata() {
        return this.executeCommand(GetMetadataCommandContext.class, EdmDataServicesProvider.class, this.backend.newGetMetadataCommandContext()).getMetadata();
    }

    @Override
    public MetadataProducer getMetadataProducer() {
        return this.executeCommand(GetMetadataProducerCommandContext.class, MetadataProducer.class, this.backend.newGetMetadataProducerCommandContext());
    }

    @Override
    public EntitiesResponse getEntities(String entitySetName, QueryInfo queryInfo) {
        return this.executeCommand(GetEntitiesCommandContext.class, EntitiesResponse.class, this.backend.newGetEntitiesCommandContext(entitySetName, queryInfo));
    }

    @Override
    public CountResponse getEntitiesCount(String entitySetName, QueryInfo queryInfo) {
        return this.executeCommand(GetEntitiesCountCommandContext.class, CountResponse.class, this.backend.newGetEntitiesCountCommandContext(entitySetName, queryInfo));
    }

    @Override
    public EntityResponse getEntity(String entitySetName, OEntityKey entityKey, EntityQueryInfo queryInfo) {
        return this.executeCommand(GetEntityCommandContext.class, EntityResponse.class, this.backend.newGetEntityCommandContext(entitySetName, entityKey, queryInfo));
    }

    @Override
    public BaseResponse getNavProperty(String entitySetName, OEntityKey entityKey, String navProp, QueryInfo queryInfo) {
        return this.executeCommand(GetNavPropertyCommandContext.class, BaseResponse.class, this.backend.newGetNavPropertyCommandContext(entitySetName, entityKey, navProp, queryInfo));
    }

    @Override
    public CountResponse getNavPropertyCount(String entitySetName, OEntityKey entityKey, String navProp, QueryInfo queryInfo) {
        return this.executeCommand(GetNavPropertyCountCommandContext.class, CountResponse.class, this.backend.newGetNavPropertyCountCommandContext(entitySetName, entityKey, navProp, queryInfo));
    }

    @Override
    public void close() {
        this.executeCommand(CloseCommandContext.class, Void.class, this.backend.newCloseCommandContext());
    }

    @Override
    public EntityResponse createEntity(String entitySetName, OEntity entity) {
        return this.executeCommand(CreateEntityCommandContext.class, EntityResponse.class, this.backend.newCreateEntityCommandContext(entitySetName, entity));
    }

    @Override
    public EntityResponse createEntity(String entitySetName, OEntityKey entityKey, String navProp, OEntity entity) {
        return this.executeCommand(CreateEntityAtPropertyCommandContext.class, EntityResponse.class, this.backend.newCreateEntityAtPropertyCommandContext(entitySetName, entityKey, navProp, entity));
    }

    @Override
    public void deleteEntity(String entitySetName, OEntityKey entityKey) {
        this.executeCommand(DeleteEntityCommandContext.class, Void.class, this.backend.newDeleteEntityCommandContext(entitySetName, entityKey));
    }

    @Override
    public void mergeEntity(String entitySetName, OEntity entity) {
        this.executeCommand(MergeEntityCommandContext.class, Void.class, this.backend.newMergeEntityCommandContext(entitySetName, entity));
    }

    @Override
    public void updateEntity(String entitySetName, OEntity entity) {
        this.executeCommand(UpdateEntityCommandContext.class, Void.class, this.backend.newUpdateEntityCommandContext(entitySetName, entity));
    }

    @Override
    public EntityIdResponse getLinks(OEntityId sourceEntity, String targetNavProp) {
        return this.executeCommand(GetLinksCommandContext.class, EntityIdResponse.class, this.backend.newGetLinksCommandContext(sourceEntity, targetNavProp));
    }

    @Override
    public void createLink(OEntityId sourceEntity, String targetNavProp, OEntityId targetEntity) {
        this.executeCommand(CreateLinkCommandContext.class, Void.class, this.backend.newCreateLinkCommandContext(sourceEntity, targetNavProp, targetEntity));
    }

    @Override
    public void updateLink(OEntityId sourceEntity, String targetNavProp, OEntityKey oldTargetEntityKey, OEntityId newTargetEntity) {
        this.executeCommand(UpdateLinkCommandContext.class, Void.class, this.backend.newUpdateLinkCommandContext(sourceEntity, targetNavProp, oldTargetEntityKey, newTargetEntity));
    }

    @Override
    public void deleteLink(OEntityId sourceEntity, String targetNavProp, OEntityKey targetEntityKey) {
        this.executeCommand(DeleteLinkCommandContext.class, Void.class, this.backend.newDeleteLinkCommandContext(sourceEntity, targetNavProp, targetEntityKey));
    }

    @Override
    public BaseResponse callFunction(EdmFunctionImport name, Map<String, OFunctionParameter> params, QueryInfo queryInfo) {
        return this.executeCommand(CallFunctionCommandContext.class, BaseResponse.class, this.backend.newCallFunctionCommandContext(name, params, queryInfo));
    }

    @Override
    public <TExtension extends OExtension<ODataProducer>> TExtension findExtension(Class<TExtension> clazz) {
        return null;
    }
}

