/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.inmemory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.core4j.Enumerable;
import org.core4j.Func;
import org.core4j.Func1;
import org.core4j.Predicate1;
import org.odata4j.core.OAtomStreamEntity;
import org.odata4j.core.OCollection;
import org.odata4j.core.OCollections;
import org.odata4j.core.OComplexObject;
import org.odata4j.core.OComplexObjects;
import org.odata4j.core.OEntities;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityId;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OExtension;
import org.odata4j.core.OFunctionParameter;
import org.odata4j.core.OLink;
import org.odata4j.core.OLinks;
import org.odata4j.core.OObject;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.core.OSimpleObject;
import org.odata4j.core.OSimpleObjects;
import org.odata4j.core.OStructuralObject;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmDecorator;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmStructuralType;
import org.odata4j.edm.EdmType;
import org.odata4j.exceptions.NotFoundException;
import org.odata4j.exceptions.NotImplementedException;
import org.odata4j.expression.BoolCommonExpression;
import org.odata4j.expression.OrderByExpression;
import org.odata4j.producer.BaseResponse;
import org.odata4j.producer.CountResponse;
import org.odata4j.producer.EntitiesResponse;
import org.odata4j.producer.EntityIdResponse;
import org.odata4j.producer.EntityQueryInfo;
import org.odata4j.producer.EntityResponse;
import org.odata4j.producer.InlineCount;
import org.odata4j.producer.ODataProducer;
import org.odata4j.producer.PropertyPathHelper;
import org.odata4j.producer.QueryInfo;
import org.odata4j.producer.Responses;
import org.odata4j.producer.edm.MetadataProducer;
import org.odata4j.producer.inmemory.BeanBasedPropertyModel;
import org.odata4j.producer.inmemory.EntityIdFunctionPropertyModelDelegate;
import org.odata4j.producer.inmemory.EnumsAsStringsPropertyModelDelegate;
import org.odata4j.producer.inmemory.InMemoryComplexTypeInfo;
import org.odata4j.producer.inmemory.InMemoryEdmGenerator;
import org.odata4j.producer.inmemory.InMemoryEntityInfo;
import org.odata4j.producer.inmemory.InMemoryEvaluation;
import org.odata4j.producer.inmemory.InMemoryTypeMapping;
import org.odata4j.producer.inmemory.PropertyModel;

public class InMemoryProducer
implements ODataProducer {
    private static final boolean DUMP = false;
    public static final String ID_PROPNAME = "EntityId";
    private final String namespace;
    private final String containerName;
    private final int maxResults;
    private final Map<String, InMemoryEntityInfo<?>> eis = new LinkedHashMap();
    private final Map<String, InMemoryComplexTypeInfo<?>> complexTypes = new LinkedHashMap();
    private EdmDataServices metadata;
    private final EdmDecorator decorator;
    private final MetadataProducer metadataProducer;
    private final InMemoryTypeMapping typeMapping;
    private boolean includeNullPropertyValues = true;
    private final boolean flattenEdm;
    private static final int DEFAULT_MAX_RESULTS = 100;

    private static void dump(String msg) {
    }

    public InMemoryProducer(String namespace) {
        this(namespace, 100);
    }

    public InMemoryProducer(String namespace, int maxResults) {
        this(namespace, null, maxResults, null, null);
    }

    public InMemoryProducer(String namespace, String containerName, int maxResults, EdmDecorator decorator, InMemoryTypeMapping typeMapping) {
        this(namespace, containerName, maxResults, decorator, typeMapping, true);
    }

    public InMemoryProducer(String namespace, String containerName, int maxResults, EdmDecorator decorator, InMemoryTypeMapping typeMapping, boolean flattenEdm) {
        this.namespace = namespace;
        this.containerName = containerName != null && !containerName.isEmpty() ? containerName : "Container";
        this.maxResults = maxResults;
        this.decorator = decorator;
        this.metadataProducer = new MetadataProducer(this, decorator);
        this.typeMapping = typeMapping == null ? InMemoryTypeMapping.DEFAULT : typeMapping;
        this.flattenEdm = flattenEdm;
    }

    @Override
    public EdmDataServices getMetadata() {
        if (this.metadata == null) {
            this.metadata = this.newEdmGenerator(this.namespace, this.typeMapping, ID_PROPNAME, this.eis, this.complexTypes).generateEdm(this.decorator).build();
        }
        return this.metadata;
    }

    public String getContainerName() {
        return this.containerName;
    }

    protected InMemoryEdmGenerator newEdmGenerator(String namespace, InMemoryTypeMapping typeMapping, String idPropName, Map<String, InMemoryEntityInfo<?>> eis, Map<String, InMemoryComplexTypeInfo<?>> complexTypesInfo) {
        return new InMemoryEdmGenerator(namespace, this.containerName, typeMapping, ID_PROPNAME, eis, complexTypesInfo, this.flattenEdm);
    }

    @Override
    public MetadataProducer getMetadataProducer() {
        return this.metadataProducer;
    }

    @Override
    public void close() {
    }

    public void setIncludeNullPropertyValues(boolean value) {
        this.includeNullPropertyValues = value;
    }

    public <TEntity> void registerComplexType(Class<TEntity> complexTypeClass, String typeName) {
        this.registerComplexType(complexTypeClass, typeName, new EnumsAsStringsPropertyModelDelegate(new BeanBasedPropertyModel(complexTypeClass, this.flattenEdm)));
    }

    public <TEntity> void registerComplexType(Class<TEntity> complexTypeClass, String typeName, PropertyModel propertyModel) {
        InMemoryComplexTypeInfo i = new InMemoryComplexTypeInfo();
        i.typeName = typeName == null ? complexTypeClass.getSimpleName() : typeName;
        i.entityClass = complexTypeClass;
        i.propertyModel = propertyModel;
        this.complexTypes.put(i.typeName, i);
        this.metadata = null;
    }

    public <TEntity> void register(Class<TEntity> entityClass, String entitySetName, Func<Iterable<TEntity>> get, String ... keys) {
        this.register(entityClass, entitySetName, entitySetName, get, keys);
    }

    public <TEntity> void register(Class<TEntity> entityClass, String entitySetName, String entityTypeName, Func<Iterable<TEntity>> get, String ... keys) {
        PropertyModel model = new BeanBasedPropertyModel(entityClass, this.flattenEdm);
        model = new EnumsAsStringsPropertyModelDelegate(model);
        this.register(entityClass, model, entitySetName, entityTypeName, get, keys);
    }

    public <TEntity, TKey> void register(Class<TEntity> entityClass, Class<TKey> keyClass, String entitySetName, Func<Iterable<TEntity>> get, Func1<TEntity, TKey> id) {
        PropertyModel model = new BeanBasedPropertyModel(entityClass, this.flattenEdm);
        model = new EnumsAsStringsPropertyModelDelegate(model);
        model = new EntityIdFunctionPropertyModelDelegate<TEntity, TKey>(model, ID_PROPNAME, keyClass, id);
        this.register(entityClass, model, entitySetName, get, ID_PROPNAME);
    }

    public <TEntity, TKey> void register(Class<TEntity> entityClass, PropertyModel propertyModel, String entitySetName, Func<Iterable<TEntity>> get, String ... keys) {
        this.register(entityClass, propertyModel, entitySetName, entitySetName, get, keys);
    }

    public <TEntity> void register(Class<TEntity> entityClass, PropertyModel propertyModel, String entitySetName, String entityTypeName, Func<Iterable<TEntity>> get, String ... keys) {
        this.register(entityClass, propertyModel, entitySetName, entityTypeName, get, (Func1<RequestContext, Iterable<TEntity>>)null, keys);
    }

    public <TEntity> void register(Class<TEntity> entityClass, PropertyModel propertyModel, final String entitySetName, String entityTypeName, Func<Iterable<TEntity>> get, Func1<RequestContext, Iterable<TEntity>> getWithContext, final String ... keys) {
        InMemoryEntityInfo ei = new InMemoryEntityInfo();
        ei.entitySetName = entitySetName;
        ei.entityTypeName = entityTypeName;
        ei.properties = propertyModel;
        ei.get = get;
        ei.getWithContext = getWithContext;
        ei.keys = keys;
        ei.entityClass = entityClass;
        ei.hasStream = OAtomStreamEntity.class.isAssignableFrom(entityClass);
        ei.id = new Func1<Object, HashMap<String, Object>>(){

            @Override
            public HashMap<String, Object> apply(Object input) {
                HashMap<String, Object> values = new HashMap<String, Object>();
                for (String key : keys) {
                    values.put(key, ((InMemoryEntityInfo)((InMemoryProducer)InMemoryProducer.this).eis.get((Object)entitySetName)).properties.getPropertyValue(input, key));
                }
                return values;
            }
        };
        this.eis.put(entitySetName, ei);
        this.metadata = null;
    }

    protected InMemoryComplexTypeInfo<?> findComplexTypeInfoForClass(Class<?> clazz) {
        for (InMemoryComplexTypeInfo<?> typeInfo : this.complexTypes.values()) {
            if (!typeInfo.entityClass.equals(clazz)) continue;
            return typeInfo;
        }
        return null;
    }

    protected InMemoryEntityInfo<?> findEntityInfoForClass(Class<?> clazz) {
        for (InMemoryEntityInfo<?> typeInfo : this.eis.values()) {
            if (!typeInfo.entityClass.equals(clazz)) continue;
            return typeInfo;
        }
        return null;
    }

    protected InMemoryEntityInfo<?> findEntityInfoForEntitySet(String entitySetName) {
        for (InMemoryEntityInfo<?> typeInfo : this.eis.values()) {
            if (!typeInfo.entitySetName.equals(entitySetName)) continue;
            return typeInfo;
        }
        return null;
    }

    protected void addPropertiesFromObject(Object obj, PropertyModel propertyModel, EdmStructuralType structuralType, List<OProperty<?>> properties, PropertyPathHelper pathHelper) {
        InMemoryProducer.dump("addPropertiesFromObject: " + obj.getClass().getName());
        for (EdmProperty property : structuralType.getProperties()) {
            if (structuralType instanceof EdmEntityType && !pathHelper.isSelected(property.getName())) continue;
            Object value = propertyModel.getPropertyValue(obj, property.getName());
            InMemoryProducer.dump("  prop: " + property.getName() + " val: " + value);
            if (value == null && !this.includeNullPropertyValues) continue;
            if (property.getCollectionKind() == EdmProperty.CollectionKind.NONE) {
                if (property.getType().isSimple()) {
                    properties.add(OProperties.simple(property.getName(), (EdmSimpleType)property.getType(), value));
                    continue;
                }
                if (value == null) {
                    properties.add(OProperties.complex(property.getName(), (EdmComplexType)property.getType(), null));
                    continue;
                }
                Class<?> propType = propertyModel.getPropertyType(property.getName());
                InMemoryComplexTypeInfo<?> typeInfo = this.findComplexTypeInfoForClass(propType);
                if (typeInfo == null) continue;
                ArrayList cprops = new ArrayList();
                this.addPropertiesFromObject(value, typeInfo.getPropertyModel(), (EdmComplexType)property.getType(), cprops, pathHelper);
                properties.add(OProperties.complex(property.getName(), (EdmComplexType)property.getType(), cprops));
                continue;
            }
            Iterable<?> values = propertyModel.getCollectionValue(obj, property.getName());
            OCollection.Builder<OObject> b = OCollections.newBuilder(property.getType());
            if (values != null) {
                InMemoryComplexTypeInfo<?> typeInfo;
                Class<?> propType = propertyModel.getCollectionElementType(property.getName());
                InMemoryComplexTypeInfo<?> inMemoryComplexTypeInfo = typeInfo = property.getType().isSimple() ? null : this.findComplexTypeInfoForClass(propType);
                if (!property.getType().isSimple() && typeInfo == null) continue;
                for (Object v : values) {
                    if (property.getType().isSimple()) {
                        b.add(OSimpleObjects.create((EdmSimpleType)property.getType(), v));
                        continue;
                    }
                    ArrayList cprops = new ArrayList();
                    this.addPropertiesFromObject(v, typeInfo.getPropertyModel(), (EdmComplexType)property.getType(), cprops, pathHelper);
                    b.add(OComplexObjects.create((EdmComplexType)property.getType(), cprops));
                }
            }
            properties.add(OProperties.collection(property.getName(), new EdmCollectionType(EdmProperty.CollectionKind.Collection, property.getType()), b.build()));
        }
        InMemoryProducer.dump("done addPropertiesFromObject: " + obj.getClass().getName());
    }

    protected OEntity toOEntity(EdmEntitySet ees, Object obj, PropertyPathHelper pathHelper) {
        InMemoryEntityInfo<?> ei = this.findEntityInfoForClass(obj.getClass());
        ArrayList<OLink> links = new ArrayList<OLink>();
        ArrayList properties = new ArrayList();
        HashMap<String, Object> keyKVPair = new HashMap<String, Object>();
        for (String key : ei.getKeys()) {
            Object keyValue = ei.getPropertyModel().getPropertyValue(obj, key);
            keyKVPair.put(key, keyValue);
        }
        EdmEntityType edmEntityType = (EdmEntityType)this.getMetadata().findEdmEntityType(this.namespace + "." + ei.getEntityTypeName());
        this.addPropertiesFromObject(obj, ei.getPropertyModel(), edmEntityType, properties, pathHelper);
        for (EdmNavigationProperty navProp : edmEntityType.getNavigationProperties()) {
            if (!pathHelper.isSelected(navProp.getName())) continue;
            if (!pathHelper.isExpanded(navProp.getName())) {
                if (navProp.getToRole().getMultiplicity() == EdmMultiplicity.MANY) {
                    links.add(OLinks.relatedEntities(null, navProp.getName(), null));
                    continue;
                }
                links.add(OLinks.relatedEntity(null, navProp.getName(), null));
                continue;
            }
            pathHelper.navigate(navProp.getName());
            if (navProp.getToRole().getMultiplicity() == EdmMultiplicity.MANY) {
                ArrayList<OEntity> relatedEntities = new ArrayList<OEntity>();
                EdmEntitySet relEntitySet = null;
                for (Object entity : this.getRelatedPojos(navProp, obj, ei)) {
                    if (relEntitySet == null) {
                        InMemoryEntityInfo<?> oei = this.findEntityInfoForClass(entity.getClass());
                        relEntitySet = this.getMetadata().getEdmEntitySet(oei.getEntitySetName());
                    }
                    relatedEntities.add(this.toOEntity(relEntitySet, entity, pathHelper));
                }
                links.add(OLinks.relatedEntitiesInline(null, navProp.getName(), null, relatedEntities));
            } else {
                Object entity = ei.getPropertyModel().getPropertyValue(obj, navProp.getName());
                OEntity relatedEntity = null;
                if (entity != null) {
                    InMemoryEntityInfo<?> oei = this.findEntityInfoForClass(entity.getClass());
                    EdmEntitySet relEntitySet = this.getMetadata().getEdmEntitySet(oei.getEntitySetName());
                    relatedEntity = this.toOEntity(relEntitySet, entity, pathHelper);
                }
                links.add(OLinks.relatedEntityInline(null, navProp.getName(), null, relatedEntity));
            }
            pathHelper.popPath();
        }
        return OEntities.create(ees, edmEntityType, OEntityKey.create(keyKVPair), properties, links, obj);
    }

    protected Iterable<?> getRelatedPojos(EdmNavigationProperty navProp, Object srcObject, InMemoryEntityInfo<?> srcInfo) {
        if (navProp.getToRole().getMultiplicity() == EdmMultiplicity.MANY) {
            Iterable<?> i = srcInfo.getPropertyModel().getCollectionValue(srcObject, navProp.getName());
            return i == null ? Collections.EMPTY_LIST : i;
        }
        return Collections.singletonList(srcInfo.getPropertyModel().getPropertyValue(srcObject, navProp.getName()));
    }

    private static Predicate1<Object> filterToPredicate(final BoolCommonExpression filter, final PropertyModel properties) {
        return new Predicate1<Object>(){

            @Override
            public boolean apply(Object input) {
                return InMemoryEvaluation.evaluate(filter, input, properties);
            }
        };
    }

    @Override
    public EntitiesResponse getEntities(String entitySetName, QueryInfo queryInfo) {
        RequestContext rc = RequestContext.newBuilder(RequestContext.RequestType.GetEntities).entitySetName(entitySetName).entitySet(this.getMetadata().getEdmEntitySet(entitySetName)).queryInfo(queryInfo).pathHelper(new PropertyPathHelper(queryInfo)).build();
        InMemoryEntityInfo<?> ei = this.eis.get(entitySetName);
        Enumerable<Object> objects = ei.getWithContext == null ? Enumerable.create(ei.get.apply()).cast(Object.class) : Enumerable.create(ei.getWithContext.apply(rc)).cast(Object.class);
        return this.getEntitiesResponse(rc, rc.getEntitySet(), objects, ei.getPropertyModel());
    }

    protected EntitiesResponse getEntitiesResponse(final RequestContext rc, final EdmEntitySet targetEntitySet, Enumerable<Object> objects, PropertyModel propertyModel) {
        final QueryInfo queryInfo = rc.getQueryInfo();
        if (queryInfo != null && queryInfo.filter != null) {
            objects = objects.where(InMemoryProducer.filterToPredicate(queryInfo.filter, propertyModel));
        }
        Integer inlineCount = null;
        if (queryInfo != null && queryInfo.inlineCount == InlineCount.ALLPAGES) {
            objects = Enumerable.create(objects.toList());
            inlineCount = objects.count();
        }
        if (queryInfo != null && queryInfo.orderBy != null) {
            objects = this.orderBy(objects, queryInfo.orderBy, propertyModel);
        }
        Enumerable<OEntity> entities = objects.select(new Func1<Object, OEntity>(){

            @Override
            public OEntity apply(Object input) {
                return InMemoryProducer.this.toOEntity(targetEntitySet, input, rc.getPathHelper());
            }
        });
        if (queryInfo != null && queryInfo.skipToken != null) {
            final Boolean[] skipping = new Boolean[]{true};
            entities = entities.skipWhile(new Predicate1<OEntity>(){

                @Override
                public boolean apply(OEntity input) {
                    if (skipping[0].booleanValue()) {
                        String inputKey = input.getEntityKey().toKeyString();
                        if (queryInfo.skipToken.equals(inputKey)) {
                            skipping[0] = false;
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        if (queryInfo != null && queryInfo.skip != null) {
            entities = entities.skip(queryInfo.skip);
        }
        int limit = this.maxResults;
        if (queryInfo != null && queryInfo.top != null && queryInfo.top < limit) {
            limit = queryInfo.top;
        }
        entities = entities.take(limit + 1);
        List<OEntity> entitiesList = entities.toList();
        String skipToken = null;
        if (entitiesList.size() > limit) {
            skipToken = (entitiesList = Enumerable.create(entitiesList).take(limit).toList()).size() == 0 ? null : Enumerable.create(entitiesList).last().getEntityKey().toKeyString();
        }
        return Responses.entities(entitiesList, targetEntitySet, inlineCount, skipToken);
    }

    @Override
    public CountResponse getEntitiesCount(String entitySetName, QueryInfo queryInfo) {
        Enumerable<Object> objects;
        final RequestContext rc = RequestContext.newBuilder(RequestContext.RequestType.GetEntitiesCount).entitySetName(entitySetName).entitySet(this.getMetadata().getEdmEntitySet(entitySetName)).queryInfo(queryInfo).build();
        InMemoryEntityInfo<?> ei = this.eis.get(entitySetName);
        final PropertyPathHelper pathHelper = new PropertyPathHelper(queryInfo);
        Enumerable<Object> enumerable = objects = ei.getWithContext == null ? Enumerable.create(ei.get.apply()).cast(Object.class) : Enumerable.create(ei.getWithContext.apply(rc)).cast(Object.class);
        if (queryInfo != null && queryInfo.filter != null) {
            objects = objects.where(InMemoryProducer.filterToPredicate(queryInfo.filter, ei.properties));
        }
        if (queryInfo != null && queryInfo.inlineCount == InlineCount.ALLPAGES) {
            throw new UnsupportedOperationException("$inlinecount cannot be applied to the resource segment '$count'");
        }
        Enumerable<OEntity> entities = objects.select(new Func1<Object, OEntity>(){

            @Override
            public OEntity apply(Object input) {
                return InMemoryProducer.this.toOEntity(rc.getEntitySet(), input, pathHelper);
            }
        });
        if (queryInfo != null && queryInfo.skipToken != null) {
            throw new UnsupportedOperationException("Skip tokens can only be provided for requests that return collections of entities.");
        }
        if (queryInfo != null && queryInfo.skip != null) {
            entities = entities.skip(queryInfo.skip);
        }
        int limit = Integer.MAX_VALUE;
        if (queryInfo != null && queryInfo.top != null && queryInfo.top < limit) {
            limit = queryInfo.top;
        }
        entities = entities.take(limit);
        return Responses.count(entities.count());
    }

    private Enumerable<Object> orderBy(Enumerable<Object> iter, List<OrderByExpression> orderBys, final PropertyModel properties) {
        for (final OrderByExpression orderBy : Enumerable.create(orderBys).reverse()) {
            iter = iter.orderBy(new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    Comparable lhs = (Comparable)InMemoryEvaluation.evaluate(orderBy.getExpression(), o1, properties);
                    Comparable rhs = (Comparable)InMemoryEvaluation.evaluate(orderBy.getExpression(), o2, properties);
                    return (orderBy.getDirection() == OrderByExpression.Direction.ASCENDING ? 1 : -1) * lhs.compareTo(rhs);
                }
            });
        }
        return iter;
    }

    @Override
    public EntityResponse getEntity(String entitySetName, OEntityKey entityKey, EntityQueryInfo queryInfo) {
        PropertyPathHelper pathHelper = new PropertyPathHelper(queryInfo);
        RequestContext rc = RequestContext.newBuilder(RequestContext.RequestType.GetEntity).entitySetName(entitySetName).entitySet(this.getMetadata().getEdmEntitySet(entitySetName)).entityKey(entityKey).queryInfo(queryInfo).pathHelper(pathHelper).build();
        Object rt = this.getEntityPojo(rc);
        if (rt == null) {
            throw new NotFoundException("No entity found in entityset " + entitySetName + " for key " + entityKey.toKeyStringWithoutParentheses() + " and query info " + queryInfo);
        }
        OEntity oe = this.toOEntity(rc.getEntitySet(), rt, rc.getPathHelper());
        return Responses.entity(oe);
    }

    @Override
    public void mergeEntity(String entitySetName, OEntity entity) {
        throw new NotImplementedException();
    }

    @Override
    public void updateEntity(String entitySetName, OEntity entity) {
        throw new NotImplementedException();
    }

    @Override
    public void deleteEntity(String entitySetName, OEntityKey entityKey) {
        throw new NotImplementedException();
    }

    @Override
    public EntityResponse createEntity(String entitySetName, OEntity entity) {
        throw new NotImplementedException();
    }

    @Override
    public EntityResponse createEntity(String entitySetName, OEntityKey entityKey, String navProp, OEntity entity) {
        throw new NotImplementedException();
    }

    @Override
    public BaseResponse getNavProperty(String entitySetName, OEntityKey entityKey, String navProp, QueryInfo queryInfo) {
        RequestContext rc = RequestContext.newBuilder(RequestContext.RequestType.GetNavProperty).entitySetName(entitySetName).entitySet(this.getMetadata().getEdmEntitySet(entitySetName)).entityKey(entityKey).navPropName(navProp).queryInfo(queryInfo).pathHelper(new PropertyPathHelper(queryInfo)).build();
        EdmNavigationProperty navProperty = rc.getEntitySet().getType().findNavigationProperty(navProp);
        if (navProperty != null) {
            return this.getNavProperty(navProperty, rc);
        }
        EdmProperty edmProperty = rc.getEntitySet().getType().findProperty(navProp);
        if (edmProperty == null) {
            throw new NotFoundException("Property " + navProp + " is not found");
        }
        EdmType edmType = edmProperty.getType();
        if (!edmType.isSimple()) {
            throw new NotImplementedException("Only simple types are supported. Property type is '" + edmType.getFullyQualifiedTypeName() + "'");
        }
        InMemoryEntityInfo<?> entityInfo = this.eis.get(entitySetName);
        Object target = this.getEntityPojo(rc);
        Object propertyValue = entityInfo.properties.getPropertyValue(target, navProp);
        OProperty property = OProperties.simple(navProp, (EdmSimpleType)edmType, propertyValue);
        return Responses.property(property);
    }

    protected EdmEntitySet findEntitySetForNavProperty(EdmNavigationProperty navProp) {
        EdmEntityType et = navProp.getToRole().getType();
        for (EdmEntitySet set : this.getMetadata().getEntitySets()) {
            if (!set.getType().equals(et)) continue;
            return set;
        }
        return null;
    }

    protected BaseResponse getNavProperty(EdmNavigationProperty navProp, RequestContext rc) {
        Object obj = this.getEntityPojo(rc);
        Iterable<?> relatedPojos = this.getRelatedPojos(navProp, obj, this.findEntityInfoForClass(obj.getClass()));
        EdmEntitySet targetEntitySet = this.findEntitySetForNavProperty(navProp);
        if (navProp.getToRole().getMultiplicity() == EdmMultiplicity.MANY) {
            return this.getEntitiesResponse(rc, targetEntitySet, Enumerable.create(relatedPojos), this.findEntityInfoForEntitySet(targetEntitySet.getName()).getPropertyModel());
        }
        return Responses.entity(this.toOEntity(targetEntitySet, relatedPojos.iterator().next(), rc.getPathHelper()));
    }

    @Override
    public CountResponse getNavPropertyCount(String entitySetName, OEntityKey entityKey, String navProp, QueryInfo queryInfo) {
        throw new NotImplementedException();
    }

    @Override
    public EntityIdResponse getLinks(OEntityId sourceEntity, String targetNavProp) {
        throw new NotImplementedException();
    }

    @Override
    public void createLink(OEntityId sourceEntity, String targetNavProp, OEntityId targetEntity) {
        throw new NotImplementedException();
    }

    @Override
    public void updateLink(OEntityId sourceEntity, String targetNavProp, OEntityKey oldTargetEntityKey, OEntityId newTargetEntity) {
        throw new NotImplementedException();
    }

    @Override
    public void deleteLink(OEntityId sourceEntity, String targetNavProp, OEntityKey targetEntityKey) {
        throw new NotImplementedException();
    }

    @Override
    public BaseResponse callFunction(EdmFunctionImport name, Map<String, OFunctionParameter> params, QueryInfo queryInfo) {
        throw new NotImplementedException();
    }

    @Override
    public <TExtension extends OExtension<ODataProducer>> TExtension findExtension(Class<TExtension> clazz) {
        return null;
    }

    protected Object getEntityPojo(final RequestContext rc) {
        final InMemoryEntityInfo<?> ei = this.eis.get(rc.getEntitySetName());
        final String[] keyList = ei.keys;
        Iterable iter = ei.getWithContext == null ? ei.get.apply() : ei.getWithContext.apply(rc);
        Object rt = Enumerable.create(iter).firstOrNull(new Predicate1<Object>(){

            @Override
            public boolean apply(Object input) {
                HashMap<String, Object> idObjectMap = ei.id.apply(input);
                if (keyList.length == 1) {
                    Object idValue = rc.getEntityKey().asSingleValue();
                    return idObjectMap.get(keyList[0]).equals(idValue);
                }
                if (keyList.length > 1) {
                    for (String key : keyList) {
                        Object curValue = null;
                        for (OProperty<?> keyProp : rc.getEntityKey().asComplexProperties()) {
                            if (!keyProp.getName().equalsIgnoreCase(key)) continue;
                            curValue = keyProp.getValue();
                        }
                        if (curValue == null) {
                            return false;
                        }
                        if (idObjectMap.get(key).equals(curValue)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        });
        return rt;
    }

    protected void fireUnmarshalEvent(Object pojo, OStructuralObject sobj, TriggerType ttype) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            Method m = pojo.getClass().getMethod(ttype == TriggerType.Before ? "beforeOEntityUnmarshal" : "afterOEntityUnmarshal", OStructuralObject.class);
            if (m != null) {
                m.invoke(pojo, sobj);
            }
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
    }

    public <T> T toPojo(OComplexObject entity, Class<T> pojoClass) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        InMemoryComplexTypeInfo<?> e = this.findComplexTypeInfoForClass(pojoClass);
        T pojo = this.fillInPojo(entity, this.getMetadata().findEdmComplexType(this.namespace + "." + e.getTypeName()), e.getPropertyModel(), pojoClass);
        this.fireUnmarshalEvent(pojo, entity, TriggerType.After);
        return pojo;
    }

    protected <T> T fillInPojo(OStructuralObject sobj, EdmStructuralType stype, PropertyModel propertyModel, Class<T> pojoClass) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        T pojo = pojoClass.newInstance();
        this.fireUnmarshalEvent(pojo, sobj, TriggerType.Before);
        for (EdmProperty property : stype.getProperties()) {
            Object value = null;
            try {
                value = sobj.getProperty(property.getName()).getValue();
            }
            catch (Exception ex) {
                if (property.isNullable()) continue;
                throw new RuntimeException("missing required property " + property.getName());
            }
            if (property.getCollectionKind() == EdmProperty.CollectionKind.NONE) {
                if (property.getType().isSimple()) {
                    propertyModel.setPropertyValue(pojo, property.getName(), value);
                    continue;
                }
                propertyModel.setPropertyValue(pojo, property.getName(), value == null ? null : this.toPojo(OComplexObjects.create((EdmComplexType)property.getType(), value), propertyModel.getPropertyType(property.getName())));
                continue;
            }
            OCollection collection = value;
            ArrayList<Object> pojos = new ArrayList<Object>();
            for (OObject item : collection) {
                if (collection.getType().isSimple()) {
                    pojos.add(((OSimpleObject)item).getValue());
                    continue;
                }
                pojos.add(this.toPojo((OComplexObject)item, propertyModel.getCollectionElementType(property.getName())));
            }
            propertyModel.setCollectionValue(pojo, property.getName(), pojos);
        }
        return pojo;
    }

    public <T> T toPojo(OEntity entity, Class<T> pojoClass) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        InMemoryEntityInfo<?> e = this.findEntityInfoForClass(pojoClass);
        EdmEntitySet entitySet = this.getMetadata().findEdmEntitySet(e.getEntitySetName());
        T pojo = this.fillInPojo(entity, entitySet.getType(), e.getPropertyModel(), pojoClass);
        for (EdmNavigationProperty np : entitySet.getType().getNavigationProperties()) {
            OLink link = null;
            try {
                link = entity.getLink(np.getName(), OLink.class);
            }
            catch (IllegalArgumentException nolinkex) {
                continue;
            }
            if (!link.isInline()) continue;
            if (link.isCollection()) {
                ArrayList pojos = new ArrayList();
                for (OEntity relatedEntity : link.getRelatedEntities()) {
                    pojos.add(this.toPojo(relatedEntity, e.getPropertyModel().getCollectionElementType(np.getName())));
                }
                e.getPropertyModel().setCollectionValue(pojo, np.getName(), pojos);
                continue;
            }
            e.getPropertyModel().setPropertyValue(pojo, np.getName(), this.toPojo(link.getRelatedEntity(), e.getPropertyModel().getPropertyType(np.getName())));
        }
        this.fireUnmarshalEvent(pojo, entity, TriggerType.After);
        return pojo;
    }

    private static enum TriggerType {
        Before,
        After;

    }

    public static class RequestContext {
        public final RequestType requestType;
        private final String entitySetName;
        private EdmEntitySet entitySet;
        private final String navPropName;
        private final OEntityKey entityKey;
        private final QueryInfo queryInfo;
        private final PropertyPathHelper pathHelper;

        public RequestType getRequestType() {
            return this.requestType;
        }

        public String getEntitySetName() {
            return this.entitySetName;
        }

        public EdmEntitySet getEntitySet() {
            return this.entitySet;
        }

        public String getNavPropName() {
            return this.navPropName;
        }

        public OEntityKey getEntityKey() {
            return this.entityKey;
        }

        public QueryInfo getQueryInfo() {
            return this.queryInfo;
        }

        public PropertyPathHelper getPathHelper() {
            return this.pathHelper;
        }

        public static Builder newBuilder(RequestType requestType) {
            return new Builder().requestType(requestType);
        }

        private RequestContext(RequestType requestType, String entitySetName, EdmEntitySet entitySet, String navPropName, OEntityKey entityKey, QueryInfo queryInfo, PropertyPathHelper pathHelper) {
            this.requestType = requestType;
            this.entitySetName = entitySetName;
            this.entitySet = entitySet;
            this.navPropName = navPropName;
            this.entityKey = entityKey;
            this.queryInfo = queryInfo;
            this.pathHelper = pathHelper;
        }

        public static class Builder {
            private RequestType requestType;
            private String entitySetName;
            private EdmEntitySet entitySet;
            private String navPropName;
            private OEntityKey entityKey;
            private QueryInfo queryInfo;
            private PropertyPathHelper pathHelper;

            public Builder requestType(RequestType value) {
                this.requestType = value;
                return this;
            }

            public Builder entitySetName(String value) {
                this.entitySetName = value;
                return this;
            }

            public Builder entitySet(EdmEntitySet value) {
                this.entitySet = value;
                return this;
            }

            public Builder navPropName(String value) {
                this.navPropName = value;
                return this;
            }

            public Builder entityKey(OEntityKey value) {
                this.entityKey = value;
                return this;
            }

            public Builder queryInfo(QueryInfo value) {
                this.queryInfo = value;
                return this;
            }

            public Builder pathHelper(PropertyPathHelper value) {
                this.pathHelper = value;
                return this;
            }

            public RequestContext build() {
                return new RequestContext(this.requestType, this.entitySetName, this.entitySet, this.navPropName, this.entityKey, this.queryInfo, this.pathHelper);
            }
        }

        public static enum RequestType {
            GetEntity,
            GetEntities,
            GetEntitiesCount,
            GetNavProperty;

        }
    }
}

