/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.odata4j.core.ImmutableList;

public class SqlStatement {
    public final String sql;
    public final ImmutableList<SqlParameter> params;

    public SqlStatement(String sql, ImmutableList<SqlParameter> params) {
        this.sql = sql;
        this.params = params;
    }

    public PreparedStatement asPreparedStatement(Connection conn) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.sql);
        for (int i = 0; i < this.params.size(); ++i) {
            SqlParameter p = this.params.get(i);
            if (p.sqlType == null) {
                stmt.setObject(i + 1, p.value);
                continue;
            }
            stmt.setObject(i + 1, p.value, p.sqlType);
        }
        return stmt;
    }

    public static class SqlParameter {
        public final Object value;
        public final Integer sqlType;

        public SqlParameter(Object value, Integer sqlType) {
            this.value = value;
            this.sqlType = sqlType;
        }
    }
}

