/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.stax2.domimpl;

import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import org.odata4j.core.Throwables;
import org.odata4j.stax2.QName2;
import org.odata4j.stax2.XMLWriter2;

public class ManualXMLWriter2
implements XMLWriter2 {
    private final Writer writer;
    private boolean isStartElementOpen;
    private final Stack<QName2> elements = new Stack();

    public ManualXMLWriter2(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void endDocument() {
        while (!this.elements.isEmpty()) {
            this.endElement(this.elements.peek().getLocalPart());
        }
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void endElement(String localName) {
        QName2 startElementName = this.elements.pop();
        if (!startElementName.getLocalPart().equals(localName)) {
            throw new IllegalArgumentException();
        }
        if (this.isStartElementOpen) {
            this.write("/");
            this.write(">");
            this.isStartElementOpen = false;
            return;
        }
        this.write("</");
        if (startElementName.getPrefix() != null) {
            this.write(startElementName.getPrefix());
            this.write(":");
        }
        this.write(localName);
        this.write(">");
    }

    @Override
    public void startDocument() {
        this.write("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\" ?>");
    }

    @Override
    public void startElement(String name) {
        this.startElement(new QName2(name));
    }

    @Override
    public void startElement(QName2 qname) {
        this.startElement(qname, null);
    }

    @Override
    public void startElement(QName2 qname, String xmlns) {
        this.ensureStartElementClosed();
        this.write("<");
        if (qname.getPrefix() != null) {
            this.write(qname.getPrefix());
            this.write(":");
        }
        this.write(qname.getLocalPart());
        if (xmlns != null) {
            this.write(" xmlns=\"" + xmlns + "\"");
        }
        this.isStartElementOpen = true;
        this.elements.push(qname);
    }

    @Override
    public void writeAttribute(String localName, String value) {
        this.writeAttribute(new QName2(localName), value);
    }

    @Override
    public void writeAttribute(QName2 qname, String value) {
        if (!this.isStartElementOpen) {
            throw new IllegalStateException();
        }
        this.write(" ");
        if (qname.getPrefix() != null) {
            this.write(qname.getPrefix());
            this.write(":");
        }
        this.write(qname.getLocalPart());
        this.write("=\"");
        this.write(this.encodeAttributeValue(value));
        this.write("\"");
    }

    @Override
    public void writeNamespace(String prefix, String namespaceUri) {
        if (!this.isStartElementOpen) {
            throw new IllegalStateException();
        }
        this.write(" xmlns:" + prefix + "=\"" + namespaceUri + "\"");
    }

    @Override
    public void writeText(String content) {
        this.ensureStartElementClosed();
        this.write(this.encodeElementValue(content));
    }

    private void ensureStartElementClosed() {
        if (this.isStartElementOpen) {
            this.write(">");
            this.isStartElementOpen = false;
        }
    }

    private void write(String value) {
        try {
            this.writer.write(value);
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    private String encodeElementValue(String value) {
        return this.encodeAttributeValue(value);
    }

    private String encodeAttributeValue(String value) {
        if (value == null) {
            return null;
        }
        int len = value.length();
        if (len == 0) {
            return value;
        }
        StringBuffer encoded = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '<') {
                encoded.append("&lt;");
                continue;
            }
            if (c == '\"') {
                encoded.append("&quot;");
                continue;
            }
            if (c == '>') {
                encoded.append("&gt;");
                continue;
            }
            if (c == '\'') {
                encoded.append("&apos;");
                continue;
            }
            if (c == '&') {
                encoded.append("&amp;");
                continue;
            }
            encoded.append(c);
        }
        return encoded.toString();
    }
}

