/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.grddl.GrddlTransformationAttribute;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeVersionAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element office:document-meta}. */
public class OfficeDocumentMetaElement extends OdfElement {

  public static final OdfName ELEMENT_NAME =
      OdfName.newName(OdfDocumentNamespace.OFFICE, "document-meta");

  /**
   * Create the instance of <code>OfficeDocumentMetaElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public OfficeDocumentMetaElement(OdfFileDom ownerDoc) {
    super(ownerDoc, ELEMENT_NAME);
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element office:document-meta}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>GrddlTransformationAttribute
   * </code> , See {@odf.attribute grddl:transformation}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getGrddlTransformationAttribute() {
    GrddlTransformationAttribute attr =
        (GrddlTransformationAttribute)
            getOdfAttribute(OdfDocumentNamespace.GRDDL, "transformation");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>GrddlTransformationAttribute</code> ,
   * See {@odf.attribute grddl:transformation}
   *
   * @param grddlTransformationValue The type is <code>String</code>
   */
  public void setGrddlTransformationAttribute(String grddlTransformationValue) {
    GrddlTransformationAttribute attr =
        new GrddlTransformationAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(grddlTransformationValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>OfficeVersionAttribute</code> ,
   * See {@odf.attribute office:version}
   *
   * <p>Attribute is mandatory.
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getOfficeVersionAttribute() {
    OfficeVersionAttribute attr =
        (OfficeVersionAttribute) getOdfAttribute(OdfDocumentNamespace.OFFICE, "version");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>OfficeVersionAttribute</code> , See
   * {@odf.attribute office:version}
   *
   * @param officeVersionValue The type is <code>String</code>
   */
  public void setOfficeVersionAttribute(String officeVersionValue) {
    OfficeVersionAttribute attr = new OfficeVersionAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(officeVersionValue);
  }

  /**
   * Create child element {@odf.element office:meta}.
   *
   * @return the element {@odf.element office:meta}
   */
  public OfficeMetaElement newOfficeMetaElement() {
    OfficeMetaElement officeMeta =
        ((OdfFileDom) this.ownerDocument).newOdfElement(OfficeMetaElement.class);
    this.appendChild(officeMeta);
    return officeMeta;
  }

  /**
   * Accept an visitor instance to allow the visitor to do some operations. Refer to visitor design
   * pattern to get a better understanding.
   *
   * @param visitor an instance of DefaultElementVisitor
   */
  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }
}
