/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBackgroundColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoPaddingTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoWrapOptionAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleCellProtectAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDecimalPlacesAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDiagonalBlTrAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDiagonalBlTrWidthsAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDiagonalTlBrAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDiagonalTlBrWidthsAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDirectionAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleGlyphOrientationVerticalAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StylePrintContentAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleRepeatContentAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleRotationAlignAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleRotationAngleAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleShadowAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleShrinkToFitAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleTextAlignSourceAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleVerticalAlignAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleWritingModeAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element style:table-cell-properties}. */
public class StyleTableCellPropertiesElement extends OdfStylePropertiesBase {

  public static final OdfName ELEMENT_NAME =
      OdfName.newName(OdfDocumentNamespace.STYLE, "table-cell-properties");

  /**
   * Create the instance of <code>StyleTableCellPropertiesElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public StyleTableCellPropertiesElement(OdfFileDom ownerDoc) {
    super(ownerDoc, ELEMENT_NAME);
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element
   *     style:table-cell-properties}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  public static final OdfStyleProperty BackgroundColor =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "background-color"));

  public static final OdfStyleProperty Border =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "border"));

  public static final OdfStyleProperty BorderBottom =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "border-bottom"));

  public static final OdfStyleProperty BorderLeft =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "border-left"));

  public static final OdfStyleProperty BorderRight =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "border-right"));

  public static final OdfStyleProperty BorderTop =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "border-top"));

  public static final OdfStyleProperty Padding =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "padding"));

  public static final OdfStyleProperty PaddingBottom =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "padding-bottom"));

  public static final OdfStyleProperty PaddingLeft =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "padding-left"));

  public static final OdfStyleProperty PaddingRight =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "padding-right"));

  public static final OdfStyleProperty PaddingTop =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "padding-top"));

  public static final OdfStyleProperty WrapOption =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.FO, "wrap-option"));

  public static final OdfStyleProperty BorderLineWidth =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "border-line-width"));

  public static final OdfStyleProperty BorderLineWidthBottom =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "border-line-width-bottom"));

  public static final OdfStyleProperty BorderLineWidthLeft =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "border-line-width-left"));

  public static final OdfStyleProperty BorderLineWidthRight =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "border-line-width-right"));

  public static final OdfStyleProperty BorderLineWidthTop =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "border-line-width-top"));

  public static final OdfStyleProperty CellProtect =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "cell-protect"));

  public static final OdfStyleProperty DecimalPlaces =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "decimal-places"));

  public static final OdfStyleProperty DiagonalBlTr =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "diagonal-bl-tr"));

  public static final OdfStyleProperty DiagonalBlTrWidths =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "diagonal-bl-tr-widths"));

  public static final OdfStyleProperty DiagonalTlBr =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "diagonal-tl-br"));

  public static final OdfStyleProperty DiagonalTlBrWidths =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "diagonal-tl-br-widths"));

  public static final OdfStyleProperty Direction =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "direction"));

  public static final OdfStyleProperty GlyphOrientationVertical =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "glyph-orientation-vertical"));

  public static final OdfStyleProperty PrintContent =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "print-content"));

  public static final OdfStyleProperty RepeatContent =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "repeat-content"));

  public static final OdfStyleProperty RotationAlign =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "rotation-align"));

  public static final OdfStyleProperty RotationAngle =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "rotation-angle"));

  public static final OdfStyleProperty Shadow =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "shadow"));

  public static final OdfStyleProperty ShrinkToFit =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "shrink-to-fit"));

  public static final OdfStyleProperty TextAlignSource =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "text-align-source"));

  public static final OdfStyleProperty VerticalAlign =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "vertical-align"));

  public static final OdfStyleProperty WritingMode =
      OdfStyleProperty.get(
          OdfStylePropertiesSet.TableCellProperties,
          OdfName.newName(OdfDocumentNamespace.STYLE, "writing-mode"));

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoBackgroundColorAttribute
   * </code> , See {@odf.attribute fo:background-color}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoBackgroundColorAttribute() {
    FoBackgroundColorAttribute attr =
        (FoBackgroundColorAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "background-color");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoBackgroundColorAttribute</code> , See
   * {@odf.attribute fo:background-color}
   *
   * @param foBackgroundColorValue The type is <code>String</code>
   */
  public void setFoBackgroundColorAttribute(String foBackgroundColorValue) {
    FoBackgroundColorAttribute attr =
        new FoBackgroundColorAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foBackgroundColorValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoBorderAttribute</code> , See
   * {@odf.attribute fo:border}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoBorderAttribute() {
    FoBorderAttribute attr = (FoBorderAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "border");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoBorderAttribute</code> , See
   * {@odf.attribute fo:border}
   *
   * @param foBorderValue The type is <code>String</code>
   */
  public void setFoBorderAttribute(String foBorderValue) {
    FoBorderAttribute attr = new FoBorderAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foBorderValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoBorderBottomAttribute</code>
   * , See {@odf.attribute fo:border-bottom}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoBorderBottomAttribute() {
    FoBorderBottomAttribute attr =
        (FoBorderBottomAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "border-bottom");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoBorderBottomAttribute</code> , See
   * {@odf.attribute fo:border-bottom}
   *
   * @param foBorderBottomValue The type is <code>String</code>
   */
  public void setFoBorderBottomAttribute(String foBorderBottomValue) {
    FoBorderBottomAttribute attr = new FoBorderBottomAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foBorderBottomValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoBorderLeftAttribute</code> ,
   * See {@odf.attribute fo:border-left}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoBorderLeftAttribute() {
    FoBorderLeftAttribute attr =
        (FoBorderLeftAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "border-left");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoBorderLeftAttribute</code> , See
   * {@odf.attribute fo:border-left}
   *
   * @param foBorderLeftValue The type is <code>String</code>
   */
  public void setFoBorderLeftAttribute(String foBorderLeftValue) {
    FoBorderLeftAttribute attr = new FoBorderLeftAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foBorderLeftValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoBorderRightAttribute</code> ,
   * See {@odf.attribute fo:border-right}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoBorderRightAttribute() {
    FoBorderRightAttribute attr =
        (FoBorderRightAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "border-right");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoBorderRightAttribute</code> , See
   * {@odf.attribute fo:border-right}
   *
   * @param foBorderRightValue The type is <code>String</code>
   */
  public void setFoBorderRightAttribute(String foBorderRightValue) {
    FoBorderRightAttribute attr = new FoBorderRightAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foBorderRightValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoBorderTopAttribute</code> ,
   * See {@odf.attribute fo:border-top}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoBorderTopAttribute() {
    FoBorderTopAttribute attr =
        (FoBorderTopAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "border-top");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoBorderTopAttribute</code> , See
   * {@odf.attribute fo:border-top}
   *
   * @param foBorderTopValue The type is <code>String</code>
   */
  public void setFoBorderTopAttribute(String foBorderTopValue) {
    FoBorderTopAttribute attr = new FoBorderTopAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foBorderTopValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoPaddingAttribute</code> , See
   * {@odf.attribute fo:padding}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoPaddingAttribute() {
    FoPaddingAttribute attr =
        (FoPaddingAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "padding");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoPaddingAttribute</code> , See
   * {@odf.attribute fo:padding}
   *
   * @param foPaddingValue The type is <code>String</code>
   */
  public void setFoPaddingAttribute(String foPaddingValue) {
    FoPaddingAttribute attr = new FoPaddingAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foPaddingValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoPaddingBottomAttribute</code>
   * , See {@odf.attribute fo:padding-bottom}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoPaddingBottomAttribute() {
    FoPaddingBottomAttribute attr =
        (FoPaddingBottomAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "padding-bottom");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoPaddingBottomAttribute</code> , See
   * {@odf.attribute fo:padding-bottom}
   *
   * @param foPaddingBottomValue The type is <code>String</code>
   */
  public void setFoPaddingBottomAttribute(String foPaddingBottomValue) {
    FoPaddingBottomAttribute attr = new FoPaddingBottomAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foPaddingBottomValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoPaddingLeftAttribute</code> ,
   * See {@odf.attribute fo:padding-left}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoPaddingLeftAttribute() {
    FoPaddingLeftAttribute attr =
        (FoPaddingLeftAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "padding-left");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoPaddingLeftAttribute</code> , See
   * {@odf.attribute fo:padding-left}
   *
   * @param foPaddingLeftValue The type is <code>String</code>
   */
  public void setFoPaddingLeftAttribute(String foPaddingLeftValue) {
    FoPaddingLeftAttribute attr = new FoPaddingLeftAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foPaddingLeftValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoPaddingRightAttribute</code>
   * , See {@odf.attribute fo:padding-right}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoPaddingRightAttribute() {
    FoPaddingRightAttribute attr =
        (FoPaddingRightAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "padding-right");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoPaddingRightAttribute</code> , See
   * {@odf.attribute fo:padding-right}
   *
   * @param foPaddingRightValue The type is <code>String</code>
   */
  public void setFoPaddingRightAttribute(String foPaddingRightValue) {
    FoPaddingRightAttribute attr = new FoPaddingRightAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foPaddingRightValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoPaddingTopAttribute</code> ,
   * See {@odf.attribute fo:padding-top}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoPaddingTopAttribute() {
    FoPaddingTopAttribute attr =
        (FoPaddingTopAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "padding-top");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoPaddingTopAttribute</code> , See
   * {@odf.attribute fo:padding-top}
   *
   * @param foPaddingTopValue The type is <code>String</code>
   */
  public void setFoPaddingTopAttribute(String foPaddingTopValue) {
    FoPaddingTopAttribute attr = new FoPaddingTopAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foPaddingTopValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FoWrapOptionAttribute</code> ,
   * See {@odf.attribute fo:wrap-option}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFoWrapOptionAttribute() {
    FoWrapOptionAttribute attr =
        (FoWrapOptionAttribute) getOdfAttribute(OdfDocumentNamespace.FO, "wrap-option");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FoWrapOptionAttribute</code> , See
   * {@odf.attribute fo:wrap-option}
   *
   * @param foWrapOptionValue The type is <code>String</code>
   */
  public void setFoWrapOptionAttribute(String foWrapOptionValue) {
    FoWrapOptionAttribute attr = new FoWrapOptionAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(foWrapOptionValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleBorderLineWidthAttribute
   * </code> , See {@odf.attribute style:border-line-width}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleBorderLineWidthAttribute() {
    StyleBorderLineWidthAttribute attr =
        (StyleBorderLineWidthAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "border-line-width");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthAttribute</code> ,
   * See {@odf.attribute style:border-line-width}
   *
   * @param styleBorderLineWidthValue The type is <code>String</code>
   */
  public void setStyleBorderLineWidthAttribute(String styleBorderLineWidthValue) {
    StyleBorderLineWidthAttribute attr =
        new StyleBorderLineWidthAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleBorderLineWidthValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleBorderLineWidthBottomAttribute</code> , See {@odf.attribute
   * style:border-line-width-bottom}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleBorderLineWidthBottomAttribute() {
    StyleBorderLineWidthBottomAttribute attr =
        (StyleBorderLineWidthBottomAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "border-line-width-bottom");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthBottomAttribute
   * </code> , See {@odf.attribute style:border-line-width-bottom}
   *
   * @param styleBorderLineWidthBottomValue The type is <code>String</code>
   */
  public void setStyleBorderLineWidthBottomAttribute(String styleBorderLineWidthBottomValue) {
    StyleBorderLineWidthBottomAttribute attr =
        new StyleBorderLineWidthBottomAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleBorderLineWidthBottomValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleBorderLineWidthLeftAttribute</code> , See {@odf.attribute style:border-line-width-left}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleBorderLineWidthLeftAttribute() {
    StyleBorderLineWidthLeftAttribute attr =
        (StyleBorderLineWidthLeftAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "border-line-width-left");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthLeftAttribute
   * </code> , See {@odf.attribute style:border-line-width-left}
   *
   * @param styleBorderLineWidthLeftValue The type is <code>String</code>
   */
  public void setStyleBorderLineWidthLeftAttribute(String styleBorderLineWidthLeftValue) {
    StyleBorderLineWidthLeftAttribute attr =
        new StyleBorderLineWidthLeftAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleBorderLineWidthLeftValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleBorderLineWidthRightAttribute</code> , See {@odf.attribute style:border-line-width-right}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleBorderLineWidthRightAttribute() {
    StyleBorderLineWidthRightAttribute attr =
        (StyleBorderLineWidthRightAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "border-line-width-right");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthRightAttribute
   * </code> , See {@odf.attribute style:border-line-width-right}
   *
   * @param styleBorderLineWidthRightValue The type is <code>String</code>
   */
  public void setStyleBorderLineWidthRightAttribute(String styleBorderLineWidthRightValue) {
    StyleBorderLineWidthRightAttribute attr =
        new StyleBorderLineWidthRightAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleBorderLineWidthRightValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleBorderLineWidthTopAttribute</code> , See {@odf.attribute style:border-line-width-top}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleBorderLineWidthTopAttribute() {
    StyleBorderLineWidthTopAttribute attr =
        (StyleBorderLineWidthTopAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "border-line-width-top");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleBorderLineWidthTopAttribute</code>
   * , See {@odf.attribute style:border-line-width-top}
   *
   * @param styleBorderLineWidthTopValue The type is <code>String</code>
   */
  public void setStyleBorderLineWidthTopAttribute(String styleBorderLineWidthTopValue) {
    StyleBorderLineWidthTopAttribute attr =
        new StyleBorderLineWidthTopAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleBorderLineWidthTopValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleCellProtectAttribute
   * </code> , See {@odf.attribute style:cell-protect}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleCellProtectAttribute() {
    StyleCellProtectAttribute attr =
        (StyleCellProtectAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "cell-protect");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleCellProtectAttribute</code> , See
   * {@odf.attribute style:cell-protect}
   *
   * @param styleCellProtectValue The type is <code>String</code>
   */
  public void setStyleCellProtectAttribute(String styleCellProtectValue) {
    StyleCellProtectAttribute attr = new StyleCellProtectAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleCellProtectValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleDecimalPlacesAttribute
   * </code> , See {@odf.attribute style:decimal-places}
   *
   * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Integer getStyleDecimalPlacesAttribute() {
    StyleDecimalPlacesAttribute attr =
        (StyleDecimalPlacesAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "decimal-places");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Integer.valueOf(attr.intValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleDecimalPlacesAttribute</code> ,
   * See {@odf.attribute style:decimal-places}
   *
   * @param styleDecimalPlacesValue The type is <code>Integer</code>
   */
  public void setStyleDecimalPlacesAttribute(Integer styleDecimalPlacesValue) {
    StyleDecimalPlacesAttribute attr =
        new StyleDecimalPlacesAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setIntValue(styleDecimalPlacesValue.intValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleDiagonalBlTrAttribute
   * </code> , See {@odf.attribute style:diagonal-bl-tr}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleDiagonalBlTrAttribute() {
    StyleDiagonalBlTrAttribute attr =
        (StyleDiagonalBlTrAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "diagonal-bl-tr");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleDiagonalBlTrAttribute</code> , See
   * {@odf.attribute style:diagonal-bl-tr}
   *
   * @param styleDiagonalBlTrValue The type is <code>String</code>
   */
  public void setStyleDiagonalBlTrAttribute(String styleDiagonalBlTrValue) {
    StyleDiagonalBlTrAttribute attr =
        new StyleDiagonalBlTrAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleDiagonalBlTrValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleDiagonalBlTrWidthsAttribute</code> , See {@odf.attribute style:diagonal-bl-tr-widths}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleDiagonalBlTrWidthsAttribute() {
    StyleDiagonalBlTrWidthsAttribute attr =
        (StyleDiagonalBlTrWidthsAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "diagonal-bl-tr-widths");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleDiagonalBlTrWidthsAttribute</code>
   * , See {@odf.attribute style:diagonal-bl-tr-widths}
   *
   * @param styleDiagonalBlTrWidthsValue The type is <code>String</code>
   */
  public void setStyleDiagonalBlTrWidthsAttribute(String styleDiagonalBlTrWidthsValue) {
    StyleDiagonalBlTrWidthsAttribute attr =
        new StyleDiagonalBlTrWidthsAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleDiagonalBlTrWidthsValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleDiagonalTlBrAttribute
   * </code> , See {@odf.attribute style:diagonal-tl-br}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleDiagonalTlBrAttribute() {
    StyleDiagonalTlBrAttribute attr =
        (StyleDiagonalTlBrAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "diagonal-tl-br");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleDiagonalTlBrAttribute</code> , See
   * {@odf.attribute style:diagonal-tl-br}
   *
   * @param styleDiagonalTlBrValue The type is <code>String</code>
   */
  public void setStyleDiagonalTlBrAttribute(String styleDiagonalTlBrValue) {
    StyleDiagonalTlBrAttribute attr =
        new StyleDiagonalTlBrAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleDiagonalTlBrValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleDiagonalTlBrWidthsAttribute</code> , See {@odf.attribute style:diagonal-tl-br-widths}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleDiagonalTlBrWidthsAttribute() {
    StyleDiagonalTlBrWidthsAttribute attr =
        (StyleDiagonalTlBrWidthsAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "diagonal-tl-br-widths");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleDiagonalTlBrWidthsAttribute</code>
   * , See {@odf.attribute style:diagonal-tl-br-widths}
   *
   * @param styleDiagonalTlBrWidthsValue The type is <code>String</code>
   */
  public void setStyleDiagonalTlBrWidthsAttribute(String styleDiagonalTlBrWidthsValue) {
    StyleDiagonalTlBrWidthsAttribute attr =
        new StyleDiagonalTlBrWidthsAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleDiagonalTlBrWidthsValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleDirectionAttribute</code>
   * , See {@odf.attribute style:direction}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleDirectionAttribute() {
    StyleDirectionAttribute attr =
        (StyleDirectionAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "direction");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleDirectionAttribute</code> , See
   * {@odf.attribute style:direction}
   *
   * @param styleDirectionValue The type is <code>String</code>
   */
  public void setStyleDirectionAttribute(String styleDirectionValue) {
    StyleDirectionAttribute attr = new StyleDirectionAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleDirectionValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * StyleGlyphOrientationVerticalAttribute</code> , See {@odf.attribute
   * style:glyph-orientation-vertical}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleGlyphOrientationVerticalAttribute() {
    StyleGlyphOrientationVerticalAttribute attr =
        (StyleGlyphOrientationVerticalAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "glyph-orientation-vertical");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleGlyphOrientationVerticalAttribute
   * </code> , See {@odf.attribute style:glyph-orientation-vertical}
   *
   * @param styleGlyphOrientationVerticalValue The type is <code>String</code>
   */
  public void setStyleGlyphOrientationVerticalAttribute(String styleGlyphOrientationVerticalValue) {
    StyleGlyphOrientationVerticalAttribute attr =
        new StyleGlyphOrientationVerticalAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleGlyphOrientationVerticalValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StylePrintContentAttribute
   * </code> , See {@odf.attribute style:print-content}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getStylePrintContentAttribute() {
    StylePrintContentAttribute attr =
        (StylePrintContentAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "print-content");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StylePrintContentAttribute</code> , See
   * {@odf.attribute style:print-content}
   *
   * @param stylePrintContentValue The type is <code>Boolean</code>
   */
  public void setStylePrintContentAttribute(Boolean stylePrintContentValue) {
    StylePrintContentAttribute attr =
        new StylePrintContentAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(stylePrintContentValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleRepeatContentAttribute
   * </code> , See {@odf.attribute style:repeat-content}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getStyleRepeatContentAttribute() {
    StyleRepeatContentAttribute attr =
        (StyleRepeatContentAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "repeat-content");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleRepeatContentAttribute</code> ,
   * See {@odf.attribute style:repeat-content}
   *
   * @param styleRepeatContentValue The type is <code>Boolean</code>
   */
  public void setStyleRepeatContentAttribute(Boolean styleRepeatContentValue) {
    StyleRepeatContentAttribute attr =
        new StyleRepeatContentAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(styleRepeatContentValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleRotationAlignAttribute
   * </code> , See {@odf.attribute style:rotation-align}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleRotationAlignAttribute() {
    StyleRotationAlignAttribute attr =
        (StyleRotationAlignAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "rotation-align");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleRotationAlignAttribute</code> ,
   * See {@odf.attribute style:rotation-align}
   *
   * @param styleRotationAlignValue The type is <code>String</code>
   */
  public void setStyleRotationAlignAttribute(String styleRotationAlignValue) {
    StyleRotationAlignAttribute attr =
        new StyleRotationAlignAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleRotationAlignValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleRotationAngleAttribute
   * </code> , See {@odf.attribute style:rotation-angle}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleRotationAngleAttribute() {
    StyleRotationAngleAttribute attr =
        (StyleRotationAngleAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "rotation-angle");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleRotationAngleAttribute</code> ,
   * See {@odf.attribute style:rotation-angle}
   *
   * @param styleRotationAngleValue The type is <code>String</code>
   */
  public void setStyleRotationAngleAttribute(String styleRotationAngleValue) {
    StyleRotationAngleAttribute attr =
        new StyleRotationAngleAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleRotationAngleValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleShadowAttribute</code> ,
   * See {@odf.attribute style:shadow}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleShadowAttribute() {
    StyleShadowAttribute attr =
        (StyleShadowAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "shadow");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleShadowAttribute</code> , See
   * {@odf.attribute style:shadow}
   *
   * @param styleShadowValue The type is <code>String</code>
   */
  public void setStyleShadowAttribute(String styleShadowValue) {
    StyleShadowAttribute attr = new StyleShadowAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleShadowValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleShrinkToFitAttribute
   * </code> , See {@odf.attribute style:shrink-to-fit}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getStyleShrinkToFitAttribute() {
    StyleShrinkToFitAttribute attr =
        (StyleShrinkToFitAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "shrink-to-fit");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleShrinkToFitAttribute</code> , See
   * {@odf.attribute style:shrink-to-fit}
   *
   * @param styleShrinkToFitValue The type is <code>Boolean</code>
   */
  public void setStyleShrinkToFitAttribute(Boolean styleShrinkToFitValue) {
    StyleShrinkToFitAttribute attr = new StyleShrinkToFitAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(styleShrinkToFitValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleTextAlignSourceAttribute
   * </code> , See {@odf.attribute style:text-align-source}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleTextAlignSourceAttribute() {
    StyleTextAlignSourceAttribute attr =
        (StyleTextAlignSourceAttribute)
            getOdfAttribute(OdfDocumentNamespace.STYLE, "text-align-source");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleTextAlignSourceAttribute</code> ,
   * See {@odf.attribute style:text-align-source}
   *
   * @param styleTextAlignSourceValue The type is <code>String</code>
   */
  public void setStyleTextAlignSourceAttribute(String styleTextAlignSourceValue) {
    StyleTextAlignSourceAttribute attr =
        new StyleTextAlignSourceAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleTextAlignSourceValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleVerticalAlignAttribute
   * </code> , See {@odf.attribute style:vertical-align}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleVerticalAlignAttribute() {
    StyleVerticalAlignAttribute attr =
        (StyleVerticalAlignAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "vertical-align");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleVerticalAlignAttribute</code> ,
   * See {@odf.attribute style:vertical-align}
   *
   * @param styleVerticalAlignValue The type is <code>String</code>
   */
  public void setStyleVerticalAlignAttribute(String styleVerticalAlignValue) {
    StyleVerticalAlignAttribute attr =
        new StyleVerticalAlignAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleVerticalAlignValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>StyleWritingModeAttribute
   * </code> , See {@odf.attribute style:writing-mode}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getStyleWritingModeAttribute() {
    StyleWritingModeAttribute attr =
        (StyleWritingModeAttribute) getOdfAttribute(OdfDocumentNamespace.STYLE, "writing-mode");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>StyleWritingModeAttribute</code> , See
   * {@odf.attribute style:writing-mode}
   *
   * @param styleWritingModeValue The type is <code>String</code>
   */
  public void setStyleWritingModeAttribute(String styleWritingModeValue) {
    StyleWritingModeAttribute attr = new StyleWritingModeAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(styleWritingModeValue);
  }

  /**
   * Create child element {@odf.element style:background-image}.
   *
   * <p>Child element was added in ODF 1.2
   *
   * @return the element {@odf.element style:background-image}
   */
  public StyleBackgroundImageElement newStyleBackgroundImageElement() {
    StyleBackgroundImageElement styleBackgroundImage =
        ((OdfFileDom) this.ownerDocument).newOdfElement(StyleBackgroundImageElement.class);
    this.appendChild(styleBackgroundImage);
    return styleBackgroundImage;
  }

  /**
   * Accept an visitor instance to allow the visitor to do some operations. Refer to visitor design
   * pattern to get a better understanding.
   *
   * @param visitor an instance of DefaultElementVisitor
   */
  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }

  /** BORDERS TO BE DELETED */
  public static final byte BORDER_NONE = 0x0;

  public static final byte BORDER_TOP = 0x1;
  public static final byte BORDER_RIGHT = 0x2;
  public static final byte BORDER_BOTTOM = 0x4;
  public static final byte BORDER_LEFT = 0x8;
  public static final byte BORDER_ALL = 0xF;

  /**
   * Removes sides of borders in total. Required by insertion of column/rows as inserted cell
   * borders depend on preceding & following cell borders. Only identical sides will be kept.
   *
   * @param borderDeletion removes the borders as given in byte
   */
  public void removeBorder(byte borderDeletion) {
    if (borderDeletion != BORDER_NONE) {
      // check if a border for all sides exists
      String foBorderContent = getFoBorderAttribute();
      boolean hasCommonBorder = foBorderContent != null && !foBorderContent.equals("none");
      if (borderDeletion == BORDER_ALL) {
        setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border", "none");
        removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "border-top");
        removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "border-line-width-top");
        removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "border-right");
        removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "border-line-width-right");
        removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "border-bottom");
        removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "border-line-width-bottom");
        removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "border-left");
        removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "border-line-width-left");
      } else {
        if (hasCommonBorder) {
          removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "border");
        }
        // if a top border should be deleted
        if ((borderDeletion & BORDER_TOP) == BORDER_TOP) {
          setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-top", "none");
          removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "border-line-width-top");
        } else if (hasCommonBorder) { // if the top border should exist
          setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-top", foBorderContent);
        }
        // if a right border should be deleted
        if ((borderDeletion & BORDER_RIGHT) == BORDER_RIGHT) {
          setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-right", "none");
          removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "border-line-width-right");
        } else if (hasCommonBorder) { // if the right border should exist
          setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-right", foBorderContent);
        }
        // if a bottom border should be deleted
        if ((borderDeletion & BORDER_BOTTOM) == BORDER_BOTTOM) {
          setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-bottom", "none");
          removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "border-line-width-bottom");
        } else if (hasCommonBorder) { // if the bottom border should exist
          setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-bottom", foBorderContent);
        }
        // if a left border should be deleted
        if ((borderDeletion & BORDER_LEFT) == BORDER_LEFT) {
          setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-left", "none");
          removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "border-line-width-left");
        } else if (hasCommonBorder) { // if the left border should exist
          setAttributeNS(OdfDocumentNamespace.FO.getUri(), "fo:border-left", foBorderContent);
        }
      }
    }
  }

  /** Removes diagonal cross from cells */
  public static final byte DIAGONAL_CROSS_NONE = 0x0;

  public static final byte DIAGONAL_CROSS_TOP_LEFT_START = 0x1;
  public static final byte DIAGONAL_CROSS_BOTTOM_LEFT_START = 0x2;
  public static final byte DIAGONAL_CROSS_ALL = 0xF;

  /**
   * Removes the diagonal cross of a cell.
   *
   * @param diagonalCrossDeletion remove diagonal cross as given in byte.
   */
  public void removeDiagonalCross(byte diagonalCrossDeletion) {
    if (diagonalCrossDeletion != DIAGONAL_CROSS_NONE) {
      if (diagonalCrossDeletion == DIAGONAL_CROSS_ALL) {
        // style:diagonal-tl-br
        setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:diagonal-tl-br", "none");
        removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "diagonal-tl-br-widths");

        // style:diagonal-bl-tr
        setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:diagonal-bl-tr", "none");
        removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "diagonal-bl-tr-widths");
      } else {
        // if the diagonal starting from top left to bottom right should be deleted
        if ((diagonalCrossDeletion & DIAGONAL_CROSS_TOP_LEFT_START)
            == DIAGONAL_CROSS_TOP_LEFT_START) {
          // style:diagonal-tl-br
          setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:diagonal-tl-br", "none");
          removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "diagonal-tl-br-widths");
        }
        // if the diagonal starting from bottom left to top right should be deleted
        if ((diagonalCrossDeletion & DIAGONAL_CROSS_BOTTOM_LEFT_START)
            == DIAGONAL_CROSS_BOTTOM_LEFT_START) {
          // style:diagonal-bl-tr
          setAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "style:diagonal-bl-tr", "none");
          removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "diagonal-bl-tr-widths");
        }
      }
    }
  }

  /** Find different diagonal borders (or cross) of the given cell property elements. */
  public static byte findDifferentDiagonalCross(
      StyleTableCellPropertiesElement newCellProps,
      StyleTableCellPropertiesElement followingCellProps) {
    byte diagonalCrossRemoval = StyleTableCellPropertiesElement.DIAGONAL_CROSS_NONE;

    // Compare the diagonal starting from bottom left to top right
    if (!hasEqualBorders(
            newCellProps.getStyleDiagonalBlTrAttribute(),
            followingCellProps.getStyleDiagonalBlTrAttribute(),
            null,
            null)
        && !hasEqualBorders(
            newCellProps.getStyleDiagonalBlTrWidthsAttribute(),
            followingCellProps.getStyleDiagonalBlTrWidthsAttribute(),
            null,
            null)) {
      diagonalCrossRemoval =
          (byte)
              (StyleTableCellPropertiesElement.DIAGONAL_CROSS_BOTTOM_LEFT_START
                  | diagonalCrossRemoval);
    } else {
      diagonalCrossRemoval =
          (byte)
              (~StyleTableCellPropertiesElement.DIAGONAL_CROSS_BOTTOM_LEFT_START
                  & diagonalCrossRemoval);
    }

    // Compare the diagonal starting from top left to bottom right
    if (!hasEqualBorders(
            newCellProps.getStyleDiagonalTlBrAttribute(),
            followingCellProps.getStyleDiagonalTlBrAttribute(),
            null,
            null)
        && !hasEqualBorders(
            newCellProps.getStyleDiagonalTlBrWidthsAttribute(),
            followingCellProps.getStyleDiagonalTlBrWidthsAttribute(),
            null,
            null)) {
      diagonalCrossRemoval =
          (byte)
              (StyleTableCellPropertiesElement.DIAGONAL_CROSS_TOP_LEFT_START
                  | diagonalCrossRemoval);
    } else {
      diagonalCrossRemoval =
          (byte)
              (~StyleTableCellPropertiesElement.DIAGONAL_CROSS_TOP_LEFT_START
                  & diagonalCrossRemoval);
    }
    return diagonalCrossRemoval;
  }

  /** Find different borders of the given cell property elements. */
  public static byte findDifferentBorders(
      StyleTableCellPropertiesElement newCellProps,
      StyleTableCellPropertiesElement followingCellProps) {
    byte borderRemoval = StyleTableCellPropertiesElement.BORDER_NONE;

    // remove all borders if both border style exist, but are different, or only the first exist and
    String firstCellBorderDefault = newCellProps.getFoBorderAttribute();
    String secondCellBorderDefault = followingCellProps.getFoBorderAttribute();
    if (!hasEqualBorders(firstCellBorderDefault, secondCellBorderDefault, null, null)) {
      borderRemoval = StyleTableCellPropertiesElement.BORDER_ALL;
    }
    // Compare Top border
    if (!hasEqualBorders(
        newCellProps.getFoBorderTopAttribute(),
        followingCellProps.getFoBorderTopAttribute(),
        firstCellBorderDefault,
        secondCellBorderDefault)) {
      borderRemoval = (byte) (StyleTableCellPropertiesElement.BORDER_TOP | borderRemoval);
    } else {
      borderRemoval = (byte) (~StyleTableCellPropertiesElement.BORDER_TOP & borderRemoval);
    }

    // Compare Right border
    if (!hasEqualBorders(
        newCellProps.getFoBorderRightAttribute(),
        followingCellProps.getFoBorderRightAttribute(),
        firstCellBorderDefault,
        secondCellBorderDefault)) {
      borderRemoval = (byte) (StyleTableCellPropertiesElement.BORDER_RIGHT | borderRemoval);
    } else {
      borderRemoval = (byte) (~StyleTableCellPropertiesElement.BORDER_RIGHT & borderRemoval);
    }

    // Compare Bottom border
    if (!hasEqualBorders(
        newCellProps.getFoBorderBottomAttribute(),
        followingCellProps.getFoBorderBottomAttribute(),
        firstCellBorderDefault,
        secondCellBorderDefault)) {
      borderRemoval = (byte) (StyleTableCellPropertiesElement.BORDER_BOTTOM | borderRemoval);
    } else {
      borderRemoval = (byte) (~StyleTableCellPropertiesElement.BORDER_BOTTOM & borderRemoval);
    }

    // Compare Left border
    if (!hasEqualBorders(
        newCellProps.getFoBorderLeftAttribute(),
        followingCellProps.getFoBorderLeftAttribute(),
        firstCellBorderDefault,
        secondCellBorderDefault)) {
      borderRemoval = (byte) (StyleTableCellPropertiesElement.BORDER_LEFT | borderRemoval);
    } else {
      borderRemoval = (byte) (~StyleTableCellPropertiesElement.BORDER_LEFT & borderRemoval);
    }
    return borderRemoval;
  }

  /**
   * @return true if both border values either null or have the same value or one is zero, but has a
   *     default value (ie. fo:border) with similar value
   */
  private static boolean hasEqualBorders(
      String borderValueOne,
      String borderValueTwo,
      String firstCellBorderDefault,
      String secondCellBorderDefault) {
    // if all borders are null they are equal, no effort of removing have to be undertaken
    return (borderValueOne == null
            && borderValueTwo == null
            && firstCellBorderDefault == null
            && secondCellBorderDefault == null)
        // if both specific border exist an are not null
        || (borderValueOne != null
            && borderValueTwo != null
            && borderValueOne.equals(borderValueTwo))
        // if one specific border exist the other has the same value from the default (all round
        // border)
        || (borderValueOne == null
            && borderValueTwo != null
            && firstCellBorderDefault != null
            && borderValueTwo.equals(firstCellBorderDefault))
        // if one specific border exist the other has the same value from the default (all round
        // border)
        || (borderValueOne != null
            && borderValueTwo == null
            && secondCellBorderDefault != null
            && borderValueOne.equals(secondCellBorderDefault))
        // if no specific value is set, but the both defaults are set and the same
        || borderValueOne == null
            && borderValueTwo == null
            && firstCellBorderDefault != null
            && secondCellBorderDefault != null
            && firstCellBorderDefault.equals(secondCellBorderDefault);
  }
}
