/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextStartValueAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStyleOverrideAttribute;
import org.odftoolkit.odfdom.dom.attribute.xml.XmlIdAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element text:list-item}. */
public class TextListItemElement extends OdfElement {

  public static final OdfName ELEMENT_NAME =
      OdfName.newName(OdfDocumentNamespace.TEXT, "list-item");

  /**
   * Create the instance of <code>TextListItemElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public TextListItemElement(OdfFileDom ownerDoc) {
    super(ownerDoc, ELEMENT_NAME);
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element text:list-item}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TextStartValueAttribute</code>
   * , See {@odf.attribute text:start-value}
   *
   * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Integer getTextStartValueAttribute() {
    TextStartValueAttribute attr =
        (TextStartValueAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "start-value");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Integer.valueOf(attr.intValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TextStartValueAttribute</code> , See
   * {@odf.attribute text:start-value}
   *
   * @param textStartValueValue The type is <code>Integer</code>
   */
  public void setTextStartValueAttribute(Integer textStartValueValue) {
    TextStartValueAttribute attr = new TextStartValueAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setIntValue(textStartValueValue.intValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TextStyleOverrideAttribute
   * </code> , See {@odf.attribute text:style-override}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getTextStyleOverrideAttribute() {
    TextStyleOverrideAttribute attr =
        (TextStyleOverrideAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "style-override");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TextStyleOverrideAttribute</code> , See
   * {@odf.attribute text:style-override}
   *
   * @param textStyleOverrideValue The type is <code>String</code>
   */
  public void setTextStyleOverrideAttribute(String textStyleOverrideValue) {
    TextStyleOverrideAttribute attr =
        new TextStyleOverrideAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(textStyleOverrideValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>XmlIdAttribute</code> , See
   * {@odf.attribute xml:id}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getXmlIdAttribute() {
    XmlIdAttribute attr = (XmlIdAttribute) getOdfAttribute(OdfDocumentNamespace.XML, "id");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>XmlIdAttribute</code> , See
   * {@odf.attribute xml:id}
   *
   * @param xmlIdValue The type is <code>String</code>
   */
  public void setXmlIdAttribute(String xmlIdValue) {
    XmlIdAttribute attr = new XmlIdAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(xmlIdValue);
  }

  /**
   * Create child element {@odf.element text:h}.
   *
   * @param textOutlineLevelValue the <code>Integer</code> value of <code>TextOutlineLevelAttribute
   *     </code>, see {@odf.attribute text:outline-level} at specification
   * @return the element {@odf.element text:h}
   */
  public TextHElement newTextHElement(int textOutlineLevelValue) {
    TextHElement textH = ((OdfFileDom) this.ownerDocument).newOdfElement(TextHElement.class);
    textH.setTextOutlineLevelAttribute(textOutlineLevelValue);
    this.appendChild(textH);
    return textH;
  }

  /**
   * Create child element {@odf.element text:list}.
   *
   * @return the element {@odf.element text:list}
   */
  public TextListElement newTextListElement() {
    TextListElement textList =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextListElement.class);
    this.appendChild(textList);
    return textList;
  }

  /**
   * Create child element {@odf.element text:number}.
   *
   * @return the element {@odf.element text:number}
   */
  public TextNumberElement newTextNumberElement() {
    TextNumberElement textNumber =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextNumberElement.class);
    this.appendChild(textNumber);
    return textNumber;
  }

  /**
   * Create child element {@odf.element text:p}.
   *
   * @return the element {@odf.element text:p}
   */
  public TextPElement newTextPElement() {
    TextPElement textP = ((OdfFileDom) this.ownerDocument).newOdfElement(TextPElement.class);
    this.appendChild(textP);
    return textP;
  }

  /**
   * Create child element {@odf.element text:soft-page-break}.
   *
   * <p>Child element was added in ODF 1.1
   *
   * @return the element {@odf.element text:soft-page-break}
   */
  public TextSoftPageBreakElement newTextSoftPageBreakElement() {
    TextSoftPageBreakElement textSoftPageBreak =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSoftPageBreakElement.class);
    this.appendChild(textSoftPageBreak);
    return textSoftPageBreak;
  }

  /**
   * Accept an visitor instance to allow the visitor to do some operations. Refer to visitor design
   * pattern to get a better understanding.
   *
   * @param visitor an instance of DefaultElementVisitor
   */
  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }
}
