/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.db;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.db.DbCommandAttribute;
import org.odftoolkit.odfdom.dom.attribute.db.DbDefaultRowStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.db.DbDescriptionAttribute;
import org.odftoolkit.odfdom.dom.attribute.db.DbEscapeProcessingAttribute;
import org.odftoolkit.odfdom.dom.attribute.db.DbNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.db.DbStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.db.DbTitleAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element db:query}. */
public class DbQueryElement extends OdfElement {

  public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.DB, "query");

  /**
   * Create the instance of <code>DbQueryElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public DbQueryElement(OdfFileDom ownerDoc) {
    super(ownerDoc, ELEMENT_NAME);
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element db:query}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DbCommandAttribute</code> , See
   * {@odf.attribute db:command}
   *
   * <p>Attribute is mandatory.
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDbCommandAttribute() {
    DbCommandAttribute attr =
        (DbCommandAttribute) getOdfAttribute(OdfDocumentNamespace.DB, "command");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DbCommandAttribute</code> , See
   * {@odf.attribute db:command}
   *
   * @param dbCommandValue The type is <code>String</code>
   */
  public void setDbCommandAttribute(String dbCommandValue) {
    DbCommandAttribute attr = new DbCommandAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(dbCommandValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DbDefaultRowStyleNameAttribute
   * </code> , See {@odf.attribute db:default-row-style-name}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDbDefaultRowStyleNameAttribute() {
    DbDefaultRowStyleNameAttribute attr =
        (DbDefaultRowStyleNameAttribute)
            getOdfAttribute(OdfDocumentNamespace.DB, "default-row-style-name");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DbDefaultRowStyleNameAttribute</code> ,
   * See {@odf.attribute db:default-row-style-name}
   *
   * @param dbDefaultRowStyleNameValue The type is <code>String</code>
   */
  public void setDbDefaultRowStyleNameAttribute(String dbDefaultRowStyleNameValue) {
    DbDefaultRowStyleNameAttribute attr =
        new DbDefaultRowStyleNameAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(dbDefaultRowStyleNameValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DbDescriptionAttribute</code> ,
   * See {@odf.attribute db:description}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDbDescriptionAttribute() {
    DbDescriptionAttribute attr =
        (DbDescriptionAttribute) getOdfAttribute(OdfDocumentNamespace.DB, "description");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DbDescriptionAttribute</code> , See
   * {@odf.attribute db:description}
   *
   * @param dbDescriptionValue The type is <code>String</code>
   */
  public void setDbDescriptionAttribute(String dbDescriptionValue) {
    DbDescriptionAttribute attr = new DbDescriptionAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(dbDescriptionValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DbEscapeProcessingAttribute
   * </code> , See {@odf.attribute db:escape-processing}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getDbEscapeProcessingAttribute() {
    DbEscapeProcessingAttribute attr =
        (DbEscapeProcessingAttribute) getOdfAttribute(OdfDocumentNamespace.DB, "escape-processing");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(DbEscapeProcessingAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DbEscapeProcessingAttribute</code> ,
   * See {@odf.attribute db:escape-processing}
   *
   * @param dbEscapeProcessingValue The type is <code>Boolean</code>
   */
  public void setDbEscapeProcessingAttribute(Boolean dbEscapeProcessingValue) {
    DbEscapeProcessingAttribute attr =
        new DbEscapeProcessingAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(dbEscapeProcessingValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DbNameAttribute</code> , See
   * {@odf.attribute db:name}
   *
   * <p>Attribute is mandatory.
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDbNameAttribute() {
    DbNameAttribute attr = (DbNameAttribute) getOdfAttribute(OdfDocumentNamespace.DB, "name");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DbNameAttribute</code> , See
   * {@odf.attribute db:name}
   *
   * @param dbNameValue The type is <code>String</code>
   */
  public void setDbNameAttribute(String dbNameValue) {
    DbNameAttribute attr = new DbNameAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(dbNameValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DbStyleNameAttribute</code> ,
   * See {@odf.attribute db:style-name}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDbStyleNameAttribute() {
    DbStyleNameAttribute attr =
        (DbStyleNameAttribute) getOdfAttribute(OdfDocumentNamespace.DB, "style-name");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DbStyleNameAttribute</code> , See
   * {@odf.attribute db:style-name}
   *
   * @param dbStyleNameValue The type is <code>String</code>
   */
  public void setDbStyleNameAttribute(String dbStyleNameValue) {
    DbStyleNameAttribute attr = new DbStyleNameAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(dbStyleNameValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DbTitleAttribute</code> , See
   * {@odf.attribute db:title}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDbTitleAttribute() {
    DbTitleAttribute attr = (DbTitleAttribute) getOdfAttribute(OdfDocumentNamespace.DB, "title");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DbTitleAttribute</code> , See
   * {@odf.attribute db:title}
   *
   * @param dbTitleValue The type is <code>String</code>
   */
  public void setDbTitleAttribute(String dbTitleValue) {
    DbTitleAttribute attr = new DbTitleAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(dbTitleValue);
  }

  /**
   * Create child element {@odf.element db:columns}.
   *
   * <p>Child element was added in ODF 1.2
   *
   * @return the element {@odf.element db:columns}
   */
  public DbColumnsElement newDbColumnsElement() {
    DbColumnsElement dbColumns =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DbColumnsElement.class);
    this.appendChild(dbColumns);
    return dbColumns;
  }

  /**
   * Create child element {@odf.element db:filter-statement}.
   *
   * @param dbCommandValue the <code>String</code> value of <code>DbCommandAttribute</code>, see
   *     {@odf.attribute db:command} at specification Child element was added in ODF 1.2
   * @return the element {@odf.element db:filter-statement}
   */
  public DbFilterStatementElement newDbFilterStatementElement(String dbCommandValue) {
    DbFilterStatementElement dbFilterStatement =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DbFilterStatementElement.class);
    dbFilterStatement.setDbCommandAttribute(dbCommandValue);
    this.appendChild(dbFilterStatement);
    return dbFilterStatement;
  }

  /**
   * Create child element {@odf.element db:order-statement}.
   *
   * @param dbCommandValue the <code>String</code> value of <code>DbCommandAttribute</code>, see
   *     {@odf.attribute db:command} at specification Child element was added in ODF 1.2
   * @return the element {@odf.element db:order-statement}
   */
  public DbOrderStatementElement newDbOrderStatementElement(String dbCommandValue) {
    DbOrderStatementElement dbOrderStatement =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DbOrderStatementElement.class);
    dbOrderStatement.setDbCommandAttribute(dbCommandValue);
    this.appendChild(dbOrderStatement);
    return dbOrderStatement;
  }

  /**
   * Create child element {@odf.element db:update-table}.
   *
   * @param dbNameValue the <code>String</code> value of <code>DbNameAttribute</code>, see
   *     {@odf.attribute db:name} at specification Child element was added in ODF 1.2
   * @return the element {@odf.element db:update-table}
   */
  public DbUpdateTableElement newDbUpdateTableElement(String dbNameValue) {
    DbUpdateTableElement dbUpdateTable =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DbUpdateTableElement.class);
    dbUpdateTable.setDbNameAttribute(dbNameValue);
    this.appendChild(dbUpdateTable);
    return dbUpdateTable;
  }

  /**
   * Accept an visitor instance to allow the visitor to do some operations. Refer to visitor design
   * pattern to get a better understanding.
   *
   * @param visitor an instance of DefaultElementVisitor
   */
  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }
}
