/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.form;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.form.FormCurrentSelectedAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormLabelAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormSelectedAttribute;
import org.odftoolkit.odfdom.dom.attribute.form.FormValueAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element form:option}. */
public class FormOptionElement extends OdfElement {

  public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.FORM, "option");

  /**
   * Create the instance of <code>FormOptionElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public FormOptionElement(OdfFileDom ownerDoc) {
    super(ownerDoc, ELEMENT_NAME);
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element form:option}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FormCurrentSelectedAttribute
   * </code> , See {@odf.attribute form:current-selected}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getFormCurrentSelectedAttribute() {
    FormCurrentSelectedAttribute attr =
        (FormCurrentSelectedAttribute)
            getOdfAttribute(OdfDocumentNamespace.FORM, "current-selected");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(FormCurrentSelectedAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FormCurrentSelectedAttribute</code> ,
   * See {@odf.attribute form:current-selected}
   *
   * @param formCurrentSelectedValue The type is <code>Boolean</code>
   */
  public void setFormCurrentSelectedAttribute(Boolean formCurrentSelectedValue) {
    FormCurrentSelectedAttribute attr =
        new FormCurrentSelectedAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(formCurrentSelectedValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FormLabelAttribute</code> , See
   * {@odf.attribute form:label}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFormLabelAttribute() {
    FormLabelAttribute attr =
        (FormLabelAttribute) getOdfAttribute(OdfDocumentNamespace.FORM, "label");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FormLabelAttribute</code> , See
   * {@odf.attribute form:label}
   *
   * @param formLabelValue The type is <code>String</code>
   */
  public void setFormLabelAttribute(String formLabelValue) {
    FormLabelAttribute attr = new FormLabelAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(formLabelValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FormSelectedAttribute</code> ,
   * See {@odf.attribute form:selected}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getFormSelectedAttribute() {
    FormSelectedAttribute attr =
        (FormSelectedAttribute) getOdfAttribute(OdfDocumentNamespace.FORM, "selected");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(FormSelectedAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FormSelectedAttribute</code> , See
   * {@odf.attribute form:selected}
   *
   * @param formSelectedValue The type is <code>Boolean</code>
   */
  public void setFormSelectedAttribute(Boolean formSelectedValue) {
    FormSelectedAttribute attr = new FormSelectedAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(formSelectedValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>FormValueAttribute</code> , See
   * {@odf.attribute form:value}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getFormValueAttribute() {
    FormValueAttribute attr =
        (FormValueAttribute) getOdfAttribute(OdfDocumentNamespace.FORM, "value");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>FormValueAttribute</code> , See
   * {@odf.attribute form:value}
   *
   * @param formValueValue The type is <code>String</code>
   */
  public void setFormValueAttribute(String formValueValue) {
    FormValueAttribute attr = new FormValueAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(formValueValue);
  }

  /**
   * Accept an visitor instance to allow the visitor to do some operations. Refer to visitor design
   * pattern to get a better understanding.
   *
   * @param visitor an instance of DefaultElementVisitor
   */
  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }

  /** Add text content. Only elements which are allowed to have text content offer this method. */
  public void newTextNode(String content) {
    if (content != null && !content.equals("")) {
      this.appendChild(this.getOwnerDocument().createTextNode(content));
    }
  }
}
