/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.draw;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dProjectionAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dShadeModeAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawConcentricGradientFillAllowedAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawEnhancedPathAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionAllowedAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionBrightnessAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionDepthAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionDiffusionAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionFirstLightDirectionAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionFirstLightHarshAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionFirstLightLevelAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionLightFaceAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionMetalAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionNumberOfLineSegmentsAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionOriginAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionRotationAngleAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionRotationCenterAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionSecondLightDirectionAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionSecondLightHarshAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionSecondLightLevelAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionShininessAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionSkewAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionSpecularityAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawExtrusionViewpointAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawGluePointLeavingDirectionsAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawGluePointTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawGluePointsAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawMirrorHorizontalAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawMirrorVerticalAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawModifiersAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawPathStretchpointXAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawPathStretchpointYAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawTextAreasAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawTextPathAllowedAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawTextPathAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawTextPathModeAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawTextPathSameLetterHeightsAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawTextPathScaleAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawTextRotateAngleAttribute;
import org.odftoolkit.odfdom.dom.attribute.draw.DrawTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.svg.SvgViewBoxAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element draw:enhanced-geometry}. */
public class DrawEnhancedGeometryElement extends OdfElement {

  public static final OdfName ELEMENT_NAME =
      OdfName.newName(OdfDocumentNamespace.DRAW, "enhanced-geometry");

  /**
   * Create the instance of <code>DrawEnhancedGeometryElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public DrawEnhancedGeometryElement(OdfFileDom ownerDoc) {
    super(ownerDoc, ELEMENT_NAME);
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element draw:enhanced-geometry}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>Dr3dProjectionAttribute</code>
   * , See {@odf.attribute dr3d:projection}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDr3dProjectionAttribute() {
    Dr3dProjectionAttribute attr =
        (Dr3dProjectionAttribute) getOdfAttribute(OdfDocumentNamespace.DR3D, "projection");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return Dr3dProjectionAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>Dr3dProjectionAttribute</code> , See
   * {@odf.attribute dr3d:projection}
   *
   * @param dr3dProjectionValue The type is <code>String</code>
   */
  public void setDr3dProjectionAttribute(String dr3dProjectionValue) {
    Dr3dProjectionAttribute attr = new Dr3dProjectionAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(dr3dProjectionValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>Dr3dShadeModeAttribute</code> ,
   * See {@odf.attribute dr3d:shade-mode}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDr3dShadeModeAttribute() {
    Dr3dShadeModeAttribute attr =
        (Dr3dShadeModeAttribute) getOdfAttribute(OdfDocumentNamespace.DR3D, "shade-mode");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return Dr3dShadeModeAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>Dr3dShadeModeAttribute</code> , See
   * {@odf.attribute dr3d:shade-mode}
   *
   * @param dr3dShadeModeValue The type is <code>String</code>
   */
  public void setDr3dShadeModeAttribute(String dr3dShadeModeValue) {
    Dr3dShadeModeAttribute attr = new Dr3dShadeModeAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(dr3dShadeModeValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * DrawConcentricGradientFillAllowedAttribute</code> , See {@odf.attribute
   * draw:concentric-gradient-fill-allowed}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getDrawConcentricGradientFillAllowedAttribute() {
    DrawConcentricGradientFillAllowedAttribute attr =
        (DrawConcentricGradientFillAllowedAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "concentric-gradient-fill-allowed");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(DrawConcentricGradientFillAllowedAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>
   * DrawConcentricGradientFillAllowedAttribute</code> , See {@odf.attribute
   * draw:concentric-gradient-fill-allowed}
   *
   * @param drawConcentricGradientFillAllowedValue The type is <code>Boolean</code>
   */
  public void setDrawConcentricGradientFillAllowedAttribute(
      Boolean drawConcentricGradientFillAllowedValue) {
    DrawConcentricGradientFillAllowedAttribute attr =
        new DrawConcentricGradientFillAllowedAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(drawConcentricGradientFillAllowedValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawEnhancedPathAttribute
   * </code> , See {@odf.attribute draw:enhanced-path}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawEnhancedPathAttribute() {
    DrawEnhancedPathAttribute attr =
        (DrawEnhancedPathAttribute) getOdfAttribute(OdfDocumentNamespace.DRAW, "enhanced-path");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawEnhancedPathAttribute</code> , See
   * {@odf.attribute draw:enhanced-path}
   *
   * @param drawEnhancedPathValue The type is <code>String</code>
   */
  public void setDrawEnhancedPathAttribute(String drawEnhancedPathValue) {
    DrawEnhancedPathAttribute attr = new DrawEnhancedPathAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawEnhancedPathValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawExtrusionAttribute</code> ,
   * See {@odf.attribute draw:extrusion}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getDrawExtrusionAttribute() {
    DrawExtrusionAttribute attr =
        (DrawExtrusionAttribute) getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(DrawExtrusionAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawExtrusionAttribute</code> , See
   * {@odf.attribute draw:extrusion}
   *
   * @param drawExtrusionValue The type is <code>Boolean</code>
   */
  public void setDrawExtrusionAttribute(Boolean drawExtrusionValue) {
    DrawExtrusionAttribute attr = new DrawExtrusionAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(drawExtrusionValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawExtrusionAllowedAttribute
   * </code> , See {@odf.attribute draw:extrusion-allowed}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getDrawExtrusionAllowedAttribute() {
    DrawExtrusionAllowedAttribute attr =
        (DrawExtrusionAllowedAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-allowed");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(DrawExtrusionAllowedAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawExtrusionAllowedAttribute</code> ,
   * See {@odf.attribute draw:extrusion-allowed}
   *
   * @param drawExtrusionAllowedValue The type is <code>Boolean</code>
   */
  public void setDrawExtrusionAllowedAttribute(Boolean drawExtrusionAllowedValue) {
    DrawExtrusionAllowedAttribute attr =
        new DrawExtrusionAllowedAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(drawExtrusionAllowedValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * DrawExtrusionBrightnessAttribute</code> , See {@odf.attribute draw:extrusion-brightness}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawExtrusionBrightnessAttribute() {
    DrawExtrusionBrightnessAttribute attr =
        (DrawExtrusionBrightnessAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-brightness");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DrawExtrusionBrightnessAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawExtrusionBrightnessAttribute</code>
   * , See {@odf.attribute draw:extrusion-brightness}
   *
   * @param drawExtrusionBrightnessValue The type is <code>String</code>
   */
  public void setDrawExtrusionBrightnessAttribute(String drawExtrusionBrightnessValue) {
    DrawExtrusionBrightnessAttribute attr =
        new DrawExtrusionBrightnessAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawExtrusionBrightnessValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawExtrusionColorAttribute
   * </code> , See {@odf.attribute draw:extrusion-color}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getDrawExtrusionColorAttribute() {
    DrawExtrusionColorAttribute attr =
        (DrawExtrusionColorAttribute) getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-color");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(DrawExtrusionColorAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawExtrusionColorAttribute</code> ,
   * See {@odf.attribute draw:extrusion-color}
   *
   * @param drawExtrusionColorValue The type is <code>Boolean</code>
   */
  public void setDrawExtrusionColorAttribute(Boolean drawExtrusionColorValue) {
    DrawExtrusionColorAttribute attr =
        new DrawExtrusionColorAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(drawExtrusionColorValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawExtrusionDepthAttribute
   * </code> , See {@odf.attribute draw:extrusion-depth}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawExtrusionDepthAttribute() {
    DrawExtrusionDepthAttribute attr =
        (DrawExtrusionDepthAttribute) getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-depth");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DrawExtrusionDepthAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawExtrusionDepthAttribute</code> ,
   * See {@odf.attribute draw:extrusion-depth}
   *
   * @param drawExtrusionDepthValue The type is <code>String</code>
   */
  public void setDrawExtrusionDepthAttribute(String drawExtrusionDepthValue) {
    DrawExtrusionDepthAttribute attr =
        new DrawExtrusionDepthAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawExtrusionDepthValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawExtrusionDiffusionAttribute
   * </code> , See {@odf.attribute draw:extrusion-diffusion}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawExtrusionDiffusionAttribute() {
    DrawExtrusionDiffusionAttribute attr =
        (DrawExtrusionDiffusionAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-diffusion");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DrawExtrusionDiffusionAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawExtrusionDiffusionAttribute</code>
   * , See {@odf.attribute draw:extrusion-diffusion}
   *
   * @param drawExtrusionDiffusionValue The type is <code>String</code>
   */
  public void setDrawExtrusionDiffusionAttribute(String drawExtrusionDiffusionValue) {
    DrawExtrusionDiffusionAttribute attr =
        new DrawExtrusionDiffusionAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawExtrusionDiffusionValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * DrawExtrusionFirstLightDirectionAttribute</code> , See {@odf.attribute
   * draw:extrusion-first-light-direction}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawExtrusionFirstLightDirectionAttribute() {
    DrawExtrusionFirstLightDirectionAttribute attr =
        (DrawExtrusionFirstLightDirectionAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-first-light-direction");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DrawExtrusionFirstLightDirectionAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>
   * DrawExtrusionFirstLightDirectionAttribute</code> , See {@odf.attribute
   * draw:extrusion-first-light-direction}
   *
   * @param drawExtrusionFirstLightDirectionValue The type is <code>String</code>
   */
  public void setDrawExtrusionFirstLightDirectionAttribute(
      String drawExtrusionFirstLightDirectionValue) {
    DrawExtrusionFirstLightDirectionAttribute attr =
        new DrawExtrusionFirstLightDirectionAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawExtrusionFirstLightDirectionValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * DrawExtrusionFirstLightHarshAttribute</code> , See {@odf.attribute
   * draw:extrusion-first-light-harsh}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getDrawExtrusionFirstLightHarshAttribute() {
    DrawExtrusionFirstLightHarshAttribute attr =
        (DrawExtrusionFirstLightHarshAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-first-light-harsh");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(DrawExtrusionFirstLightHarshAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawExtrusionFirstLightHarshAttribute
   * </code> , See {@odf.attribute draw:extrusion-first-light-harsh}
   *
   * @param drawExtrusionFirstLightHarshValue The type is <code>Boolean</code>
   */
  public void setDrawExtrusionFirstLightHarshAttribute(Boolean drawExtrusionFirstLightHarshValue) {
    DrawExtrusionFirstLightHarshAttribute attr =
        new DrawExtrusionFirstLightHarshAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(drawExtrusionFirstLightHarshValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * DrawExtrusionFirstLightLevelAttribute</code> , See {@odf.attribute
   * draw:extrusion-first-light-level}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawExtrusionFirstLightLevelAttribute() {
    DrawExtrusionFirstLightLevelAttribute attr =
        (DrawExtrusionFirstLightLevelAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-first-light-level");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DrawExtrusionFirstLightLevelAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawExtrusionFirstLightLevelAttribute
   * </code> , See {@odf.attribute draw:extrusion-first-light-level}
   *
   * @param drawExtrusionFirstLightLevelValue The type is <code>String</code>
   */
  public void setDrawExtrusionFirstLightLevelAttribute(String drawExtrusionFirstLightLevelValue) {
    DrawExtrusionFirstLightLevelAttribute attr =
        new DrawExtrusionFirstLightLevelAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawExtrusionFirstLightLevelValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawExtrusionLightFaceAttribute
   * </code> , See {@odf.attribute draw:extrusion-light-face}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getDrawExtrusionLightFaceAttribute() {
    DrawExtrusionLightFaceAttribute attr =
        (DrawExtrusionLightFaceAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-light-face");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(DrawExtrusionLightFaceAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawExtrusionLightFaceAttribute</code>
   * , See {@odf.attribute draw:extrusion-light-face}
   *
   * @param drawExtrusionLightFaceValue The type is <code>Boolean</code>
   */
  public void setDrawExtrusionLightFaceAttribute(Boolean drawExtrusionLightFaceValue) {
    DrawExtrusionLightFaceAttribute attr =
        new DrawExtrusionLightFaceAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(drawExtrusionLightFaceValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawExtrusionMetalAttribute
   * </code> , See {@odf.attribute draw:extrusion-metal}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getDrawExtrusionMetalAttribute() {
    DrawExtrusionMetalAttribute attr =
        (DrawExtrusionMetalAttribute) getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-metal");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(DrawExtrusionMetalAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawExtrusionMetalAttribute</code> ,
   * See {@odf.attribute draw:extrusion-metal}
   *
   * @param drawExtrusionMetalValue The type is <code>Boolean</code>
   */
  public void setDrawExtrusionMetalAttribute(Boolean drawExtrusionMetalValue) {
    DrawExtrusionMetalAttribute attr =
        new DrawExtrusionMetalAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(drawExtrusionMetalValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * DrawExtrusionNumberOfLineSegmentsAttribute</code> , See {@odf.attribute
   * draw:extrusion-number-of-line-segments}
   *
   * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Integer getDrawExtrusionNumberOfLineSegmentsAttribute() {
    DrawExtrusionNumberOfLineSegmentsAttribute attr =
        (DrawExtrusionNumberOfLineSegmentsAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-number-of-line-segments");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Integer.valueOf(attr.intValue());
    }
    return Integer.valueOf(DrawExtrusionNumberOfLineSegmentsAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>
   * DrawExtrusionNumberOfLineSegmentsAttribute</code> , See {@odf.attribute
   * draw:extrusion-number-of-line-segments}
   *
   * @param drawExtrusionNumberOfLineSegmentsValue The type is <code>Integer</code>
   */
  public void setDrawExtrusionNumberOfLineSegmentsAttribute(
      Integer drawExtrusionNumberOfLineSegmentsValue) {
    DrawExtrusionNumberOfLineSegmentsAttribute attr =
        new DrawExtrusionNumberOfLineSegmentsAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setIntValue(drawExtrusionNumberOfLineSegmentsValue.intValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawExtrusionOriginAttribute
   * </code> , See {@odf.attribute draw:extrusion-origin}
   *
   * @return - the <code>Double</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public Double getDrawExtrusionOriginAttribute() {
    DrawExtrusionOriginAttribute attr =
        (DrawExtrusionOriginAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-origin");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Double.valueOf(attr.doubleValue());
    }
    return Double.valueOf(DrawExtrusionOriginAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawExtrusionOriginAttribute</code> ,
   * See {@odf.attribute draw:extrusion-origin}
   *
   * @param drawExtrusionOriginValue The type is <code>Double</code>
   */
  public void setDrawExtrusionOriginAttribute(Double drawExtrusionOriginValue) {
    DrawExtrusionOriginAttribute attr =
        new DrawExtrusionOriginAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setDoubleValue(drawExtrusionOriginValue.doubleValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * DrawExtrusionRotationAngleAttribute</code> , See {@odf.attribute draw:extrusion-rotation-angle}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawExtrusionRotationAngleAttribute() {
    DrawExtrusionRotationAngleAttribute attr =
        (DrawExtrusionRotationAngleAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-rotation-angle");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DrawExtrusionRotationAngleAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawExtrusionRotationAngleAttribute
   * </code> , See {@odf.attribute draw:extrusion-rotation-angle}
   *
   * @param drawExtrusionRotationAngleValue The type is <code>String</code>
   */
  public void setDrawExtrusionRotationAngleAttribute(String drawExtrusionRotationAngleValue) {
    DrawExtrusionRotationAngleAttribute attr =
        new DrawExtrusionRotationAngleAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawExtrusionRotationAngleValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * DrawExtrusionRotationCenterAttribute</code> , See {@odf.attribute
   * draw:extrusion-rotation-center}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawExtrusionRotationCenterAttribute() {
    DrawExtrusionRotationCenterAttribute attr =
        (DrawExtrusionRotationCenterAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-rotation-center");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawExtrusionRotationCenterAttribute
   * </code> , See {@odf.attribute draw:extrusion-rotation-center}
   *
   * @param drawExtrusionRotationCenterValue The type is <code>String</code>
   */
  public void setDrawExtrusionRotationCenterAttribute(String drawExtrusionRotationCenterValue) {
    DrawExtrusionRotationCenterAttribute attr =
        new DrawExtrusionRotationCenterAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawExtrusionRotationCenterValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * DrawExtrusionSecondLightDirectionAttribute</code> , See {@odf.attribute
   * draw:extrusion-second-light-direction}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawExtrusionSecondLightDirectionAttribute() {
    DrawExtrusionSecondLightDirectionAttribute attr =
        (DrawExtrusionSecondLightDirectionAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-second-light-direction");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DrawExtrusionSecondLightDirectionAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>
   * DrawExtrusionSecondLightDirectionAttribute</code> , See {@odf.attribute
   * draw:extrusion-second-light-direction}
   *
   * @param drawExtrusionSecondLightDirectionValue The type is <code>String</code>
   */
  public void setDrawExtrusionSecondLightDirectionAttribute(
      String drawExtrusionSecondLightDirectionValue) {
    DrawExtrusionSecondLightDirectionAttribute attr =
        new DrawExtrusionSecondLightDirectionAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawExtrusionSecondLightDirectionValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * DrawExtrusionSecondLightHarshAttribute</code> , See {@odf.attribute
   * draw:extrusion-second-light-harsh}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getDrawExtrusionSecondLightHarshAttribute() {
    DrawExtrusionSecondLightHarshAttribute attr =
        (DrawExtrusionSecondLightHarshAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-second-light-harsh");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(DrawExtrusionSecondLightHarshAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawExtrusionSecondLightHarshAttribute
   * </code> , See {@odf.attribute draw:extrusion-second-light-harsh}
   *
   * @param drawExtrusionSecondLightHarshValue The type is <code>Boolean</code>
   */
  public void setDrawExtrusionSecondLightHarshAttribute(
      Boolean drawExtrusionSecondLightHarshValue) {
    DrawExtrusionSecondLightHarshAttribute attr =
        new DrawExtrusionSecondLightHarshAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(drawExtrusionSecondLightHarshValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * DrawExtrusionSecondLightLevelAttribute</code> , See {@odf.attribute
   * draw:extrusion-second-light-level}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawExtrusionSecondLightLevelAttribute() {
    DrawExtrusionSecondLightLevelAttribute attr =
        (DrawExtrusionSecondLightLevelAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-second-light-level");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DrawExtrusionSecondLightLevelAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawExtrusionSecondLightLevelAttribute
   * </code> , See {@odf.attribute draw:extrusion-second-light-level}
   *
   * @param drawExtrusionSecondLightLevelValue The type is <code>String</code>
   */
  public void setDrawExtrusionSecondLightLevelAttribute(String drawExtrusionSecondLightLevelValue) {
    DrawExtrusionSecondLightLevelAttribute attr =
        new DrawExtrusionSecondLightLevelAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawExtrusionSecondLightLevelValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawExtrusionShininessAttribute
   * </code> , See {@odf.attribute draw:extrusion-shininess}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawExtrusionShininessAttribute() {
    DrawExtrusionShininessAttribute attr =
        (DrawExtrusionShininessAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-shininess");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DrawExtrusionShininessAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawExtrusionShininessAttribute</code>
   * , See {@odf.attribute draw:extrusion-shininess}
   *
   * @param drawExtrusionShininessValue The type is <code>String</code>
   */
  public void setDrawExtrusionShininessAttribute(String drawExtrusionShininessValue) {
    DrawExtrusionShininessAttribute attr =
        new DrawExtrusionShininessAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawExtrusionShininessValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawExtrusionSkewAttribute
   * </code> , See {@odf.attribute draw:extrusion-skew}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawExtrusionSkewAttribute() {
    DrawExtrusionSkewAttribute attr =
        (DrawExtrusionSkewAttribute) getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-skew");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DrawExtrusionSkewAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawExtrusionSkewAttribute</code> , See
   * {@odf.attribute draw:extrusion-skew}
   *
   * @param drawExtrusionSkewValue The type is <code>String</code>
   */
  public void setDrawExtrusionSkewAttribute(String drawExtrusionSkewValue) {
    DrawExtrusionSkewAttribute attr =
        new DrawExtrusionSkewAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawExtrusionSkewValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * DrawExtrusionSpecularityAttribute</code> , See {@odf.attribute draw:extrusion-specularity}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawExtrusionSpecularityAttribute() {
    DrawExtrusionSpecularityAttribute attr =
        (DrawExtrusionSpecularityAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-specularity");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DrawExtrusionSpecularityAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawExtrusionSpecularityAttribute
   * </code> , See {@odf.attribute draw:extrusion-specularity}
   *
   * @param drawExtrusionSpecularityValue The type is <code>String</code>
   */
  public void setDrawExtrusionSpecularityAttribute(String drawExtrusionSpecularityValue) {
    DrawExtrusionSpecularityAttribute attr =
        new DrawExtrusionSpecularityAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawExtrusionSpecularityValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawExtrusionViewpointAttribute
   * </code> , See {@odf.attribute draw:extrusion-viewpoint}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawExtrusionViewpointAttribute() {
    DrawExtrusionViewpointAttribute attr =
        (DrawExtrusionViewpointAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "extrusion-viewpoint");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DrawExtrusionViewpointAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawExtrusionViewpointAttribute</code>
   * , See {@odf.attribute draw:extrusion-viewpoint}
   *
   * @param drawExtrusionViewpointValue The type is <code>String</code>
   */
  public void setDrawExtrusionViewpointAttribute(String drawExtrusionViewpointValue) {
    DrawExtrusionViewpointAttribute attr =
        new DrawExtrusionViewpointAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawExtrusionViewpointValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * DrawGluePointLeavingDirectionsAttribute</code> , See {@odf.attribute
   * draw:glue-point-leaving-directions}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawGluePointLeavingDirectionsAttribute() {
    DrawGluePointLeavingDirectionsAttribute attr =
        (DrawGluePointLeavingDirectionsAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "glue-point-leaving-directions");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawGluePointLeavingDirectionsAttribute
   * </code> , See {@odf.attribute draw:glue-point-leaving-directions}
   *
   * @param drawGluePointLeavingDirectionsValue The type is <code>String</code>
   */
  public void setDrawGluePointLeavingDirectionsAttribute(
      String drawGluePointLeavingDirectionsValue) {
    DrawGluePointLeavingDirectionsAttribute attr =
        new DrawGluePointLeavingDirectionsAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawGluePointLeavingDirectionsValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawGluePointTypeAttribute
   * </code> , See {@odf.attribute draw:glue-point-type}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawGluePointTypeAttribute() {
    DrawGluePointTypeAttribute attr =
        (DrawGluePointTypeAttribute) getOdfAttribute(OdfDocumentNamespace.DRAW, "glue-point-type");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DrawGluePointTypeAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawGluePointTypeAttribute</code> , See
   * {@odf.attribute draw:glue-point-type}
   *
   * @param drawGluePointTypeValue The type is <code>String</code>
   */
  public void setDrawGluePointTypeAttribute(String drawGluePointTypeValue) {
    DrawGluePointTypeAttribute attr =
        new DrawGluePointTypeAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawGluePointTypeValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawGluePointsAttribute</code>
   * , See {@odf.attribute draw:glue-points}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawGluePointsAttribute() {
    DrawGluePointsAttribute attr =
        (DrawGluePointsAttribute) getOdfAttribute(OdfDocumentNamespace.DRAW, "glue-points");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawGluePointsAttribute</code> , See
   * {@odf.attribute draw:glue-points}
   *
   * @param drawGluePointsValue The type is <code>String</code>
   */
  public void setDrawGluePointsAttribute(String drawGluePointsValue) {
    DrawGluePointsAttribute attr = new DrawGluePointsAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawGluePointsValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawMirrorHorizontalAttribute
   * </code> , See {@odf.attribute draw:mirror-horizontal}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getDrawMirrorHorizontalAttribute() {
    DrawMirrorHorizontalAttribute attr =
        (DrawMirrorHorizontalAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "mirror-horizontal");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(DrawMirrorHorizontalAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawMirrorHorizontalAttribute</code> ,
   * See {@odf.attribute draw:mirror-horizontal}
   *
   * @param drawMirrorHorizontalValue The type is <code>Boolean</code>
   */
  public void setDrawMirrorHorizontalAttribute(Boolean drawMirrorHorizontalValue) {
    DrawMirrorHorizontalAttribute attr =
        new DrawMirrorHorizontalAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(drawMirrorHorizontalValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawMirrorVerticalAttribute
   * </code> , See {@odf.attribute draw:mirror-vertical}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getDrawMirrorVerticalAttribute() {
    DrawMirrorVerticalAttribute attr =
        (DrawMirrorVerticalAttribute) getOdfAttribute(OdfDocumentNamespace.DRAW, "mirror-vertical");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(DrawMirrorVerticalAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawMirrorVerticalAttribute</code> ,
   * See {@odf.attribute draw:mirror-vertical}
   *
   * @param drawMirrorVerticalValue The type is <code>Boolean</code>
   */
  public void setDrawMirrorVerticalAttribute(Boolean drawMirrorVerticalValue) {
    DrawMirrorVerticalAttribute attr =
        new DrawMirrorVerticalAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(drawMirrorVerticalValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawModifiersAttribute</code> ,
   * See {@odf.attribute draw:modifiers}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawModifiersAttribute() {
    DrawModifiersAttribute attr =
        (DrawModifiersAttribute) getOdfAttribute(OdfDocumentNamespace.DRAW, "modifiers");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawModifiersAttribute</code> , See
   * {@odf.attribute draw:modifiers}
   *
   * @param drawModifiersValue The type is <code>String</code>
   */
  public void setDrawModifiersAttribute(String drawModifiersValue) {
    DrawModifiersAttribute attr = new DrawModifiersAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawModifiersValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawPathStretchpointXAttribute
   * </code> , See {@odf.attribute draw:path-stretchpoint-x}
   *
   * @return - the <code>Double</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public Double getDrawPathStretchpointXAttribute() {
    DrawPathStretchpointXAttribute attr =
        (DrawPathStretchpointXAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "path-stretchpoint-x");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Double.valueOf(attr.doubleValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawPathStretchpointXAttribute</code> ,
   * See {@odf.attribute draw:path-stretchpoint-x}
   *
   * @param drawPathStretchpointXValue The type is <code>Double</code>
   */
  public void setDrawPathStretchpointXAttribute(Double drawPathStretchpointXValue) {
    DrawPathStretchpointXAttribute attr =
        new DrawPathStretchpointXAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setDoubleValue(drawPathStretchpointXValue.doubleValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawPathStretchpointYAttribute
   * </code> , See {@odf.attribute draw:path-stretchpoint-y}
   *
   * @return - the <code>Double</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public Double getDrawPathStretchpointYAttribute() {
    DrawPathStretchpointYAttribute attr =
        (DrawPathStretchpointYAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "path-stretchpoint-y");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Double.valueOf(attr.doubleValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawPathStretchpointYAttribute</code> ,
   * See {@odf.attribute draw:path-stretchpoint-y}
   *
   * @param drawPathStretchpointYValue The type is <code>Double</code>
   */
  public void setDrawPathStretchpointYAttribute(Double drawPathStretchpointYValue) {
    DrawPathStretchpointYAttribute attr =
        new DrawPathStretchpointYAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setDoubleValue(drawPathStretchpointYValue.doubleValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawTextAreasAttribute</code> ,
   * See {@odf.attribute draw:text-areas}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawTextAreasAttribute() {
    DrawTextAreasAttribute attr =
        (DrawTextAreasAttribute) getOdfAttribute(OdfDocumentNamespace.DRAW, "text-areas");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawTextAreasAttribute</code> , See
   * {@odf.attribute draw:text-areas}
   *
   * @param drawTextAreasValue The type is <code>String</code>
   */
  public void setDrawTextAreasAttribute(String drawTextAreasValue) {
    DrawTextAreasAttribute attr = new DrawTextAreasAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawTextAreasValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawTextPathAttribute</code> ,
   * See {@odf.attribute draw:text-path}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getDrawTextPathAttribute() {
    DrawTextPathAttribute attr =
        (DrawTextPathAttribute) getOdfAttribute(OdfDocumentNamespace.DRAW, "text-path");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(DrawTextPathAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawTextPathAttribute</code> , See
   * {@odf.attribute draw:text-path}
   *
   * @param drawTextPathValue The type is <code>Boolean</code>
   */
  public void setDrawTextPathAttribute(Boolean drawTextPathValue) {
    DrawTextPathAttribute attr = new DrawTextPathAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(drawTextPathValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawTextPathAllowedAttribute
   * </code> , See {@odf.attribute draw:text-path-allowed}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getDrawTextPathAllowedAttribute() {
    DrawTextPathAllowedAttribute attr =
        (DrawTextPathAllowedAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "text-path-allowed");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(DrawTextPathAllowedAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawTextPathAllowedAttribute</code> ,
   * See {@odf.attribute draw:text-path-allowed}
   *
   * @param drawTextPathAllowedValue The type is <code>Boolean</code>
   */
  public void setDrawTextPathAllowedAttribute(Boolean drawTextPathAllowedValue) {
    DrawTextPathAllowedAttribute attr =
        new DrawTextPathAllowedAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(drawTextPathAllowedValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawTextPathModeAttribute
   * </code> , See {@odf.attribute draw:text-path-mode}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawTextPathModeAttribute() {
    DrawTextPathModeAttribute attr =
        (DrawTextPathModeAttribute) getOdfAttribute(OdfDocumentNamespace.DRAW, "text-path-mode");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DrawTextPathModeAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawTextPathModeAttribute</code> , See
   * {@odf.attribute draw:text-path-mode}
   *
   * @param drawTextPathModeValue The type is <code>String</code>
   */
  public void setDrawTextPathModeAttribute(String drawTextPathModeValue) {
    DrawTextPathModeAttribute attr = new DrawTextPathModeAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawTextPathModeValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>
   * DrawTextPathSameLetterHeightsAttribute</code> , See {@odf.attribute
   * draw:text-path-same-letter-heights}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getDrawTextPathSameLetterHeightsAttribute() {
    DrawTextPathSameLetterHeightsAttribute attr =
        (DrawTextPathSameLetterHeightsAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "text-path-same-letter-heights");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(DrawTextPathSameLetterHeightsAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawTextPathSameLetterHeightsAttribute
   * </code> , See {@odf.attribute draw:text-path-same-letter-heights}
   *
   * @param drawTextPathSameLetterHeightsValue The type is <code>Boolean</code>
   */
  public void setDrawTextPathSameLetterHeightsAttribute(
      Boolean drawTextPathSameLetterHeightsValue) {
    DrawTextPathSameLetterHeightsAttribute attr =
        new DrawTextPathSameLetterHeightsAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(drawTextPathSameLetterHeightsValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawTextPathScaleAttribute
   * </code> , See {@odf.attribute draw:text-path-scale}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawTextPathScaleAttribute() {
    DrawTextPathScaleAttribute attr =
        (DrawTextPathScaleAttribute) getOdfAttribute(OdfDocumentNamespace.DRAW, "text-path-scale");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DrawTextPathScaleAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawTextPathScaleAttribute</code> , See
   * {@odf.attribute draw:text-path-scale}
   *
   * @param drawTextPathScaleValue The type is <code>String</code>
   */
  public void setDrawTextPathScaleAttribute(String drawTextPathScaleValue) {
    DrawTextPathScaleAttribute attr =
        new DrawTextPathScaleAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawTextPathScaleValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawTextRotateAngleAttribute
   * </code> , See {@odf.attribute draw:text-rotate-angle}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawTextRotateAngleAttribute() {
    DrawTextRotateAngleAttribute attr =
        (DrawTextRotateAngleAttribute)
            getOdfAttribute(OdfDocumentNamespace.DRAW, "text-rotate-angle");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DrawTextRotateAngleAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawTextRotateAngleAttribute</code> ,
   * See {@odf.attribute draw:text-rotate-angle}
   *
   * @param drawTextRotateAngleValue The type is <code>String</code>
   */
  public void setDrawTextRotateAngleAttribute(String drawTextRotateAngleValue) {
    DrawTextRotateAngleAttribute attr =
        new DrawTextRotateAngleAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawTextRotateAngleValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>DrawTypeAttribute</code> , See
   * {@odf.attribute draw:type}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getDrawTypeAttribute() {
    DrawTypeAttribute attr = (DrawTypeAttribute) getOdfAttribute(OdfDocumentNamespace.DRAW, "type");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return DrawTypeAttribute.DEFAULT_VALUE_NON_PRIMITIVE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>DrawTypeAttribute</code> , See
   * {@odf.attribute draw:type}
   *
   * @param drawTypeValue The type is <code>String</code>
   */
  public void setDrawTypeAttribute(String drawTypeValue) {
    DrawTypeAttribute attr = new DrawTypeAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(drawTypeValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>SvgViewBoxAttribute</code> ,
   * See {@odf.attribute svg:viewBox}
   *
   * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Integer getSvgViewBoxAttribute() {
    SvgViewBoxAttribute attr =
        (SvgViewBoxAttribute) getOdfAttribute(OdfDocumentNamespace.SVG, "viewBox");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Integer.valueOf(attr.intValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>SvgViewBoxAttribute</code> , See
   * {@odf.attribute svg:viewBox}
   *
   * @param svgViewBoxValue The type is <code>Integer</code>
   */
  public void setSvgViewBoxAttribute(Integer svgViewBoxValue) {
    SvgViewBoxAttribute attr = new SvgViewBoxAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setIntValue(svgViewBoxValue.intValue());
  }

  /**
   * Create child element {@odf.element draw:equation}.
   *
   * @return the element {@odf.element draw:equation}
   */
  public DrawEquationElement newDrawEquationElement() {
    DrawEquationElement drawEquation =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DrawEquationElement.class);
    this.appendChild(drawEquation);
    return drawEquation;
  }

  /**
   * Create child element {@odf.element draw:handle}.
   *
   * @param drawHandlePositionValue the <code>String</code> value of <code>
   *     DrawHandlePositionAttribute</code>, see {@odf.attribute draw:handle-position} at
   *     specification
   * @return the element {@odf.element draw:handle}
   */
  public DrawHandleElement newDrawHandleElement(String drawHandlePositionValue) {
    DrawHandleElement drawHandle =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DrawHandleElement.class);
    drawHandle.setDrawHandlePositionAttribute(drawHandlePositionValue);
    this.appendChild(drawHandle);
    return drawHandle;
  }

  /**
   * Accept an visitor instance to allow the visitor to do some operations. Refer to visitor design
   * pattern to get a better understanding.
   *
   * @param visitor an instance of DefaultElementVisitor
   */
  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }
}
