/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeTargetFrameNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeTitleAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextVisitedStyleNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkActuateAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkHrefAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkShowAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkTypeAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.dr3d.Dr3dSceneElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawAElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawCaptionElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawCircleElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawConnectorElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawControlElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawCustomShapeElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawEllipseElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawGElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawLineElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawMeasureElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPageThumbnailElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPathElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPolygonElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPolylineElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawRectElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawRegularPolygonElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeAnnotationElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeAnnotationEndElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeEventListenersElement;
import org.odftoolkit.odfdom.dom.element.presentation.PresentationDateTimeElement;
import org.odftoolkit.odfdom.dom.element.presentation.PresentationFooterElement;
import org.odftoolkit.odfdom.dom.element.presentation.PresentationHeaderElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element text:a}. */
public class TextAElement extends OdfStylableElement {

  public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "a");

  /**
   * Create the instance of <code>TextAElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public TextAElement(OdfFileDom ownerDoc) {
    super(
        ownerDoc,
        ELEMENT_NAME,
        OdfStyleFamily.Text,
        OdfName.newName(OdfDocumentNamespace.TEXT, "style-name"));
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element text:a}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>OfficeNameAttribute</code> ,
   * See {@odf.attribute office:name}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getOfficeNameAttribute() {
    OfficeNameAttribute attr =
        (OfficeNameAttribute) getOdfAttribute(OdfDocumentNamespace.OFFICE, "name");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>OfficeNameAttribute</code> , See
   * {@odf.attribute office:name}
   *
   * @param officeNameValue The type is <code>String</code>
   */
  public void setOfficeNameAttribute(String officeNameValue) {
    OfficeNameAttribute attr = new OfficeNameAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(officeNameValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>OfficeTargetFrameNameAttribute
   * </code> , See {@odf.attribute office:target-frame-name}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getOfficeTargetFrameNameAttribute() {
    OfficeTargetFrameNameAttribute attr =
        (OfficeTargetFrameNameAttribute)
            getOdfAttribute(OdfDocumentNamespace.OFFICE, "target-frame-name");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>OfficeTargetFrameNameAttribute</code> ,
   * See {@odf.attribute office:target-frame-name}
   *
   * @param officeTargetFrameNameValue The type is <code>String</code>
   */
  public void setOfficeTargetFrameNameAttribute(String officeTargetFrameNameValue) {
    OfficeTargetFrameNameAttribute attr =
        new OfficeTargetFrameNameAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(officeTargetFrameNameValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>OfficeTitleAttribute</code> ,
   * See {@odf.attribute office:title}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getOfficeTitleAttribute() {
    OfficeTitleAttribute attr =
        (OfficeTitleAttribute) getOdfAttribute(OdfDocumentNamespace.OFFICE, "title");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>OfficeTitleAttribute</code> , See
   * {@odf.attribute office:title}
   *
   * @param officeTitleValue The type is <code>String</code>
   */
  public void setOfficeTitleAttribute(String officeTitleValue) {
    OfficeTitleAttribute attr = new OfficeTitleAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(officeTitleValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TextStyleNameAttribute</code> ,
   * See {@odf.attribute text:style-name}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getTextStyleNameAttribute() {
    TextStyleNameAttribute attr =
        (TextStyleNameAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "style-name");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TextStyleNameAttribute</code> , See
   * {@odf.attribute text:style-name}
   *
   * @param textStyleNameValue The type is <code>String</code>
   */
  public void setTextStyleNameAttribute(String textStyleNameValue) {
    TextStyleNameAttribute attr = new TextStyleNameAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(textStyleNameValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TextVisitedStyleNameAttribute
   * </code> , See {@odf.attribute text:visited-style-name}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getTextVisitedStyleNameAttribute() {
    TextVisitedStyleNameAttribute attr =
        (TextVisitedStyleNameAttribute)
            getOdfAttribute(OdfDocumentNamespace.TEXT, "visited-style-name");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TextVisitedStyleNameAttribute</code> ,
   * See {@odf.attribute text:visited-style-name}
   *
   * @param textVisitedStyleNameValue The type is <code>String</code>
   */
  public void setTextVisitedStyleNameAttribute(String textVisitedStyleNameValue) {
    TextVisitedStyleNameAttribute attr =
        new TextVisitedStyleNameAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(textVisitedStyleNameValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>XlinkActuateAttribute</code> ,
   * See {@odf.attribute xlink:actuate}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getXlinkActuateAttribute() {
    XlinkActuateAttribute attr =
        (XlinkActuateAttribute) getOdfAttribute(OdfDocumentNamespace.XLINK, "actuate");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return XlinkActuateAttribute.DEFAULT_VALUE_ONREQUEST;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>XlinkActuateAttribute</code> , See
   * {@odf.attribute xlink:actuate}
   *
   * @param xlinkActuateValue The type is <code>String</code>
   */
  public void setXlinkActuateAttribute(String xlinkActuateValue) {
    XlinkActuateAttribute attr = new XlinkActuateAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(xlinkActuateValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>XlinkHrefAttribute</code> , See
   * {@odf.attribute xlink:href}
   *
   * <p>Attribute is mandatory.
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getXlinkHrefAttribute() {
    XlinkHrefAttribute attr =
        (XlinkHrefAttribute) getOdfAttribute(OdfDocumentNamespace.XLINK, "href");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>XlinkHrefAttribute</code> , See
   * {@odf.attribute xlink:href}
   *
   * @param xlinkHrefValue The type is <code>String</code>
   */
  public void setXlinkHrefAttribute(String xlinkHrefValue) {
    XlinkHrefAttribute attr = new XlinkHrefAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(xlinkHrefValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>XlinkShowAttribute</code> , See
   * {@odf.attribute xlink:show}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getXlinkShowAttribute() {
    XlinkShowAttribute attr =
        (XlinkShowAttribute) getOdfAttribute(OdfDocumentNamespace.XLINK, "show");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>XlinkShowAttribute</code> , See
   * {@odf.attribute xlink:show}
   *
   * @param xlinkShowValue The type is <code>String</code>
   */
  public void setXlinkShowAttribute(String xlinkShowValue) {
    XlinkShowAttribute attr = new XlinkShowAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(xlinkShowValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>XlinkTypeAttribute</code> , See
   * {@odf.attribute xlink:type}
   *
   * <p>Attribute is mandatory.
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getXlinkTypeAttribute() {
    XlinkTypeAttribute attr =
        (XlinkTypeAttribute) getOdfAttribute(OdfDocumentNamespace.XLINK, "type");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return XlinkTypeAttribute.DEFAULT_VALUE;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>XlinkTypeAttribute</code> , See
   * {@odf.attribute xlink:type}
   *
   * @param xlinkTypeValue The type is <code>String</code>
   */
  public void setXlinkTypeAttribute(String xlinkTypeValue) {
    XlinkTypeAttribute attr = new XlinkTypeAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(xlinkTypeValue);
  }

  /**
   * Create child element {@odf.element dr3d:scene}.
   *
   * @return the element {@odf.element dr3d:scene}
   */
  public Dr3dSceneElement newDr3dSceneElement() {
    Dr3dSceneElement dr3dScene =
        ((OdfFileDom) this.ownerDocument).newOdfElement(Dr3dSceneElement.class);
    this.appendChild(dr3dScene);
    return dr3dScene;
  }

  /**
   * Create child element {@odf.element draw:a}.
   *
   * @param xlinkHrefValue the <code>String</code> value of <code>XlinkHrefAttribute</code>, see
   *     {@odf.attribute xlink:href} at specification
   * @param xlinkTypeValue the <code>String</code> value of <code>XlinkTypeAttribute</code>, see
   *     {@odf.attribute xlink:type} at specification
   * @return the element {@odf.element draw:a}
   */
  public DrawAElement newDrawAElement(String xlinkHrefValue, String xlinkTypeValue) {
    DrawAElement drawA = ((OdfFileDom) this.ownerDocument).newOdfElement(DrawAElement.class);
    drawA.setXlinkHrefAttribute(xlinkHrefValue);
    drawA.setXlinkTypeAttribute(xlinkTypeValue);
    this.appendChild(drawA);
    return drawA;
  }

  /**
   * Create child element {@odf.element draw:caption}.
   *
   * @return the element {@odf.element draw:caption}
   */
  public DrawCaptionElement newDrawCaptionElement() {
    DrawCaptionElement drawCaption =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DrawCaptionElement.class);
    this.appendChild(drawCaption);
    return drawCaption;
  }

  /**
   * Create child element {@odf.element draw:circle}.
   *
   * @return the element {@odf.element draw:circle}
   */
  public DrawCircleElement newDrawCircleElement() {
    DrawCircleElement drawCircle =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DrawCircleElement.class);
    this.appendChild(drawCircle);
    return drawCircle;
  }

  /**
   * Create child element {@odf.element draw:connector}.
   *
   * @param svgViewBoxValue the <code>Integer</code> value of <code>SvgViewBoxAttribute</code>, see
   *     {@odf.attribute svg:viewBox} at specification
   * @return the element {@odf.element draw:connector}
   */
  public DrawConnectorElement newDrawConnectorElement(int svgViewBoxValue) {
    DrawConnectorElement drawConnector =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DrawConnectorElement.class);
    drawConnector.setSvgViewBoxAttribute(svgViewBoxValue);
    this.appendChild(drawConnector);
    return drawConnector;
  }

  /**
   * Create child element {@odf.element draw:control}.
   *
   * @param drawControlValue the <code>String</code> value of <code>DrawControlAttribute</code>, see
   *     {@odf.attribute draw:control} at specification
   * @return the element {@odf.element draw:control}
   */
  public DrawControlElement newDrawControlElement(String drawControlValue) {
    DrawControlElement drawControl =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DrawControlElement.class);
    drawControl.setDrawControlAttribute(drawControlValue);
    this.appendChild(drawControl);
    return drawControl;
  }

  /**
   * Create child element {@odf.element draw:custom-shape}.
   *
   * @return the element {@odf.element draw:custom-shape}
   */
  public DrawCustomShapeElement newDrawCustomShapeElement() {
    DrawCustomShapeElement drawCustomShape =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DrawCustomShapeElement.class);
    this.appendChild(drawCustomShape);
    return drawCustomShape;
  }

  /**
   * Create child element {@odf.element draw:ellipse}.
   *
   * @return the element {@odf.element draw:ellipse}
   */
  public DrawEllipseElement newDrawEllipseElement() {
    DrawEllipseElement drawEllipse =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DrawEllipseElement.class);
    this.appendChild(drawEllipse);
    return drawEllipse;
  }

  /**
   * Create child element {@odf.element draw:frame}.
   *
   * @return the element {@odf.element draw:frame}
   */
  public DrawFrameElement newDrawFrameElement() {
    DrawFrameElement drawFrame =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DrawFrameElement.class);
    this.appendChild(drawFrame);
    return drawFrame;
  }

  /**
   * Create child element {@odf.element draw:g}.
   *
   * @return the element {@odf.element draw:g}
   */
  public DrawGElement newDrawGElement() {
    DrawGElement drawG = ((OdfFileDom) this.ownerDocument).newOdfElement(DrawGElement.class);
    this.appendChild(drawG);
    return drawG;
  }

  /**
   * Create child element {@odf.element draw:line}.
   *
   * @param svgX1Value the <code>String</code> value of <code>SvgX1Attribute</code>, see
   *     {@odf.attribute svg:x1} at specification
   * @param svgX2Value the <code>String</code> value of <code>SvgX2Attribute</code>, see
   *     {@odf.attribute svg:x2} at specification
   * @param svgY1Value the <code>String</code> value of <code>SvgY1Attribute</code>, see
   *     {@odf.attribute svg:y1} at specification
   * @param svgY2Value the <code>String</code> value of <code>SvgY2Attribute</code>, see
   *     {@odf.attribute svg:y2} at specification
   * @return the element {@odf.element draw:line}
   */
  public DrawLineElement newDrawLineElement(
      String svgX1Value, String svgX2Value, String svgY1Value, String svgY2Value) {
    DrawLineElement drawLine =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DrawLineElement.class);
    drawLine.setSvgX1Attribute(svgX1Value);
    drawLine.setSvgX2Attribute(svgX2Value);
    drawLine.setSvgY1Attribute(svgY1Value);
    drawLine.setSvgY2Attribute(svgY2Value);
    this.appendChild(drawLine);
    return drawLine;
  }

  /**
   * Create child element {@odf.element draw:measure}.
   *
   * @param svgX1Value the <code>String</code> value of <code>SvgX1Attribute</code>, see
   *     {@odf.attribute svg:x1} at specification
   * @param svgX2Value the <code>String</code> value of <code>SvgX2Attribute</code>, see
   *     {@odf.attribute svg:x2} at specification
   * @param svgY1Value the <code>String</code> value of <code>SvgY1Attribute</code>, see
   *     {@odf.attribute svg:y1} at specification
   * @param svgY2Value the <code>String</code> value of <code>SvgY2Attribute</code>, see
   *     {@odf.attribute svg:y2} at specification
   * @return the element {@odf.element draw:measure}
   */
  public DrawMeasureElement newDrawMeasureElement(
      String svgX1Value, String svgX2Value, String svgY1Value, String svgY2Value) {
    DrawMeasureElement drawMeasure =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DrawMeasureElement.class);
    drawMeasure.setSvgX1Attribute(svgX1Value);
    drawMeasure.setSvgX2Attribute(svgX2Value);
    drawMeasure.setSvgY1Attribute(svgY1Value);
    drawMeasure.setSvgY2Attribute(svgY2Value);
    this.appendChild(drawMeasure);
    return drawMeasure;
  }

  /**
   * Create child element {@odf.element draw:page-thumbnail}.
   *
   * @return the element {@odf.element draw:page-thumbnail}
   */
  public DrawPageThumbnailElement newDrawPageThumbnailElement() {
    DrawPageThumbnailElement drawPageThumbnail =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DrawPageThumbnailElement.class);
    this.appendChild(drawPageThumbnail);
    return drawPageThumbnail;
  }

  /**
   * Create child element {@odf.element draw:path}.
   *
   * @param svgDValue the <code>String</code> value of <code>SvgDAttribute</code>, see
   *     {@odf.attribute svg:d} at specification
   * @param svgViewBoxValue the <code>Integer</code> value of <code>SvgViewBoxAttribute</code>, see
   *     {@odf.attribute svg:viewBox} at specification
   * @return the element {@odf.element draw:path}
   */
  public DrawPathElement newDrawPathElement(String svgDValue, int svgViewBoxValue) {
    DrawPathElement drawPath =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DrawPathElement.class);
    drawPath.setSvgDAttribute(svgDValue);
    drawPath.setSvgViewBoxAttribute(svgViewBoxValue);
    this.appendChild(drawPath);
    return drawPath;
  }

  /**
   * Create child element {@odf.element draw:polygon}.
   *
   * @param drawPointsValue the <code>String</code> value of <code>DrawPointsAttribute</code>, see
   *     {@odf.attribute draw:points} at specification
   * @param svgViewBoxValue the <code>Integer</code> value of <code>SvgViewBoxAttribute</code>, see
   *     {@odf.attribute svg:viewBox} at specification
   * @return the element {@odf.element draw:polygon}
   */
  public DrawPolygonElement newDrawPolygonElement(String drawPointsValue, int svgViewBoxValue) {
    DrawPolygonElement drawPolygon =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DrawPolygonElement.class);
    drawPolygon.setDrawPointsAttribute(drawPointsValue);
    drawPolygon.setSvgViewBoxAttribute(svgViewBoxValue);
    this.appendChild(drawPolygon);
    return drawPolygon;
  }

  /**
   * Create child element {@odf.element draw:polyline}.
   *
   * @param drawPointsValue the <code>String</code> value of <code>DrawPointsAttribute</code>, see
   *     {@odf.attribute draw:points} at specification
   * @param svgViewBoxValue the <code>Integer</code> value of <code>SvgViewBoxAttribute</code>, see
   *     {@odf.attribute svg:viewBox} at specification
   * @return the element {@odf.element draw:polyline}
   */
  public DrawPolylineElement newDrawPolylineElement(String drawPointsValue, int svgViewBoxValue) {
    DrawPolylineElement drawPolyline =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DrawPolylineElement.class);
    drawPolyline.setDrawPointsAttribute(drawPointsValue);
    drawPolyline.setSvgViewBoxAttribute(svgViewBoxValue);
    this.appendChild(drawPolyline);
    return drawPolyline;
  }

  /**
   * Create child element {@odf.element draw:rect}.
   *
   * @return the element {@odf.element draw:rect}
   */
  public DrawRectElement newDrawRectElement() {
    DrawRectElement drawRect =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DrawRectElement.class);
    this.appendChild(drawRect);
    return drawRect;
  }

  /**
   * Create child element {@odf.element draw:regular-polygon}.
   *
   * @param drawConcaveValue the <code>Boolean</code> value of <code>DrawConcaveAttribute</code>,
   *     see {@odf.attribute draw:concave} at specification
   * @param drawCornersValue the <code>Integer</code> value of <code>DrawCornersAttribute</code>,
   *     see {@odf.attribute draw:corners} at specification
   * @return the element {@odf.element draw:regular-polygon}
   */
  public DrawRegularPolygonElement newDrawRegularPolygonElement(
      boolean drawConcaveValue, int drawCornersValue) {
    DrawRegularPolygonElement drawRegularPolygon =
        ((OdfFileDom) this.ownerDocument).newOdfElement(DrawRegularPolygonElement.class);
    drawRegularPolygon.setDrawConcaveAttribute(drawConcaveValue);
    drawRegularPolygon.setDrawCornersAttribute(drawCornersValue);
    this.appendChild(drawRegularPolygon);
    return drawRegularPolygon;
  }

  /**
   * Create child element {@odf.element office:annotation}.
   *
   * @return the element {@odf.element office:annotation}
   */
  public OfficeAnnotationElement newOfficeAnnotationElement() {
    OfficeAnnotationElement officeAnnotation =
        ((OdfFileDom) this.ownerDocument).newOdfElement(OfficeAnnotationElement.class);
    this.appendChild(officeAnnotation);
    return officeAnnotation;
  }

  /**
   * Create child element {@odf.element office:annotation-end}.
   *
   * @param officeNameValue the <code>String</code> value of <code>OfficeNameAttribute</code>, see
   *     {@odf.attribute office:name} at specification Child element was added in ODF 1.2
   * @return the element {@odf.element office:annotation-end}
   */
  public OfficeAnnotationEndElement newOfficeAnnotationEndElement(String officeNameValue) {
    OfficeAnnotationEndElement officeAnnotationEnd =
        ((OdfFileDom) this.ownerDocument).newOdfElement(OfficeAnnotationEndElement.class);
    officeAnnotationEnd.setOfficeNameAttribute(officeNameValue);
    this.appendChild(officeAnnotationEnd);
    return officeAnnotationEnd;
  }

  /**
   * Create child element {@odf.element office:event-listeners}.
   *
   * @return the element {@odf.element office:event-listeners}
   */
  public OfficeEventListenersElement newOfficeEventListenersElement() {
    OfficeEventListenersElement officeEventListeners =
        ((OdfFileDom) this.ownerDocument).newOdfElement(OfficeEventListenersElement.class);
    this.appendChild(officeEventListeners);
    return officeEventListeners;
  }

  /**
   * Create child element {@odf.element presentation:date-time}.
   *
   * @return the element {@odf.element presentation:date-time}
   */
  public PresentationDateTimeElement newPresentationDateTimeElement() {
    PresentationDateTimeElement presentationDateTime =
        ((OdfFileDom) this.ownerDocument).newOdfElement(PresentationDateTimeElement.class);
    this.appendChild(presentationDateTime);
    return presentationDateTime;
  }

  /**
   * Create child element {@odf.element presentation:footer}.
   *
   * @return the element {@odf.element presentation:footer}
   */
  public PresentationFooterElement newPresentationFooterElement() {
    PresentationFooterElement presentationFooter =
        ((OdfFileDom) this.ownerDocument).newOdfElement(PresentationFooterElement.class);
    this.appendChild(presentationFooter);
    return presentationFooter;
  }

  /**
   * Create child element {@odf.element presentation:header}.
   *
   * @return the element {@odf.element presentation:header}
   */
  public PresentationHeaderElement newPresentationHeaderElement() {
    PresentationHeaderElement presentationHeader =
        ((OdfFileDom) this.ownerDocument).newOdfElement(PresentationHeaderElement.class);
    this.appendChild(presentationHeader);
    return presentationHeader;
  }

  /**
   * Create child element {@odf.element text:alphabetical-index-mark}.
   *
   * @param textStringValueValue the <code>String</code> value of <code>TextStringValueAttribute
   *     </code>, see {@odf.attribute text:string-value} at specification
   * @return the element {@odf.element text:alphabetical-index-mark}
   */
  public TextAlphabeticalIndexMarkElement newTextAlphabeticalIndexMarkElement(
      String textStringValueValue) {
    TextAlphabeticalIndexMarkElement textAlphabeticalIndexMark =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextAlphabeticalIndexMarkElement.class);
    textAlphabeticalIndexMark.setTextStringValueAttribute(textStringValueValue);
    this.appendChild(textAlphabeticalIndexMark);
    return textAlphabeticalIndexMark;
  }

  /**
   * Create child element {@odf.element text:alphabetical-index-mark-end}.
   *
   * @param textIdValue the <code>String</code> value of <code>TextIdAttribute</code>, see
   *     {@odf.attribute text:id} at specification
   * @return the element {@odf.element text:alphabetical-index-mark-end}
   */
  public TextAlphabeticalIndexMarkEndElement newTextAlphabeticalIndexMarkEndElement(
      String textIdValue) {
    TextAlphabeticalIndexMarkEndElement textAlphabeticalIndexMarkEnd =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextAlphabeticalIndexMarkEndElement.class);
    textAlphabeticalIndexMarkEnd.setTextIdAttribute(textIdValue);
    this.appendChild(textAlphabeticalIndexMarkEnd);
    return textAlphabeticalIndexMarkEnd;
  }

  /**
   * Create child element {@odf.element text:alphabetical-index-mark-start}.
   *
   * @param textIdValue the <code>String</code> value of <code>TextIdAttribute</code>, see
   *     {@odf.attribute text:id} at specification
   * @return the element {@odf.element text:alphabetical-index-mark-start}
   */
  public TextAlphabeticalIndexMarkStartElement newTextAlphabeticalIndexMarkStartElement(
      String textIdValue) {
    TextAlphabeticalIndexMarkStartElement textAlphabeticalIndexMarkStart =
        ((OdfFileDom) this.ownerDocument)
            .newOdfElement(TextAlphabeticalIndexMarkStartElement.class);
    textAlphabeticalIndexMarkStart.setTextIdAttribute(textIdValue);
    this.appendChild(textAlphabeticalIndexMarkStart);
    return textAlphabeticalIndexMarkStart;
  }

  /**
   * Create child element {@odf.element text:author-initials}.
   *
   * @return the element {@odf.element text:author-initials}
   */
  public TextAuthorInitialsElement newTextAuthorInitialsElement() {
    TextAuthorInitialsElement textAuthorInitials =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextAuthorInitialsElement.class);
    this.appendChild(textAuthorInitials);
    return textAuthorInitials;
  }

  /**
   * Create child element {@odf.element text:author-name}.
   *
   * @return the element {@odf.element text:author-name}
   */
  public TextAuthorNameElement newTextAuthorNameElement() {
    TextAuthorNameElement textAuthorName =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextAuthorNameElement.class);
    this.appendChild(textAuthorName);
    return textAuthorName;
  }

  /**
   * Create child element {@odf.element text:bibliography-mark}.
   *
   * @param textBibliographyTypeValue the <code>String</code> value of <code>
   *     TextBibliographyTypeAttribute</code>, see {@odf.attribute text:bibliography-type} at
   *     specification
   * @return the element {@odf.element text:bibliography-mark}
   */
  public TextBibliographyMarkElement newTextBibliographyMarkElement(
      String textBibliographyTypeValue) {
    TextBibliographyMarkElement textBibliographyMark =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextBibliographyMarkElement.class);
    textBibliographyMark.setTextBibliographyTypeAttribute(textBibliographyTypeValue);
    this.appendChild(textBibliographyMark);
    return textBibliographyMark;
  }

  /**
   * Create child element {@odf.element text:bookmark}.
   *
   * @param textNameValue the <code>String</code> value of <code>TextNameAttribute</code>, see
   *     {@odf.attribute text:name} at specification
   * @return the element {@odf.element text:bookmark}
   */
  public TextBookmarkElement newTextBookmarkElement(String textNameValue) {
    TextBookmarkElement textBookmark =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextBookmarkElement.class);
    textBookmark.setTextNameAttribute(textNameValue);
    this.appendChild(textBookmark);
    return textBookmark;
  }

  /**
   * Create child element {@odf.element text:bookmark-end}.
   *
   * @param textNameValue the <code>String</code> value of <code>TextNameAttribute</code>, see
   *     {@odf.attribute text:name} at specification
   * @return the element {@odf.element text:bookmark-end}
   */
  public TextBookmarkEndElement newTextBookmarkEndElement(String textNameValue) {
    TextBookmarkEndElement textBookmarkEnd =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextBookmarkEndElement.class);
    textBookmarkEnd.setTextNameAttribute(textNameValue);
    this.appendChild(textBookmarkEnd);
    return textBookmarkEnd;
  }

  /**
   * Create child element {@odf.element text:bookmark-ref}.
   *
   * @return the element {@odf.element text:bookmark-ref}
   */
  public TextBookmarkRefElement newTextBookmarkRefElement() {
    TextBookmarkRefElement textBookmarkRef =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextBookmarkRefElement.class);
    this.appendChild(textBookmarkRef);
    return textBookmarkRef;
  }

  /**
   * Create child element {@odf.element text:bookmark-start}.
   *
   * @param textNameValue the <code>String</code> value of <code>TextNameAttribute</code>, see
   *     {@odf.attribute text:name} at specification
   * @return the element {@odf.element text:bookmark-start}
   */
  public TextBookmarkStartElement newTextBookmarkStartElement(String textNameValue) {
    TextBookmarkStartElement textBookmarkStart =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextBookmarkStartElement.class);
    textBookmarkStart.setTextNameAttribute(textNameValue);
    this.appendChild(textBookmarkStart);
    return textBookmarkStart;
  }

  /**
   * Create child element {@odf.element text:change}.
   *
   * @param textChangeIdValue the <code>String</code> value of <code>TextChangeIdAttribute</code>,
   *     see {@odf.attribute text:change-id} at specification
   * @return the element {@odf.element text:change}
   */
  public TextChangeElement newTextChangeElement(String textChangeIdValue) {
    TextChangeElement textChange =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextChangeElement.class);
    textChange.setTextChangeIdAttribute(textChangeIdValue);
    this.appendChild(textChange);
    return textChange;
  }

  /**
   * Create child element {@odf.element text:change-end}.
   *
   * @param textChangeIdValue the <code>String</code> value of <code>TextChangeIdAttribute</code>,
   *     see {@odf.attribute text:change-id} at specification
   * @return the element {@odf.element text:change-end}
   */
  public TextChangeEndElement newTextChangeEndElement(String textChangeIdValue) {
    TextChangeEndElement textChangeEnd =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextChangeEndElement.class);
    textChangeEnd.setTextChangeIdAttribute(textChangeIdValue);
    this.appendChild(textChangeEnd);
    return textChangeEnd;
  }

  /**
   * Create child element {@odf.element text:change-start}.
   *
   * @param textChangeIdValue the <code>String</code> value of <code>TextChangeIdAttribute</code>,
   *     see {@odf.attribute text:change-id} at specification
   * @return the element {@odf.element text:change-start}
   */
  public TextChangeStartElement newTextChangeStartElement(String textChangeIdValue) {
    TextChangeStartElement textChangeStart =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextChangeStartElement.class);
    textChangeStart.setTextChangeIdAttribute(textChangeIdValue);
    this.appendChild(textChangeStart);
    return textChangeStart;
  }

  /**
   * Create child element {@odf.element text:chapter}.
   *
   * @param textDisplayValue the <code>String</code> value of <code>TextDisplayAttribute</code>, see
   *     {@odf.attribute text:display} at specification
   * @param textOutlineLevelValue the <code>Integer</code> value of <code>TextOutlineLevelAttribute
   *     </code>, see {@odf.attribute text:outline-level} at specification
   * @return the element {@odf.element text:chapter}
   */
  public TextChapterElement newTextChapterElement(
      String textDisplayValue, int textOutlineLevelValue) {
    TextChapterElement textChapter =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextChapterElement.class);
    textChapter.setTextDisplayAttribute(textDisplayValue);
    textChapter.setTextOutlineLevelAttribute(textOutlineLevelValue);
    this.appendChild(textChapter);
    return textChapter;
  }

  /**
   * Create child element {@odf.element text:character-count}.
   *
   * @param styleNumFormatValue the <code>String</code> value of <code>StyleNumFormatAttribute
   *     </code>, see {@odf.attribute style:num-format} at specification
   * @return the element {@odf.element text:character-count}
   */
  public TextCharacterCountElement newTextCharacterCountElement(String styleNumFormatValue) {
    TextCharacterCountElement textCharacterCount =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextCharacterCountElement.class);
    textCharacterCount.setStyleNumFormatAttribute(styleNumFormatValue);
    this.appendChild(textCharacterCount);
    return textCharacterCount;
  }

  /**
   * Create child element {@odf.element text:conditional-text}.
   *
   * @param textConditionValue the <code>String</code> value of <code>TextConditionAttribute</code>,
   *     see {@odf.attribute text:condition} at specification
   * @param textStringValueIfFalseValue the <code>String</code> value of <code>
   *     TextStringValueIfFalseAttribute</code>, see {@odf.attribute text:string-value-if-false} at
   *     specification
   * @param textStringValueIfTrueValue the <code>String</code> value of <code>
   *     TextStringValueIfTrueAttribute</code>, see {@odf.attribute text:string-value-if-true} at
   *     specification
   * @return the element {@odf.element text:conditional-text}
   */
  public TextConditionalTextElement newTextConditionalTextElement(
      String textConditionValue,
      String textStringValueIfFalseValue,
      String textStringValueIfTrueValue) {
    TextConditionalTextElement textConditionalText =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextConditionalTextElement.class);
    textConditionalText.setTextConditionAttribute(textConditionValue);
    textConditionalText.setTextStringValueIfFalseAttribute(textStringValueIfFalseValue);
    textConditionalText.setTextStringValueIfTrueAttribute(textStringValueIfTrueValue);
    this.appendChild(textConditionalText);
    return textConditionalText;
  }

  /**
   * Create child element {@odf.element text:creation-date}.
   *
   * @return the element {@odf.element text:creation-date}
   */
  public TextCreationDateElement newTextCreationDateElement() {
    TextCreationDateElement textCreationDate =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextCreationDateElement.class);
    this.appendChild(textCreationDate);
    return textCreationDate;
  }

  /**
   * Create child element {@odf.element text:creation-time}.
   *
   * @return the element {@odf.element text:creation-time}
   */
  public TextCreationTimeElement newTextCreationTimeElement() {
    TextCreationTimeElement textCreationTime =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextCreationTimeElement.class);
    this.appendChild(textCreationTime);
    return textCreationTime;
  }

  /**
   * Create child element {@odf.element text:creator}.
   *
   * @return the element {@odf.element text:creator}
   */
  public TextCreatorElement newTextCreatorElement() {
    TextCreatorElement textCreator =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextCreatorElement.class);
    this.appendChild(textCreator);
    return textCreator;
  }

  /**
   * Create child element {@odf.element text:database-display}.
   *
   * @param textColumnNameValue the <code>String</code> value of <code>TextColumnNameAttribute
   *     </code>, see {@odf.attribute text:column-name} at specification
   * @param textTableNameValue the <code>String</code> value of <code>TextTableNameAttribute</code>,
   *     see {@odf.attribute text:table-name} at specification
   * @return the element {@odf.element text:database-display}
   */
  public TextDatabaseDisplayElement newTextDatabaseDisplayElement(
      String textColumnNameValue, String textTableNameValue) {
    TextDatabaseDisplayElement textDatabaseDisplay =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextDatabaseDisplayElement.class);
    textDatabaseDisplay.setTextColumnNameAttribute(textColumnNameValue);
    textDatabaseDisplay.setTextTableNameAttribute(textTableNameValue);
    this.appendChild(textDatabaseDisplay);
    return textDatabaseDisplay;
  }

  /**
   * Create child element {@odf.element text:database-name}.
   *
   * @param textTableNameValue the <code>String</code> value of <code>TextTableNameAttribute</code>,
   *     see {@odf.attribute text:table-name} at specification
   * @return the element {@odf.element text:database-name}
   */
  public TextDatabaseNameElement newTextDatabaseNameElement(String textTableNameValue) {
    TextDatabaseNameElement textDatabaseName =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextDatabaseNameElement.class);
    textDatabaseName.setTextTableNameAttribute(textTableNameValue);
    this.appendChild(textDatabaseName);
    return textDatabaseName;
  }

  /**
   * Create child element {@odf.element text:database-next}.
   *
   * @param textTableNameValue the <code>String</code> value of <code>TextTableNameAttribute</code>,
   *     see {@odf.attribute text:table-name} at specification
   * @return the element {@odf.element text:database-next}
   */
  public TextDatabaseNextElement newTextDatabaseNextElement(String textTableNameValue) {
    TextDatabaseNextElement textDatabaseNext =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextDatabaseNextElement.class);
    textDatabaseNext.setTextTableNameAttribute(textTableNameValue);
    this.appendChild(textDatabaseNext);
    return textDatabaseNext;
  }

  /**
   * Create child element {@odf.element text:database-row-number}.
   *
   * @param styleNumFormatValue the <code>String</code> value of <code>StyleNumFormatAttribute
   *     </code>, see {@odf.attribute style:num-format} at specification
   * @param textTableNameValue the <code>String</code> value of <code>TextTableNameAttribute</code>,
   *     see {@odf.attribute text:table-name} at specification
   * @return the element {@odf.element text:database-row-number}
   */
  public TextDatabaseRowNumberElement newTextDatabaseRowNumberElement(
      String styleNumFormatValue, String textTableNameValue) {
    TextDatabaseRowNumberElement textDatabaseRowNumber =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextDatabaseRowNumberElement.class);
    textDatabaseRowNumber.setStyleNumFormatAttribute(styleNumFormatValue);
    textDatabaseRowNumber.setTextTableNameAttribute(textTableNameValue);
    this.appendChild(textDatabaseRowNumber);
    return textDatabaseRowNumber;
  }

  /**
   * Create child element {@odf.element text:database-row-select}.
   *
   * @param textTableNameValue the <code>String</code> value of <code>TextTableNameAttribute</code>,
   *     see {@odf.attribute text:table-name} at specification
   * @return the element {@odf.element text:database-row-select}
   */
  public TextDatabaseRowSelectElement newTextDatabaseRowSelectElement(String textTableNameValue) {
    TextDatabaseRowSelectElement textDatabaseRowSelect =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextDatabaseRowSelectElement.class);
    textDatabaseRowSelect.setTextTableNameAttribute(textTableNameValue);
    this.appendChild(textDatabaseRowSelect);
    return textDatabaseRowSelect;
  }

  /**
   * Create child element {@odf.element text:date}.
   *
   * @return the element {@odf.element text:date}
   */
  public TextDateElement newTextDateElement() {
    TextDateElement textDate =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextDateElement.class);
    this.appendChild(textDate);
    return textDate;
  }

  /**
   * Create child element {@odf.element text:dde-connection}.
   *
   * @param textConnectionNameValue the <code>String</code> value of <code>
   *     TextConnectionNameAttribute</code>, see {@odf.attribute text:connection-name} at
   *     specification
   * @return the element {@odf.element text:dde-connection}
   */
  public TextDdeConnectionElement newTextDdeConnectionElement(String textConnectionNameValue) {
    TextDdeConnectionElement textDdeConnection =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextDdeConnectionElement.class);
    textDdeConnection.setTextConnectionNameAttribute(textConnectionNameValue);
    this.appendChild(textDdeConnection);
    return textDdeConnection;
  }

  /**
   * Create child element {@odf.element text:description}.
   *
   * @return the element {@odf.element text:description}
   */
  public TextDescriptionElement newTextDescriptionElement() {
    TextDescriptionElement textDescription =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextDescriptionElement.class);
    this.appendChild(textDescription);
    return textDescription;
  }

  /**
   * Create child element {@odf.element text:editing-cycles}.
   *
   * @return the element {@odf.element text:editing-cycles}
   */
  public TextEditingCyclesElement newTextEditingCyclesElement() {
    TextEditingCyclesElement textEditingCycles =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextEditingCyclesElement.class);
    this.appendChild(textEditingCycles);
    return textEditingCycles;
  }

  /**
   * Create child element {@odf.element text:editing-duration}.
   *
   * @return the element {@odf.element text:editing-duration}
   */
  public TextEditingDurationElement newTextEditingDurationElement() {
    TextEditingDurationElement textEditingDuration =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextEditingDurationElement.class);
    this.appendChild(textEditingDuration);
    return textEditingDuration;
  }

  /**
   * Create child element {@odf.element text:execute-macro}.
   *
   * @return the element {@odf.element text:execute-macro}
   */
  public TextExecuteMacroElement newTextExecuteMacroElement() {
    TextExecuteMacroElement textExecuteMacro =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextExecuteMacroElement.class);
    this.appendChild(textExecuteMacro);
    return textExecuteMacro;
  }

  /**
   * Create child element {@odf.element text:expression}.
   *
   * @param officeValueValue the <code>Double</code> value of <code>OfficeValueAttribute</code>, see
   *     {@odf.attribute office:value} at specification
   * @param officeValueTypeValue the <code>String</code> value of <code>OfficeValueTypeAttribute
   *     </code>, see {@odf.attribute office:value-type} at specification
   * @return the element {@odf.element text:expression}
   */
  public TextExpressionElement newTextExpressionElement(
      double officeValueValue, String officeValueTypeValue) {
    TextExpressionElement textExpression =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextExpressionElement.class);
    textExpression.setOfficeValueAttribute(officeValueValue);
    textExpression.setOfficeValueTypeAttribute(officeValueTypeValue);
    this.appendChild(textExpression);
    return textExpression;
  }

  /**
   * Create child element {@odf.element text:file-name}.
   *
   * @return the element {@odf.element text:file-name}
   */
  public TextFileNameElement newTextFileNameElement() {
    TextFileNameElement textFileName =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextFileNameElement.class);
    this.appendChild(textFileName);
    return textFileName;
  }

  /**
   * Create child element {@odf.element text:hidden-paragraph}.
   *
   * @param textConditionValue the <code>String</code> value of <code>TextConditionAttribute</code>,
   *     see {@odf.attribute text:condition} at specification
   * @return the element {@odf.element text:hidden-paragraph}
   */
  public TextHiddenParagraphElement newTextHiddenParagraphElement(String textConditionValue) {
    TextHiddenParagraphElement textHiddenParagraph =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextHiddenParagraphElement.class);
    textHiddenParagraph.setTextConditionAttribute(textConditionValue);
    this.appendChild(textHiddenParagraph);
    return textHiddenParagraph;
  }

  /**
   * Create child element {@odf.element text:hidden-text}.
   *
   * @param textConditionValue the <code>String</code> value of <code>TextConditionAttribute</code>,
   *     see {@odf.attribute text:condition} at specification
   * @param textStringValueValue the <code>String</code> value of <code>TextStringValueAttribute
   *     </code>, see {@odf.attribute text:string-value} at specification
   * @return the element {@odf.element text:hidden-text}
   */
  public TextHiddenTextElement newTextHiddenTextElement(
      String textConditionValue, String textStringValueValue) {
    TextHiddenTextElement textHiddenText =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextHiddenTextElement.class);
    textHiddenText.setTextConditionAttribute(textConditionValue);
    textHiddenText.setTextStringValueAttribute(textStringValueValue);
    this.appendChild(textHiddenText);
    return textHiddenText;
  }

  /**
   * Create child element {@odf.element text:image-count}.
   *
   * @param styleNumFormatValue the <code>String</code> value of <code>StyleNumFormatAttribute
   *     </code>, see {@odf.attribute style:num-format} at specification
   * @return the element {@odf.element text:image-count}
   */
  public TextImageCountElement newTextImageCountElement(String styleNumFormatValue) {
    TextImageCountElement textImageCount =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextImageCountElement.class);
    textImageCount.setStyleNumFormatAttribute(styleNumFormatValue);
    this.appendChild(textImageCount);
    return textImageCount;
  }

  /**
   * Create child element {@odf.element text:initial-creator}.
   *
   * @return the element {@odf.element text:initial-creator}
   */
  public TextInitialCreatorElement newTextInitialCreatorElement() {
    TextInitialCreatorElement textInitialCreator =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextInitialCreatorElement.class);
    this.appendChild(textInitialCreator);
    return textInitialCreator;
  }

  /**
   * Create child element {@odf.element text:keywords}.
   *
   * @return the element {@odf.element text:keywords}
   */
  public TextKeywordsElement newTextKeywordsElement() {
    TextKeywordsElement textKeywords =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextKeywordsElement.class);
    this.appendChild(textKeywords);
    return textKeywords;
  }

  /**
   * Create child element {@odf.element text:line-break}.
   *
   * @return the element {@odf.element text:line-break}
   */
  public TextLineBreakElement newTextLineBreakElement() {
    TextLineBreakElement textLineBreak =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextLineBreakElement.class);
    this.appendChild(textLineBreak);
    return textLineBreak;
  }

  /**
   * Create child element {@odf.element text:measure}.
   *
   * @param textKindValue the <code>String</code> value of <code>TextKindAttribute</code>, see
   *     {@odf.attribute text:kind} at specification
   * @return the element {@odf.element text:measure}
   */
  public TextMeasureElement newTextMeasureElement(String textKindValue) {
    TextMeasureElement textMeasure =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextMeasureElement.class);
    textMeasure.setTextKindAttribute(textKindValue);
    this.appendChild(textMeasure);
    return textMeasure;
  }

  /**
   * Create child element {@odf.element text:meta}.
   *
   * <p>Child element was added in ODF 1.2
   *
   * @return the element {@odf.element text:meta}
   */
  public TextMetaElement newTextMetaElement() {
    TextMetaElement textMeta =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextMetaElement.class);
    this.appendChild(textMeta);
    return textMeta;
  }

  /**
   * Create child element {@odf.element text:meta-field}.
   *
   * @param xmlIdValue the <code>String</code> value of <code>XmlIdAttribute</code>, see
   *     {@odf.attribute xml:id} at specification Child element was added in ODF 1.2
   * @return the element {@odf.element text:meta-field}
   */
  public TextMetaFieldElement newTextMetaFieldElement(String xmlIdValue) {
    TextMetaFieldElement textMetaField =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextMetaFieldElement.class);
    textMetaField.setXmlIdAttribute(xmlIdValue);
    this.appendChild(textMetaField);
    return textMetaField;
  }

  /**
   * Create child element {@odf.element text:modification-date}.
   *
   * @return the element {@odf.element text:modification-date}
   */
  public TextModificationDateElement newTextModificationDateElement() {
    TextModificationDateElement textModificationDate =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextModificationDateElement.class);
    this.appendChild(textModificationDate);
    return textModificationDate;
  }

  /**
   * Create child element {@odf.element text:modification-time}.
   *
   * @return the element {@odf.element text:modification-time}
   */
  public TextModificationTimeElement newTextModificationTimeElement() {
    TextModificationTimeElement textModificationTime =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextModificationTimeElement.class);
    this.appendChild(textModificationTime);
    return textModificationTime;
  }

  /**
   * Create child element {@odf.element text:note}.
   *
   * @param textNoteClassValue the <code>String</code> value of <code>TextNoteClassAttribute</code>,
   *     see {@odf.attribute text:note-class} at specification
   * @return the element {@odf.element text:note}
   */
  public TextNoteElement newTextNoteElement(String textNoteClassValue) {
    TextNoteElement textNote =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextNoteElement.class);
    textNote.setTextNoteClassAttribute(textNoteClassValue);
    this.appendChild(textNote);
    return textNote;
  }

  /**
   * Create child element {@odf.element text:note-ref}.
   *
   * @param textNoteClassValue the <code>String</code> value of <code>TextNoteClassAttribute</code>,
   *     see {@odf.attribute text:note-class} at specification
   * @return the element {@odf.element text:note-ref}
   */
  public TextNoteRefElement newTextNoteRefElement(String textNoteClassValue) {
    TextNoteRefElement textNoteRef =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextNoteRefElement.class);
    textNoteRef.setTextNoteClassAttribute(textNoteClassValue);
    this.appendChild(textNoteRef);
    return textNoteRef;
  }

  /**
   * Create child element {@odf.element text:object-count}.
   *
   * @param styleNumFormatValue the <code>String</code> value of <code>StyleNumFormatAttribute
   *     </code>, see {@odf.attribute style:num-format} at specification
   * @return the element {@odf.element text:object-count}
   */
  public TextObjectCountElement newTextObjectCountElement(String styleNumFormatValue) {
    TextObjectCountElement textObjectCount =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextObjectCountElement.class);
    textObjectCount.setStyleNumFormatAttribute(styleNumFormatValue);
    this.appendChild(textObjectCount);
    return textObjectCount;
  }

  /**
   * Create child element {@odf.element text:page-continuation}.
   *
   * @param textSelectPageValue the <code>String</code> value of <code>TextSelectPageAttribute
   *     </code>, see {@odf.attribute text:select-page} at specification
   * @return the element {@odf.element text:page-continuation}
   */
  public TextPageContinuationElement newTextPageContinuationElement(String textSelectPageValue) {
    TextPageContinuationElement textPageContinuation =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextPageContinuationElement.class);
    textPageContinuation.setTextSelectPageAttribute(textSelectPageValue);
    this.appendChild(textPageContinuation);
    return textPageContinuation;
  }

  /**
   * Create child element {@odf.element text:page-count}.
   *
   * @param styleNumFormatValue the <code>String</code> value of <code>StyleNumFormatAttribute
   *     </code>, see {@odf.attribute style:num-format} at specification
   * @return the element {@odf.element text:page-count}
   */
  public TextPageCountElement newTextPageCountElement(String styleNumFormatValue) {
    TextPageCountElement textPageCount =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextPageCountElement.class);
    textPageCount.setStyleNumFormatAttribute(styleNumFormatValue);
    this.appendChild(textPageCount);
    return textPageCount;
  }

  /**
   * Create child element {@odf.element text:page-number}.
   *
   * @param styleNumFormatValue the <code>String</code> value of <code>StyleNumFormatAttribute
   *     </code>, see {@odf.attribute style:num-format} at specification
   * @return the element {@odf.element text:page-number}
   */
  public TextPageNumberElement newTextPageNumberElement(String styleNumFormatValue) {
    TextPageNumberElement textPageNumber =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextPageNumberElement.class);
    textPageNumber.setStyleNumFormatAttribute(styleNumFormatValue);
    this.appendChild(textPageNumber);
    return textPageNumber;
  }

  /**
   * Create child element {@odf.element text:page-variable-get}.
   *
   * @param styleNumFormatValue the <code>String</code> value of <code>StyleNumFormatAttribute
   *     </code>, see {@odf.attribute style:num-format} at specification
   * @return the element {@odf.element text:page-variable-get}
   */
  public TextPageVariableGetElement newTextPageVariableGetElement(String styleNumFormatValue) {
    TextPageVariableGetElement textPageVariableGet =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextPageVariableGetElement.class);
    textPageVariableGet.setStyleNumFormatAttribute(styleNumFormatValue);
    this.appendChild(textPageVariableGet);
    return textPageVariableGet;
  }

  /**
   * Create child element {@odf.element text:page-variable-set}.
   *
   * @return the element {@odf.element text:page-variable-set}
   */
  public TextPageVariableSetElement newTextPageVariableSetElement() {
    TextPageVariableSetElement textPageVariableSet =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextPageVariableSetElement.class);
    this.appendChild(textPageVariableSet);
    return textPageVariableSet;
  }

  /**
   * Create child element {@odf.element text:paragraph-count}.
   *
   * @param styleNumFormatValue the <code>String</code> value of <code>StyleNumFormatAttribute
   *     </code>, see {@odf.attribute style:num-format} at specification
   * @return the element {@odf.element text:paragraph-count}
   */
  public TextParagraphCountElement newTextParagraphCountElement(String styleNumFormatValue) {
    TextParagraphCountElement textParagraphCount =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextParagraphCountElement.class);
    textParagraphCount.setStyleNumFormatAttribute(styleNumFormatValue);
    this.appendChild(textParagraphCount);
    return textParagraphCount;
  }

  /**
   * Create child element {@odf.element text:placeholder}.
   *
   * @param textPlaceholderTypeValue the <code>String</code> value of <code>
   *     TextPlaceholderTypeAttribute</code>, see {@odf.attribute text:placeholder-type} at
   *     specification
   * @return the element {@odf.element text:placeholder}
   */
  public TextPlaceholderElement newTextPlaceholderElement(String textPlaceholderTypeValue) {
    TextPlaceholderElement textPlaceholder =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextPlaceholderElement.class);
    textPlaceholder.setTextPlaceholderTypeAttribute(textPlaceholderTypeValue);
    this.appendChild(textPlaceholder);
    return textPlaceholder;
  }

  /**
   * Create child element {@odf.element text:print-date}.
   *
   * @return the element {@odf.element text:print-date}
   */
  public TextPrintDateElement newTextPrintDateElement() {
    TextPrintDateElement textPrintDate =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextPrintDateElement.class);
    this.appendChild(textPrintDate);
    return textPrintDate;
  }

  /**
   * Create child element {@odf.element text:print-time}.
   *
   * @return the element {@odf.element text:print-time}
   */
  public TextPrintTimeElement newTextPrintTimeElement() {
    TextPrintTimeElement textPrintTime =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextPrintTimeElement.class);
    this.appendChild(textPrintTime);
    return textPrintTime;
  }

  /**
   * Create child element {@odf.element text:printed-by}.
   *
   * @return the element {@odf.element text:printed-by}
   */
  public TextPrintedByElement newTextPrintedByElement() {
    TextPrintedByElement textPrintedBy =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextPrintedByElement.class);
    this.appendChild(textPrintedBy);
    return textPrintedBy;
  }

  /**
   * Create child element {@odf.element text:reference-mark}.
   *
   * @param textNameValue the <code>String</code> value of <code>TextNameAttribute</code>, see
   *     {@odf.attribute text:name} at specification
   * @return the element {@odf.element text:reference-mark}
   */
  public TextReferenceMarkElement newTextReferenceMarkElement(String textNameValue) {
    TextReferenceMarkElement textReferenceMark =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextReferenceMarkElement.class);
    textReferenceMark.setTextNameAttribute(textNameValue);
    this.appendChild(textReferenceMark);
    return textReferenceMark;
  }

  /**
   * Create child element {@odf.element text:reference-mark-end}.
   *
   * @param textNameValue the <code>String</code> value of <code>TextNameAttribute</code>, see
   *     {@odf.attribute text:name} at specification
   * @return the element {@odf.element text:reference-mark-end}
   */
  public TextReferenceMarkEndElement newTextReferenceMarkEndElement(String textNameValue) {
    TextReferenceMarkEndElement textReferenceMarkEnd =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextReferenceMarkEndElement.class);
    textReferenceMarkEnd.setTextNameAttribute(textNameValue);
    this.appendChild(textReferenceMarkEnd);
    return textReferenceMarkEnd;
  }

  /**
   * Create child element {@odf.element text:reference-mark-start}.
   *
   * @param textNameValue the <code>String</code> value of <code>TextNameAttribute</code>, see
   *     {@odf.attribute text:name} at specification
   * @return the element {@odf.element text:reference-mark-start}
   */
  public TextReferenceMarkStartElement newTextReferenceMarkStartElement(String textNameValue) {
    TextReferenceMarkStartElement textReferenceMarkStart =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextReferenceMarkStartElement.class);
    textReferenceMarkStart.setTextNameAttribute(textNameValue);
    this.appendChild(textReferenceMarkStart);
    return textReferenceMarkStart;
  }

  /**
   * Create child element {@odf.element text:reference-ref}.
   *
   * @return the element {@odf.element text:reference-ref}
   */
  public TextReferenceRefElement newTextReferenceRefElement() {
    TextReferenceRefElement textReferenceRef =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextReferenceRefElement.class);
    this.appendChild(textReferenceRef);
    return textReferenceRef;
  }

  /**
   * Create child element {@odf.element text:ruby}.
   *
   * @return the element {@odf.element text:ruby}
   */
  public TextRubyElement newTextRubyElement() {
    TextRubyElement textRuby =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextRubyElement.class);
    this.appendChild(textRuby);
    return textRuby;
  }

  /**
   * Create child element {@odf.element text:s}.
   *
   * @return the element {@odf.element text:s}
   */
  public TextSElement newTextSElement() {
    TextSElement textS = ((OdfFileDom) this.ownerDocument).newOdfElement(TextSElement.class);
    this.appendChild(textS);
    return textS;
  }

  /**
   * Create child element {@odf.element text:script}.
   *
   * @return the element {@odf.element text:script}
   */
  public TextScriptElement newTextScriptElement() {
    TextScriptElement textScript =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextScriptElement.class);
    this.appendChild(textScript);
    return textScript;
  }

  /**
   * Create child element {@odf.element text:sender-city}.
   *
   * @return the element {@odf.element text:sender-city}
   */
  public TextSenderCityElement newTextSenderCityElement() {
    TextSenderCityElement textSenderCity =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSenderCityElement.class);
    this.appendChild(textSenderCity);
    return textSenderCity;
  }

  /**
   * Create child element {@odf.element text:sender-company}.
   *
   * @return the element {@odf.element text:sender-company}
   */
  public TextSenderCompanyElement newTextSenderCompanyElement() {
    TextSenderCompanyElement textSenderCompany =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSenderCompanyElement.class);
    this.appendChild(textSenderCompany);
    return textSenderCompany;
  }

  /**
   * Create child element {@odf.element text:sender-country}.
   *
   * @return the element {@odf.element text:sender-country}
   */
  public TextSenderCountryElement newTextSenderCountryElement() {
    TextSenderCountryElement textSenderCountry =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSenderCountryElement.class);
    this.appendChild(textSenderCountry);
    return textSenderCountry;
  }

  /**
   * Create child element {@odf.element text:sender-email}.
   *
   * @return the element {@odf.element text:sender-email}
   */
  public TextSenderEmailElement newTextSenderEmailElement() {
    TextSenderEmailElement textSenderEmail =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSenderEmailElement.class);
    this.appendChild(textSenderEmail);
    return textSenderEmail;
  }

  /**
   * Create child element {@odf.element text:sender-fax}.
   *
   * @return the element {@odf.element text:sender-fax}
   */
  public TextSenderFaxElement newTextSenderFaxElement() {
    TextSenderFaxElement textSenderFax =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSenderFaxElement.class);
    this.appendChild(textSenderFax);
    return textSenderFax;
  }

  /**
   * Create child element {@odf.element text:sender-firstname}.
   *
   * @return the element {@odf.element text:sender-firstname}
   */
  public TextSenderFirstnameElement newTextSenderFirstnameElement() {
    TextSenderFirstnameElement textSenderFirstname =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSenderFirstnameElement.class);
    this.appendChild(textSenderFirstname);
    return textSenderFirstname;
  }

  /**
   * Create child element {@odf.element text:sender-initials}.
   *
   * @return the element {@odf.element text:sender-initials}
   */
  public TextSenderInitialsElement newTextSenderInitialsElement() {
    TextSenderInitialsElement textSenderInitials =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSenderInitialsElement.class);
    this.appendChild(textSenderInitials);
    return textSenderInitials;
  }

  /**
   * Create child element {@odf.element text:sender-lastname}.
   *
   * @return the element {@odf.element text:sender-lastname}
   */
  public TextSenderLastnameElement newTextSenderLastnameElement() {
    TextSenderLastnameElement textSenderLastname =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSenderLastnameElement.class);
    this.appendChild(textSenderLastname);
    return textSenderLastname;
  }

  /**
   * Create child element {@odf.element text:sender-phone-private}.
   *
   * @return the element {@odf.element text:sender-phone-private}
   */
  public TextSenderPhonePrivateElement newTextSenderPhonePrivateElement() {
    TextSenderPhonePrivateElement textSenderPhonePrivate =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSenderPhonePrivateElement.class);
    this.appendChild(textSenderPhonePrivate);
    return textSenderPhonePrivate;
  }

  /**
   * Create child element {@odf.element text:sender-phone-work}.
   *
   * @return the element {@odf.element text:sender-phone-work}
   */
  public TextSenderPhoneWorkElement newTextSenderPhoneWorkElement() {
    TextSenderPhoneWorkElement textSenderPhoneWork =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSenderPhoneWorkElement.class);
    this.appendChild(textSenderPhoneWork);
    return textSenderPhoneWork;
  }

  /**
   * Create child element {@odf.element text:sender-position}.
   *
   * @return the element {@odf.element text:sender-position}
   */
  public TextSenderPositionElement newTextSenderPositionElement() {
    TextSenderPositionElement textSenderPosition =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSenderPositionElement.class);
    this.appendChild(textSenderPosition);
    return textSenderPosition;
  }

  /**
   * Create child element {@odf.element text:sender-postal-code}.
   *
   * @return the element {@odf.element text:sender-postal-code}
   */
  public TextSenderPostalCodeElement newTextSenderPostalCodeElement() {
    TextSenderPostalCodeElement textSenderPostalCode =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSenderPostalCodeElement.class);
    this.appendChild(textSenderPostalCode);
    return textSenderPostalCode;
  }

  /**
   * Create child element {@odf.element text:sender-state-or-province}.
   *
   * @return the element {@odf.element text:sender-state-or-province}
   */
  public TextSenderStateOrProvinceElement newTextSenderStateOrProvinceElement() {
    TextSenderStateOrProvinceElement textSenderStateOrProvince =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSenderStateOrProvinceElement.class);
    this.appendChild(textSenderStateOrProvince);
    return textSenderStateOrProvince;
  }

  /**
   * Create child element {@odf.element text:sender-street}.
   *
   * @return the element {@odf.element text:sender-street}
   */
  public TextSenderStreetElement newTextSenderStreetElement() {
    TextSenderStreetElement textSenderStreet =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSenderStreetElement.class);
    this.appendChild(textSenderStreet);
    return textSenderStreet;
  }

  /**
   * Create child element {@odf.element text:sender-title}.
   *
   * @return the element {@odf.element text:sender-title}
   */
  public TextSenderTitleElement newTextSenderTitleElement() {
    TextSenderTitleElement textSenderTitle =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSenderTitleElement.class);
    this.appendChild(textSenderTitle);
    return textSenderTitle;
  }

  /**
   * Create child element {@odf.element text:sequence}.
   *
   * @param styleNumFormatValue the <code>String</code> value of <code>StyleNumFormatAttribute
   *     </code>, see {@odf.attribute style:num-format} at specification
   * @param textNameValue the <code>String</code> value of <code>TextNameAttribute</code>, see
   *     {@odf.attribute text:name} at specification
   * @return the element {@odf.element text:sequence}
   */
  public TextSequenceElement newTextSequenceElement(
      String styleNumFormatValue, String textNameValue) {
    TextSequenceElement textSequence =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSequenceElement.class);
    textSequence.setStyleNumFormatAttribute(styleNumFormatValue);
    textSequence.setTextNameAttribute(textNameValue);
    this.appendChild(textSequence);
    return textSequence;
  }

  /**
   * Create child element {@odf.element text:sequence-ref}.
   *
   * @return the element {@odf.element text:sequence-ref}
   */
  public TextSequenceRefElement newTextSequenceRefElement() {
    TextSequenceRefElement textSequenceRef =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSequenceRefElement.class);
    this.appendChild(textSequenceRef);
    return textSequenceRef;
  }

  /**
   * Create child element {@odf.element text:sheet-name}.
   *
   * @return the element {@odf.element text:sheet-name}
   */
  public TextSheetNameElement newTextSheetNameElement() {
    TextSheetNameElement textSheetName =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSheetNameElement.class);
    this.appendChild(textSheetName);
    return textSheetName;
  }

  /**
   * Create child element {@odf.element text:soft-page-break}.
   *
   * <p>Child element was added in ODF 1.1
   *
   * @return the element {@odf.element text:soft-page-break}
   */
  public TextSoftPageBreakElement newTextSoftPageBreakElement() {
    TextSoftPageBreakElement textSoftPageBreak =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSoftPageBreakElement.class);
    this.appendChild(textSoftPageBreak);
    return textSoftPageBreak;
  }

  /**
   * Create child element {@odf.element text:span}.
   *
   * @return the element {@odf.element text:span}
   */
  public TextSpanElement newTextSpanElement() {
    TextSpanElement textSpan =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSpanElement.class);
    this.appendChild(textSpan);
    return textSpan;
  }

  /**
   * Create child element {@odf.element text:subject}.
   *
   * @return the element {@odf.element text:subject}
   */
  public TextSubjectElement newTextSubjectElement() {
    TextSubjectElement textSubject =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextSubjectElement.class);
    this.appendChild(textSubject);
    return textSubject;
  }

  /**
   * Create child element {@odf.element text:tab}.
   *
   * @return the element {@odf.element text:tab}
   */
  public TextTabElement newTextTabElement() {
    TextTabElement textTab = ((OdfFileDom) this.ownerDocument).newOdfElement(TextTabElement.class);
    this.appendChild(textTab);
    return textTab;
  }

  /**
   * Create child element {@odf.element text:table-count}.
   *
   * @param styleNumFormatValue the <code>String</code> value of <code>StyleNumFormatAttribute
   *     </code>, see {@odf.attribute style:num-format} at specification
   * @return the element {@odf.element text:table-count}
   */
  public TextTableCountElement newTextTableCountElement(String styleNumFormatValue) {
    TextTableCountElement textTableCount =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextTableCountElement.class);
    textTableCount.setStyleNumFormatAttribute(styleNumFormatValue);
    this.appendChild(textTableCount);
    return textTableCount;
  }

  /**
   * Create child element {@odf.element text:table-formula}.
   *
   * @return the element {@odf.element text:table-formula}
   */
  public TextTableFormulaElement newTextTableFormulaElement() {
    TextTableFormulaElement textTableFormula =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextTableFormulaElement.class);
    this.appendChild(textTableFormula);
    return textTableFormula;
  }

  /**
   * Create child element {@odf.element text:template-name}.
   *
   * @return the element {@odf.element text:template-name}
   */
  public TextTemplateNameElement newTextTemplateNameElement() {
    TextTemplateNameElement textTemplateName =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextTemplateNameElement.class);
    this.appendChild(textTemplateName);
    return textTemplateName;
  }

  /**
   * Create child element {@odf.element text:text-input}.
   *
   * @return the element {@odf.element text:text-input}
   */
  public TextTextInputElement newTextTextInputElement() {
    TextTextInputElement textTextInput =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextTextInputElement.class);
    this.appendChild(textTextInput);
    return textTextInput;
  }

  /**
   * Create child element {@odf.element text:time}.
   *
   * @return the element {@odf.element text:time}
   */
  public TextTimeElement newTextTimeElement() {
    TextTimeElement textTime =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextTimeElement.class);
    this.appendChild(textTime);
    return textTime;
  }

  /**
   * Create child element {@odf.element text:title}.
   *
   * @return the element {@odf.element text:title}
   */
  public TextTitleElement newTextTitleElement() {
    TextTitleElement textTitle =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextTitleElement.class);
    this.appendChild(textTitle);
    return textTitle;
  }

  /**
   * Create child element {@odf.element text:toc-mark}.
   *
   * @param textStringValueValue the <code>String</code> value of <code>TextStringValueAttribute
   *     </code>, see {@odf.attribute text:string-value} at specification
   * @return the element {@odf.element text:toc-mark}
   */
  public TextTocMarkElement newTextTocMarkElement(String textStringValueValue) {
    TextTocMarkElement textTocMark =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextTocMarkElement.class);
    textTocMark.setTextStringValueAttribute(textStringValueValue);
    this.appendChild(textTocMark);
    return textTocMark;
  }

  /**
   * Create child element {@odf.element text:toc-mark-end}.
   *
   * @param textIdValue the <code>String</code> value of <code>TextIdAttribute</code>, see
   *     {@odf.attribute text:id} at specification
   * @return the element {@odf.element text:toc-mark-end}
   */
  public TextTocMarkEndElement newTextTocMarkEndElement(String textIdValue) {
    TextTocMarkEndElement textTocMarkEnd =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextTocMarkEndElement.class);
    textTocMarkEnd.setTextIdAttribute(textIdValue);
    this.appendChild(textTocMarkEnd);
    return textTocMarkEnd;
  }

  /**
   * Create child element {@odf.element text:toc-mark-start}.
   *
   * @param textIdValue the <code>String</code> value of <code>TextIdAttribute</code>, see
   *     {@odf.attribute text:id} at specification
   * @return the element {@odf.element text:toc-mark-start}
   */
  public TextTocMarkStartElement newTextTocMarkStartElement(String textIdValue) {
    TextTocMarkStartElement textTocMarkStart =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextTocMarkStartElement.class);
    textTocMarkStart.setTextIdAttribute(textIdValue);
    this.appendChild(textTocMarkStart);
    return textTocMarkStart;
  }

  /**
   * Create child element {@odf.element text:user-defined}.
   *
   * @param textNameValue the <code>String</code> value of <code>TextNameAttribute</code>, see
   *     {@odf.attribute text:name} at specification
   * @return the element {@odf.element text:user-defined}
   */
  public TextUserDefinedElement newTextUserDefinedElement(String textNameValue) {
    TextUserDefinedElement textUserDefined =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextUserDefinedElement.class);
    textUserDefined.setTextNameAttribute(textNameValue);
    this.appendChild(textUserDefined);
    return textUserDefined;
  }

  /**
   * Create child element {@odf.element text:user-field-get}.
   *
   * @param textNameValue the <code>String</code> value of <code>TextNameAttribute</code>, see
   *     {@odf.attribute text:name} at specification
   * @return the element {@odf.element text:user-field-get}
   */
  public TextUserFieldGetElement newTextUserFieldGetElement(String textNameValue) {
    TextUserFieldGetElement textUserFieldGet =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextUserFieldGetElement.class);
    textUserFieldGet.setTextNameAttribute(textNameValue);
    this.appendChild(textUserFieldGet);
    return textUserFieldGet;
  }

  /**
   * Create child element {@odf.element text:user-field-input}.
   *
   * @param textNameValue the <code>String</code> value of <code>TextNameAttribute</code>, see
   *     {@odf.attribute text:name} at specification
   * @return the element {@odf.element text:user-field-input}
   */
  public TextUserFieldInputElement newTextUserFieldInputElement(String textNameValue) {
    TextUserFieldInputElement textUserFieldInput =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextUserFieldInputElement.class);
    textUserFieldInput.setTextNameAttribute(textNameValue);
    this.appendChild(textUserFieldInput);
    return textUserFieldInput;
  }

  /**
   * Create child element {@odf.element text:user-index-mark}.
   *
   * @param textIndexNameValue the <code>String</code> value of <code>TextIndexNameAttribute</code>,
   *     see {@odf.attribute text:index-name} at specification
   * @param textStringValueValue the <code>String</code> value of <code>TextStringValueAttribute
   *     </code>, see {@odf.attribute text:string-value} at specification
   * @return the element {@odf.element text:user-index-mark}
   */
  public TextUserIndexMarkElement newTextUserIndexMarkElement(
      String textIndexNameValue, String textStringValueValue) {
    TextUserIndexMarkElement textUserIndexMark =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextUserIndexMarkElement.class);
    textUserIndexMark.setTextIndexNameAttribute(textIndexNameValue);
    textUserIndexMark.setTextStringValueAttribute(textStringValueValue);
    this.appendChild(textUserIndexMark);
    return textUserIndexMark;
  }

  /**
   * Create child element {@odf.element text:user-index-mark-end}.
   *
   * @param textIdValue the <code>String</code> value of <code>TextIdAttribute</code>, see
   *     {@odf.attribute text:id} at specification
   * @return the element {@odf.element text:user-index-mark-end}
   */
  public TextUserIndexMarkEndElement newTextUserIndexMarkEndElement(String textIdValue) {
    TextUserIndexMarkEndElement textUserIndexMarkEnd =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextUserIndexMarkEndElement.class);
    textUserIndexMarkEnd.setTextIdAttribute(textIdValue);
    this.appendChild(textUserIndexMarkEnd);
    return textUserIndexMarkEnd;
  }

  /**
   * Create child element {@odf.element text:user-index-mark-start}.
   *
   * @param textIdValue the <code>String</code> value of <code>TextIdAttribute</code>, see
   *     {@odf.attribute text:id} at specification
   * @param textIndexNameValue the <code>String</code> value of <code>TextIndexNameAttribute</code>,
   *     see {@odf.attribute text:index-name} at specification
   * @return the element {@odf.element text:user-index-mark-start}
   */
  public TextUserIndexMarkStartElement newTextUserIndexMarkStartElement(
      String textIdValue, String textIndexNameValue) {
    TextUserIndexMarkStartElement textUserIndexMarkStart =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextUserIndexMarkStartElement.class);
    textUserIndexMarkStart.setTextIdAttribute(textIdValue);
    textUserIndexMarkStart.setTextIndexNameAttribute(textIndexNameValue);
    this.appendChild(textUserIndexMarkStart);
    return textUserIndexMarkStart;
  }

  /**
   * Create child element {@odf.element text:variable-get}.
   *
   * @param textNameValue the <code>String</code> value of <code>TextNameAttribute</code>, see
   *     {@odf.attribute text:name} at specification
   * @return the element {@odf.element text:variable-get}
   */
  public TextVariableGetElement newTextVariableGetElement(String textNameValue) {
    TextVariableGetElement textVariableGet =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextVariableGetElement.class);
    textVariableGet.setTextNameAttribute(textNameValue);
    this.appendChild(textVariableGet);
    return textVariableGet;
  }

  /**
   * Create child element {@odf.element text:variable-input}.
   *
   * @param officeValueTypeValue the <code>String</code> value of <code>OfficeValueTypeAttribute
   *     </code>, see {@odf.attribute office:value-type} at specification
   * @param textNameValue the <code>String</code> value of <code>TextNameAttribute</code>, see
   *     {@odf.attribute text:name} at specification
   * @return the element {@odf.element text:variable-input}
   */
  public TextVariableInputElement newTextVariableInputElement(
      String officeValueTypeValue, String textNameValue) {
    TextVariableInputElement textVariableInput =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextVariableInputElement.class);
    textVariableInput.setOfficeValueTypeAttribute(officeValueTypeValue);
    textVariableInput.setTextNameAttribute(textNameValue);
    this.appendChild(textVariableInput);
    return textVariableInput;
  }

  /**
   * Create child element {@odf.element text:variable-set}.
   *
   * @param officeValueValue the <code>Double</code> value of <code>OfficeValueAttribute</code>, see
   *     {@odf.attribute office:value} at specification
   * @param officeValueTypeValue the <code>String</code> value of <code>OfficeValueTypeAttribute
   *     </code>, see {@odf.attribute office:value-type} at specification
   * @param textNameValue the <code>String</code> value of <code>TextNameAttribute</code>, see
   *     {@odf.attribute text:name} at specification
   * @return the element {@odf.element text:variable-set}
   */
  public TextVariableSetElement newTextVariableSetElement(
      double officeValueValue, String officeValueTypeValue, String textNameValue) {
    TextVariableSetElement textVariableSet =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextVariableSetElement.class);
    textVariableSet.setOfficeValueAttribute(officeValueValue);
    textVariableSet.setOfficeValueTypeAttribute(officeValueTypeValue);
    textVariableSet.setTextNameAttribute(textNameValue);
    this.appendChild(textVariableSet);
    return textVariableSet;
  }

  /**
   * Create child element {@odf.element text:word-count}.
   *
   * @param styleNumFormatValue the <code>String</code> value of <code>StyleNumFormatAttribute
   *     </code>, see {@odf.attribute style:num-format} at specification
   * @return the element {@odf.element text:word-count}
   */
  public TextWordCountElement newTextWordCountElement(String styleNumFormatValue) {
    TextWordCountElement textWordCount =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextWordCountElement.class);
    textWordCount.setStyleNumFormatAttribute(styleNumFormatValue);
    this.appendChild(textWordCount);
    return textWordCount;
  }

  /**
   * Accept an visitor instance to allow the visitor to do some operations. Refer to visitor design
   * pattern to get a better understanding.
   *
   * @param visitor an instance of DefaultElementVisitor
   */
  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }

  /** Add text content. Only elements which are allowed to have text content offer this method. */
  public void newTextNode(String content) {
    if (content != null && !content.equals("")) {
      this.appendChild(this.getOwnerDocument().createTextNode(content));
    }
  }
}
