/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.changes;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.odftoolkit.odfdom.changes.CachedComponent;
import org.odftoolkit.odfdom.changes.CachedInnerTableOperation;
import org.odftoolkit.odfdom.changes.CachedOperation;
import org.odftoolkit.odfdom.changes.CachedTable;
import org.odftoolkit.odfdom.changes.Cell;
import org.odftoolkit.odfdom.changes.CommentComponent;
import org.odftoolkit.odfdom.changes.Component;
import org.odftoolkit.odfdom.changes.JsonOperationProducer;
import org.odftoolkit.odfdom.changes.MapHelper;
import org.odftoolkit.odfdom.changes.OperationConstants;
import org.odftoolkit.odfdom.changes.PageArea;
import org.odftoolkit.odfdom.changes.ParagraphListProperties;
import org.odftoolkit.odfdom.changes.ShapeProperties;
import org.odftoolkit.odfdom.changes.ShapeType;
import org.odftoolkit.odfdom.changes.Table;
import org.odftoolkit.odfdom.changes.TextContainer;
import org.odftoolkit.odfdom.changes.TextContainingElement;
import org.odftoolkit.odfdom.changes.TextFieldSelection;
import org.odftoolkit.odfdom.changes.TextHyperlinkSelection;
import org.odftoolkit.odfdom.changes.TextSelection;
import org.odftoolkit.odfdom.changes.TextSpanSelection;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfMetaDom;
import org.odftoolkit.odfdom.dom.OdfSchemaConstraint;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.OdfSettingsDom;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.OdfStyleableShapeElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawConnectorElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawGElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawImageElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawLineElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawMeasureElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawShapeElementBase;
import org.odftoolkit.odfdom.dom.element.draw.DrawTextBoxElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeAnnotationElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeAnnotationEndElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeAutomaticStylesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFontFaceElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFooterStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderFooterPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.dom.element.style.StyleStyleElement;
import org.odftoolkit.odfdom.dom.element.svg.SvgDescElement;
import org.odftoolkit.odfdom.dom.element.table.TableCoveredTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextLineBreakElement;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.dom.element.text.TextListHeaderElement;
import org.odftoolkit.odfdom.dom.element.text.TextListItemElement;
import org.odftoolkit.odfdom.dom.element.text.TextListStyleElement;
import org.odftoolkit.odfdom.dom.element.text.TextNoteCitationElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextParagraphElementBase;
import org.odftoolkit.odfdom.dom.element.text.TextSElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.dom.element.text.TextTabElement;
import org.odftoolkit.odfdom.dom.element.text.TextUserFieldDeclElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStylePageLayout;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextListStyle;
import org.odftoolkit.odfdom.pkg.OdfAttribute;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfFileSaxHandler;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfNamespace;
import org.odftoolkit.odfdom.pkg.OdfValidationException;
import org.odftoolkit.odfdom.pkg.ValidationConstraint;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ChangesFileSaxHandler
extends OdfFileSaxHandler {
    private static final Logger LOG = Logger.getLogger(ChangesFileSaxHandler.class.getName());
    private static final String ROW_SPAN = "rowSpan";
    private static final String COLUMN_SPAN = "gridSpan";
    private static final String LIBRE_OFFICE_MS_INTEROP_NAMESPACE = "urn:openoffice:names:experimental:ooo-ms-interop:xmlns:field:1.0";
    private static final String LIBRE_OFFICE_MS_INTEROP_TYPE_CHECKBOX = "vnd.oasis.opendocument.field.FORMCHECKBOX";
    private static final String LIBRE_OFFICE_MS_INTEROP_CHECKBOX_UNICODE = "\u25a1";
    private static final Integer ONE = 1;
    public static final String COMMENT_PREFIX = "cmt";
    private OdfFileDom mFileDom;
    private JsonOperationProducer mJsonOperationProducer;
    private Map<String, TextListStyleElement> mAutoListStyles = null;
    private Map<String, TextUserFieldDeclElement> mUserFieldDecls = null;
    private final ArrayDeque<TextSelection> mTextSelectionStack;
    private final StringBuilder mCharsForElement = new StringBuilder();
    private final StringBuilder mCharsForOperation = new StringBuilder();
    private boolean mIsCharsBeginning = true;
    List<Integer> mCharsStartPosition = null;
    private int mComponentDepth = -1;
    private Component mCurrentComponent;
    private final LinkedList<Integer> mLastComponentPositions = new LinkedList();
    private final boolean domCreationEnabled = true;
    private String mTableName;
    private TableTableElement mTableElement;
    private List<TableTableColumnElement> mColumns;
    private List<Integer> mColumnRelWidths;
    private int mColumnCount;
    private boolean isTableNew = false;
    Map<String, Object> mTableHardFormatting = null;
    private int mListStartValue = -1;
    private final ArrayDeque<ParagraphListProperties> mListStyleStack;
    private final ArrayDeque<WhitespaceStatus> mWhitespaceStatusStack;
    private final Map<String, ContinuedList> mLinkedLists = new HashMap<String, ContinuedList>();
    int mElementDepth = 0;
    int mBlockingElementDepth = 0;
    boolean mNoOperationsAllowed = false;
    boolean mIsBlockingFrame = false;
    boolean mIsIgnoredElement = false;
    boolean mIsBlockingShape = false;
    private int mMaxAllowedColumnCount;
    private int mMaxAllowedRowCount;
    private int mMaxAllowedCellCount;
    private static final String HYERLINK_DEFAULT_STYLE = "Internet_20_link";
    private boolean mHasHyperlinkTemplateStyle = false;
    private String mMasterPageStyleName = null;
    private String mPageLayoutName = null;
    private String mPageStyleUsage = null;
    private boolean mHasNextMasterPage = false;
    private JSONObject headerAttrs = null;
    private JSONObject footerAttrs = null;
    private String mContextName = null;
    public static final String CONTEXT_DELIMITER = "_";
    PageArea mPageArea = null;
    String mMediaType = null;
    OdfSchemaDocument mSchemaDoc = null;
    Stack<CachedComponent> mComponentStack = new Stack();
    ArrayDeque<ShapeProperties> m_cachedPageShapes = new ArrayDeque();
    boolean mPageBoundObjectsRelocated = false;
    HashMap<String, Integer> mTopLevelTables = new HashMap();

    ContinuedList newContinuedList(String precedingListId, String currentListId) {
        ContinuedList continuedList;
        if (!this.mLinkedLists.containsKey(precedingListId)) {
            continuedList = new ContinuedList(precedingListId, currentListId);
            continuedList.add(precedingListId);
            this.mLinkedLists.put(precedingListId, continuedList);
        } else {
            continuedList = this.mLinkedLists.get(precedingListId);
        }
        if (currentListId != null && !currentListId.isEmpty()) {
            continuedList.add(currentListId);
            this.mLinkedLists.put(currentListId, continuedList);
        }
        return continuedList;
    }

    ContinuedList newContinuedList(String currentListId) {
        ContinuedList continuedList = null;
        if (currentListId != null && !currentListId.isEmpty()) {
            if (!this.mLinkedLists.containsKey(currentListId)) {
                continuedList = new ContinuedList(null, currentListId);
                this.mLinkedLists.put(currentListId, continuedList);
            } else {
                continuedList = this.mLinkedLists.get(currentListId);
            }
        }
        return continuedList;
    }

    public ChangesFileSaxHandler(Node rootNode) throws SAXException {
        super(rootNode);
        this.mFileDom = rootNode instanceof OdfFileDom ? (OdfFileDom)((Object)rootNode) : (OdfFileDom)((Object)rootNode.getOwnerDocument());
        this.mCurrentNode = rootNode;
        this.mSchemaDoc = (OdfSchemaDocument)this.mFileDom.getDocument();
        if (this.mSchemaDoc != null) {
            if (this.mFileDom instanceof OdfContentDom) {
                this.mSchemaDoc.setContentDom((OdfContentDom)this.mFileDom);
            } else if (this.mFileDom instanceof OdfStylesDom) {
                this.mSchemaDoc.setStylesDom((OdfStylesDom)this.mFileDom);
            } else if (this.mFileDom instanceof OdfMetaDom) {
                this.mSchemaDoc.setMetaDom((OdfMetaDom)this.mFileDom);
            } else if (this.mFileDom instanceof OdfSettingsDom) {
                this.mSchemaDoc.setSettingsDom((OdfSettingsDom)this.mFileDom);
            }
        }
        this.mCurrentComponent = null;
        Map<String, Object> configuration = this.mSchemaDoc.getPackage().getRunTimeConfiguration();
        this.mMaxAllowedColumnCount = OperationConstants.MAX_SUPPORTED_COLUMNS_NUMBER;
        this.mMaxAllowedRowCount = OperationConstants.MAX_SUPPORTED_ROWS_NUMBER;
        this.mMaxAllowedCellCount = OperationConstants.MAX_SUPPORTED_CELLS_NUMBER;
        this.mMediaType = this.mSchemaDoc.getMediaTypeString();
        if (configuration != null) {
            if (configuration.containsKey("maxTableColumns")) {
                this.mMaxAllowedColumnCount = (Integer)configuration.get("maxTableColumns");
            }
            if (configuration.containsKey("maxTableRows")) {
                this.mMaxAllowedRowCount = (Integer)configuration.get("maxTableRows");
            }
            if (configuration.containsKey("maxTableCells")) {
                this.mMaxAllowedCellCount = (Integer)configuration.get("maxTableCells");
            }
        }
        LOG.log(Level.FINEST, "mMaxTableColumnCount{0}", this.mMaxAllowedColumnCount);
        LOG.log(Level.FINEST, "mMaxTableRowCount{0}", this.mMaxAllowedRowCount);
        LOG.log(Level.FINEST, "mMaxTableCellCount{0}", this.mMaxAllowedCellCount);
        this.mJsonOperationProducer = this.mSchemaDoc.getJsonOperationQueue();
        if (this.mJsonOperationProducer == null) {
            this.mJsonOperationProducer = new JsonOperationProducer();
            this.mSchemaDoc.setJsonOperationQueue(this.mJsonOperationProducer);
        }
        this.mAutoListStyles = new HashMap<String, TextListStyleElement>();
        this.mUserFieldDecls = new HashMap<String, TextUserFieldDeclElement>();
        this.mTextSelectionStack = new ArrayDeque();
        this.mListStyleStack = new ArrayDeque();
        this.mWhitespaceStatusStack = new ArrayDeque();
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    private boolean isBlockedSubTree() {
        return this.mNoOperationsAllowed;
    }

    private boolean checkEndOfBlockedSubTree(String uri, String localName) {
        boolean isBlocked = this.mNoOperationsAllowed;
        if (this.mNoOperationsAllowed) {
            isBlocked = this.isBlockedSubTree(uri, localName, false);
        }
        --this.mElementDepth;
        return isBlocked;
    }

    private boolean checkStartOfBlockedSubTree(String uri, String localName) {
        ++this.mElementDepth;
        boolean isBlocked = this.mNoOperationsAllowed;
        if (!this.mNoOperationsAllowed) {
            isBlocked = this.isBlockedSubTree(uri, localName, true);
        } else if (this.mIsBlockingFrame) {
            isBlocked = this.mBlockingElementDepth != this.mElementDepth - 1 || localName.equals("table");
        }
        return isBlocked;
    }

    private boolean isBlockedSubTree(String uri, String localName, boolean isStart) {
        boolean isMasterPage;
        boolean isBlocked = this.mNoOperationsAllowed;
        boolean bl = isMasterPage = uri != null && uri.equals(StyleMasterPageElement.ELEMENT_NAME.getUri()) && localName.equals(StyleMasterPageElement.ELEMENT_NAME.getLocalName());
        if (isStart) {
            if (OdfElement.isIgnoredElement(uri, localName) || (isMasterPage || Component.isHeaderRoot(uri, localName) || Component.isFooterRoot(uri, localName)) && OdfDocument.OdfMediaType.TEXT.getMediaTypeString() != this.mMediaType && OdfDocument.OdfMediaType.SPREADSHEET.getMediaTypeString() != this.mMediaType) {
                isBlocked = true;
                this.mNoOperationsAllowed = true;
                this.mIsIgnoredElement = true;
                this.mBlockingElementDepth = this.mElementDepth;
            }
        } else if (this.mNoOperationsAllowed) {
            if (this.mBlockingElementDepth == this.mElementDepth) {
                if (this.mIsIgnoredElement && OdfElement.isIgnoredElement(uri, localName) || (isMasterPage || Component.isHeaderRoot(uri, localName) || Component.isFooterRoot(uri, localName)) && OdfDocument.OdfMediaType.TEXT.getMediaTypeString() != this.mMediaType && OdfDocument.OdfMediaType.SPREADSHEET.getMediaTypeString() != this.mMediaType) {
                    this.mIsIgnoredElement = false;
                    this.mBlockingElementDepth = -1;
                    this.mNoOperationsAllowed = false;
                    isBlocked = true;
                }
            } else if (this.mIsBlockingFrame && this.mBlockingElementDepth == this.mElementDepth - 1 && !localName.equals("table")) {
                isBlocked = false;
            }
        } else if (this.mIsIgnoredElement || this.mIsBlockingShape) {
            this.mNoOperationsAllowed = true;
            isBlocked = false;
        } else if (this.mIsBlockingFrame) {
            isBlocked = this.mBlockingElementDepth != this.mElementDepth - 1 || localName.equals("table");
        }
        return isBlocked;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Set<String> fontNames;
        String fontName;
        this.flushTextAtStart(uri, localName, qName);
        OdfElement element = null;
        element = uri.equals("") || qName.equals("") ? this.mFileDom.createElement(localName) : (localName == qName ? this.mFileDom.createElementNS(OdfName.getOdfName(OdfNamespace.newNamespace(null, uri), localName)) : this.mFileDom.createElementNS(uri, qName));
        this.addAttributes((Element)((Object)element), attributes);
        if (this.mComponentDepth < 0 && this.m_cachedPageShapes.size() > 0 && (localName.equals("p") || localName.equals("h") || localName.equals("table"))) {
            Node bodyNode = this.mCurrentNode.getParentNode();
            for (ShapeProperties component : this.m_cachedPageShapes) {
                bodyNode.insertBefore(component.mOwnNode, bodyNode.getFirstChild());
            }
            this.mLastComponentPositions.clear();
        }
        if (element instanceof StyleFontFaceElement && (fontName = element.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "name")) != null && !fontName.isEmpty() && !(fontNames = ((OdfDocument)this.mSchemaDoc).getFontNames()).contains(fontName)) {
            this.mJsonOperationProducer.addFontData(fontName, null, element.getAttributeNS(OdfDocumentNamespace.SVG.getUri(), "font-family"), element.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "font-family-generic"), element.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "font-pitch"), element.getAttributeNS(OdfDocumentNamespace.SVG.getUri(), "panose-1"));
            fontNames.add(fontName);
        }
        if (element instanceof TextListStyleElement) {
            TextListStyleElement listStyle = (TextListStyleElement)element;
            String styleName = listStyle.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "name");
            if (styleName != null && !styleName.isEmpty()) {
                this.mAutoListStyles.put(styleName, listStyle);
            }
        } else if (element instanceof TextUserFieldDeclElement) {
            TextUserFieldDeclElement fieldDecl = (TextUserFieldDeclElement)element;
            this.mUserFieldDecls.put(fieldDecl.getAttribute("text:name"), fieldDecl);
        }
        if (!this.checkStartOfBlockedSubTree(uri, localName)) {
            PageArea pageArea;
            TextSelection selection;
            List<Integer> position;
            if (Component.isComponentRoot(uri, localName)) {
                List<Integer> position2;
                if (element instanceof TextPElement || element instanceof TextHElement) {
                    boolean isNestedParagraph = false;
                    if (!isNestedParagraph) {
                        ++this.mComponentDepth;
                        TextParagraphElementBase p = (TextParagraphElementBase)element;
                        Map<String, Object> hardFormatting = this.mJsonOperationProducer.getHardStyles(p);
                        if (hardFormatting == null) {
                            hardFormatting = new HashMap<String, Object>();
                        }
                        if (element instanceof TextHElement || !this.mListStyleStack.isEmpty()) {
                            if (!hardFormatting.containsKey("paragraph")) {
                                hardFormatting.put("paragraph", new JSONObject());
                            }
                            JSONObject paraProps = (JSONObject)hardFormatting.get("paragraph");
                            try {
                                Integer outlineLevel;
                                if (!this.mListStyleStack.isEmpty()) {
                                    String listStyleId;
                                    paraProps.put("listLevel", this.mListStyleStack.size() - 1);
                                    ParagraphListProperties listProps = this.mListStyleStack.getLast();
                                    if (listProps.hasListLabel()) {
                                        listProps.showListLabel(Boolean.FALSE);
                                    } else {
                                        paraProps.put("listLabelHidden", (Object)Boolean.TRUE);
                                    }
                                    String listId = listProps.getListId();
                                    if (listId != null && !listId.isEmpty()) {
                                        paraProps.put("listId", (Object)listId);
                                    }
                                    boolean foundListXmlId = false;
                                    boolean foundListItemXmlId = false;
                                    Iterator<ParagraphListProperties> listPropsIter = this.mListStyleStack.descendingIterator();
                                    while (!(foundListXmlId && foundListItemXmlId || !listPropsIter.hasNext())) {
                                        ParagraphListProperties currentListProp = listPropsIter.next();
                                        String listXmlId = currentListProp.getListXmlId();
                                        if (!foundListXmlId && listXmlId != null && !listXmlId.isEmpty()) {
                                            foundListXmlId = true;
                                            paraProps.put("listXmlId", (Object)listXmlId);
                                        }
                                        String listItemXmlId = currentListProp.getListItemXmlId();
                                        if (foundListItemXmlId || listItemXmlId == null || listItemXmlId.isEmpty()) continue;
                                        foundListItemXmlId = true;
                                        paraProps.put("listItemXmlId", (Object)listItemXmlId);
                                    }
                                    if (listProps.isListStart()) {
                                        paraProps.put("listStart", (Object)Boolean.TRUE);
                                    }
                                    if ((listStyleId = JsonOperationProducer.getListStyle(this.mListStyleStack, p)) != null && !listStyleId.isEmpty()) {
                                        this.mJsonOperationProducer.addListStyle(this.mSchemaDoc, this.mAutoListStyles, listStyleId);
                                        paraProps.put("listStyleId", (Object)listStyleId);
                                    } else {
                                        paraProps.put("listStyleId", (Object)"OTK_DEFAULT_LIST");
                                    }
                                    if (this.mListStartValue != -1) {
                                        paraProps.put("listStartValue", this.mListStartValue);
                                        this.mListStartValue = -1;
                                    }
                                }
                                if (element instanceof TextHElement && (outlineLevel = ((TextHElement)element).getTextOutlineLevelAttribute()) != null) {
                                    paraProps.put("outlineLevel", (Object)outlineLevel);
                                }
                            }
                            catch (JSONException ex) {
                                Logger.getLogger(ChangesFileSaxHandler.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                        List<Integer> position3 = this.updateComponentPosition();
                        OdfStyle templateStyle = p.getDocumentStyle();
                        String styleId = null;
                        if (templateStyle != null && (styleId = templateStyle.getStyleNameAttribute()) != null && !styleId.isEmpty()) {
                            hardFormatting.put("styleId", styleId);
                        }
                        this.mCurrentComponent = this.mCurrentComponent.createChildComponent(p);
                        boolean paragraphOpCreated = false;
                        if (!this.mPageBoundObjectsRelocated && !this.m_cachedPageShapes.isEmpty()) {
                            boolean isFirstDocumentParagraph;
                            boolean bl = isFirstDocumentParagraph = this.mComponentStack.empty() || this.mComponentStack.peek() instanceof CachedTable;
                            if (isFirstDocumentParagraph && this.m_cachedPageShapes.size() > 0) {
                                this.cacheOperation(false, "Paragraph", position3, false, hardFormatting, this.mContextName);
                                paragraphOpCreated = true;
                                for (ShapeProperties component : this.m_cachedPageShapes) {
                                    Component frameComponent = component.getDrawFrameElement().getComponent();
                                    Component frameComponentParent = frameComponent.getParent();
                                    int framePosition = frameComponentParent.indexOf(frameComponent);
                                    frameComponentParent.remove(framePosition);
                                    element.appendChild(component.mOwnNode);
                                    component.mShapePosition.addAll(0, position3);
                                    component.createShapeOperation(this, this.mComponentStack, component.mDescription, component.hasImageSibling() ? ShapeType.ImageShape : (component.isGroupShape() ? ShapeType.GroupShape : ShapeType.NormalShape), component.mContext);
                                    for (CachedOperation op : component) {
                                        List<Integer> start = op.mStart;
                                        if (!op.mAbsolutePosition) {
                                            if (op.mComponentType.equals("Attributes")) {
                                                List end = (List)op.mComponentProperties[0];
                                                end.addAll(0, position3);
                                            }
                                            start.addAll(0, position3);
                                        }
                                        this.cacheOperation(false, op.mComponentType, start, false, op.mHardFormattingProperties, op.mComponentProperties);
                                    }
                                }
                                this.m_cachedPageShapes.clear();
                            }
                            this.mPageBoundObjectsRelocated |= isFirstDocumentParagraph;
                        }
                        if (!paragraphOpCreated) {
                            this.cacheOperation(false, "Paragraph", position3, false, hardFormatting, this.mContextName);
                        }
                        this.mWhitespaceStatusStack.add(new WhitespaceStatus(false, this.mComponentDepth));
                        element.markAsComponentRoot(true);
                    } else {
                        this.mWhitespaceStatusStack.add(new WhitespaceStatus(true, this.mComponentDepth));
                        element.ignoredComponent(true);
                    }
                } else if (element instanceof DrawFrameElement || Component.isShapeElement(uri, localName)) {
                    String styleId;
                    Integer zIndex;
                    OdfElement shape = element;
                    Map<String, Object> hardFormatting = null;
                    if (element instanceof OdfStyleableShapeElement) {
                        hardFormatting = this.mJsonOperationProducer.getHardStyles((OdfStyleableShapeElement)shape);
                    }
                    if (hardFormatting == null || !hardFormatting.containsKey("drawing")) {
                        if (hardFormatting == null) {
                            hardFormatting = new HashMap<String, Object>();
                        }
                        hardFormatting.put("drawing", new JSONObject());
                    }
                    JSONObject drawingProps = (JSONObject)hardFormatting.get("drawing");
                    if (hardFormatting == null || !hardFormatting.containsKey("image")) {
                        if (hardFormatting == null) {
                            hardFormatting = new HashMap<String, Object>();
                        }
                        hardFormatting.put("image", new JSONObject());
                    }
                    int anchorHorOffset = 0;
                    int anchorVertOffset = 0;
                    int anchorLayerOrder = 0;
                    int width = 0;
                    int height = 0;
                    if (shape instanceof DrawShapeElementBase && null != (zIndex = ((DrawShapeElementBase)shape).getDrawZIndexAttribute())) {
                        anchorLayerOrder = zIndex;
                    }
                    if (element instanceof DrawLineElement || element instanceof DrawConnectorElement || element instanceof DrawMeasureElement) {
                        if (shape.hasAttributeNS(OdfDocumentNamespace.SVG.getUri(), "y1") && shape.hasAttributeNS(OdfDocumentNamespace.SVG.getUri(), "x1") && shape.hasAttributeNS(OdfDocumentNamespace.SVG.getUri(), "y2") && shape.hasAttributeNS(OdfDocumentNamespace.SVG.getUri(), "x2")) {
                            int x1 = MapHelper.normalizeLength(shape.getAttributeNS(OdfDocumentNamespace.SVG.getUri(), "x1"));
                            int x2 = MapHelper.normalizeLength(shape.getAttributeNS(OdfDocumentNamespace.SVG.getUri(), "x2"));
                            int y1 = MapHelper.normalizeLength(shape.getAttributeNS(OdfDocumentNamespace.SVG.getUri(), "y1"));
                            int y2 = MapHelper.normalizeLength(shape.getAttributeNS(OdfDocumentNamespace.SVG.getUri(), "y2"));
                            anchorHorOffset = Math.min(x1, x2);
                            width = Math.abs(x2 - x1) + 1;
                            anchorVertOffset = Math.min(y1, y2);
                            height = Math.abs(y2 - y1) + 1;
                        }
                    } else {
                        if (shape.hasAttributeNS(OdfDocumentNamespace.SVG.getUri(), "width")) {
                            width = MapHelper.normalizeLength(shape.getAttributeNS(OdfDocumentNamespace.SVG.getUri(), "width"));
                        }
                        if (shape.hasAttributeNS(OdfDocumentNamespace.SVG.getUri(), "height")) {
                            height = MapHelper.normalizeLength(shape.getAttributeNS(OdfDocumentNamespace.SVG.getUri(), "height"));
                        }
                        if (shape.hasAttributeNS(OdfDocumentNamespace.SVG.getUri(), "x")) {
                            anchorHorOffset = MapHelper.normalizeLength(shape.getAttributeNS(OdfDocumentNamespace.SVG.getUri(), "x"));
                        }
                        if (shape.hasAttributeNS(OdfDocumentNamespace.SVG.getUri(), "y")) {
                            anchorVertOffset = MapHelper.normalizeLength(shape.getAttributeNS(OdfDocumentNamespace.SVG.getUri(), "y"));
                        }
                    }
                    try {
                        if (height != 0) {
                            drawingProps.put("height", height);
                        }
                        if (width != 0) {
                            drawingProps.put("width", width);
                        }
                        if (anchorHorOffset != 0) {
                            drawingProps.put("anchorHorOffset", anchorHorOffset);
                            drawingProps.put("left", anchorHorOffset);
                        }
                        if (anchorVertOffset != 0) {
                            drawingProps.put("anchorVertOffset", anchorVertOffset);
                            drawingProps.put("top", anchorVertOffset);
                        }
                        if (anchorLayerOrder != 0) {
                            drawingProps.put("anchorLayerOrder", anchorLayerOrder);
                        }
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(ChangesFileSaxHandler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    if (shape.hasAttributeNS(OdfDocumentNamespace.DRAW.getUri(), "transform")) {
                        try {
                            String transform = shape.getAttributeNS(OdfDocumentNamespace.DRAW.getUri(), "transform");
                            int index = transform.indexOf("translate");
                            if (index >= 0) {
                                index = transform.indexOf(40, index);
                                transform = transform.substring(index, transform.length());
                                int separator = transform.indexOf(32);
                                String leftValue = transform.substring(1, separator);
                                index = transform.indexOf(41, separator);
                                String rightValue = transform.substring(separator + 1, index);
                                anchorHorOffset += MapHelper.normalizeLength(leftValue);
                                anchorVertOffset += MapHelper.normalizeLength(rightValue);
                            }
                            if (anchorVertOffset != 0) {
                                drawingProps.put("anchorVertOffset", anchorVertOffset);
                            }
                            if (anchorHorOffset != 0) {
                                drawingProps.put("anchorHorOffset", anchorHorOffset);
                            }
                        }
                        catch (IndexOutOfBoundsException ex) {
                            Logger.getLogger(ChangesFileSaxHandler.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (JSONException ex) {
                            Logger.getLogger(ChangesFileSaxHandler.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    if (shape.hasAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "anchor-type")) {
                        try {
                            String anchorVertBase = null;
                            String anchorHorBase = null;
                            String anchorType = shape.getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "anchor-type");
                            if (anchorType.equals("page")) {
                                drawingProps.put("inline", (Object)Boolean.FALSE);
                                drawingProps.put("anchorHorBase", (Object)"page");
                                drawingProps.put("anchorVertBase", (Object)"page");
                            } else if (anchorType.equals("frame")) {
                                drawingProps.put("inline", (Object)Boolean.FALSE);
                                anchorVertBase = "column";
                                anchorVertBase = "margin";
                            } else if (anchorType.equals("paragraph")) {
                                drawingProps.put("inline", (Object)Boolean.FALSE);
                                anchorHorBase = "column";
                                anchorVertBase = "paragraph";
                            } else if (anchorType.equals("char")) {
                                drawingProps.put("inline", (Object)Boolean.FALSE);
                                anchorHorBase = "character";
                                anchorVertBase = "paragraph";
                            } else if (anchorType.equals("as-char")) {
                                drawingProps.put("inline", (Object)Boolean.TRUE);
                            }
                            if (anchorVertBase != null && !drawingProps.has("anchorVertBase")) {
                                drawingProps.put("anchorVertBase", (Object)anchorVertBase);
                            }
                            if (anchorHorBase != null && !drawingProps.has("anchorHorBase")) {
                                drawingProps.put("anchorHorBase", (Object)anchorHorBase);
                            }
                        }
                        catch (JSONException ex) {
                            Logger.getLogger(ChangesFileSaxHandler.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    hardFormatting.put("drawing", drawingProps);
                    ++this.mComponentDepth;
                    List<Integer> pos = this.updateComponentPosition();
                    if (element instanceof OdfStyleableShapeElement && (styleId = ((OdfStyleableShapeElement)shape).getDocumentStyleName()) != null && !styleId.isEmpty()) {
                        hardFormatting.put("styleId", styleId);
                    }
                    ShapeProperties shapeProps = new ShapeProperties(pos, hardFormatting);
                    if (element instanceof DrawFrameElement) {
                        CachedComponent comp;
                        shapeProps.setDrawFrameElement((DrawFrameElement)shape);
                        if (!this.mComponentStack.isEmpty() && (comp = this.mComponentStack.peek()) instanceof ShapeProperties && ((ShapeProperties)comp).getDrawFrameElement() != null) {
                            LOG.warning("Feature 'Frame attached to Frame' yet unsupported");
                        }
                    } else if (element instanceof DrawGElement) {
                        shapeProps.setGroupShape();
                        element.markAsComponentRoot(true);
                    }
                    if (this.mCurrentComponent != null) {
                        this.mComponentStack.push(shapeProps);
                        this.mCurrentComponent = this.mCurrentComponent.createChildComponent(element);
                    }
                } else if (element instanceof TableTableElement) {
                    ++this.mComponentDepth;
                    this.updateComponentPosition();
                    this.isTableNew = true;
                    this.mTableElement = (TableTableElement)element;
                    this.mCurrentComponent = this.mCurrentComponent.createChildComponent(this.mTableElement);
                    if (this.mTableElement.hasAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "style-name")) {
                        this.mTableHardFormatting = this.mJsonOperationProducer.getHardStyles(this.mTableElement);
                        String styleId = this.mTableElement.getDocumentStyleName();
                        if (styleId != null && !styleId.isEmpty()) {
                            if (this.mTableHardFormatting == null) {
                                this.mTableHardFormatting = new HashMap<String, Object>();
                            }
                            this.mTableHardFormatting.put("styleId", styleId);
                        }
                    } else {
                        this.mTableHardFormatting = new HashMap<String, Object>();
                    }
                    this.mTableName = this.mTableElement.getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "name");
                    this.mColumnRelWidths = new LinkedList<Integer>();
                    element.markAsComponentRoot(true);
                } else if (element instanceof TableTableRowElement) {
                    ++this.mComponentDepth;
                    if (this.isTableNew) {
                        this.mColumnRelWidths = Table.collectColumnWidths(this.mTableElement, this.mColumns);
                        this.mColumns.clear();
                        if (this.mColumnRelWidths != null && this.mColumnRelWidths.isEmpty()) {
                            for (int i = 0; i < this.mColumnCount; ++i) {
                                this.mColumnRelWidths.add(ONE);
                            }
                        }
                        LinkedList<Integer> tablePosition = new LinkedList<Integer>(this.mLastComponentPositions);
                        this.cacheTableOperation("Table", tablePosition, this.mTableHardFormatting, this.mColumnRelWidths, this.mTableName);
                        this.mTableHardFormatting = null;
                        this.isTableNew = false;
                        this.mTableName = null;
                        this.mColumnCount = 0;
                        this.mColumnRelWidths = null;
                    }
                    position = this.updateComponentPosition();
                    TableTableRowElement row = (TableTableRowElement)element;
                    this.mCurrentComponent = this.mCurrentComponent.createChildComponent(row);
                    int repeatedRows = 1;
                    if (row.hasAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-rows-repeated")) {
                        repeatedRows = Integer.parseInt(row.getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-rows-repeated"));
                        this.mCurrentComponent.hasRepeated(true);
                    }
                    boolean isVisible = Boolean.TRUE;
                    if (row.hasAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "visibility")) {
                        isVisible = "visible".equals(row.getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "visibility"));
                    }
                    Map<String, Object> hardFormatting = this.mJsonOperationProducer.getHardStyles(row);
                    OdfStyle templateStyle = row.getDocumentStyle();
                    String styleId = null;
                    if (templateStyle != null && (styleId = templateStyle.getStyleNameAttribute()) != null && !styleId.isEmpty()) {
                        hardFormatting.put("styleId", styleId);
                    }
                    if (!isVisible) {
                        JSONObject rowProps;
                        if (hardFormatting == null && hardFormatting == null) {
                            hardFormatting = new HashMap<String, Object>();
                        }
                        if (!hardFormatting.containsKey("row")) {
                            rowProps = new JSONObject();
                            hardFormatting.put("row", rowProps);
                        } else {
                            rowProps = (JSONObject)hardFormatting.get("row");
                            if (rowProps == null) {
                                rowProps = new JSONObject();
                            }
                        }
                        try {
                            rowProps.put("visible", (Object)Boolean.FALSE);
                        }
                        catch (JSONException ex) {
                            Logger.getLogger(ChangesFileSaxHandler.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    this.cacheTableOperation("Rows", position, hardFormatting, repeatedRows);
                    element.markAsComponentRoot(true);
                } else if (element instanceof TableTableCellElement || element instanceof TableCoveredTableCellElement) {
                    String styleId;
                    OdfStyle templateStyle;
                    boolean covered = element instanceof TableCoveredTableCellElement;
                    ++this.mComponentDepth;
                    TableTableCellElement cell = covered ? null : (TableTableCellElement)element;
                    this.mCurrentComponent = cell != null ? this.mCurrentComponent.createChildComponent(cell) : this.mCurrentComponent.createChildComponent(element);
                    CachedTable cachedTableOps = (CachedTable)this.mComponentStack.peek();
                    cachedTableOps.setCellRepetition(1);
                    int repetition = 1;
                    Map<String, Object> hardFormatting = null;
                    if (!covered) {
                        hardFormatting = this.mJsonOperationProducer.getHardStyles(cell);
                    }
                    if (element.hasAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated")) {
                        cachedTableOps.setCellRepetition(Integer.parseInt(element.getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated")));
                        repetition = Integer.parseInt(element.getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated"));
                        this.mCurrentComponent.hasRepeated(true);
                    }
                    if (cell != null && cell.hasAttributes()) {
                        try {
                            JSONObject cellProps;
                            if (!(hardFormatting != null && hardFormatting.containsKey("cell") || hardFormatting != null)) {
                                hardFormatting = new HashMap<String, Object>();
                            }
                            if ((cellProps = (JSONObject)hardFormatting.get("cell")) == null) {
                                cellProps = new JSONObject();
                            }
                            if (cell.hasAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-spanned")) {
                                cellProps.put(COLUMN_SPAN, Integer.parseInt(cell.getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-spanned")));
                            }
                            if (cell.hasAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-rows-spanned")) {
                                cellProps.put(ROW_SPAN, Integer.parseInt(cell.getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-rows-spanned")));
                            }
                            if (cellProps.length() != 0) {
                                hardFormatting.put("cell", cellProps);
                            }
                        }
                        catch (JSONException ex) {
                            Logger.getLogger(ChangesFileSaxHandler.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    List<Integer> position4 = this.updateComponentPosition();
                    OdfStyle odfStyle = templateStyle = covered ? null : cell.getDocumentStyle();
                    if (templateStyle != null && (styleId = templateStyle.getStyleNameAttribute()) != null && !styleId.isEmpty()) {
                        hardFormatting.put("styleId", styleId);
                    }
                    this.cacheTableOperation("Cells", position4, hardFormatting, this.mCurrentComponent, repetition);
                    element.markAsComponentRoot(true);
                } else if (element instanceof TextLineBreakElement) {
                    ++this.mComponentDepth;
                    TextLineBreakElement lineBreak = (TextLineBreakElement)element;
                    position2 = this.updateComponentPosition();
                    this.mCurrentComponent = this.mCurrentComponent.createChildComponent(lineBreak);
                    this.cacheOperation(false, "LineBreak", position2, false, null, null, null);
                    element.markAsComponentRoot(true);
                } else if (element instanceof TextTabElement) {
                    ++this.mComponentDepth;
                    TextTabElement tab = (TextTabElement)element;
                    position2 = this.updateComponentPosition();
                    this.mCurrentComponent = this.mCurrentComponent.createChildComponent(tab);
                    this.cacheOperation(false, "Tab", position2, false, null, null, null);
                    element.markAsComponentRoot(true);
                } else if (Component.isField(uri, localName)) {
                    ++this.mComponentDepth;
                    position = this.updateComponentPosition();
                    this.mCurrentComponent = this.mCurrentComponent.createChildComponent(element);
                    TextFieldSelection selection2 = null;
                    selection2 = element.hasAttributeNS(LIBRE_OFFICE_MS_INTEROP_NAMESPACE, "type") && element.getAttributeNS(LIBRE_OFFICE_MS_INTEROP_NAMESPACE, "type").equals(LIBRE_OFFICE_MS_INTEROP_TYPE_CHECKBOX) ? new TextFieldSelection(element, position, LIBRE_OFFICE_MS_INTEROP_CHECKBOX_UNICODE) : (this.mFileDom instanceof OdfContentDom ? new TextFieldSelection(element, position, ((OdfContentDom)this.mFileDom).getAutomaticStyles(), this.mUserFieldDecls) : new TextFieldSelection(element, position, ((OdfStylesDom)this.mFileDom).getAutomaticStyles(), this.mUserFieldDecls));
                    this.mTextSelectionStack.add(selection2);
                } else if (element instanceof OfficeAnnotationElement) {
                    ++this.mComponentDepth;
                    if (this.mIsCharsBeginning) {
                        this.updateTextPosition();
                    }
                    this.mCurrentComponent = this.mCurrentComponent.createChildComponent(element);
                    String annotationName = ((OfficeAnnotationElement)element).getOfficeNameAttribute();
                    if (annotationName == null) {
                        annotationName = ((OdfDocument)this.mSchemaDoc).getUniqueAnnotationName();
                    }
                    CommentComponent commentProps = new CommentComponent(this.mLastComponentPositions, annotationName);
                    ((OdfDocument)this.mSchemaDoc).addAnnotation(annotationName, (OfficeAnnotationElement)element);
                    this.mComponentStack.push(commentProps);
                    element.markAsComponentRoot(true);
                } else if (element instanceof OfficeAnnotationEndElement) {
                    ++this.mComponentDepth;
                    position = this.updateComponentPosition();
                    Object id = COMMENT_PREFIX;
                    id = (String)id + ((OfficeAnnotationEndElement)element).getOfficeNameAttribute();
                    this.cacheOperation(false, "CommentRange", position, false, null, id, this.mContextName);
                    this.mCurrentComponent = this.mCurrentComponent.createChildComponent(element);
                    element.markAsComponentRoot(true);
                } else {
                    ++this.mComponentDepth;
                    element.markAsComponentRoot(true);
                }
            } else if (element instanceof TextSpanElement) {
                selection = new TextSpanSelection((TextSpanElement)element, this.getTextPosition());
                this.mTextSelectionStack.add(selection);
            } else if (element instanceof TextAElement) {
                selection = new TextHyperlinkSelection((TextAElement)element, this.getTextPosition());
                this.mTextSelectionStack.add(selection);
            } else if (element instanceof TextSElement) {
                ++this.mComponentDepth;
                position = this.updateComponentPosition();
                if (this.mIsCharsBeginning) {
                    this.mCharsStartPosition = position;
                    this.mIsCharsBeginning = false;
                }
                TextSElement spaces = (TextSElement)element;
                this.mCurrentComponent = this.mCurrentComponent.createChildComponent(spaces);
                Integer quantity = spaces.getTextCAttribute();
                if (quantity == null) {
                    this.addText(" ");
                } else {
                    for (int i = 0; i < quantity; ++i) {
                        this.mCharsForOperation.append(' ');
                    }
                    this.addText(this.mCharsForOperation);
                }
            } else if (element instanceof TableTableColumnElement) {
                TableTableColumnElement column = (TableTableColumnElement)element;
                ++this.mColumnCount;
                int repeatedColumns = 1;
                if (column.hasAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated") && (repeatedColumns = Integer.parseInt(column.getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated"))) > 1) {
                    this.mColumnCount += repeatedColumns - 1;
                }
                if (this.mColumns == null) {
                    this.mColumns = new ArrayList<TableTableColumnElement>();
                }
                this.mColumns.add(column);
            } else if (element instanceof TextListElement) {
                TextListElement list = (TextListElement)element;
                if (this.mListStyleStack.isEmpty()) {
                    ParagraphListProperties paragraphListProps = new ParagraphListProperties();
                    paragraphListProps.setListStart(true);
                    String continuedListId = list.getTextContinueListAttribute();
                    String listXmlId = list.getXmlIdAttribute();
                    if (continuedListId != null && !continuedListId.isEmpty()) {
                        paragraphListProps.setListId(this.newContinuedList(continuedListId, listXmlId).getListId());
                    } else if (listXmlId != null && !listXmlId.isEmpty()) {
                        paragraphListProps.setListId(this.newContinuedList(listXmlId).getListId());
                    }
                    if (listXmlId != null && !listXmlId.isEmpty()) {
                        paragraphListProps.setListXmlId(listXmlId);
                    } else {
                        paragraphListProps.setListXmlId(null);
                    }
                    this.mListStyleStack.add(paragraphListProps);
                } else {
                    this.mListStyleStack.add(new ParagraphListProperties());
                }
                if (list.hasAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "style-name")) {
                    String listStyle = list.getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "style-name");
                    this.mListStyleStack.getLast().setListStyleName(listStyle);
                }
            } else if (element instanceof TextListItemElement || element instanceof TextListHeaderElement) {
                ParagraphListProperties paragraphListStyle = this.mListStyleStack.getLast();
                OdfElement listItem = element;
                if (listItem instanceof TextListHeaderElement) {
                    paragraphListStyle.showListLabel(false);
                } else {
                    paragraphListStyle.showListLabel(true);
                }
                if (listItem.hasAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "start-value")) {
                    this.mListStartValue = Integer.parseInt(listItem.getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "start-value"));
                }
                if (listItem.hasAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "style-override")) {
                    String styleOverride = listItem.getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "style-override");
                    if (styleOverride != null && !styleOverride.isEmpty()) {
                        paragraphListStyle.overrideListStyle(styleOverride);
                    } else {
                        paragraphListStyle.overrideListStyle(null);
                    }
                } else {
                    paragraphListStyle.overrideListStyle(null);
                }
                String listXmlId = null;
                if (listItem instanceof TextListItemElement) {
                    listXmlId = ((TextListItemElement)listItem).getXmlIdAttribute();
                } else if (listItem instanceof TextListHeaderElement) {
                    listXmlId = ((TextListHeaderElement)listItem).getXmlIdAttribute();
                }
                if (listXmlId != null && !listXmlId.isEmpty()) {
                    this.mListStyleStack.getLast().setListItemXmlId(listXmlId);
                } else {
                    this.mListStyleStack.getLast().setListItemXmlId(null);
                }
            } else if (element instanceof StyleMasterPageElement) {
                String nextMasterPageStyle;
                StyleMasterPageElement masterPage = (StyleMasterPageElement)element;
                this.mMasterPageStyleName = masterPage.getStyleNameAttribute();
                this.mPageLayoutName = masterPage.getStylePageLayoutNameAttribute();
                this.headerAttrs = null;
                this.footerAttrs = null;
                if (this.mPageLayoutName != null) {
                    try {
                        OdfStylePageLayout pageLayout;
                        OdfStylesDom stylesDom = this.mSchemaDoc.getStylesDom();
                        OfficeAutomaticStylesElement autoStyles = stylesDom.getAutomaticStyles();
                        if (autoStyles != null && (pageLayout = autoStyles.getPageLayout(this.mPageLayoutName)) != null) {
                            this.mPageStyleUsage = pageLayout.getStylePageUsageAttribute();
                            this.headerAttrs = this.getHeaderFooterAttrs((OdfElement)((Object)pageLayout.getChildElement(StyleHeaderStyleElement.ELEMENT_NAME.getUri(), "header-style")));
                            this.footerAttrs = this.getHeaderFooterAttrs((OdfElement)((Object)pageLayout.getChildElement(StyleFooterStyleElement.ELEMENT_NAME.getUri(), "footer-style")));
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ChangesFileSaxHandler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                this.mHasNextMasterPage = (nextMasterPageStyle = masterPage.getStyleNextStyleNameAttribute()) != null && !nextMasterPageStyle.isEmpty();
            } else if (Component.isHeaderRoot(uri, localName)) {
                pageArea = null;
                pageArea = localName.equals("header") ? PageArea.HEADER_DEFAULT : (localName.equals("header-left") ? PageArea.HEADER_EVEN : PageArea.HEADER_FIRST);
                this.mContextName = pageArea.getPageAreaName() + CONTEXT_DELIMITER + this.mMasterPageStyleName;
                this.mJsonOperationProducer.addHeaderFooter(this.mContextName, pageArea, this.headerAttrs);
            } else if (Component.isFooterRoot(uri, localName)) {
                pageArea = null;
                pageArea = localName.equals("footer") ? PageArea.FOOTER_DEFAULT : (localName.equals("footer-left") ? PageArea.FOOTER_EVEN : PageArea.FOOTER_FIRST);
                this.mContextName = pageArea.getPageAreaName() + CONTEXT_DELIMITER + this.mMasterPageStyleName;
                this.mJsonOperationProducer.addHeaderFooter(this.mContextName, pageArea, this.footerAttrs);
            } else if (element instanceof DrawImageElement) {
                DrawImageElement image = (DrawImageElement)element;
                ShapeProperties frameProps = (ShapeProperties)this.mComponentStack.peek();
                int childNo = frameProps.incrementChildNumber();
                if (childNo == 1) {
                    HashMap<String, Object> hardFormatting = new HashMap<String, Object>();
                    hardFormatting.putAll(frameProps.getShapeHardFormatting());
                    JSONObject drawingProps = (JSONObject)hardFormatting.get("drawing");
                    JSONObject imageProps = (JSONObject)hardFormatting.get("image");
                    if (image.hasAttributeNS(OdfDocumentNamespace.XLINK.getUri(), "href")) {
                        try {
                            String href = image.getAttributeNS(OdfDocumentNamespace.XLINK.getUri(), "href");
                            imageProps.put("imageUrl", (Object)href);
                            if (imageProps.has("cropRight") && (imageProps.has("height") || imageProps.has("width"))) {
                                JsonOperationProducer.calculateCrops(image, href, imageProps);
                            }
                        }
                        catch (JSONException ex) {
                            Logger.getLogger(ChangesFileSaxHandler.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    if (image.hasAttributeNS(OdfDocumentNamespace.XML.getUri(), "id")) {
                        try {
                            drawingProps.put("imageXmlId", (Object)image.getAttributeNS(OdfDocumentNamespace.XML.getUri(), "id"));
                        }
                        catch (JSONException ex) {
                            Logger.getLogger(ChangesFileSaxHandler.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    DrawFrameElement frameElement = frameProps.getDrawFrameElement();
                    frameElement.markAsComponentRoot(true);
                    this.mComponentStack.pop();
                    this.mComponentStack.push(frameProps);
                    frameProps.declareImage();
                    hardFormatting.put("drawing", drawingProps);
                }
            } else if (element instanceof DrawTextBoxElement && !this.mComponentStack.empty()) {
                ShapeProperties parentShapeProps = (ShapeProperties)this.mComponentStack.peek();
                JSONObject originalDrawingProps = (JSONObject)parentShapeProps.mShapeHardFormatations.get("drawing");
                if (originalDrawingProps != null && !originalDrawingProps.has("height")) {
                    try {
                        if (!parentShapeProps.mShapeHardFormatations.containsKey("shape")) {
                            parentShapeProps.mShapeHardFormatations.put("shape", new JSONObject());
                        }
                        JSONObject originalShapeProps = (JSONObject)parentShapeProps.mShapeHardFormatations.get("shape");
                        originalShapeProps.put("autoResizeHeight", (Object)"true");
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(ChangesFileSaxHandler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            if (Component.isDocumentRoot(uri, localName) || Component.isHeaderRoot(uri, localName) || Component.isFooterRoot(uri, localName)) {
                this.mCurrentComponent = new Component(element);
                this.mSchemaDoc.setRootComponent(this.mCurrentComponent);
                if (Component.isHeaderRoot(uri, localName) || Component.isFooterRoot(uri, localName)) {
                    this.mLastComponentPositions.clear();
                } else {
                    this.mPageArea = PageArea.BODY;
                }
            }
        } else if (element instanceof OdfElement) {
            element.ignoredComponent(true);
        }
        this.mCurrentNode = this.mCurrentNode.appendChild((Node)((Object)element));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.flushTextAtEnd(uri, localName, qName);
        if (uri != null && localName != null && localName.equals(TableTableElement.ELEMENT_NAME.getLocalName()) && uri.equals(OdfDocumentNamespace.TABLE.getUri())) {
            this.endTableSizeEvaluation();
        }
        if (qName.equals("office:styles") && this.mFileDom instanceof OdfStylesDom) {
            Integer defaultTabStopWidth = null;
            JSONObject defaultPageStyles = null;
            OdfStylesDom stylesDom = (OdfStylesDom)this.mFileDom;
            this.mContextName = null;
            OdfOfficeStyles officeStyles = (OdfOfficeStyles)((Object)this.mCurrentNode);
            if (officeStyles != null) {
                this.mHasHyperlinkTemplateStyle = officeStyles.getStyle(HYERLINK_DEFAULT_STYLE, OdfStyleFamily.Text) != null;
                Iterator<OdfStyle> paragraphStyleIter = officeStyles.getStylesForFamily(OdfStyleFamily.Paragraph).iterator();
                Integer _defaultTabStopWidth = null;
                while (paragraphStyleIter.hasNext()) {
                    _defaultTabStopWidth = this.mJsonOperationProducer.triggerStyleHierarchyOps(officeStyles, OdfStyleFamily.Paragraph, paragraphStyleIter.next());
                    if (_defaultTabStopWidth == null) continue;
                    defaultTabStopWidth = _defaultTabStopWidth;
                }
                Iterator<OdfStyle> textStyleIter = officeStyles.getStylesForFamily(OdfStyleFamily.Text).iterator();
                while (textStyleIter.hasNext()) {
                    this.mJsonOperationProducer.triggerStyleHierarchyOps(officeStyles, OdfStyleFamily.Text, textStyleIter.next());
                }
                Iterator<OdfStyle> graphicStyleIter = officeStyles.getStylesForFamily(OdfStyleFamily.Graphic).iterator();
                while (graphicStyleIter.hasNext()) {
                    this.mJsonOperationProducer.triggerStyleHierarchyOps(officeStyles, OdfStyleFamily.Graphic, graphicStyleIter.next());
                }
                this.mJsonOperationProducer.triggerDefaultStyleOp(OdfStyleFamily.Graphic, officeStyles.getDefaultStyle(OdfStyleFamily.Graphic));
                for (OdfStyle style : officeStyles.getStylesForFamily(OdfStyleFamily.TableCell)) {
                    this.mJsonOperationProducer.triggerStyleHierarchyOps(officeStyles, OdfStyleFamily.TableCell, style);
                }
                Iterator<OdfTextListStyle> textListStyleIter = officeStyles.getListStyles().iterator();
                while (textListStyleIter.hasNext()) {
                    this.mJsonOperationProducer.addListStyle(textListStyleIter.next());
                }
                defaultPageStyles = this.mJsonOperationProducer.addPageProperties(stylesDom);
                this.mJsonOperationProducer.addDocumentProperties(stylesDom, defaultTabStopWidth, defaultPageStyles);
            } else {
                this.mJsonOperationProducer.addDocumentProperties(stylesDom, null, null);
            }
        }
        boolean selectionNormalization = false;
        if (!this.checkEndOfBlockedSubTree(uri, localName)) {
            CachedComponent commProps;
            boolean isImageComponent = false;
            if (uri != null && uri.equals(DrawFrameElement.ELEMENT_NAME.getUri()) && localName.equals(DrawFrameElement.ELEMENT_NAME.getLocalName()) || Component.isShapeElement(uri, localName)) {
                if (!this.mComponentStack.empty()) {
                    SvgDescElement desc;
                    Node descText;
                    ShapeProperties shapeProps = (ShapeProperties)this.mComponentStack.pop();
                    --this.mComponentDepth;
                    isImageComponent = shapeProps.hasImageSibling();
                    NodeList descList = this.mCurrentComponent.mRootElement.getElementsByTagNameNS(OdfDocumentNamespace.SVG.getUri(), SvgDescElement.ELEMENT_NAME.getLocalName());
                    String description = null;
                    if (descList.getLength() > 0 && (descText = (desc = (SvgDescElement)((Object)descList.item(0))).getFirstChild()) != null && descText instanceof Text) {
                        description = ((Text)descText).getTextContent();
                    }
                    shapeProps.createShapeOperation(this, this.mComponentStack, description, isImageComponent ? ShapeType.ImageShape : (shapeProps.isGroupShape() ? ShapeType.GroupShape : ShapeType.NormalShape), this.mContextName);
                    if (shapeProps.isGroupShape()) {
                        this.mCurrentNode.setUserData("groupWidth", shapeProps.mHoriOffsetMax - (shapeProps.mHoriOffsetMin == null ? 0 : shapeProps.mHoriOffsetMin), null);
                        this.mCurrentNode.setUserData("groupHeight", shapeProps.mVertOffsetMax - (shapeProps.mVertOffsetMin == null ? 0 : shapeProps.mVertOffsetMin), null);
                    }
                    for (CachedOperation op : shapeProps) {
                        this.cacheOperation(true, op.mComponentType, op.mStart, false, op.mHardFormattingProperties, op.mComponentProperties);
                    }
                    this.mCurrentComponent = this.mCurrentComponent.getParent();
                }
            } else if (ChangesFileSaxHandler.isSpaceElement(uri, localName)) {
                --this.mComponentDepth;
                this.mCurrentComponent = this.mCurrentComponent.getParent();
            } else if (uri != null && Component.isComponentRoot(uri, localName)) {
                if (localName.equals(DrawFrameElement.ELEMENT_NAME.getLocalName()) && uri.equals(DrawFrameElement.ELEMENT_NAME.getUri()) && isImageComponent || !localName.equals(DrawFrameElement.ELEMENT_NAME.getLocalName()) || !uri.equals(DrawFrameElement.ELEMENT_NAME.getUri())) {
                    if (Component.isTextComponentRoot(this.mCurrentNode)) {
                        Collection<TextSelection> selections = ((TextParagraphElementBase)((Object)this.mCurrentNode)).getTextSelections();
                        if (selections != null) {
                            for (TextSelection s : selections) {
                                OdfStylableElement selectionElement = (OdfStylableElement)s.getSelectionElement();
                                Map<String, Object> hardFormatting = this.mJsonOperationProducer.getHardStyles(selectionElement);
                                String styleId = null;
                                OdfStyle templateStyle = selectionElement.getDocumentStyle();
                                if (templateStyle != null) {
                                    styleId = templateStyle.getStyleNameAttribute();
                                }
                                if (s.hasUrl() || styleId != null) {
                                    try {
                                        if (hardFormatting == null && hardFormatting == null) {
                                            hardFormatting = new HashMap<String, Object>();
                                        }
                                        if (s.hasUrl()) {
                                            JSONObject charProps;
                                            if (!hardFormatting.containsKey("character")) {
                                                charProps = new JSONObject();
                                                hardFormatting.put("character", charProps);
                                            } else {
                                                charProps = (JSONObject)hardFormatting.get("character");
                                            }
                                            charProps.put("url", (Object)s.getURL());
                                        }
                                        if (styleId != null && !styleId.isEmpty()) {
                                            hardFormatting.put("styleId", styleId);
                                        } else if (this.mHasHyperlinkTemplateStyle) {
                                            hardFormatting.put("styleId", HYERLINK_DEFAULT_STYLE);
                                        }
                                    }
                                    catch (JSONException ex) {
                                        Logger.getLogger(ChangesFileSaxHandler.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                                if (hardFormatting == null) continue;
                                this.cacheOperation(false, "Attributes", s.getStartPosition(), false, hardFormatting, s.getEndPosition(), this.mContextName);
                            }
                        }
                        if (this.mWhitespaceStatusStack.size() > 0) {
                            this.mWhitespaceStatusStack.removeLast();
                        }
                    }
                    if (localName.equals("annotation") && !((CommentComponent)(commProps = (CommentComponent)this.mComponentStack.pop())).isInHeaderFooter()) {
                        Object id = COMMENT_PREFIX;
                        id = (String)id + ((CommentComponent)commProps).getCommentName();
                        this.cacheOperation(false, "Comment", ((CommentComponent)commProps).getComponentPosition(), false, null, id, ((CommentComponent)commProps).getAuthor(), ((CommentComponent)commProps).getDate(), this.mContextName);
                        int parentPosSize = ((CommentComponent)commProps).getComponentPosition().size();
                        for (CachedOperation op : commProps) {
                            CachedOperation newOp = op.clone();
                            for (int r = 0; r < parentPosSize; ++r) {
                                newOp.mStart.remove(0);
                            }
                            ArrayList<Object> componentProperties = new ArrayList<Object>();
                            for (int propIndex = 0; newOp.mComponentProperties.length > propIndex && newOp.mComponentProperties[propIndex] != null; ++propIndex) {
                                if (propIndex == 0 && newOp.mComponentType.equals("Attributes")) {
                                    List endArray = (List)newOp.mComponentProperties[propIndex];
                                    for (int r = 0; r < parentPosSize; ++r) {
                                        endArray.remove(0);
                                    }
                                    componentProperties.add(endArray);
                                    continue;
                                }
                                if (this.mContextName != null && newOp.mComponentProperties[propIndex].equals(this.mContextName)) continue;
                                componentProperties.add(newOp.mComponentProperties[propIndex]);
                            }
                            componentProperties.add(id);
                            componentProperties.add(null);
                            this.cacheOperation(false, newOp.mComponentType, newOp.mStart, true, newOp.mHardFormattingProperties, componentProperties.toArray());
                        }
                    }
                    if (this.mCurrentComponent.hasRepeated()) {
                        boolean isCell = localName.equals("table-cell");
                        boolean isRow = localName.equals("table-row");
                        if (isRow || isCell) {
                            CachedTable currentTable = (CachedTable)this.mComponentStack.peek();
                            int opSize = currentTable.size();
                            int pos = 0;
                            for (pos = opSize - 1; pos >= 0; --pos) {
                                CachedOperation op = (CachedOperation)currentTable.get(pos);
                                if (op.mComponentType.equals(isRow ? "Rows" : "Cells")) break;
                            }
                            if (pos > 0) {
                                CachedOperation cellInsertOp = (CachedOperation)currentTable.get(pos);
                                int incrementPos = cellInsertOp.mStart.size() - 1;
                                int repetition = (Integer)cellInsertOp.mComponentProperties[isRow ? 0 : 1];
                                for (int rep = 0; rep < repetition - 1; ++rep) {
                                    for (int opPos = pos; opPos < opSize; ++opPos) {
                                        CachedOperation newOp = ((CachedOperation)currentTable.get(opPos)).clone();
                                        if (newOp.mStart != null) {
                                            int oldIndex = newOp.mStart.get(incrementPos);
                                            newOp.mStart.set(incrementPos, oldIndex + rep + 1);
                                        }
                                        this.cacheOperation(false, newOp.mComponentType, newOp.mStart, false, newOp.mHardFormattingProperties, newOp.mComponentProperties);
                                    }
                                }
                            }
                        }
                        this.mLastComponentPositions.set(this.mComponentDepth, this.mLastComponentPositions.get(this.mComponentDepth) + this.mCurrentComponent.repetition() - 1);
                    }
                    --this.mComponentDepth;
                    this.mCurrentComponent = this.mCurrentComponent.getParent();
                }
            } else if (Component.isTextSelection(this.mCurrentNode)) {
                TextSelection textSelection = this.mTextSelectionStack.pollLast();
                if (textSelection != null) {
                    textSelection.setEndPosition(this.getTextPosition());
                    OdfElement root = ((OdfElement)((Object)this.mCurrentNode)).getComponentRoot();
                    if (Component.isTextComponentRoot((Node)((Object)root))) {
                        this.mCurrentNode = ((TextContainingElement)root).appendTextSelection(textSelection);
                        selectionNormalization = true;
                    }
                }
            } else if (uri.equals(OdfDocumentNamespace.TEXT.getUri()) && localName.equals("list-item")) {
                this.mListStyleStack.getLast().overrideListStyle(null);
            } else if (uri.equals(OdfDocumentNamespace.TEXT.getUri()) && localName.equals("list")) {
                this.mListStyleStack.removeLast();
            } else if (localName.equals("creator")) {
                CachedComponent cachedComponent = commProps = this.mComponentStack.isEmpty() ? null : this.mComponentStack.peek();
                if (commProps != null && commProps instanceof CommentComponent) {
                    ((CommentComponent)commProps).setAuthor(this.mCurrentNode.getTextContent());
                }
            } else if (localName.equals("date")) {
                CachedComponent cachedComponent = commProps = this.mComponentStack.isEmpty() ? null : this.mComponentStack.peek();
                if (commProps != null && commProps instanceof CommentComponent) {
                    ((CommentComponent)commProps).setDate(this.mCurrentNode.getTextContent());
                }
            }
        }
        if (this.mCurrentNode != null && !selectionNormalization) {
            this.mCurrentNode = this.mCurrentNode.getParentNode();
        }
    }

    private void addAttributes(Element element, Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            OdfAttribute attr;
            String attrURL = attributes.getURI(i);
            String attrQname = attributes.getQName(i);
            if (attrURL.equals("") || attrQname.equals("")) {
                attr = this.mFileDom.createAttribute(attributes.getLocalName(i));
            } else {
                if (attrQname.startsWith("xmlns:")) {
                    OdfNamespace namespace = this.mFileDom.setNamespace(attributes.getLocalName(i), attributes.getValue(i));
                    Object root = this.mFileDom.getRootElement();
                    if (root == null) {
                        root = element;
                    }
                    root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + namespace.getPrefix(), namespace.getUri());
                }
                attr = this.mFileDom.createAttributeNS(attrURL, attrQname);
            }
            if (attr == null) continue;
            element.setAttributeNodeNS((Attr)((Object)attr));
            try {
                attr.setValue(attributes.getValue(i));
                continue;
            }
            catch (IllegalArgumentException e) {
                ErrorHandler errorHandler = this.mFileDom.getDocument().getPackage().getErrorHandler();
                if (errorHandler != null) {
                    try {
                        errorHandler.error(new OdfValidationException((ValidationConstraint)OdfSchemaConstraint.DOCUMENT_XML_INVALID_ATTRIBUTE_VALUE, attr.getValue(), attr.getPrefix() + ":" + attr.getLocalName()));
                    }
                    catch (SAXException ex) {
                        Logger.getLogger(StyleStyleElement.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    LOG.severe("ERROR / EXCEPTION DURING XML PARSING: INVALID ATTRIBUTE: '" + attr.getPrefix() + ":" + attr.getLocalName() + "' with value '" + attr.getValue() + "'!");
                }
                element.removeAttributeNode((Attr)((Object)attr));
            }
        }
    }

    private void flushTextAtStart(String uri, String localName, String qName) {
        this.flushText(uri, localName, qName, false);
    }

    private void flushTextAtEnd(String uri, String localName, String qName) {
        this.flushText(uri, localName, qName, true);
    }

    private void flushText(String uri, String localName, String qName, boolean isEndOfElement) {
        if (this.mCharsForElement.length() > 0) {
            String newString = this.mCharsForElement.toString();
            this.mCharsForElement.setLength(0);
            Text text = this.mFileDom.createTextNode(newString);
            if (isEndOfElement && Component.isField(uri, localName)) {
                TextSelection textSelection = this.mTextSelectionStack.pollLast();
                if (!this.isBlockedSubTree()) {
                    TextFieldSelection textFieldSelection = (TextFieldSelection)textSelection;
                    String replacementText = textFieldSelection.getReplacementText();
                    Map<String, Object> attrMap = textFieldSelection.getAttributes();
                    this.cacheOperation(false, "Field", textSelection.getStartPosition(), false, null, localName, replacementText != null ? replacementText : newString, attrMap, this.mContextName);
                }
                this.mCurrentNode.appendChild(text);
            } else if (this.mCurrentNode instanceof OdfElement) {
                if ((Component.isTextComponentRoot(this.mCurrentNode) || Component.isTextComponentRoot((Node)((Object)((OdfElement)((Object)this.mCurrentNode)).getComponentRoot()))) && !this.isBlockedSubTree() && this.mWhitespaceStatusStack.size() > 0 && !(this.mCurrentNode instanceof TextNoteCitationElement)) {
                    ++this.mComponentDepth;
                    if (this.mIsCharsBeginning) {
                        this.mCharsStartPosition = this.updateTextPosition();
                        this.mIsCharsBeginning = false;
                    }
                    --this.mComponentDepth;
                    this.addText(newString);
                }
                if (ChangesFileSaxHandler.isSpaceElement(this.mCurrentNode)) {
                    this.mCurrentNode.getParentNode().appendChild(text);
                } else {
                    this.mCurrentNode.appendChild(text);
                }
            }
        } else if (isEndOfElement && Component.isField(uri, localName)) {
            TextSelection textSelection = this.mTextSelectionStack.pollLast();
            if (!this.isBlockedSubTree()) {
                TextFieldSelection textFieldSelection = (TextFieldSelection)textSelection;
                String replacementText = textFieldSelection.getReplacementText();
                Map<String, Object> attrMap = textFieldSelection.getAttributes();
                if (replacementText == null) {
                    replacementText = new String();
                }
                this.cacheOperation(false, "Field", textSelection.getStartPosition(), false, null, localName, replacementText, attrMap, this.mContextName);
            }
        }
        if (this.mCharsForOperation.length() > 0 && Component.isComponentRoot(uri, localName) && !ChangesFileSaxHandler.isSpaceElement(uri, localName)) {
            this.addText(this.mCharsForOperation);
        }
    }

    private void addText(CharSequence newText) {
        this.cacheOperation(false, "Text", this.mCharsStartPosition, false, null, newText.toString(), this.mContextName);
        this.mCharsForOperation.setLength(0);
        this.mIsCharsBeginning = true;
    }

    static boolean isSpaceElement(Node node) {
        return node instanceof TextSElement;
    }

    static boolean isSpaceElement(String uri, String localName) {
        return uri != null && uri.equals(TextSElement.ELEMENT_NAME.getUri()) && localName.equals(TextSElement.ELEMENT_NAME.getLocalName());
    }

    @Override
    public void characters(char[] ch, int startPosition, int length) {
        if (this.mCurrentComponent instanceof TextContainer) {
            WhitespaceStatus currentWhiteSpaceStatus = this.mWhitespaceStatusStack.getLast();
            int endPosition = startPosition;
            int lastPos = startPosition + length;
            boolean previousContentWritten = false;
            for (int i = startPosition; i < lastPos; ++i) {
                char c = ch[i];
                if (currentWhiteSpaceStatus.hasOnlyWhiteSpace()) {
                    if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                        ++startPosition;
                        ++endPosition;
                        continue;
                    }
                    currentWhiteSpaceStatus.setOnlyWhiteSpace(false);
                    ++endPosition;
                    continue;
                }
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                    if (currentWhiteSpaceStatus.hasSpaceBefore()) {
                        if (!previousContentWritten) {
                            if (endPosition - startPosition > 0) {
                                this.mCharsForElement.append(ch, startPosition, endPosition - startPosition);
                            }
                            previousContentWritten = true;
                        }
                        startPosition = ++endPosition;
                        continue;
                    }
                    currentWhiteSpaceStatus.setFirstSpaceCharPosition(i);
                    ch[i] = 32;
                    ++endPosition;
                    continue;
                }
                if (currentWhiteSpaceStatus.hasSpaceBefore()) {
                    currentWhiteSpaceStatus.setFirstSpaceCharPosition(-1);
                }
                ++endPosition;
            }
            if (endPosition - startPosition > 0) {
                this.mCharsForElement.append(ch, startPosition, endPosition - startPosition);
            }
        } else {
            this.mCharsForElement.append(ch, startPosition, length);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return super.resolveEntity(publicId, systemId);
    }

    private List<Integer> updateComponentPosition() {
        List<Integer> pos = this.updatePosition(true);
        return pos;
    }

    private List<Integer> updateTextPosition() {
        return this.updatePosition(false);
    }

    private List<Integer> updatePosition(boolean isComponent) {
        if (this.mComponentDepth == this.mLastComponentPositions.size()) {
            this.mLastComponentPositions.add(this.mComponentDepth, 0);
        } else if (this.mComponentDepth == this.mLastComponentPositions.size() - 1) {
            int positionUpdate = this.mCurrentComponent instanceof TextContainer ? this.mCurrentComponent.size() : (this.mCurrentComponent instanceof Cell ? this.mLastComponentPositions.get(this.mComponentDepth) + 1 : (this.mCurrentComponent.getRootElement() instanceof OfficeAnnotationEndElement ? this.mCurrentComponent.getParent().size() : this.mLastComponentPositions.get(this.mComponentDepth) + 1));
            this.mLastComponentPositions.set(this.mComponentDepth, positionUpdate);
        } else if (this.mComponentDepth < this.mLastComponentPositions.size() - 1) {
            this.mLastComponentPositions.removeLast();
            this.updatePosition(isComponent);
        } else {
            LOG.warning("Houston, we have a problem..");
        }
        return new LinkedList<Integer>(this.mLastComponentPositions);
    }

    private List<Integer> getTextPosition() {
        ++this.mComponentDepth;
        List<Integer> position = this.updateTextPosition();
        --this.mComponentDepth;
        return position;
    }

    public void cacheOperation(boolean fillCacheOnly, String componentType, List<Integer> start, boolean absolutePosition, Map<String, Object> hardFormattingProperties, Object ... componentProperties) {
        if (this.mComponentStack.empty()) {
            if (componentType.equals("Text")) {
                String text = (String)componentProperties[0];
                String context = (String)componentProperties[1];
                this.mJsonOperationProducer.addText(start, text, context);
            } else if (componentType.equals("Paragraph")) {
                String context = (String)componentProperties[0];
                this.mJsonOperationProducer.add(componentType, start, hardFormattingProperties, context);
            } else if (componentType.equals("Table")) {
                List tableGrid = (List)componentProperties[0];
                String tableName = (String)componentProperties[1];
                String context = (String)componentProperties[2];
                this.mJsonOperationProducer.addTable(start, hardFormattingProperties, tableGrid, tableName, context);
            } else if (componentType.equals("ExceededTable")) {
                int columns = (Integer)componentProperties[0];
                int rows = (Integer)componentProperties[1];
                List tableGrid = (List)componentProperties[2];
                String context = (String)componentProperties[3];
                this.mJsonOperationProducer.addExceededTable(start, columns, rows, tableGrid, context);
            } else if (componentType.equals("Attributes")) {
                List end = (List)componentProperties[0];
                String context = (String)componentProperties[1];
                this.mJsonOperationProducer.format(start, end, hardFormattingProperties, context);
            } else if (componentType.equals("FormatRows")) {
                Integer firstRow = (Integer)componentProperties[0];
                Integer lastRow = (Integer)componentProperties[1];
                String context = (String)componentProperties[3];
                Integer repeatedRowOffset = (Integer)componentProperties[2];
                this.mJsonOperationProducer.formatRows(start, hardFormattingProperties, firstRow, lastRow, repeatedRowOffset, context);
            } else if (componentType.equals("FormatColumns")) {
                Integer firstColumn = (Integer)componentProperties[0];
                Integer lastColumn = (Integer)componentProperties[1];
                String context = (String)componentProperties[2];
                this.mJsonOperationProducer.formatColumns(start, hardFormattingProperties, firstColumn, lastColumn, context);
            } else if (componentType.equals("Shape") || componentType.equals("Group")) {
                String context = (String)componentProperties[0];
                this.mJsonOperationProducer.addShape(start, hardFormattingProperties, context, componentType.equals("Group"));
            } else if (componentType.equals("Image")) {
                String context = (String)componentProperties[0];
                this.mJsonOperationProducer.addImage(start, hardFormattingProperties, context);
            } else if (componentType.equals("Field")) {
                String fieldType = (String)componentProperties[0];
                String fieldContent = (String)componentProperties[1];
                Map fieldAttributes = (Map)componentProperties[2];
                String context = (String)componentProperties[3];
                this.mJsonOperationProducer.addField(start, fieldType, fieldContent, fieldAttributes, context);
            } else if (componentType.equals("Comment")) {
                String id = (String)componentProperties[0];
                String author = (String)componentProperties[1];
                String date = (String)componentProperties[2];
                String target = (String)componentProperties[3];
                this.mJsonOperationProducer.addAnnotation(start, id, author, date, target);
            } else if (componentType.equals("CommentRange")) {
                String id = (String)componentProperties[0];
                String target = (String)componentProperties[1];
                this.mJsonOperationProducer.addRange(start, id, target);
            } else if (componentType.equals("Tab")) {
                String target = (String)componentProperties[0];
                this.mJsonOperationProducer.add(componentType, start, hardFormattingProperties, target != null ? target : this.mContextName);
            } else {
                String target = (String)componentProperties[0];
                this.mJsonOperationProducer.add(componentType, start, hardFormattingProperties, target != null ? target : this.mContextName);
            }
        } else {
            CachedComponent topComponent = this.mComponentStack.peek();
            if (!fillCacheOnly && topComponent instanceof CachedTable) {
                this.cacheTableOperation(componentType, start, hardFormattingProperties, componentProperties);
            } else {
                LinkedList<Integer> position = null;
                if (start != null) {
                    position = new LinkedList<Integer>(start);
                }
                topComponent.add(new CachedOperation(componentType, position, absolutePosition, hardFormattingProperties, componentProperties));
            }
        }
    }

    private void cacheTableOperation(String componentType, List<Integer> start, Map<String, Object> hardFormattingProperties, Object ... componentProperties) {
        CachedTable currentTable;
        LinkedList<Integer> position = null;
        CachedTable cachedTable = this.mComponentStack.empty() ? null : (currentTable = this.mComponentStack.peek() instanceof CachedTable ? (CachedTable)this.mComponentStack.peek() : null);
        if (start != null) {
            position = new LinkedList<Integer>(start);
        }
        if (componentType.equals("Cells")) {
            ++currentTable.mCellCount;
            if (this.mMaxAllowedCellCount != 0 && currentTable.mCellCount > this.mMaxAllowedCellCount) {
                currentTable.mIsTooLarge = true;
            }
        } else if (componentType.equals("Rows")) {
            ++currentTable.mRowCount;
            if (this.mMaxAllowedRowCount != 0 && currentTable.mRowCount > this.mMaxAllowedRowCount) {
                currentTable.mIsTooLarge = true;
            }
        } else if (componentType.equals("Table")) {
            List tableGrid = (List)componentProperties[0];
            CachedTable newCachedTable = this.startTableSizeEvaluation(position, tableGrid);
            if (newCachedTable.mTableGrid != null) {
                if (this.mMaxAllowedColumnCount != 0 && newCachedTable.mTableGrid.size() > this.mMaxAllowedColumnCount) {
                    newCachedTable.mIsTooLarge = true;
                } else {
                    newCachedTable.mColumnCount = newCachedTable.mTableGrid.size();
                }
            }
            if (currentTable == null) {
                currentTable = newCachedTable;
                this.mComponentStack.push(currentTable);
                currentTable.add(new CachedInnerTableOperation(componentType, position, false, hardFormattingProperties, componentProperties));
            } else {
                currentTable.addSubTable(newCachedTable, start);
                currentTable.add(new CachedInnerTableOperation(componentType, position, false, hardFormattingProperties, componentProperties));
                currentTable = newCachedTable;
                currentTable.add(new CachedInnerTableOperation(componentType, position, false, hardFormattingProperties, componentProperties));
            }
        }
        if (!(currentTable.mIsTooLarge || componentType.equals("Table") || componentType.equals("Columns"))) {
            currentTable.add(new CachedInnerTableOperation(componentType, position, false, hardFormattingProperties, componentProperties));
        }
    }

    private CachedTable startTableSizeEvaluation(List<Integer> position, List<Integer> tableGrid) {
        CachedTable cachedTable = null;
        cachedTable = new CachedTable();
        cachedTable.mTableGrid = tableGrid;
        return cachedTable;
    }

    private void endTableSizeEvaluation() throws SAXException {
        CachedTable cachedTableOps = (CachedTable)this.mComponentStack.peek();
        if (cachedTableOps.getSubTableCount() == 0) {
            cachedTableOps.mMostUsedColumnStyle = ChangesFileSaxHandler.getMostUsedStyle(cachedTableOps.columnStyleOccurrence);
            cachedTableOps.mMostUsedRowStyle = ChangesFileSaxHandler.getMostUsedStyle(cachedTableOps.rowStyleOccurrence);
            this.mComponentStack.pop();
            this.flushTableOperations(cachedTableOps, true);
            if (cachedTableOps != null && cachedTableOps.mCachedTableContentOps != null) {
                cachedTableOps.mCachedTableContentOps = null;
                cachedTableOps.lastRowFormatOperation = null;
            }
        } else if (cachedTableOps.getSubTableCount() > 0) {
            cachedTableOps.removeSubTable();
        } else {
            if (cachedTableOps != null && cachedTableOps.mCachedTableContentOps != null) {
                cachedTableOps.mCachedTableContentOps = null;
                cachedTableOps.lastRowFormatOperation = null;
            }
            this.mComponentStack.pop();
        }
    }

    private void flushTableOperations(CachedTable currentTable, boolean isStartOfTable) throws SAXException {
        boolean putPageBreak = false;
        boolean isBreakBefore = true;
        ListIterator cachedOperationIterator = currentTable.listIterator();
        while (cachedOperationIterator.hasNext()) {
            CachedOperation operation = (CachedOperation)cachedOperationIterator.next();
            if (operation instanceof CachedInnerTableOperation && operation.mComponentType.equals("Table")) {
                if (isStartOfTable) {
                    isStartOfTable = false;
                    if (currentTable.mIsTooLarge) {
                        this.cacheOperation(false, "ExceededTable", operation.mStart, false, null, ((List)operation.mComponentProperties[0]).size(), currentTable.mRowCount, operation.mComponentProperties[0], this.mContextName);
                        break;
                    }
                    if (this.mMaxAllowedRowCount != 0 && currentTable.mRowCount > this.mMaxAllowedRowCount || this.mMaxAllowedColumnCount != 0 && currentTable.mColumnCount > this.mMaxAllowedColumnCount || this.mMaxAllowedCellCount != 0 && currentTable.mCellCount > this.mMaxAllowedCellCount) {
                        this.cacheOperation(false, "ExceededTable", operation.mStart, false, null, ((List)operation.mComponentProperties[0]).size(), currentTable.mRowCount, operation.mComponentProperties[0], this.mContextName);
                        break;
                    }
                    JSONObject tableAttr = null;
                    if (operation.mHardFormattingProperties.containsKey("table") && ((tableAttr = (JSONObject)operation.mHardFormattingProperties.get("table")).has("pageBreakBefore") || tableAttr.has("pageBreakAfter"))) {
                        isBreakBefore = tableAttr.has("pageBreakBefore");
                        String breakString = isBreakBefore ? "pageBreakBefore" : "pageBreakAfter";
                        boolean breakAttr = tableAttr.getBoolean(breakString);
                        if (breakAttr) {
                            putPageBreak = true;
                        }
                        tableAttr.remove(breakString);
                    }
                    this.cacheOperation(false, "Table", operation.mStart, false, operation.mHardFormattingProperties, operation.mComponentProperties[0], operation.mComponentProperties[1], this.mContextName);
                    continue;
                }
                this.flushTableOperations(currentTable.getSubTable(operation.mStart), true);
                continue;
            }
            if (operation.mComponentType.equals("Text")) {
                String context = this.mContextName;
                if (operation.mComponentProperties.length > 1 && operation.mComponentProperties[1] != null) {
                    context = (String)operation.mComponentProperties[1];
                }
                this.cacheOperation(false, operation.mComponentType, operation.mStart, false, null, operation.mComponentProperties[0], context);
                continue;
            }
            if (operation.mComponentType.equals("Attributes")) {
                String context = this.mContextName;
                if (operation.mComponentProperties.length > 1 && operation.mComponentProperties[1] != null) {
                    context = (String)operation.mComponentProperties[1];
                }
                this.cacheOperation(false, "Attributes", operation.mStart, false, operation.mHardFormattingProperties, operation.mComponentProperties[0], context);
                continue;
            }
            if (operation.mComponentType.equals("Shape") || operation.mComponentType.equals("Image") || operation.mComponentType.equals("Group")) {
                this.cacheOperation(false, operation.mComponentType, operation.mStart, false, operation.mHardFormattingProperties, this.mContextName);
                continue;
            }
            if (operation.mComponentType.equals("Field")) {
                Map attrMap = (Map)operation.mComponentProperties[2];
                this.cacheOperation(false, operation.mComponentType, operation.mStart, false, null, operation.mComponentProperties[0], operation.mComponentProperties[1], attrMap, this.mContextName);
                continue;
            }
            if (operation.mComponentType.equals("Table") || operation.mComponentType.equals("Comment") || operation.mComponentType.equals("CommentRange")) {
                this.cacheOperation(false, operation.mComponentType, operation.mStart, false, operation.mHardFormattingProperties, operation.mComponentProperties);
                continue;
            }
            if (operation.mComponentType.equals("Comment") || operation.mComponentType.equals("CommentRange")) {
                this.cacheOperation(false, operation.mComponentType, operation.mStart, false, operation.mHardFormattingProperties, operation.mComponentProperties);
                continue;
            }
            boolean isParagraphOperation = operation.mComponentType.equals("Paragraph");
            if (putPageBreak && isParagraphOperation) {
                JSONObject paraProps = null;
                if (operation.mHardFormattingProperties == null) {
                    operation.mHardFormattingProperties = new HashMap<String, Object>();
                }
                paraProps = !operation.mHardFormattingProperties.containsKey("paragraph") ? new JSONObject() : (JSONObject)operation.mHardFormattingProperties.get("paragraph");
                paraProps.put(isBreakBefore ? "pageBreakBefore" : "pageBreakAfter", true);
                operation.mHardFormattingProperties.put("paragraph", paraProps);
                putPageBreak = false;
            }
            String context = this.mContextName;
            if (isParagraphOperation && operation.mComponentProperties[0] != null) {
                context = (String)operation.mComponentProperties[0];
            }
            this.cacheOperation(false, operation.mComponentType, operation.mStart, false, operation.mHardFormattingProperties, context);
        }
    }

    private static String getMostUsedStyle(Map<String, Integer> styleOccurrances) {
        String mostUsedStyleName = null;
        if (styleOccurrances != null) {
            Set<Map.Entry<String, Integer>> entrySet = styleOccurrances.entrySet();
            Iterator<Map.Entry<String, Integer>> iter = entrySet.iterator();
            Integer styleOccurance = null;
            Integer styleOccuranceMax = null;
            while (iter.hasNext()) {
                Map.Entry<String, Integer> entry = iter.next();
                styleOccurance = entry.getValue();
                if (styleOccuranceMax != null && styleOccuranceMax >= styleOccurance) continue;
                styleOccuranceMax = styleOccurance;
                mostUsedStyleName = entry.getKey();
            }
            if (mostUsedStyleName != null && styleOccurrances.get(mostUsedStyleName) == 1) {
                mostUsedStyleName = null;
            }
        }
        return mostUsedStyleName;
    }

    private JSONObject getHeaderFooterAttrs(OdfElement e) {
        Element p;
        JSONObject attrs = null;
        JSONObject pageAttrs = null;
        if (e != null && (p = e.getChildElement(StyleHeaderFooterPropertiesElement.ELEMENT_NAME.getUri(), "header-footer-properties")) != null) {
            String sMarginRight;
            String sMarginLeft;
            String sMarginBottom;
            String sMarginTop;
            String sHeight;
            pageAttrs = new JSONObject((Object)3);
            String sMinHeight = p.getAttribute("fo:min-height");
            if (!sMinHeight.isEmpty()) {
                pageAttrs.put("minHeight", MapHelper.normalizeLength(sMinHeight));
            }
            if (!(sHeight = p.getAttribute("svg:height")).isEmpty()) {
                pageAttrs.put("height", MapHelper.normalizeLength(sHeight));
            }
            if (!(sMarginTop = p.getAttribute("fo:margin-top")).isEmpty()) {
                pageAttrs.put("marginTop", MapHelper.normalizeLength(sMarginTop));
            }
            if (!(sMarginBottom = p.getAttribute("fo:margin-bottom")).isEmpty()) {
                pageAttrs.put("marginBottom", MapHelper.normalizeLength(sMarginBottom));
            }
            if (!(sMarginLeft = p.getAttribute("fo:margin-left")).isEmpty()) {
                pageAttrs.put("marginLeft", MapHelper.normalizeLength(sMarginLeft));
            }
            if (!(sMarginRight = p.getAttribute("fo:margin-right")).isEmpty()) {
                pageAttrs.put("marginRight", MapHelper.normalizeLength(sMarginRight));
            }
        }
        if (pageAttrs != null && pageAttrs.length() != 0) {
            attrs = new JSONObject((Object)1);
            attrs.put("page", (Object)pageAttrs);
        }
        return attrs;
    }

    class ContinuedList {
        private String mListId;
        private List<String> mSortedIds = null;

        public ContinuedList(String precedingListId, String currentListId) {
            if (precedingListId != null && !precedingListId.isEmpty()) {
                this.mListId = precedingListId;
            } else if (currentListId != null && !currentListId.isEmpty()) {
                this.mListId = currentListId;
            }
            this.mSortedIds = new LinkedList<String>();
        }

        public void add(String listId) {
            this.mSortedIds.add(listId);
        }

        public List<String> getListIds() {
            return this.mSortedIds;
        }

        public String getListId() {
            return this.mListId;
        }
    }

    class WhitespaceStatus {
        int mDepth = -1;
        boolean mOnlyWhiteSpaceSoFar = true;
        int mFirstSpaceCharPosition = -1;

        WhitespaceStatus(boolean isParagraphIgnored, int depth) {
            this.mDepth = depth;
        }

        public int getParagraphDepth() {
            return this.mDepth;
        }

        public boolean hasOnlyWhiteSpace() {
            return this.mOnlyWhiteSpaceSoFar;
        }

        public void setOnlyWhiteSpace(boolean onlyWhiteSpace) {
            this.mOnlyWhiteSpaceSoFar = onlyWhiteSpace;
        }

        public int getFirstSpaceCharPosition() {
            return this.mFirstSpaceCharPosition;
        }

        public void setFirstSpaceCharPosition(int currentSpaceCharPosition) {
            this.mFirstSpaceCharPosition = currentSpaceCharPosition;
        }

        public boolean hasSpaceBefore() {
            return this.mFirstSpaceCharPosition > -1;
        }
    }
}

