/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.changes;

import java.io.IOException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.odftoolkit.odfdom.changes.Component;
import org.odftoolkit.odfdom.changes.JsonOperationProducer;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeValueTypeAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.number.DataStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTabStopElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTabStopsElement;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfStylesBase;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfNamespace;
import org.odftoolkit.odfdom.type.Length;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MapHelper {
    public static final String AUTO = "auto";
    public static final String NORMAL = "normal";
    public static final String BOLD = "bold";
    public static final String THIN = "thin";
    public static final String MEDIUM = "medium";
    public static final String THICK = "thick";
    public static final String HASH = "#";
    public static final String TRANSPARENT = "transparent";
    private static final String PERCENT = "%";
    private static final Logger LOG = Logger.getLogger(JsonOperationProducer.class.getName());
    private static Map<Integer, String> languageToLocaleMap = null;
    private static Map<String, Integer> localeToLanguageMap = null;
    private static final Map<String, String> COLOR_MAP_AUTO = MapHelper.createColorMap("auto");

    public static JSONObject createBorderMap(String borderValue) {
        JSONObject border = new JSONObject();
        try {
            if (borderValue.equals("none")) {
                border.put("style", (Object)"none");
            } else {
                String[] tokens = borderValue.split("\\s+");
                boolean checkedColor = false;
                boolean checkedStyle = false;
                boolean checkedWidth = false;
                for (int i = 0; i < tokens.length; ++i) {
                    String token = tokens[i];
                    if (token.isEmpty()) continue;
                    boolean isTokenTaken = false;
                    if (!checkedColor && MapHelper.isColor(token)) {
                        isTokenTaken = checkedColor = MapHelper.mapColor(border, token);
                    }
                    if (!isTokenTaken && !checkedStyle) {
                        isTokenTaken = checkedStyle = MapHelper.mapStyle(border, token);
                    }
                    if (isTokenTaken || checkedWidth) continue;
                    checkedWidth = MapHelper.mapWidth(border, token, tokens);
                }
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return border;
    }

    public static boolean isColor(String color) {
        return color.startsWith(HASH) || color.equals(TRANSPARENT);
    }

    public static boolean mapColor(JSONObject border, String width) {
        boolean isColor = false;
        try {
            border.put("color", MapHelper.createColorMap(width));
        }
        catch (JSONException ex) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
        }
        isColor = true;
        return isColor;
    }

    public static boolean mapStyle(JSONObject border, String style) throws JSONException {
        boolean isStyle = false;
        if (style.equals("solid") || style.equals("groove") || style.equals("ridge")) {
            style = "single";
            border.put("style", (Object)style);
            isStyle = true;
        } else if (style.equals("hidden")) {
            style = "none";
            border.put("style", (Object)style);
            isStyle = true;
        } else if (style.equals("double") || style.equals("dotted") || style.equals("dashed") || style.equals("outset") || style.equals("inset")) {
            border.put("style", (Object)style);
            isStyle = true;
        } else if (style.contains("-dash")) {
            border.put("style", (Object)"dashed");
            isStyle = true;
        } else if (style.contains("-dot")) {
            border.put("style", (Object)"dotted");
            isStyle = true;
        } else if (style.contains("double")) {
            border.put("style", (Object)"double");
            isStyle = true;
        }
        return isStyle;
    }

    public static Map<String, String> createColorMap(String rgbValue) {
        HashMap<String, String> color = new HashMap<String, String>();
        if (rgbValue.contains(HASH)) {
            color.put("type", "rgb");
            rgbValue = rgbValue.subSequence(rgbValue.indexOf(35) + 1, rgbValue.length()).toString();
            color.put("value", rgbValue);
        } else if (rgbValue.equals(TRANSPARENT) || rgbValue.equals(AUTO)) {
            color.put("type", AUTO);
        }
        return Collections.unmodifiableMap(color);
    }

    public static boolean mapWidth(JSONObject border, String widthString, String[] tokens) {
        boolean isWidth;
        block2: {
            isWidth = false;
            try {
                int width = widthString.equals(AUTO) ? 26 : (widthString.equals(NORMAL) ? 27 : (widthString.equals(BOLD) ? 54 : (widthString.equals(THIN) ? 26 : (widthString.equals(MEDIUM) ? 53 : (widthString.equals(THICK) ? 79 : MapHelper.normalizeLength(widthString))))));
                border.put("width", width);
                isWidth = true;
            }
            catch (Throwable t) {
                if (tokens.length != 3) break block2;
                throw new RuntimeException(t);
            }
        }
        return isWidth;
    }

    public static int normalizeLength(String value) {
        Length length = new Length(value);
        return (int)Math.round(length.getMicrometer() / 10.0);
    }

    public static JSONObject mapProperties(String styleFamilyGroup, Map<String, String> odfProps) {
        JSONObject newProps = null;
        JSONObject shapeProps = null;
        JSONObject imageProps = null;
        JSONObject lineProps = null;
        JSONObject fillProps = null;
        if (odfProps != null) {
            Object propValue;
            newProps = new JSONObject();
            if (styleFamilyGroup.equals("character")) {
                boolean borderToBeDone = true;
                boolean paddingToBeDone = true;
                boolean marginToBeDone = true;
                for (String propName : odfProps.keySet()) {
                    try {
                        Map<String, String> color;
                        Double fontSize;
                        Length length;
                        if (propName.contains("margin")) {
                            if (marginToBeDone) {
                                MapHelper.mapMargin(newProps, odfProps);
                                marginToBeDone = false;
                            }
                        } else if (propName.contains("padding")) {
                            if (paddingToBeDone) {
                                MapHelper.mapPadding(newProps, odfProps);
                                paddingToBeDone = false;
                            }
                        } else if (propName.contains("border")) {
                            if (borderToBeDone) {
                                MapHelper.mapBorder(newProps, odfProps);
                                borderToBeDone = false;
                            }
                        } else if (propName.contains("letter-spacing")) {
                            propValue = odfProps.get("fo:letter-spacing");
                            if (((String)propValue).equals(NORMAL)) {
                                newProps.put("letterSpacing", propValue);
                            } else {
                                Integer spacing = MapHelper.normalizeLength((String)propValue);
                                newProps.put("letterSpacing", (Object)spacing);
                            }
                        } else if (propName.equals("fo:font-size")) {
                            propValue = odfProps.get("fo:font-size");
                            if (((String)propValue).contains(PERCENT)) {
                                LOG.fine("fo:font-size does have a percentage value, which we do not support!");
                            } else {
                                length = new Length((String)propValue);
                                fontSize = length.getPoint();
                                newProps.put("fontSize", (Object)fontSize);
                            }
                        } else if (propName.equals("style:font-size-asian")) {
                            propValue = odfProps.get("style:font-size-asian");
                            if (((String)propValue).contains(PERCENT)) {
                                LOG.fine("style:font-size-asia does have a percentage value!");
                            } else {
                                length = new Length((String)propValue);
                                fontSize = length.getPoint();
                                newProps.put("fontSizeAsian", (Object)fontSize);
                            }
                        } else if (propName.equals("style:font-size-complex")) {
                            propValue = odfProps.get("style:font-size-complex");
                            if (((String)propValue).contains(PERCENT)) {
                                LOG.fine("style:font-size-complex does have a percentage value!");
                            } else {
                                length = new Length((String)propValue);
                                fontSize = length.getPoint();
                                newProps.put("fontSizeAsian", (Object)fontSize);
                            }
                        } else if (propName.equals("style:font-name")) {
                            propValue = odfProps.get("style:font-name");
                            newProps.put("fontName", propValue);
                        } else if (propName.equals("style:font-name-asian")) {
                            propValue = odfProps.get("style:font-name-asian");
                            newProps.put("fontNameAsian", propValue);
                        } else if (propName.equals("style:font-name-complex")) {
                            propValue = odfProps.get("style:font-name-complex");
                            newProps.put("fontNameComplex", propValue);
                        } else if (propName.equals("style:text-position")) {
                            propValue = odfProps.get("style:text-position");
                            if (((String)propValue).contains("sub")) {
                                propValue = "sub";
                                newProps.put("vertAlign", propValue);
                            } else if (((String)propValue).contains("super")) {
                                propValue = "super";
                                newProps.put("vertAlign", propValue);
                            } else if (((String)propValue).equals("0%") || ((String)propValue).equals("0% 100%")) {
                                propValue = "baseline";
                                newProps.put("vertAlign", propValue);
                            }
                        } else if (propName.equals("fo:language")) {
                            propValue = odfProps.get("fo:language");
                            String country = odfProps.get("fo:country");
                            if (propValue != null) {
                                if (!((String)propValue).equals("none")) {
                                    if (country != null && !country.isEmpty() && !country.equals("none")) {
                                        propValue = (String)propValue + "-" + country;
                                    }
                                    newProps.put("language", propValue);
                                } else {
                                    newProps.put("noProof", true);
                                    newProps.put("language", (Object)"none");
                                }
                            }
                        }
                        if (propName.equals("fo:font-weight")) {
                            propValue = odfProps.get("fo:font-weight");
                            if (((String)propValue).equals(NORMAL)) {
                                newProps.put(BOLD, (Object)Boolean.FALSE);
                                continue;
                            }
                            newProps.put(BOLD, (Object)Boolean.TRUE);
                            continue;
                        }
                        if (propName.equals("style:font-weight-asian")) {
                            propValue = odfProps.get("style:font-weight-asian");
                            if (((String)propValue).equals(NORMAL)) {
                                newProps.put("boldAsian", (Object)Boolean.FALSE);
                                continue;
                            }
                            newProps.put("boldAsian", (Object)Boolean.TRUE);
                            continue;
                        }
                        if (propName.equals("style:font-weight-complex")) {
                            propValue = odfProps.get("style:font-weight-complex");
                            if (((String)propValue).equals(NORMAL)) {
                                newProps.put("boldComplex", (Object)Boolean.FALSE);
                                continue;
                            }
                            newProps.put("boldComplex", (Object)Boolean.TRUE);
                            continue;
                        }
                        if (propName.equals("style:text-underline-style")) {
                            propValue = odfProps.get("style:text-underline-style");
                            if (((String)propValue).equals("none")) {
                                newProps.put("underline", (Object)Boolean.FALSE);
                                continue;
                            }
                            newProps.put("underline", (Object)Boolean.TRUE);
                            continue;
                        }
                        if (propName.equals("fo:font-style")) {
                            propValue = odfProps.get("fo:font-style");
                            if (((String)propValue).equals(NORMAL)) {
                                newProps.put("italic", (Object)Boolean.FALSE);
                                continue;
                            }
                            newProps.put("italic", (Object)Boolean.TRUE);
                            continue;
                        }
                        if (propName.equals("style:font-style-asian")) {
                            propValue = odfProps.get("style:font-style-asian");
                            if (((String)propValue).equals(NORMAL)) {
                                newProps.put("italicAsian", (Object)Boolean.FALSE);
                                continue;
                            }
                            newProps.put("italicAsian", (Object)Boolean.TRUE);
                            continue;
                        }
                        if (propName.equals("style:font-style-complex")) {
                            propValue = odfProps.get("style:font-style-complex");
                            if (((String)propValue).equals(NORMAL)) {
                                newProps.put("italicComplex", (Object)Boolean.FALSE);
                                continue;
                            }
                            newProps.put("italicComplex", (Object)Boolean.TRUE);
                            continue;
                        }
                        if (propName.equals("fo:color")) {
                            if (newProps.has("color")) continue;
                            propValue = odfProps.get("fo:color");
                            color = MapHelper.createColorMap((String)propValue);
                            newProps.put("color", color);
                            continue;
                        }
                        if (propName.equals("style:use-window-font-color")) {
                            propValue = odfProps.get("style:use-window-font-color");
                            if (!((String)propValue).equals("true")) continue;
                            newProps.put("color", COLOR_MAP_AUTO);
                            continue;
                        }
                        if (propName.equals("fo:background-color")) {
                            propValue = odfProps.get("fo:background-color");
                            color = MapHelper.createColorMap((String)propValue);
                            newProps.put("fillColor", color);
                            continue;
                        }
                        if (propName.equals("style:width")) {
                            propValue = odfProps.get("style:width");
                            if (((String)propValue).contains(PERCENT)) continue;
                            newProps.put("width", MapHelper.normalizeLength((String)propValue));
                            continue;
                        }
                        if (propName.equals("style:writing-mode")) {
                            propValue = odfProps.get("style:writing-mode");
                            newProps.put("writingMode", propValue);
                            continue;
                        }
                        if (!propName.equals("style:text-line-through-style")) continue;
                        propValue = odfProps.get("style:text-line-through-style");
                        if (((String)propValue).equals("none")) {
                            newProps.put("strike", (Object)"none");
                            continue;
                        }
                        if (odfProps.containsKey("style:text-line-through-type")) {
                            propValue = odfProps.get("style:text-line-through-type");
                            if (((String)propValue).equals("double")) {
                                newProps.put("strike", (Object)"double");
                                continue;
                            }
                            newProps.put("strike", (Object)"single");
                            continue;
                        }
                        newProps.put("strike", (Object)"single");
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            } else if (styleFamilyGroup.equals("paragraph")) {
                boolean borderToBeDone = true;
                boolean paddingToBeDone = true;
                boolean marginToBeDone = true;
                JSONArray tabs = null;
                block25: for (String propName : odfProps.keySet()) {
                    try {
                        if (propName.contains("margin")) {
                            if (!marginToBeDone) continue;
                            MapHelper.mapMargin(newProps, odfProps);
                            marginToBeDone = false;
                            continue;
                        }
                        if (propName.contains("padding")) {
                            if (!paddingToBeDone) continue;
                            MapHelper.mapPadding(newProps, odfProps);
                            paddingToBeDone = false;
                            continue;
                        }
                        if (propName.contains("border")) {
                            if (!borderToBeDone) continue;
                            MapHelper.mapBorder(newProps, odfProps);
                            borderToBeDone = false;
                            continue;
                        }
                        if (propName.equals("fo:background-color")) {
                            propValue = odfProps.get("fo:background-color");
                            Map<String, String> color = MapHelper.createColorMap((String)propValue);
                            newProps.put("fillColor", color);
                            continue;
                        }
                        if (propName.equals("fo:line-height")) {
                            String lineHeightValue = odfProps.get("fo:line-height");
                            if (lineHeightValue == null || lineHeightValue.isEmpty()) continue;
                            JSONObject lineHeight = MapHelper.createLineHeightMap(lineHeightValue);
                            newProps.put("lineHeight", (Object)lineHeight);
                            continue;
                        }
                        if (propName.equals("style:line-spacing")) {
                            String lineLeadingValue = odfProps.get("style:line-spacing");
                            if (lineLeadingValue == null || lineLeadingValue.isEmpty()) continue;
                            JSONObject lineHeightLeadingMap = new JSONObject();
                            lineHeightLeadingMap.put("type", (Object)"leading");
                            lineHeightLeadingMap.put("value", MapHelper.normalizeLength(lineLeadingValue));
                            newProps.put("lineHeight", (Object)lineHeightLeadingMap);
                            continue;
                        }
                        if (propName.equals("style:line-height-at-least")) {
                            String lineHeightAtLeastValue = odfProps.get("style:line-height-at-least");
                            if (lineHeightAtLeastValue == null || lineHeightAtLeastValue.isEmpty()) continue;
                            JSONObject lineHeightAtLeastMap = new JSONObject();
                            lineHeightAtLeastMap.put("type", (Object)"atLeast");
                            lineHeightAtLeastMap.put("value", MapHelper.normalizeLength(lineHeightAtLeastValue));
                            newProps.put("lineHeight", (Object)lineHeightAtLeastMap);
                            continue;
                        }
                        if (propName.equals("fo:text-align")) {
                            propValue = odfProps.get("fo:text-align");
                            newProps.put("alignment", (Object)MapHelper.mapFoTextAlign((String)propValue));
                            continue;
                        }
                        if (propName.equals("fo:text-indent")) {
                            propValue = odfProps.get("fo:text-indent");
                            if (((String)propValue).contains(PERCENT)) {
                                LOG.fine("WARNING: Found a 'fo:text-indent' with percentage we are not yet supporting in our API: " + (String)propValue);
                                continue;
                            }
                            newProps.put("indentFirstLine", MapHelper.normalizeLength((String)propValue));
                            continue;
                        }
                        if (propName.startsWith("tab_")) {
                            int i = 0;
                            boolean hasTabChar = false;
                            boolean hasTabPos = false;
                            boolean hasTabType = false;
                            JSONObject tab = null;
                            if (newProps.has("tabStops")) continue;
                            while (true) {
                                if (odfProps.containsKey("tab_LeaderText" + i)) {
                                    propValue = odfProps.get("tab_LeaderText" + i);
                                    if (tab == null) {
                                        tab = new JSONObject();
                                    }
                                    tab.put("fillChar", propValue);
                                    hasTabChar = true;
                                } else {
                                    hasTabChar = false;
                                }
                                if (odfProps.containsKey("tab_Pos" + i)) {
                                    propValue = odfProps.get("tab_Pos" + i);
                                    if (tab == null) {
                                        tab = new JSONObject();
                                    }
                                    tab.put("pos", Integer.parseInt((String)propValue));
                                    hasTabPos = true;
                                } else {
                                    hasTabPos = false;
                                }
                                if (odfProps.containsKey("tab_Type" + i)) {
                                    propValue = odfProps.get("tab_Type" + i);
                                    if (tab == null) {
                                        tab = new JSONObject();
                                    }
                                    if (((String)propValue).equals("left")) {
                                        propValue = null;
                                    }
                                    if (propValue != null) {
                                        tab.put("value", propValue);
                                        hasTabType = true;
                                    }
                                } else {
                                    hasTabType = false;
                                }
                                if (!(hasTabChar || hasTabType || hasTabPos)) {
                                    newProps.put("tabStops", (Object)tabs);
                                    continue block25;
                                }
                                if (tabs == null) {
                                    tabs = new JSONArray();
                                }
                                tabs.put((Object)tab);
                                hasTabType = false;
                                hasTabPos = false;
                                hasTabChar = false;
                                tab = null;
                                ++i;
                            }
                        }
                        if (propName.equals("style:tab-stop-distance")) {
                            propValue = odfProps.get("style:tab-stop-distance");
                            if (propValue == null || ((String)propValue).isEmpty()) continue;
                            JSONObject documentProps = newProps.has("document") ? newProps.getJSONObject("document") : new JSONObject();
                            documentProps.put("defaultTabStop", MapHelper.normalizeLength((String)propValue));
                            newProps.put("document", (Object)documentProps);
                            continue;
                        }
                        if (propName.equals("fo:break-before")) {
                            propValue = odfProps.get("fo:break-before");
                            if (!((String)propValue).equals("page")) continue;
                            newProps.put("pageBreakBefore", (Object)Boolean.TRUE);
                            continue;
                        }
                        if (!propName.equals("fo:break-after") || !((String)(propValue = odfProps.get("fo:break-after"))).equals("page")) continue;
                        newProps.put("pageBreakAfter", (Object)Boolean.TRUE);
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            } else if (styleFamilyGroup.equals("cell")) {
                boolean borderToBeDone = true;
                boolean paddingToBeDone = true;
                for (String propName : odfProps.keySet()) {
                    try {
                        if (propName.contains("padding")) {
                            if (!paddingToBeDone) continue;
                            MapHelper.mapPadding(newProps, odfProps);
                            paddingToBeDone = false;
                            continue;
                        }
                        if (propName.contains("border")) {
                            if (!borderToBeDone) continue;
                            MapHelper.mapBorder(newProps, odfProps);
                            borderToBeDone = false;
                            continue;
                        }
                        if (propName.equals("fo:background-color")) {
                            propValue = odfProps.get("fo:background-color");
                            Map<String, String> color = MapHelper.createColorMap((String)propValue);
                            newProps.put("fillColor", color);
                            continue;
                        }
                        if (!propName.equals("style:vertical-align")) continue;
                        propValue = odfProps.get("style:vertical-align");
                        newProps.put("alignVert", propValue);
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            } else if (styleFamilyGroup.equals("column")) {
                for (String propName : odfProps.keySet()) {
                    try {
                        if (propName.equals("style:column-width")) {
                            propValue = odfProps.get("style:column-width");
                            newProps.put("width", MapHelper.normalizeLength((String)propValue));
                            continue;
                        }
                        if (!propName.contains("style:use-optimal-column-width")) continue;
                        propValue = odfProps.get("style:use-optimal-column-width");
                        newProps.put("customWidth", !Boolean.parseBoolean((String)propValue));
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            } else if (styleFamilyGroup.equals("row")) {
                try {
                    for (String propName : odfProps.keySet()) {
                        if (propName.equals("fo:background-color")) {
                            propValue = odfProps.get("fo:background-color");
                            Map<String, String> color = MapHelper.createColorMap((String)propValue);
                            newProps.put("fillColor", color);
                            continue;
                        }
                        if (propName.equals("style:min-row-height")) {
                            propValue = odfProps.get("style:min-row-height");
                            newProps.put("height", MapHelper.normalizeLength((String)propValue));
                            continue;
                        }
                        if (propName.equals("style:row-height")) {
                            propValue = odfProps.get("style:row-height");
                            newProps.put("height", MapHelper.normalizeLength((String)propValue));
                            continue;
                        }
                        if (!propName.contains("style:use-optimal-row-height")) continue;
                        propValue = odfProps.get("style:use-optimal-row-height");
                        newProps.put("customHeight", !Boolean.parseBoolean((String)propValue));
                    }
                }
                catch (JSONException ex) {
                    Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else if (styleFamilyGroup.equals("list")) {
                try {
                    for (String propName : odfProps.keySet()) {
                        if (propName.equals("style:font-name")) {
                            propValue = odfProps.get("style:font-name");
                            newProps.put("fontName", propValue);
                            continue;
                        }
                        if (propName.equals("style:font-name-asian")) {
                            propValue = odfProps.get("style:font-name-asian");
                            newProps.put("fontNameAsian", propValue);
                            continue;
                        }
                        if (propName.equals("style:font-name-complex")) {
                            propValue = odfProps.get("style:font-name-complex");
                            newProps.put("fontNameComplex", propValue);
                            continue;
                        }
                        if (!propName.equals("fo:text-align")) continue;
                        propValue = odfProps.get("fo:text-align");
                        if (((String)propValue).equals("start") || ((String)propValue).equals("left")) {
                            propValue = "left";
                        } else if (((String)propValue).equals("end") || ((String)propValue).equals("right")) {
                            propValue = "right";
                        }
                        newProps.put("alignment", propValue);
                    }
                }
                catch (JSONException ex) {
                    Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else if (styleFamilyGroup.equals("table")) {
                boolean marginToBeDone = true;
                for (String propName : odfProps.keySet()) {
                    try {
                        if (propName.contains("margin")) {
                            if (!marginToBeDone) continue;
                            MapHelper.mapMargin(newProps, odfProps);
                            marginToBeDone = false;
                            continue;
                        }
                        if (propName.equals("style:width")) {
                            propValue = odfProps.get("style:width");
                            if (((String)propValue).contains(PERCENT)) continue;
                            newProps.put("width", MapHelper.normalizeLength((String)propValue));
                            continue;
                        }
                        if (propName.equals("fo:background-color")) {
                            propValue = odfProps.get("fo:background-color");
                            Map<String, String> color = MapHelper.createColorMap((String)propValue);
                            newProps.put("fillColor", color);
                            continue;
                        }
                        if (propName.equals("table:display")) {
                            propValue = odfProps.get("table:display");
                            newProps.put("visible", Boolean.parseBoolean((String)propValue));
                            continue;
                        }
                        if (propName.equals("fo:break-before")) {
                            propValue = odfProps.get("fo:break-before");
                            newProps.put("pageBreakBefore", ((String)propValue).equals("page"));
                            continue;
                        }
                        if (!propName.equals("fo:break-after")) continue;
                        propValue = odfProps.get("fo:break-after");
                        newProps.put("pageBreakAfter", ((String)propValue).equals("page"));
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            } else if (styleFamilyGroup.equals("page")) {
                boolean borderToBeDone = true;
                boolean paddingToBeDone = true;
                boolean marginToBeDone = true;
                for (String propName : odfProps.keySet()) {
                    try {
                        if (propName.contains("margin")) {
                            if (!marginToBeDone) continue;
                            MapHelper.mapMargin(newProps, odfProps);
                            marginToBeDone = false;
                            continue;
                        }
                        if (propName.contains("padding")) {
                            if (!paddingToBeDone) continue;
                            MapHelper.mapPadding(newProps, odfProps);
                            paddingToBeDone = false;
                            continue;
                        }
                        if (propName.contains("border")) {
                            if (!borderToBeDone) continue;
                            MapHelper.mapBorder(newProps, odfProps);
                            borderToBeDone = false;
                            continue;
                        }
                        if (propName.equals("fo:background-color")) {
                            propValue = odfProps.get("fo:background-color");
                            Map<String, String> color = MapHelper.createColorMap((String)propValue);
                            newProps.put("fillColor", color);
                            continue;
                        }
                        if (propName.equals("fo:page-width")) {
                            propValue = odfProps.get("fo:page-width");
                            newProps.put("width", MapHelper.normalizeLength((String)propValue));
                            continue;
                        }
                        if (propName.equals("fo:page-height")) {
                            propValue = odfProps.get("fo:page-height");
                            newProps.put("height", MapHelper.normalizeLength((String)propValue));
                            continue;
                        }
                        if (propName.equals("style:print-orientation")) {
                            propValue = odfProps.get("style:print-orientation");
                            newProps.put("printOrientation", propValue);
                            continue;
                        }
                        if (!propName.equals("style:num-format")) continue;
                        propValue = odfProps.get("style:num-format");
                        newProps.put("numberFormat", propValue);
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            } else if (styleFamilyGroup.equals("drawing")) {
                boolean borderToBeDone = true;
                boolean paddingToBeDone = true;
                boolean marginToBeDone = true;
                shapeProps = new JSONObject();
                imageProps = new JSONObject();
                lineProps = new JSONObject();
                fillProps = new JSONObject();
                for (String propName : odfProps.keySet()) {
                    try {
                        String runThrough;
                        if (propName.contains("margin")) {
                            if (!marginToBeDone) continue;
                            MapHelper.mapMargin(newProps, odfProps);
                            marginToBeDone = false;
                            continue;
                        }
                        if (propName.contains("padding")) {
                            if (!paddingToBeDone) continue;
                            MapHelper.mapPadding(shapeProps, odfProps);
                            paddingToBeDone = false;
                            continue;
                        }
                        if (propName.contains("border")) {
                            if (!borderToBeDone) continue;
                            MapHelper.mapBorder(newProps, odfProps);
                            borderToBeDone = false;
                            continue;
                        }
                        if (propName.equals("fo:background-color")) {
                            propValue = odfProps.get("fo:background-color");
                            Map<String, String> color = MapHelper.createColorMap((String)propValue);
                            fillProps.put("type", (Object)"solid");
                            fillProps.put("color", color);
                            continue;
                        }
                        if (propName.equals("draw:fill-color")) {
                            propValue = odfProps.get("draw:fill-color");
                            Map<String, String> color = MapHelper.createColorMap((String)propValue);
                            fillProps.put("type", (Object)"solid");
                            fillProps.put("color", color);
                            continue;
                        }
                        if (propName.equals("style:mirror")) {
                            String mirror = odfProps.get("style:mirror");
                            if (mirror.contains("horizontal") && !mirror.contains("-on-")) {
                                newProps.put("flipH", (Object)Boolean.TRUE);
                            }
                            if (mirror.contains("vertical")) {
                                newProps.put("flipV", (Object)Boolean.TRUE);
                            }
                            if (!mirror.equals("none")) continue;
                            newProps.put("flipV", (Object)Boolean.FALSE);
                            newProps.put("flipH", (Object)Boolean.FALSE);
                            continue;
                        }
                        if (propName.contains("horizontal-pos")) {
                            String horizontalPos = odfProps.get("style:horizontal-pos");
                            if (horizontalPos.equals("center")) {
                                newProps.put("anchorHorAlign", (Object)"center");
                                continue;
                            }
                            if (horizontalPos.equals("from-left")) {
                                newProps.put("anchorHorAlign", (Object)"offset");
                                continue;
                            }
                            if (horizontalPos.equals("left")) {
                                newProps.put("anchorHorAlign", (Object)"left");
                                continue;
                            }
                            if (horizontalPos.equals("right")) {
                                newProps.put("anchorHorAlign", (Object)"right");
                                continue;
                            }
                            if (horizontalPos.equals("inside")) {
                                newProps.put("anchorHorAlign", (Object)"inside");
                                continue;
                            }
                            if (!horizontalPos.equals("outside")) continue;
                            newProps.put("anchorHorAlign", (Object)"outside");
                            continue;
                        }
                        if (propName.contains("vertical-pos")) {
                            String verticalPos = odfProps.get("style:vertical-pos");
                            if (verticalPos.equals("center")) {
                                newProps.put("anchorVertAlign", (Object)"center");
                                continue;
                            }
                            if (verticalPos.equals("from-top")) {
                                newProps.put("anchorVertAlign", (Object)"offset");
                                continue;
                            }
                            if (verticalPos.equals("top")) {
                                newProps.put("anchorVertAlign", (Object)"top");
                                continue;
                            }
                            if (verticalPos.equals("bottom")) {
                                newProps.put("anchorVertAlign", (Object)"bottom");
                                continue;
                            }
                            if (verticalPos.equals("inside")) {
                                newProps.put("anchorVertAlign", (Object)"inside");
                                continue;
                            }
                            if (!verticalPos.equals("outside")) continue;
                            newProps.put("anchorVertAlign", (Object)"outside");
                            continue;
                        }
                        if (propName.contains("horizontal-rel")) {
                            String horiRel = odfProps.get("style:horizontal-rel");
                            if (horiRel.equals("char")) {
                                newProps.put("anchorHorBase", (Object)"character");
                                continue;
                            }
                            if (horiRel.equals("page-content")) {
                                newProps.put("anchorHorBase", (Object)"margin");
                                continue;
                            }
                            if (horiRel.equals("page-start-margin")) {
                                newProps.put("anchorHorBase", (Object)"leftMargin");
                                continue;
                            }
                            if (horiRel.equals("page-end-margin")) {
                                newProps.put("anchorHorBase", (Object)"rightMargin");
                                continue;
                            }
                            if (horiRel.equals("frame")) {
                                newProps.put("anchorHorBase", (Object)"column");
                                continue;
                            }
                            if (horiRel.equals("frame-content") || horiRel.equals("frame-end-margin") || horiRel.equals("frame-start-margin")) {
                                newProps.put("anchorHorBase", (Object)"column");
                                continue;
                            }
                            if (horiRel.equals("paragraph") || horiRel.equals("paragraph-content")) {
                                newProps.put("anchorHorBase", (Object)"column");
                                continue;
                            }
                            if (horiRel.equals("paragraph-end-margin")) {
                                newProps.put("anchorHorBase", (Object)"rightMargin");
                                continue;
                            }
                            if (horiRel.equals("paragraph-start-margin")) {
                                newProps.put("anchorHorBase", (Object)"leftMargin");
                                continue;
                            }
                            if (!horiRel.equals("page")) continue;
                            newProps.put("anchorHorBase", (Object)"page");
                            continue;
                        }
                        if (propName.contains("vertical-rel")) {
                            String verticalRel = odfProps.get("style:vertical-rel");
                            if (verticalRel.equals("char")) {
                                newProps.put("anchorVertBase", (Object)"line");
                                continue;
                            }
                            if (verticalRel.equals("frame")) {
                                newProps.put("anchorVertBase", (Object)"paragraph");
                                continue;
                            }
                            if (verticalRel.equals("frame-content")) {
                                newProps.put("anchorVertBase", (Object)"paragraph");
                                continue;
                            }
                            if (verticalRel.equals("line")) {
                                newProps.put("anchorVertBase", (Object)"line");
                                continue;
                            }
                            if (verticalRel.equals("page")) {
                                newProps.put("anchorVertBase", (Object)"page");
                                continue;
                            }
                            if (verticalRel.equals("page-content")) {
                                newProps.put("anchorVertBase", (Object)"margin");
                                continue;
                            }
                            if (verticalRel.equals("paragraph")) {
                                newProps.put("anchorVertBase", (Object)"paragraph");
                                continue;
                            }
                            if (verticalRel.equals("paragraph-content")) {
                                newProps.put("anchorVertBase", (Object)"paragraph");
                                continue;
                            }
                            if (!verticalRel.equals("text")) continue;
                            newProps.put("anchorVertBase", (Object)"line");
                            continue;
                        }
                        if (propName.equals("svg:x")) {
                            int x = MapHelper.normalizeLength(odfProps.get("svg:x"));
                            if (x == 0) continue;
                            newProps.put("anchorHorOffset", x);
                            newProps.put("left", x);
                            continue;
                        }
                        if (propName.equals("svg:y")) {
                            int y = MapHelper.normalizeLength(odfProps.get("svg:y"));
                            if (y == 0) continue;
                            newProps.put("anchorVertOffset", y);
                            newProps.put("top", y);
                            continue;
                        }
                        if (propName.equals("fo:clip")) {
                            String[] clips;
                            String clipping = odfProps.get("fo:clip");
                            int start = clipping.indexOf("rect(");
                            int end = clipping.indexOf(")");
                            if (start > -1 && end > -1) {
                                clipping = clipping.substring(start + 5, end);
                            }
                            if ((clips = clipping.split(", ")).length != 4) {
                                clips = clipping.split(" ");
                            }
                            int clipTop = MapHelper.normalizeLength(clips[0]);
                            imageProps.put("cropTop", clipTop);
                            int clipRight = MapHelper.normalizeLength(clips[1]);
                            imageProps.put("cropRight", clipRight);
                            int clipBottom = MapHelper.normalizeLength(clips[2]);
                            imageProps.put("cropBottom", clipBottom);
                            int clipLeft = MapHelper.normalizeLength(clips[3]);
                            imageProps.put("cropLeft", clipLeft);
                            continue;
                        }
                        if (propName.equals("style:wrap")) {
                            String wrap = odfProps.get("style:wrap");
                            if (wrap.equals("biggest")) {
                                newProps.put("textWrapMode", (Object)"square");
                                newProps.put("textWrapSide", (Object)"largest");
                                continue;
                            }
                            if (wrap.equals("left")) {
                                newProps.put("textWrapMode", (Object)"square");
                                newProps.put("textWrapSide", (Object)"left");
                                continue;
                            }
                            if (wrap.equals("none")) {
                                newProps.put("textWrapMode", (Object)"topAndBottom");
                                continue;
                            }
                            if (wrap.equals("parallel")) {
                                newProps.put("textWrapMode", (Object)"square");
                                newProps.put("textWrapSide", (Object)"both");
                                continue;
                            }
                            if (wrap.equals("right")) {
                                newProps.put("textWrapMode", (Object)"square");
                                newProps.put("textWrapSide", (Object)"right");
                                continue;
                            }
                            if (!wrap.equals("run-through")) continue;
                            newProps.put("textWrapMode", (Object)"through");
                            newProps.put("textWrapSide", (Object)"both");
                            continue;
                        }
                        if (propName.equals("draw:stroke")) {
                            String stroke = odfProps.get("draw:stroke");
                            if (stroke.equals("none")) {
                                lineProps.put("style", (Object)"none");
                                continue;
                            }
                            lineProps.put("style", (Object)(stroke.equals("solid") ? "solid" : "dashed"));
                            if (!lineProps.has("width")) {
                                lineProps.put("width", 1);
                            }
                            if (lineProps.has("type")) continue;
                            lineProps.put("type", (Object)"solid");
                            continue;
                        }
                        if (propName.equals("svg:stroke-color")) {
                            String color = odfProps.get("svg:stroke-color");
                            lineProps.put("color", MapHelper.createColorMap(color));
                            continue;
                        }
                        if (propName.equals("svg:stroke-width")) {
                            lineProps.put("width", MapHelper.normalizeLength(odfProps.get("svg:stroke-width")));
                            continue;
                        }
                        if (!propName.equals("style:run-through") || !"background".equals(runThrough = odfProps.get(propName))) continue;
                        newProps.put("anchorBehindDoc", true);
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                try {
                    if (newProps.has("border") || newProps.has("borderTop")) {
                        JSONObject currentBorder;
                        JSONObject jSONObject = currentBorder = newProps.has("border") ? newProps.getJSONObject("border") : newProps.getJSONObject("borderTop");
                        if (currentBorder.has("style")) {
                            String style = currentBorder.getString("style");
                            if (style.equals("none")) {
                                lineProps.put("type", (Object)"none");
                            } else {
                                if (style.equals("dashed")) {
                                    lineProps.put("style", (Object)"dashed");
                                } else if (style.equals("dotted")) {
                                    lineProps.put("style", (Object)"dotted");
                                } else {
                                    lineProps.put("style", (Object)"solid");
                                }
                                lineProps.put("type", (Object)"solid");
                            }
                        }
                        if (currentBorder.has("width")) {
                            lineProps.put("width", currentBorder.get("width"));
                        }
                        if (currentBorder.has("color")) {
                            lineProps.put("color", currentBorder.get("color"));
                        }
                    }
                    if (newProps.has("borderTop")) {
                        newProps.remove("borderTop");
                    }
                    if (newProps.has("borderBottom")) {
                        newProps.remove("borderBottom");
                    }
                    if (newProps.has("borderLeft")) {
                        newProps.remove("borderLeft");
                    }
                    if (newProps.has("borderRight")) {
                        newProps.remove("borderRight");
                    }
                    if (newProps.has("border")) {
                        newProps.remove("border");
                    }
                }
                catch (JSONException jSONException) {}
            } else if (styleFamilyGroup.equals("headerFooter")) {
                boolean borderToBeDone = true;
                boolean paddingToBeDone = true;
                boolean marginToBeDone = true;
                for (String propName : odfProps.keySet()) {
                    try {
                        if (propName.contains("margin")) {
                            if (!marginToBeDone) continue;
                            MapHelper.mapMargin(newProps, odfProps);
                            marginToBeDone = false;
                            continue;
                        }
                        if (propName.contains("padding")) {
                            if (!paddingToBeDone) continue;
                            MapHelper.mapPadding(newProps, odfProps);
                            paddingToBeDone = false;
                            continue;
                        }
                        if (propName.contains("border")) {
                            if (!borderToBeDone) continue;
                            MapHelper.mapBorder(newProps, odfProps);
                            borderToBeDone = false;
                            continue;
                        }
                        if (!propName.equals("fo:background-color")) continue;
                        propValue = odfProps.get("fo:background-color");
                        Map<String, String> color = MapHelper.createColorMap((String)propValue);
                        newProps.put("fillColor", color);
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        JSONObject retObject = new JSONObject();
        try {
            retObject.put(styleFamilyGroup, (Object)newProps);
            if (shapeProps != null && shapeProps.length() > 0) {
                retObject.put("shape", shapeProps);
            }
            if (imageProps != null && imageProps.length() > 0) {
                retObject.put("image", imageProps);
            }
            if (lineProps != null) {
                retObject.put("line", lineProps);
            }
            if (fillProps != null && fillProps.length() > 0) {
                retObject.put("fill", fillProps);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return retObject;
    }

    private static JSONObject createLineHeightMap(String lineHeightValue) {
        JSONObject lineHeight = new JSONObject();
        try {
            if (lineHeightValue.equals(NORMAL)) {
                lineHeight.put("type", (Object)"percent");
                lineHeight.put("value", (Object)"100");
            } else if (lineHeightValue.contains(PERCENT)) {
                lineHeight.put("type", (Object)"percent");
                lineHeight.put("value", Integer.parseInt(lineHeightValue.subSequence(0, lineHeightValue.indexOf(37)).toString()));
            } else {
                lineHeight.put("type", (Object)"fixed");
                lineHeight.put("value", MapHelper.normalizeLength(lineHeightValue));
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return lineHeight;
    }

    private static void mapBorder(JSONObject newProps, Map<String, String> odfProps) throws JSONException {
        JSONObject border;
        String propValue;
        JSONObject defaultBorder = null;
        Integer defaultSpace = null;
        if (odfProps.containsKey("fo:border")) {
            propValue = odfProps.get("fo:border");
            defaultBorder = MapHelper.createBorderMap(propValue);
            if (odfProps.containsKey("fo:padding")) {
                propValue = odfProps.get("fo:padding");
                if (!propValue.contains(PERCENT)) {
                    defaultSpace = MapHelper.normalizeLength(propValue);
                }
                defaultBorder.put("space", (Object)defaultSpace);
            }
        }
        if (odfProps.containsKey("fo:border-left")) {
            propValue = odfProps.get("fo:border-left");
            border = MapHelper.createBorderMap(propValue);
            if (odfProps.containsKey("fo:padding-left")) {
                propValue = odfProps.get("fo:padding-left");
                if (!propValue.contains(PERCENT)) {
                    border.put("space", MapHelper.normalizeLength(propValue));
                }
            } else if (defaultSpace != null) {
                border.put("space", defaultSpace);
            }
            newProps.put("borderLeft", (Object)border);
        } else {
            newProps.put("borderLeft", (Object)defaultBorder);
        }
        if (odfProps.containsKey("fo:border-top")) {
            propValue = odfProps.get("fo:border-top");
            border = MapHelper.createBorderMap(propValue);
            if (odfProps.containsKey("fo:padding-top")) {
                propValue = odfProps.get("fo:padding-top");
                if (!propValue.contains(PERCENT)) {
                    border.put("space", MapHelper.normalizeLength(propValue));
                }
            } else if (defaultSpace != null) {
                border.put("space", (Object)defaultSpace);
            }
            newProps.put("borderTop", (Object)border);
        } else {
            newProps.put("borderTop", (Object)defaultBorder);
        }
        if (odfProps.containsKey("fo:border-right")) {
            propValue = odfProps.get("fo:border-right");
            border = MapHelper.createBorderMap(propValue);
            if (odfProps.containsKey("fo:padding-right")) {
                propValue = odfProps.get("fo:padding-right");
                if (!propValue.contains(PERCENT)) {
                    border.put("space", MapHelper.normalizeLength(propValue));
                }
            } else if (defaultSpace != null) {
                border.put("space", (Object)defaultSpace);
            }
            newProps.put("borderRight", (Object)border);
        } else {
            newProps.put("borderRight", (Object)defaultBorder);
        }
        if (odfProps.containsKey("fo:border-bottom")) {
            propValue = odfProps.get("fo:border-bottom");
            border = MapHelper.createBorderMap(propValue);
            if (odfProps.containsKey("fo:padding-bottom")) {
                propValue = odfProps.get("fo:padding-bottom");
                if (!propValue.contains(PERCENT)) {
                    border.put("space", MapHelper.normalizeLength(propValue));
                }
            } else if (defaultSpace != null) {
                border.put("space", (Object)defaultSpace);
            }
            newProps.put("borderBottom", (Object)border);
        } else {
            newProps.put("borderBottom", (Object)defaultBorder);
        }
    }

    public static String mapFoTextAlign(String propValue) {
        if (propValue.equals("start") || propValue.equals("left")) {
            propValue = "left";
        } else if (propValue.equals("end") || propValue.equals("right")) {
            propValue = "right";
        }
        return propValue;
    }

    private static void mapMargin(JSONObject newProps, Map<String, String> odfProps) throws JSONException {
        String propValue;
        Integer defaultLength = null;
        if (odfProps.containsKey("fo:margin") && !(propValue = odfProps.get("fo:margin")).contains(PERCENT)) {
            defaultLength = MapHelper.normalizeLength(propValue);
        }
        if (odfProps.containsKey("fo:margin-left")) {
            propValue = odfProps.get("fo:margin-left");
            if (!propValue.contains(PERCENT)) {
                newProps.put("marginLeft", MapHelper.normalizeLength(propValue));
                newProps.put("indentLeft", MapHelper.normalizeLength(propValue));
            }
        } else if (defaultLength != null) {
            newProps.put("marginLeft", defaultLength);
            newProps.put("indentLeft", (Object)defaultLength);
        }
        if (odfProps.containsKey("fo:margin-top")) {
            propValue = odfProps.get("fo:margin-top");
            if (!propValue.contains(PERCENT)) {
                newProps.put("marginTop", MapHelper.normalizeLength(propValue));
            }
        } else if (defaultLength != null) {
            newProps.put("marginTop", (Object)defaultLength);
        }
        if (odfProps.containsKey("fo:margin-right")) {
            propValue = odfProps.get("fo:margin-right");
            if (!propValue.contains(PERCENT)) {
                newProps.put("marginRight", MapHelper.normalizeLength(propValue));
                newProps.put("indentRight", MapHelper.normalizeLength(propValue));
            }
        } else if (defaultLength != null) {
            newProps.put("marginRight", (Object)defaultLength);
            newProps.put("indentRight", (Object)defaultLength);
        }
        if (odfProps.containsKey("fo:margin-bottom")) {
            propValue = odfProps.get("fo:margin-bottom");
            if (!propValue.contains(PERCENT)) {
                newProps.put("marginBottom", MapHelper.normalizeLength(propValue));
            }
        } else if (defaultLength != null) {
            newProps.put("marginBottom", (Object)defaultLength);
        }
    }

    private static void mapPadding(JSONObject newProps, Map<String, String> odfProps) throws JSONException {
        String propValue;
        Integer defaultLength = null;
        if (odfProps.containsKey("fo:padding") && !(propValue = odfProps.get("fo:padding")).contains(PERCENT)) {
            defaultLength = MapHelper.normalizeLength(propValue);
        }
        if (odfProps.containsKey("fo:padding-left")) {
            propValue = odfProps.get("fo:padding-left");
            if (!propValue.contains(PERCENT)) {
                newProps.put("paddingLeft", MapHelper.normalizeLength(propValue));
            }
        } else if (defaultLength != null) {
            newProps.put("paddingLeft", defaultLength);
        }
        if (odfProps.containsKey("fo:padding-top")) {
            propValue = odfProps.get("fo:padding-top");
            if (!propValue.contains(PERCENT)) {
                newProps.put("paddingTop", MapHelper.normalizeLength(propValue));
            }
        } else if (defaultLength != null) {
            newProps.put("paddingTop", (Object)defaultLength);
        }
        if (odfProps.containsKey("fo:padding-right")) {
            propValue = odfProps.get("fo:padding-right");
            if (!propValue.contains(PERCENT)) {
                newProps.put("paddingRight", MapHelper.normalizeLength(propValue));
            }
        } else if (defaultLength != null) {
            newProps.put("paddingRight", (Object)defaultLength);
        }
        if (odfProps.containsKey("fo:padding-bottom")) {
            propValue = odfProps.get("fo:padding-bottom");
            if (!propValue.contains(PERCENT)) {
                newProps.put("paddingBottom", MapHelper.normalizeLength(propValue));
            }
        } else if (defaultLength != null) {
            newProps.put("paddingBottom", (Object)defaultLength);
        }
    }

    public static Map<String, Object> mapStyleProperties(OdfStylableElement styleElement, Map<String, Map<String, String>> allOdfProps) {
        Map<String, OdfStylePropertiesSet> familyPropertyGroups = Component.getAllStyleGroupingIdProperties(styleElement);
        return MapHelper.mapStyleProperties(familyPropertyGroups, allOdfProps);
    }

    public static Map<String, Object> mapStyleProperties(Map<String, OdfStylePropertiesSet> familyPropertyGroups, Map<String, Map<String, String>> allOdfProps) {
        HashMap<String, Object> allProps = new HashMap<String, Object>();
        for (String styleFamilyKey : familyPropertyGroups.keySet()) {
            JSONObject mappedProps = MapHelper.mapProperties(styleFamilyKey, allOdfProps.get(styleFamilyKey));
            try {
                if (mappedProps == null) continue;
                if (mappedProps.has(styleFamilyKey) && mappedProps.getJSONObject(styleFamilyKey).length() != 0) {
                    allProps.put(styleFamilyKey, mappedProps.getJSONObject(styleFamilyKey));
                }
                if (!styleFamilyKey.equals("drawing")) continue;
                if (mappedProps.has("shape") && mappedProps.getJSONObject("shape").length() != 0) {
                    allProps.put("shape", mappedProps.getJSONObject("shape"));
                }
                if (mappedProps.has("image") && mappedProps.getJSONObject("image").length() != 0) {
                    allProps.put("image", mappedProps.getJSONObject("image"));
                }
                if (mappedProps.has("line") && mappedProps.getJSONObject("line").length() != 0) {
                    allProps.put("line", mappedProps.getJSONObject("line"));
                }
                if (!mappedProps.has("fill") || mappedProps.getJSONObject("fill").length() == 0) continue;
                allProps.put("fill", mappedProps.getJSONObject("fill"));
            }
            catch (JSONException jSONException) {}
        }
        return allProps;
    }

    public static Map<String, Object> getMappedStyleProperties(OdfStyle style) {
        Map<String, Object> mappedFormatting = null;
        if (style != null) {
            HashMap<String, Map<String, String>> allOdfProps = new HashMap<String, Map<String, String>>();
            Map<String, OdfStylePropertiesSet> familyPropertyGroups = Component.getAllStyleGroupingIdProperties(style.getFamily());
            MapHelper.getStyleProperties((OdfStyleBase)style, familyPropertyGroups, allOdfProps);
            mappedFormatting = MapHelper.mapStyleProperties(familyPropertyGroups, allOdfProps);
        }
        return mappedFormatting;
    }

    public static void getStyleProperties(OdfStyleBase style, OdfStylableElement styleElement, Map<String, Map<String, String>> allOdfProps) {
        Map<String, OdfStylePropertiesSet> familyPropertyGroups = Component.getAllStyleGroupingIdProperties(styleElement);
        MapHelper.getStyleProperties(style, familyPropertyGroups, allOdfProps);
    }

    public static void getStyleProperties(OdfStyleBase style, Map<String, OdfStylePropertiesSet> familyPropertyGroups, Map<String, Map<String, String>> allOdfProps) {
        if (style != null) {
            for (String styleFamilyKey : familyPropertyGroups.keySet()) {
                HashMap<String, String> odfProps = new HashMap<String, String>();
                OdfStylePropertiesSet key = familyPropertyGroups.get(styleFamilyKey);
                OdfStylePropertiesBase propsElement = style.getPropertiesElement(key);
                if (propsElement != null) {
                    StyleParagraphPropertiesElement paraPropsElement;
                    NodeList tabStops;
                    NamedNodeMap attrs = propsElement.getAttributes();
                    Object name = null;
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        name = null;
                        Attr prop = (Attr)attrs.item(i);
                        name = OdfNamespace.getNamespace(prop.getNamespaceURI()).getPrefix();
                        if (name == null) {
                            name = prop.getPrefix();
                        }
                        name = name != null ? (String)name + ":" + prop.getName() : prop.getName();
                        odfProps.put((String)name, prop.getValue());
                    }
                    if (propsElement instanceof StyleParagraphPropertiesElement && (tabStops = (paraPropsElement = (StyleParagraphPropertiesElement)propsElement).getElementsByTagNameNS(OdfDocumentNamespace.STYLE.getUri(), "tab-stops")).getLength() > 0) {
                        StyleTabStopsElement tabStopsElement = (StyleTabStopsElement)((Object)tabStops.item(0));
                        NodeList tabStopList = tabStopsElement.getElementsByTagNameNS(OdfDocumentNamespace.STYLE.getUri(), "tab-stop");
                        int size = tabStopList.getLength();
                        int tabNumber = -1;
                        for (int i = 0; i < size; ++i) {
                            Node child = tabStopList.item(i);
                            if (!(child instanceof Element)) continue;
                            MapHelper.extractTabulatorLeaderText((StyleTabStopElement)((Object)child), odfProps, ++tabNumber);
                            MapHelper.extractTabulatorPosition((StyleTabStopElement)((Object)child), odfProps, tabNumber);
                            MapHelper.extractTabulatorType((StyleTabStopElement)((Object)child), odfProps, tabNumber);
                        }
                    }
                }
                if (odfProps.isEmpty()) continue;
                allOdfProps.put(styleFamilyKey, odfProps);
            }
        }
    }

    private static void extractTabulatorType(StyleTabStopElement tabStopElement, Map<String, String> odfProps, int tabNumber) {
        String tabType = tabStopElement.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "type");
        if (tabType != null && !tabType.isEmpty()) {
            if (tabType.equals("char")) {
                tabType = "decimal";
            }
            odfProps.put("tab_Type" + tabNumber, tabType);
        }
    }

    private static void extractTabulatorLeaderText(StyleTabStopElement tabStopElement, Map<String, String> odfProps, int tabNumber) {
        String tabLeaderText = tabStopElement.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "leader-text");
        if (tabLeaderText != null & !tabLeaderText.isEmpty()) {
            if (tabLeaderText.equals(".")) {
                odfProps.put("tab_LeaderText" + tabNumber, "dot");
            } else if (tabLeaderText.equals("-")) {
                odfProps.put("tab_LeaderText" + tabNumber, "hyphen");
            } else if (tabLeaderText.equals("_")) {
                odfProps.put("tab_LeaderText" + tabNumber, "underscore");
            } else if (tabLeaderText.equals(" ")) {
                odfProps.put("tab_LeaderText" + tabNumber, "none");
            }
        }
    }

    private static boolean hasTabsRelativeToIndent(OdfElement element) {
        boolean isTabsRelativeToIndent = false;
        OdfSchemaDocument schemaDoc = (OdfSchemaDocument)((OdfFileDom)((Object)element.getOwnerDocument())).getDocument();
        if (schemaDoc instanceof OdfTextDocument) {
            isTabsRelativeToIndent = ((OdfTextDocument)schemaDoc).hasTabsRelativeToIndent();
        }
        return isTabsRelativeToIndent;
    }

    private static void extractTabulatorPosition(StyleTabStopElement tabStopElement, Map<String, String> odfProps, int tabNumber) {
        String propValue;
        String tabPos = tabStopElement.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "position");
        int tabIndent = 0;
        if (odfProps.containsKey("fo:margin-left") && MapHelper.hasTabsRelativeToIndent(tabStopElement) && !(propValue = odfProps.get("fo:margin-left")).contains(PERCENT)) {
            tabIndent = MapHelper.normalizeLength(propValue);
        }
        if (tabPos.isEmpty()) {
            LOG.severe("There should be only be a length, but it has been: '" + tabPos + "'");
        } else {
            odfProps.put("tab_Pos" + tabNumber, Integer.toString(MapHelper.normalizeLength(tabPos) + tabIndent));
        }
    }

    public static Double dateToDouble(Object value) {
        Double ret = new Double(0.0);
        if (value != null && value instanceof String) {
            FastDateFormat fdf = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT;
            Date date = null;
            try {
                date = fdf.parse((String)value);
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                long diff = cal.getTimeInMillis() + 2209161600000L;
                ret = (double)diff / 8.64E7;
            }
            catch (ParseException ex) {
                Logger.getLogger(MapHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return ret;
    }

    public static Double timeToDouble(Object value) {
        Double ret = new Double(0.0);
        if (value != null && value instanceof String) {
            try {
                String duration = (String)value;
                int length = duration.length();
                double hours = 0.0;
                double mins = 0.0;
                double millisecs = 0.0;
                if (length >= 11) {
                    int hPos = duration.indexOf(72);
                    int mPos = duration.indexOf(77);
                    hours = Integer.parseInt(duration.substring(2, hPos));
                    mins = Integer.parseInt(duration.substring(hPos + 1, mPos));
                    millisecs = Double.parseDouble(duration.substring(mPos + 1, length - 1));
                    ret = hours / 24.0 + mins / 1440.0 + millisecs / 86400.0;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static boolean putNumberFormat(Map<String, Object> jsonStyleProperties, Map<String, Map<String, String>> stringProperties, OdfStyle autoStyle, OdfStylesBase autoStyles, OdfStylesBase officeStyles) {
        boolean ret = false;
        if (autoStyle != null && autoStyle.hasAttribute("style:data-style-name")) {
            String dataStyleName = autoStyle.getAttribute("style:data-style-name");
            String formatCode = "";
            DataStyleElement dataStyleBase = null;
            dataStyleBase = officeStyles.getAllDataStyles().get(dataStyleName);
            if (dataStyleBase == null && autoStyles != null) {
                dataStyleBase = autoStyles.getAllDataStyles().get(dataStyleName);
            }
            if (dataStyleBase != null) {
                formatCode = dataStyleBase.getFormat(true);
            }
            if (!formatCode.isEmpty()) {
                ret = true;
                JSONObject jsonCellProps = new JSONObject();
                if (jsonStyleProperties != null) {
                    if (jsonStyleProperties.containsKey("cell")) {
                        jsonCellProps = (JSONObject)jsonStyleProperties.get("cell");
                    }
                    try {
                        jsonCellProps.put("formatCode", (Object)formatCode);
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    jsonStyleProperties.put("cell", jsonCellProps);
                } else {
                    Map<String, String> stringCellProps = new HashMap<String, String>();
                    if (stringProperties.containsKey("cell")) {
                        stringCellProps = stringProperties.get("cell");
                    }
                    stringCellProps.put("numberformat_code", formatCode);
                    stringProperties.put("cell", stringCellProps);
                }
            }
        }
        return ret;
    }

    public static String removeQuotedAndColor(String compareCode) {
        int secondQuote;
        int firstQuote;
        while (((String)compareCode).contains("\"") && (firstQuote = ((String)compareCode).indexOf("\"")) != ((String)compareCode).length() - 1 && (secondQuote = ((String)compareCode).indexOf("\"", firstQuote + 1)) >= 0) {
            Object tmp = ((String)compareCode).substring(0, firstQuote);
            compareCode = tmp = (String)tmp + ((String)compareCode).substring(secondQuote + 1);
        }
        int openBracket = ((String)compareCode).indexOf("[");
        boolean hasCurrency = false;
        while (openBracket >= 0) {
            int closeBracket = ((String)compareCode).indexOf("]", openBracket);
            if (closeBracket > openBracket) {
                String innerText = ((String)compareCode).substring(openBracket + 1, closeBracket);
                if (innerText.startsWith("$") && innerText.length() > 1) {
                    hasCurrency = true;
                }
                compareCode = ((String)compareCode).substring(0, openBracket) + ((String)compareCode).substring(closeBracket + 1);
            }
            openBracket = ((String)compareCode).indexOf("[");
        }
        if (hasCurrency) {
            compareCode = (String)compareCode + "[$]";
        }
        return compareCode;
    }

    public static OfficeValueTypeAttribute.Value detectFormatType(String code) {
        String compareCode = code.replaceAll("AM", "xx9999xx");
        compareCode = compareCode.replaceAll("PM", "xx9999xx");
        compareCode = MapHelper.removeQuotedAndColor(compareCode);
        OfficeValueTypeAttribute.Value type = OfficeValueTypeAttribute.Value.VOID;
        type = compareCode.contains("@") ? OfficeValueTypeAttribute.Value.STRING : (compareCode.equals("BOOLEAN") ? OfficeValueTypeAttribute.Value.BOOLEAN : (compareCode.contains("[$") ? OfficeValueTypeAttribute.Value.CURRENCY : (compareCode.contains(PERCENT) ? OfficeValueTypeAttribute.Value.PERCENTAGE : (compareCode.contains("D") || compareCode.contains("d") || compareCode.contains("M") || compareCode.contains("Y") || compareCode.contains("y") || compareCode.contains("WW") || compareCode.contains("ww") ? OfficeValueTypeAttribute.Value.DATE : (compareCode.contains("h") || compareCode.contains("H") || compareCode.contains("m") || compareCode.contains("s") || compareCode.contains("S") || compareCode.contains("xx9999xx") ? OfficeValueTypeAttribute.Value.TIME : OfficeValueTypeAttribute.Value.FLOAT)))));
        return type;
    }

    public static String findOrCreateDataStyle(String code, long id, OdfFileDom fileDom) {
        OdfDocument odfDocument = (OdfDocument)fileDom.getDocument();
        Object ret = "";
        try {
            OdfContentDom contentDom = odfDocument.getContentDom();
            OdfOfficeStyles officeStyles = odfDocument.getStylesDom().getOfficeStyles();
            OdfOfficeAutomaticStyles autoStyles = contentDom.getAutomaticStyles();
            OfficeValueTypeAttribute.Value type = OfficeValueTypeAttribute.Value.VOID;
            if (id > 0L && id < 164L) {
                switch ((int)id) {
                    case 1: {
                        code = "0";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 2: {
                        code = "0.00";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 3: {
                        code = "#,##0";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 4: {
                        code = "#,##0.00";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 5: {
                        code = "#,##0[$$-409]";
                        type = OfficeValueTypeAttribute.Value.CURRENCY;
                        break;
                    }
                    case 6: {
                        code = "#,##0[$$-409];[RED]-#,##0[$$-409]";
                        type = OfficeValueTypeAttribute.Value.CURRENCY;
                        break;
                    }
                    case 7: {
                        code = "#,##0.00[$$-409]";
                        type = OfficeValueTypeAttribute.Value.CURRENCY;
                        break;
                    }
                    case 8: {
                        code = "#,##0.00[$$-409];[RED]-#,##0.00[$$-409]";
                        type = OfficeValueTypeAttribute.Value.CURRENCY;
                        break;
                    }
                    case 9: {
                        code = "0%";
                        type = OfficeValueTypeAttribute.Value.PERCENTAGE;
                        break;
                    }
                    case 10: {
                        code = "0.00%";
                        type = OfficeValueTypeAttribute.Value.PERCENTAGE;
                        break;
                    }
                    case 11: {
                        code = "0.00E+00";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 12: {
                        code = "# ?/?";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 13: {
                        code = "# ??/??";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 14: {
                        code = "MM/DD/YYYY";
                        type = OfficeValueTypeAttribute.Value.DATE;
                        break;
                    }
                    case 15: {
                        code = "D-MMM-YY";
                        type = OfficeValueTypeAttribute.Value.DATE;
                        break;
                    }
                    case 16: {
                        code = "D-MMM";
                        type = OfficeValueTypeAttribute.Value.DATE;
                        break;
                    }
                    case 17: {
                        code = "MMM-YY";
                        type = OfficeValueTypeAttribute.Value.DATE;
                        break;
                    }
                    case 18: {
                        code = "H:MM AM/PM";
                        type = OfficeValueTypeAttribute.Value.DATE;
                        break;
                    }
                    case 19: {
                        code = "H:MM:SS AM/PM";
                        type = OfficeValueTypeAttribute.Value.DATE;
                        break;
                    }
                    case 20: {
                        code = "H:MM";
                        type = OfficeValueTypeAttribute.Value.TIME;
                        break;
                    }
                    case 21: {
                        code = "H:MM:SS";
                        type = OfficeValueTypeAttribute.Value.TIME;
                        break;
                    }
                    case 22: {
                        code = "M/D/YYYY H:MM";
                        type = OfficeValueTypeAttribute.Value.DATE;
                        break;
                    }
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: {
                        code = "0";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        code = "M/D/YYYY";
                        type = OfficeValueTypeAttribute.Value.DATE;
                        break;
                    }
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: {
                        code = "HH:MM:SS";
                        type = OfficeValueTypeAttribute.Value.TIME;
                        break;
                    }
                    case 36: {
                        code = "M/D/YYYY";
                        type = OfficeValueTypeAttribute.Value.DATE;
                        break;
                    }
                    case 37: {
                        code = "#,##0_);(#,##0)";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 38: {
                        code = "#,##0_);[RED](#,##0)";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 39: {
                        code = "#,##0.00_);(#,##0.00)";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 40: {
                        code = "#,##0.00_);[RED](#,##0.00)";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 41: {
                        code = "_-* #,##0 _\u20ac_-;-* #,##0 _\u20ac_-;_-* \"-\" _\u20ac_-;_-@_-";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 42: {
                        code = "_-* #,##0 \"\u20ac\"_-;-* #,##0 \"\u20ac\"_-;_-* \"-\" \"\u20ac\"_-;_-@_-";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 43: {
                        code = "_-* #,##0.00 _\u20ac_-;-* #,##0.00 _\u20ac_-;_-* \"-\"?? _\u20ac_-;_-@_-";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 44: {
                        code = "_-* #,##0.00 \"\u20ac\"_-;-* #,##0.00 \"\u20ac\"_-;_-* \"-\"?? \"\u20ac\"_-;_-@_-";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 45: {
                        code = "MM:SS";
                        type = OfficeValueTypeAttribute.Value.TIME;
                        break;
                    }
                    case 46: {
                        code = "[h]:mm:ss";
                        type = OfficeValueTypeAttribute.Value.TIME;
                        break;
                    }
                    case 47: {
                        code = "mm:ss.0";
                        type = OfficeValueTypeAttribute.Value.TIME;
                        break;
                    }
                    case 48: {
                        code = "##0.0E+0";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 49: {
                        code = "@";
                        type = OfficeValueTypeAttribute.Value.STRING;
                        break;
                    }
                    case 50: {
                        code = "M/D/YYYY";
                        type = OfficeValueTypeAttribute.Value.DATE;
                        break;
                    }
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: {
                        code = "M/D/YYYY";
                        type = OfficeValueTypeAttribute.Value.DATE;
                        break;
                    }
                    case 59: {
                        code = "0";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 60: {
                        code = "0.00";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 61: {
                        code = "#,##0";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 62: {
                        code = "#,##0.00";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 63: {
                        code = "#,##0 \"\u20ac\";-#,##0 \"\u20ac\"";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 64: {
                        code = "#,##0 \"\u20ac\";[RED]-#,##0 \"\u20ac\"";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 65: {
                        code = "#,##0.00 \"\u20ac\";-#,##0.00 \"\u20ac\"";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 66: {
                        code = "#,##0.00 \"\u20ac\";[RED]-#,##0.00 \"\u20ac\"";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 67: {
                        code = "0%";
                        type = OfficeValueTypeAttribute.Value.PERCENTAGE;
                        break;
                    }
                    case 68: {
                        code = "0.00%";
                        type = OfficeValueTypeAttribute.Value.PERCENTAGE;
                        break;
                    }
                    case 69: {
                        code = "0.00E+00";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 70: {
                        code = "# ?/?";
                        type = OfficeValueTypeAttribute.Value.FLOAT;
                        break;
                    }
                    case 71: 
                    case 72: {
                        code = "M/D/YYYY";
                        type = OfficeValueTypeAttribute.Value.DATE;
                        break;
                    }
                    case 73: {
                        code = "D-MMM-YY";
                        type = OfficeValueTypeAttribute.Value.DATE;
                        break;
                    }
                    case 74: {
                        code = "D-MMM";
                        type = OfficeValueTypeAttribute.Value.DATE;
                        break;
                    }
                    case 75: {
                        code = "MMM-YY";
                        type = OfficeValueTypeAttribute.Value.DATE;
                        break;
                    }
                    case 76: {
                        code = "HH:MM";
                        type = OfficeValueTypeAttribute.Value.TIME;
                        break;
                    }
                    case 77: {
                        code = "HH:MM:SS";
                        type = OfficeValueTypeAttribute.Value.TIME;
                        break;
                    }
                    case 78: {
                        code = "M/D/YYYY H:MM";
                        type = OfficeValueTypeAttribute.Value.TIME;
                        break;
                    }
                    case 79: {
                        code = "mm:ss";
                        type = OfficeValueTypeAttribute.Value.TIME;
                        break;
                    }
                    case 80: {
                        code = "[h]:mm:ss";
                        type = OfficeValueTypeAttribute.Value.TIME;
                        break;
                    }
                    case 81: {
                        code = "mm:ss.0";
                        type = OfficeValueTypeAttribute.Value.TIME;
                    }
                }
            }
            if (!code.isEmpty() && type == OfficeValueTypeAttribute.Value.VOID) {
                type = MapHelper.detectFormatType(code);
            }
            if (!code.isEmpty() && type != OfficeValueTypeAttribute.Value.VOID) {
                String foundStyleName = null;
                boolean foundInAutoStyles = false;
                HashMap<String, DataStyleElement> officeDataStyles = officeStyles.getAllDataStyles();
                HashMap<String, DataStyleElement> autoDataStyles = autoStyles.getAllDataStyles();
                for (Map.Entry<String, DataStyleElement> autoNumberStyle : autoDataStyles.entrySet()) {
                    if (!autoNumberStyle.getValue().getFormat(true).equals(code)) continue;
                    foundStyleName = autoNumberStyle.getKey();
                    ret = foundStyleName;
                    foundInAutoStyles = true;
                    break;
                }
                if (!foundInAutoStyles) {
                    for (Map.Entry<String, DataStyleElement> officeNumberStyle : officeDataStyles.entrySet()) {
                        if (!officeNumberStyle.getValue().getFormat(true).equals(code)) continue;
                        foundStyleName = officeNumberStyle.getKey();
                        ret = foundStyleName;
                        break;
                    }
                }
                if (foundStyleName == null) {
                    int newIndex = autoDataStyles.size() + officeDataStyles.size();
                    String newDataStyleName = "N" + newIndex;
                    while (autoDataStyles.containsKey(newDataStyleName) || officeDataStyles.containsKey(newDataStyleName)) {
                        newDataStyleName = "N" + ++newIndex;
                    }
                    DataStyleElement newStyle = autoStyles.createDataStyle(type, code, newDataStyleName);
                    if (id == 14L) {
                        newStyle.setAttributeNS(OdfDocumentNamespace.NUMBER.getUri(), "number:automatic-order", "true");
                        newStyle.removeAttributeNS(OdfDocumentNamespace.NUMBER.getUri(), "format-source");
                    }
                    ret = newDataStyleName;
                }
            }
        }
        catch (SAXException e) {
            Logger.getLogger(MapHelper.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (IOException ex) {
            Logger.getLogger(MapHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
        return ret;
    }

    private static void fillLocaleMaps() {
        if (localeToLanguageMap == null) {
            localeToLanguageMap = new HashMap<String, Integer>();
            languageToLocaleMap = new HashMap<Integer, String>();
            class StringAndInt {
                public String locale;
                public int msValue;

                public StringAndInt(String s, int v) {
                    this.locale = s;
                    this.msValue = v;
                }
            }
            StringAndInt[] mapping = new StringAndInt[]{new StringAndInt("af-ZA", 1078), new StringAndInt("sq-AL", 1052), new StringAndInt("gsw-FR", 1156), new StringAndInt("am-ET", 1118), new StringAndInt("ar-DZ", 5121), new StringAndInt("ar-BH", 15361), new StringAndInt("ar-EG", 3073), new StringAndInt("ar-IQ", 2049), new StringAndInt("ar-JO", 11265), new StringAndInt("ar-KW", 13313), new StringAndInt("ar-LB", 12289), new StringAndInt("ar-LY", 4097), new StringAndInt("ar-MA", 6145), new StringAndInt("ar-OM", 8193), new StringAndInt("ar-QA", 16385), new StringAndInt("ar-SA", 1025), new StringAndInt("ar-SY", 10241), new StringAndInt("ar-TN", 7169), new StringAndInt("ar-AE", 14337), new StringAndInt("ar-YE", 9217), new StringAndInt("ar", 1), new StringAndInt("hy-AM", 1067), new StringAndInt("as-IN", 1101), new StringAndInt("az", 44), new StringAndInt("az-cyrillic", 2092), new StringAndInt("az-AZ", 1068), new StringAndInt("ba-RU", 1133), new StringAndInt("eu", 1069), new StringAndInt("be-BY", 1059), new StringAndInt("bn-IN", 1093), new StringAndInt("bn-BD", 2117), new StringAndInt("bs-BA", 5146), new StringAndInt("br-FR", 1150), new StringAndInt("bg-BG", 1026), new StringAndInt("my-MM", 1109), new StringAndInt("ca-ES", 1027), new StringAndInt("chr-US", 1116), new StringAndInt("zh", 4), new StringAndInt("zh-HK", 3076), new StringAndInt("zh-MO", 5124), new StringAndInt("zh-CN", 2052), new StringAndInt("zh-SG", 4100), new StringAndInt("zh-TW", 1028), new StringAndInt("co-FR", 1155), new StringAndInt("hr-HR", 1050), new StringAndInt("hr-BA", 4122), new StringAndInt("cs-CZ", 1029), new StringAndInt("da-DK", 1030), new StringAndInt("gbz-AF", 1164), new StringAndInt("dv-MV", 1125), new StringAndInt("nl-NL", 1043), new StringAndInt("nl-BE", 2067), new StringAndInt("bin-NG", 1126), new StringAndInt("en", 9), new StringAndInt("en-AU", 3081), new StringAndInt("en-BZ", 10249), new StringAndInt("en-CA", 4105), new StringAndInt("en-BS", 9225), new StringAndInt("en-IE", 6153), new StringAndInt("en-HK", 15369), new StringAndInt("en-IN", 16393), new StringAndInt("en-ID", 14345), new StringAndInt("en-JM", 8201), new StringAndInt("en-MY", 17417), new StringAndInt("en-NZ", 5129), new StringAndInt("en-PH", 13321), new StringAndInt("en-ZA", 7177), new StringAndInt("en-SG", 18441), new StringAndInt("en-TT", 11273), new StringAndInt("en-GB", 2057), new StringAndInt("en-US", 1033), new StringAndInt("en-ZW", 12297), new StringAndInt("et-EE", 1061), new StringAndInt("fo-FO", 1080), new StringAndInt("fa-IR", 1065), new StringAndInt("fil-PH", 1124), new StringAndInt("fi-FI", 1035), new StringAndInt("fr-FR", 1036), new StringAndInt("fr-BE", 2060), new StringAndInt("fr-CM", 11276), new StringAndInt("fr-CA", 3084), new StringAndInt("fr-CI", 12300), new StringAndInt("fr-HT", 15372), new StringAndInt("fr-LU", 5132), new StringAndInt("fr-ML", 13324), new StringAndInt("fr-MC", 6156), new StringAndInt("fr-MA", 14348), new StringAndInt("fr", 58380), new StringAndInt("fr-RE", 8204), new StringAndInt("fr-SN", 10252), new StringAndInt("fr-CH", 4108), new StringAndInt("fr", 7180), new StringAndInt("fr-CD", 9228), new StringAndInt("fy-NL", 1122), new StringAndInt("ff-NG", 1127), new StringAndInt("ga-IE", 2108), new StringAndInt("gd-GB", 1084), new StringAndInt("gl-ES", 1110), new StringAndInt("ka-GE", 1079), new StringAndInt("de-DE", 1031), new StringAndInt("de-AT", 3079), new StringAndInt("de-LI", 5127), new StringAndInt("de-LU", 4103), new StringAndInt("de-CH", 2055), new StringAndInt("el-GR", 1032), new StringAndInt("gug-PY", 1140), new StringAndInt("gu-IN", 1095), new StringAndInt("ha-NG", 1128), new StringAndInt("haw-US", 1141), new StringAndInt("he-IL", 1037), new StringAndInt("hi-IN", 1081), new StringAndInt("hu-HU", 1038), new StringAndInt("is-IS", 1039), new StringAndInt("ig-NG", 1136), new StringAndInt("id-ID", 1057), new StringAndInt("iu-CA", 2141), new StringAndInt("it-IT", 1040), new StringAndInt("it-CH", 2064), new StringAndInt("ja-JP", 1041), new StringAndInt("kl-GL", 1135), new StringAndInt("kn-IN", 1099), new StringAndInt("kr-NG", 1137), new StringAndInt("ks", 1120), new StringAndInt("ks-IN", 2144), new StringAndInt("kk-KZ", 1087), new StringAndInt("km-KH", 1107), new StringAndInt("qut-GT", 1158), new StringAndInt("rw-RW", 1159), new StringAndInt("ky-KG", 1088), new StringAndInt("kok-IN", 1111), new StringAndInt("ko-KR", 1042), new StringAndInt("ko-KR", 2066), new StringAndInt("lo-LA", 1108), new StringAndInt("la-VA", 1142), new StringAndInt("lv-LV", 1062), new StringAndInt("lt-LT", 1063), new StringAndInt("lt-LT", 2087), new StringAndInt("lb-LU", 1134), new StringAndInt("mk-MK", 1071), new StringAndInt("ms", 62), new StringAndInt("ml-IN", 1100), new StringAndInt("ms-BN", 2110), new StringAndInt("ms-MY", 1086), new StringAndInt("mt-MT", 1082), new StringAndInt("mni-IN", 1112), new StringAndInt("mi-NZ", 1153), new StringAndInt("arn-CL", 1146), new StringAndInt("mr-IN", 1102), new StringAndInt("moh-CA", 1148), new StringAndInt("mn-MN", 1104), new StringAndInt("mn-MN", 2128), new StringAndInt("ne-NP", 1121), new StringAndInt("ne-IN", 2145), new StringAndInt("no-NO", 20), new StringAndInt("nb-NO", 1044), new StringAndInt("nn-NO", 2068), new StringAndInt("oc-FR", 1154), new StringAndInt("or-IN", 1096), new StringAndInt("om-ET", 1138), new StringAndInt("pap-AN", 1145), new StringAndInt("ps-AF", 1123), new StringAndInt("pl-PL", 1045), new StringAndInt("pt-PT", 2070), new StringAndInt("pt-BR", 1046), new StringAndInt("pa-IN", 1094), new StringAndInt("lah-PK", 2118), new StringAndInt("qu-BO", 1131), new StringAndInt("qu-EC", 2155), new StringAndInt("qu-PE", 3179), new StringAndInt("rm-CH", 1047), new StringAndInt("ro-RO", 1048), new StringAndInt("ro-MD", 2072), new StringAndInt("ru-RU", 1049), new StringAndInt("mo-MD", 2073), new StringAndInt("se-NO", 1083), new StringAndInt("smn-FI", 9275), new StringAndInt("smj-NO", 4155), new StringAndInt("smj-SE", 5179), new StringAndInt("se-FI", 3131), new StringAndInt("se-SE", 2107), new StringAndInt("sms-FI", 8251), new StringAndInt("sma-NO", 6203), new StringAndInt("sma-SE", 7227), new StringAndInt("sa-IN", 1103), new StringAndInt("nso-ZA", 1132), new StringAndInt("sr", 26), new StringAndInt("sr-YU", 3098), new StringAndInt("sr-BA", 7194), new StringAndInt("sh-YU", 2074), new StringAndInt("sh-BA", 6170), new StringAndInt("sh", 31770), new StringAndInt("st-ZA", 1072), new StringAndInt("sd-IN", 1113), new StringAndInt("sd-PK", 2137), new StringAndInt("si-LK", 1115), new StringAndInt("sk-SK", 1051), new StringAndInt("sl-SI", 1060), new StringAndInt("so-SO", 1143), new StringAndInt("hsb-DE", 1070), new StringAndInt("dsb-DE", 2094), new StringAndInt("es-ES", 1034), new StringAndInt("es-AR", 11274), new StringAndInt("es-BO", 16394), new StringAndInt("es-CL", 13322), new StringAndInt("es-CO", 9226), new StringAndInt("es-CR", 5130), new StringAndInt("es-DO", 7178), new StringAndInt("es-EC", 12298), new StringAndInt("es-SV", 17418), new StringAndInt("es-GT", 4106), new StringAndInt("es-HN", 18442), new StringAndInt("es", 58378), new StringAndInt("es-MX", 2058), new StringAndInt("es-ES", 3082), new StringAndInt("es-NI", 19466), new StringAndInt("es-PA", 6154), new StringAndInt("es-PY", 15370), new StringAndInt("es-PE", 10250), new StringAndInt("es-PR", 20490), new StringAndInt("es-US", 21514), new StringAndInt("es-UY", 14346), new StringAndInt("es-VE", 8202), new StringAndInt("sw-KE", 1089), new StringAndInt("sv-SE", 1053), new StringAndInt("sv-FI", 2077), new StringAndInt("syr-TR", 1114), new StringAndInt("tg-TJ", 1064), new StringAndInt("ta-IN", 1097), new StringAndInt("tt-RU", 1092), new StringAndInt("te-IN", 1098), new StringAndInt("th-TH", 1054), new StringAndInt("bo-CN", 1105), new StringAndInt("dz-BT", 2129), new StringAndInt("ti-ER", 2163), new StringAndInt("ti-ET", 1139), new StringAndInt("ts-ZA", 1073), new StringAndInt("tn-ZA", 1074), new StringAndInt("tr-TR", 1055), new StringAndInt("tk-TM", 1090), new StringAndInt("ug-CN", 1152), new StringAndInt("uk-UA", 1058), new StringAndInt("ur", 32), new StringAndInt("ur-IN", 2080), new StringAndInt("ur-PK", 1056), new StringAndInt("uz-UZ", 1091), new StringAndInt("ve-ZA", 1075), new StringAndInt("vi-VN", 1066), new StringAndInt("cy-GB", 1106), new StringAndInt("wo-SN", 1160), new StringAndInt("xh-ZA", 1076), new StringAndInt("sah-RU", 1157), new StringAndInt("ii-CN", 1144), new StringAndInt("yi-IL", 1085), new StringAndInt("yo-NG", 1130), new StringAndInt("zu-ZA", 1077), null};
            int index = 0;
            while (mapping[index] != null) {
                localeToLanguageMap.put(mapping[index].locale, mapping[index].msValue);
                languageToLocaleMap.put(mapping[index].msValue, mapping[index].locale);
                ++index;
            }
            localeToLanguageMap = Collections.unmodifiableMap(localeToLanguageMap);
            languageToLocaleMap = Collections.unmodifiableMap(languageToLocaleMap);
        }
    }

    public static String getLocaleFromLangCode(String languageCode) {
        if (languageToLocaleMap == null) {
            MapHelper.fillLocaleMaps();
        }
        String ret = "";
        try {
            int languageValue = Integer.parseInt(languageCode, 16);
            ret = languageToLocaleMap.get(languageValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret;
    }

    public static String getMSLangCode(String language, String country) {
        Integer entry;
        if (localeToLanguageMap == null) {
            MapHelper.fillLocaleMaps();
        }
        Object cmpString = new String(language);
        if (!country.isEmpty()) {
            cmpString = (String)cmpString + "-" + country;
        }
        if ((entry = localeToLanguageMap.get(cmpString)) != null) {
            return Integer.toHexString(entry);
        }
        return "";
    }

    public static void moveParaToCell(Map<String, Object> allHardFormatting) {
        JSONObject paraProps;
        if (allHardFormatting != null && allHardFormatting.containsKey("paragraph") && (paraProps = (JSONObject)allHardFormatting.get("paragraph")).has("alignment")) {
            if (!allHardFormatting.containsKey("cell")) {
                allHardFormatting.put("cell", new JSONObject());
            }
            JSONObject cellProps = (JSONObject)allHardFormatting.get("cell");
            try {
                cellProps.put("alignHor", paraProps.opt("alignment"));
                paraProps.remove("alignment");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }
}

