/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextConditionAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextCurrentValueAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStringValueIfFalseAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStringValueIfTrueAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class TextConditionalTextElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "conditional-text");

    public TextConditionalTextElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getTextConditionAttribute() {
        TextConditionAttribute attr = (TextConditionAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "condition");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextConditionAttribute(String textConditionValue) {
        TextConditionAttribute attr = new TextConditionAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textConditionValue);
    }

    public Boolean getTextCurrentValueAttribute() {
        TextCurrentValueAttribute attr = (TextCurrentValueAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "current-value");
        if (attr != null && !attr.getValue().isEmpty()) {
            return attr.booleanValue();
        }
        return null;
    }

    public void setTextCurrentValueAttribute(Boolean textCurrentValueValue) {
        TextCurrentValueAttribute attr = new TextCurrentValueAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setBooleanValue(textCurrentValueValue);
    }

    public String getTextStringValueIfFalseAttribute() {
        TextStringValueIfFalseAttribute attr = (TextStringValueIfFalseAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "string-value-if-false");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextStringValueIfFalseAttribute(String textStringValueIfFalseValue) {
        TextStringValueIfFalseAttribute attr = new TextStringValueIfFalseAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textStringValueIfFalseValue);
    }

    public String getTextStringValueIfTrueAttribute() {
        TextStringValueIfTrueAttribute attr = (TextStringValueIfTrueAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "string-value-if-true");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextStringValueIfTrueAttribute(String textStringValueIfTrueValue) {
        TextStringValueIfTrueAttribute attr = new TextStringValueIfTrueAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textStringValueIfTrueValue);
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }

    public void newTextNode(String content) {
        if (content != null && !content.equals("")) {
            this.appendChild(this.getOwnerDocument().createTextNode(content));
        }
    }
}

