/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;

import org.odftoolkit.odfdom.dom.element.script.ScriptEventListenerElement;
import org.odftoolkit.odfdom.dom.element.presentation.PresentationEventListenerElement;

/**
 * DOM implementation of OpenDocument element  {@odf.element office:event-listeners}.
 *
 */
public class OfficeEventListenersElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.OFFICE, "event-listeners" );


	/**
	 * Create the instance of <code>OfficeEventListenersElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public OfficeEventListenersElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element office:event-listeners}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}


	/**
	 * Create child element {@odf.element script:event-listener}.
	 *
     * @param scriptEventNameAttributeValue  the <code>String</code> value of <code>ScriptEventNameAttribute</code>, see {@odf.attribute  script:event-name} at specification
	 * @param scriptLanguageAttributeValue  the <code>String</code> value of <code>ScriptLanguageAttribute</code>, see {@odf.attribute  script:language} at specification
	 * @param scriptMacroNameAttributeValue  the <code>String</code> value of <code>ScriptMacroNameAttribute</code>, see {@odf.attribute  script:macro-name} at specification
	 * @return   return  the element {@odf.element script:event-listener}
	 * DifferentQName 
	 */
    
	public ScriptEventListenerElement newScriptEventListenerElement(String scriptEventNameAttributeValue, String scriptLanguageAttributeValue, String scriptMacroNameAttributeValue)
	{
		ScriptEventListenerElement  scriptEventListener = ((OdfFileDom)this.ownerDocument).newOdfElement(ScriptEventListenerElement.class);
		scriptEventListener.setScriptEventNameAttribute( scriptEventNameAttributeValue );
		scriptEventListener.setScriptLanguageAttribute( scriptLanguageAttributeValue );
		scriptEventListener.setScriptMacroNameAttribute( scriptMacroNameAttributeValue );
		this.appendChild( scriptEventListener);
		return  scriptEventListener;      
	}
    
	/**
	 * Create child element {@odf.element script:event-listener}.
	 *
     * @param scriptEventNameAttributeValue  the <code>String</code> value of <code>ScriptEventNameAttribute</code>, see {@odf.attribute  script:event-name} at specification
	 * @param scriptLanguageAttributeValue  the <code>String</code> value of <code>ScriptLanguageAttribute</code>, see {@odf.attribute  script:language} at specification
	 * @param xlinkHrefAttributeValue  the <code>String</code> value of <code>XlinkHrefAttribute</code>, see {@odf.attribute  xlink:href} at specification
	 * @param xlinkTypeAttributeValue  the <code>String</code> value of <code>XlinkTypeAttribute</code>, see {@odf.attribute  xlink:type} at specification
	 * @return   return  the element {@odf.element script:event-listener}
	 * DifferentQName 
	 */
    
	public ScriptEventListenerElement newScriptEventListenerElement(String scriptEventNameAttributeValue, String scriptLanguageAttributeValue, String xlinkHrefAttributeValue, String xlinkTypeAttributeValue)
	{
		ScriptEventListenerElement  scriptEventListener = ((OdfFileDom)this.ownerDocument).newOdfElement(ScriptEventListenerElement.class);
		scriptEventListener.setScriptEventNameAttribute( scriptEventNameAttributeValue );
		scriptEventListener.setScriptLanguageAttribute( scriptLanguageAttributeValue );
		scriptEventListener.setXlinkHrefAttribute( xlinkHrefAttributeValue );
		scriptEventListener.setXlinkTypeAttribute( xlinkTypeAttributeValue );
		this.appendChild( scriptEventListener);
		return  scriptEventListener;      
	}
    
	/**
	 * Create child element {@odf.element presentation:event-listener}.
	 *
     * @param presentationActionAttributeValue  the <code>String</code> value of <code>PresentationActionAttribute</code>, see {@odf.attribute  presentation:action} at specification
	 * @param scriptEventNameAttributeValue  the <code>String</code> value of <code>ScriptEventNameAttribute</code>, see {@odf.attribute  script:event-name} at specification
	 * @return   return  the element {@odf.element presentation:event-listener}
	 * DifferentQName 
	 */
    
	public PresentationEventListenerElement newPresentationEventListenerElement(String presentationActionAttributeValue, String scriptEventNameAttributeValue)
	{
		PresentationEventListenerElement  presentationEventListener = ((OdfFileDom)this.ownerDocument).newOdfElement(PresentationEventListenerElement.class);
		presentationEventListener.setPresentationActionAttribute( presentationActionAttributeValue );
		presentationEventListener.setScriptEventNameAttribute( scriptEventNameAttributeValue );
		this.appendChild( presentationEventListener);
		return  presentationEventListener;      
	}
    
}
