/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.changes;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.odftoolkit.odfdom.changes.Component;
import org.odftoolkit.odfdom.changes.MapHelper;
import org.odftoolkit.odfdom.changes.PageArea;
import org.odftoolkit.odfdom.changes.ParagraphListProperties;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeAutomaticStylesElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeMasterStylesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleListLevelLabelAlignmentElement;
import org.odftoolkit.odfdom.dom.element.style.StyleListLevelPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleBulletElement;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleElementBase;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleImageElement;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleNumberElement;
import org.odftoolkit.odfdom.dom.element.text.TextListStyleElement;
import org.odftoolkit.odfdom.dom.element.text.TextParagraphElementBase;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfDefaultStyle;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStylePageLayout;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.type.Length;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JsonOperationProducer {
    private static final Logger LOG = Logger.getLogger(JsonOperationProducer.class.getName());
    static final String BLACK = "#000000";
    private static String ODFDOM_GIT_BRANCH = System.getProperty("odfdom.git.branch");
    private static String ODFDOM_GIT_COMMIT_TIME = System.getProperty("odfdom.git.commit.time");
    private static String ODFDOM_GIT_COMMIT_DESCRIBE = System.getProperty("odfdom.git.commit.id.describe");
    private static String ODFDOM_GIT_URL = System.getProperty("odfdom.git.remote.origin.url");
    private final JSONArray mOperationQueue = new JSONArray();
    private final JSONObject mOperations = new JSONObject();
    private final JSONObject mDocumentAttributes = new JSONObject();
    Map knownStyles = new HashMap();
    Map knownListStyles = new HashMap();
    boolean mIsTableExceededStyleAdded = false;
    private static final String NUMBER_FORMAT_CODE = "code";
    private static final String NUMBER_FORMAT_CODE_STANDARD = "Standard";

    public JsonOperationProducer() {
        try {
            this.mDocumentAttributes.put("name", (Object)"noOp");
            this.mOperationQueue.put((Object)this.mDocumentAttributes);
            this.mOperations.put("editor", (Object)ODFDOM_GIT_URL);
            this.mOperations.put("version", (Object)ODFDOM_GIT_COMMIT_DESCRIBE);
            this.mOperations.put("version-branch", (Object)ODFDOM_GIT_BRANCH);
            this.mOperations.put("version-time", (Object)ODFDOM_GIT_COMMIT_TIME);
            this.mOperations.put("changes", (Object)this.mOperationQueue);
        }
        catch (JSONException e) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public JSONObject getDocumentOperations() {
        return this.mOperations;
    }

    public int getCurrentOperationIndex() {
        return this.mOperations.length() - 1;
    }

    public void add(String componentType, List<Integer> start, Map<String, Object> formattingProperties, String context) {
        JSONObject addComponentObject = new JSONObject();
        try {
            addComponentObject.put("name", (Object)("add" + componentType));
            addComponentObject.put("start", JsonOperationProducer.incrementAll(start));
            if (context != null) {
                addComponentObject.put("context", (Object)context);
            }
            if (formattingProperties != null && !formattingProperties.isEmpty()) {
                JSONObject attrs = new JSONObject();
                for (String arg : formattingProperties.keySet()) {
                    attrs.put(arg, formattingProperties.get(arg));
                }
                addComponentObject.put("attrs", (Object)attrs);
            }
            this.mOperationQueue.put((Object)addComponentObject);
            LOG.log(Level.FINEST, "add" + componentType + " - component:{0}", addComponentObject);
        }
        catch (JSONException e) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void addAnnotation(List<Integer> start, String id, String author, String date, String context) {
        JSONObject newOperation = new JSONObject();
        try {
            newOperation.put("name", (Object)"addNote");
            newOperation.put("start", JsonOperationProducer.incrementAll(start));
            newOperation.put("id", (Object)id);
            newOperation.put("author", (Object)author);
            newOperation.put("date", (Object)date);
            if (context != null) {
                newOperation.put("context", (Object)context);
            }
            this.mOperationQueue.put((Object)newOperation);
            LOG.log(Level.FINEST, "addNote - component:{0}", newOperation);
        }
        catch (JSONException e) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void addRange(List<Integer> start, String id, String context) {
        JSONObject newOperation = new JSONObject();
        try {
            newOperation.put("name", (Object)"addNoteSelection");
            newOperation.put("start", JsonOperationProducer.incrementAll(start));
            newOperation.put("id", (Object)id);
            newOperation.put("type", (Object)"comment");
            newOperation.put("position", (Object)"end");
            if (context != null) {
                newOperation.put("context", (Object)context);
            }
            this.mOperationQueue.put((Object)newOperation);
            LOG.log(Level.FINEST, "addNoteSelection - component:{0}", newOperation);
        }
        catch (JSONException e) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void formatColumns(List<Integer> start, Map<String, Object> formattingProperties, Integer firstColumn, Integer lastColumn, String context) {
        if (formattingProperties != null && !formattingProperties.isEmpty()) {
            JSONObject newOperation = new JSONObject();
            try {
                newOperation.put("name", (Object)"FormatColumns");
                newOperation.put("sheet", (Object)start.get(0));
                newOperation.put("start", (Object)firstColumn);
                if (context != null) {
                    newOperation.put("context", (Object)context);
                }
                if (lastColumn != null && !firstColumn.equals(lastColumn)) {
                    newOperation.put("end", (Object)lastColumn);
                }
                if (formattingProperties != null && !formattingProperties.isEmpty()) {
                    JSONObject attrs = new JSONObject();
                    for (String arg : formattingProperties.keySet()) {
                        attrs.put(arg, formattingProperties.get(arg));
                    }
                    newOperation.put("attrs", (Object)attrs);
                }
                this.mOperationQueue.put((Object)newOperation);
                LOG.log(Level.FINEST, "changeColumns - component:{0}", newOperation);
            }
            catch (JSONException e) {
                Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }

    public void formatRows(List<Integer> start, Map<String, Object> formattingProperties, Integer firstRow, Integer lastRow, Integer previousRowRepeated, String context) {
        if (formattingProperties != null && !formattingProperties.isEmpty()) {
            JSONObject newOperation = new JSONObject();
            try {
                newOperation.put("name", (Object)"changeRows");
                newOperation.put("sheet", (Object)start.get(0));
                newOperation.put("start", firstRow + previousRowRepeated);
                if (context != null) {
                    newOperation.put("context", (Object)context);
                }
                if (lastRow != null && !firstRow.equals(lastRow)) {
                    newOperation.put("end", lastRow + previousRowRepeated);
                }
                JSONObject attrs = new JSONObject();
                for (String arg : formattingProperties.keySet()) {
                    attrs.put(arg, formattingProperties.get(arg));
                }
                newOperation.put("attrs", (Object)attrs);
                this.mOperationQueue.put((Object)newOperation);
                LOG.log(Level.FINEST, "changeRows - component:{0}", newOperation);
            }
            catch (JSONException e) {
                Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }

    private JSONObject getCellNumberFormat(String valueType) {
        JSONObject cellNumberFormat = new JSONObject();
        try {
            if (valueType == null || valueType.isEmpty()) {
                cellNumberFormat.put(NUMBER_FORMAT_CODE, (Object)NUMBER_FORMAT_CODE_STANDARD);
            } else {
                cellNumberFormat.put(NUMBER_FORMAT_CODE, (Object)NUMBER_FORMAT_CODE_STANDARD);
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return cellNumberFormat;
    }

    private void addRange(int sheet, Integer firstRow, Integer lastRow, int repeatedRowOffset, int firstContentCell, int horizontalRepetition, JSONObject repeatedCell, JSONArray singleRow, boolean hasHorizontalRepetition) {
        int rowStartNo = firstRow + repeatedRowOffset;
        LinkedList<Integer> rangeStart = new LinkedList<Integer>();
        if (hasHorizontalRepetition || lastRow != null && !firstRow.equals(lastRow)) {
            rangeStart.add(firstContentCell);
            rangeStart.add(rowStartNo);
            LinkedList<Integer> rangeEnd = new LinkedList<Integer>();
            rangeEnd.add(firstContentCell + horizontalRepetition - 1);
            int rowEndNo = lastRow + repeatedRowOffset;
            rangeEnd.add(rowEndNo);
            this.fillCellRange(sheet, rangeStart, rangeEnd, repeatedCell);
        } else {
            rangeStart.add(firstContentCell);
            rangeStart.add(rowStartNo);
            this.setCellContents(sheet, rangeStart, singleRow);
        }
    }

    private void setCellContents(Integer sheet, List rangeStart, JSONArray spreadsheetRange) {
        JSONObject newOperation = new JSONObject();
        try {
            newOperation.put("name", (Object)"setCellContents");
            newOperation.put("sheet", (Object)sheet);
            newOperation.put("start", (Collection)rangeStart);
            newOperation.put("contents", (Object)new JSONArray().put((Object)spreadsheetRange));
            this.mOperationQueue.put((Object)newOperation);
            LOG.log(Level.FINEST, "setCellContents - component:{0}", newOperation);
        }
        catch (JSONException e) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void mergeCells(List<Integer> position, int columns, int rows) {
        JSONObject newOperation = new JSONObject();
        LinkedList<Integer> rangeStart = new LinkedList<Integer>();
        rangeStart.add(position.get(2));
        rangeStart.add(position.get(1));
        LinkedList<Integer> rangeEnd = new LinkedList<Integer>();
        rangeEnd.add(position.get(2) + columns - 1);
        rangeEnd.add(position.get(1) + rows - 1);
        try {
            newOperation.put("name", (Object)"mergeCells");
            newOperation.put("sheet", (Object)position.get(0));
            newOperation.put("start", rangeStart);
            newOperation.put("end", rangeEnd);
            newOperation.put("type", (Object)"merge");
            this.mOperationQueue.put((Object)newOperation);
            LOG.log(Level.FINEST, "mergeCells - component:{0}", newOperation);
        }
        catch (JSONException e) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private void fillCellRange(int sheet, List<Integer> start, List<Integer> end, JSONObject cell) {
        JSONObject newOperation = new JSONObject();
        try {
            if (cell != null && cell.length() != 0) {
                newOperation.put("name", (Object)"fillCellRange");
                newOperation.put("sheet", sheet);
                newOperation.put("start", JsonOperationProducer.incrementAll(start));
                if (end != null) {
                    newOperation.put("end", JsonOperationProducer.incrementAll(end));
                }
                if (cell.has("value")) {
                    newOperation.put("value", cell.get("value"));
                }
                if (cell.has("attrs")) {
                    newOperation.put("attrs", cell.get("attrs"));
                }
                this.mOperationQueue.put((Object)newOperation);
                LOG.log(Level.FINEST, "fillCellRange - component:{0}", newOperation);
            }
        }
        catch (JSONException e) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void addText(List<Integer> start, String text, String context) {
        JSONObject newOperation = new JSONObject();
        try {
            newOperation.put("text", (Object)text);
            newOperation.put("start", JsonOperationProducer.incrementAll(start));
            if (context != null) {
                newOperation.put("context", (Object)context);
            }
            newOperation.put("name", (Object)"addText");
            this.mOperationQueue.put((Object)newOperation);
            LOG.log(Level.FINEST, newOperation.toString());
        }
        catch (JSONException e) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    void format(List<Integer> start, Map<String, Object> attrs, String context) {
        this.format(start, null, attrs, context);
    }

    public void format(List<Integer> start, List<Integer> end, Map<String, Object> attrs, String context) {
        if (attrs != null && attrs.size() > 0) {
            JSONObject newOp = new JSONObject();
            LinkedList<Integer> lastCharacterPos = new LinkedList<Integer>();
            if (end != null) {
                for (int i = 0; i < end.size(); ++i) {
                    Integer pos = end.get(i);
                    if (i == end.size() - 1 && pos != 0) {
                        Integer n = pos;
                        pos = pos - 1;
                    }
                    lastCharacterPos.add(pos);
                }
            }
            try {
                newOp.put("name", (Object)"format");
                newOp.put("start", JsonOperationProducer.incrementAll(start));
                if (context != null) {
                    newOp.put("context", (Object)context);
                }
                boolean isValidOperation = true;
                if (end != null) {
                    newOp.put("end", JsonOperationProducer.incrementAll(lastCharacterPos));
                    if (start.get(start.size() - 1) > (Integer)lastCharacterPos.get(start.size() - 1)) {
                        isValidOperation = false;
                        LOG.fine("Neglecting '" + newOp.toString());
                    }
                }
                newOp.put("attrs", attrs);
                if (isValidOperation) {
                    this.mOperationQueue.put((Object)newOp);
                }
                LOG.log(Level.FINEST, "New Operation 'format':" + newOp);
            }
            catch (JSONException e) {
                Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }

    public void addImage(List<Integer> start, Map<String, Object> hardFormatations, String context) {
        JSONObject newOperation = new JSONObject();
        try {
            newOperation.put("name", (Object)"addDrawing");
            newOperation.put("type", (Object)"image");
            newOperation.put("start", JsonOperationProducer.incrementAll(start));
            if (context != null) {
                newOperation.put("context", (Object)context);
            }
            if (hardFormatations != null) {
                newOperation.put("attrs", hardFormatations);
            }
            this.mOperationQueue.put((Object)newOperation);
            LOG.log(Level.FINEST, "addDrawing (image) - component:{0}", newOperation);
        }
        catch (JSONException e) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void addShape(List<Integer> start, Map<String, Object> hardFormatations, String context, boolean isGroup) {
        JSONObject newOperation = new JSONObject();
        try {
            newOperation.put("name", (Object)"addDrawing");
            newOperation.put("type", (Object)(isGroup ? "group" : "shape"));
            newOperation.put("start", JsonOperationProducer.incrementAll(start));
            if (context != null) {
                newOperation.put("context", (Object)context);
            }
            if (hardFormatations != null) {
                newOperation.put("attrs", hardFormatations);
            }
            this.mOperationQueue.put((Object)newOperation);
            LOG.log(Level.FINEST, "addDrawing (shape) - component:{0}", newOperation);
        }
        catch (JSONException e) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void addTable(List<Integer> start, Map<String, Object> hardFormatations, List<Integer> tableGrid, String tableName, String context) {
        JSONObject newOperation = new JSONObject();
        try {
            newOperation.put("name", (Object)"addTable");
            newOperation.put("start", JsonOperationProducer.incrementAll(start));
            if (context != null) {
                newOperation.put("context", (Object)context);
            }
            JSONObject tableAttrs = null;
            if (hardFormatations != null && !hardFormatations.isEmpty()) {
                tableAttrs = (JSONObject)hardFormatations.get("table");
            } else if (hardFormatations == null) {
                hardFormatations = new HashMap<String, Object>();
            }
            if (tableAttrs == null) {
                tableAttrs = new JSONObject();
            }
            if (tableGrid != null) {
                tableAttrs.put("tableGrid", tableGrid);
            }
            hardFormatations.put("table", tableAttrs);
            newOperation.put("attrs", hardFormatations);
            this.mOperationQueue.put((Object)newOperation);
            LOG.log(Level.FINEST, "addTable - component:{0}", newOperation);
        }
        catch (JSONException e) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private void addTableExceededStyle() {
        try {
            JSONArray operations = new JSONArray("[{\"styleName\":\"Exceeded Table Style\",\"styleId\":\"LightShading-Accent1\",\"attrs\":{\"firstRow\":{\"paragraph\":{\"marginBottom\":0,\"lineHeight\":{\"value\":100,\"type\":\"percent\"},\"marginTop\":0},\"cell\":{\"borderInsideVert\":{\"style\":\"none\"},\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"accent1\",\"type\":\"scheme\"},\"width\":35},\"borderInsideHor\":{\"style\":\"none\"},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"accent1\",\"type\":\"scheme\"},\"width\":35},\"borderRight\":{\"style\":\"none\"},\"borderLeft\":{\"style\":\"none\"}},\"character\":{\"bold\":true}},\"lastRow\":{\"paragraph\":{\"marginBottom\":0,\"lineHeight\":{\"value\":100,\"type\":\"percent\"},\"marginTop\":0},\"cell\":{\"borderInsideVert\":{\"style\":\"none\"},\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"accent1\",\"type\":\"scheme\"},\"width\":35},\"borderInsideHor\":{\"style\":\"none\"},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"accent1\",\"type\":\"scheme\"},\"width\":35},\"borderRight\":{\"style\":\"none\"},\"borderLeft\":{\"style\":\"none\"}},\"character\":{\"bold\":true}},\"band1Hor\":{\"cell\":{\"borderInsideVert\":{\"style\":\"none\"},\"fillColor\":{\"value\":\"accent1\",\"type\":\"scheme\",\"transformations\":[{\"value\":24706,\"type\":\"tint\"}]},\"borderInsideHor\":{\"style\":\"none\"},\"borderRight\":{\"style\":\"none\"},\"borderLeft\":{\"style\":\"none\"}}},\"lastCol\":{\"character\":{\"bold\":true}},\"wholeTable\":{\"paragraph\":{\"marginBottom\":0,\"lineHeight\":{\"value\":100,\"type\":\"percent\"}},\"table\":{\"paddingTop\":0,\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"accent1\",\"type\":\"scheme\"},\"width\":35},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"accent1\",\"type\":\"scheme\"},\"width\":35},\"paddingBottom\":0,\"paddingLeft\":190,\"paddingRight\":190},\"character\":{\"color\":{\"value\":\"accent1\",\"type\":\"scheme\",\"transformations\":[{\"value\":74902,\"type\":\"shade\"}]}}},\"band1Vert\":{\"cell\":{\"borderInsideVert\":{\"style\":\"none\"},\"fillColor\":{\"value\":\"accent1\",\"type\":\"scheme\",\"transformations\":[{\"value\":24706,\"type\":\"tint\"}]},\"borderInsideHor\":{\"style\":\"none\"},\"borderRight\":{\"style\":\"none\"},\"borderLeft\":{\"style\":\"none\"}}},\"firstCol\":{\"character\":{\"bold\":true}}},\"parent\":\"TableNormal\",\"uiPriority\":60,\"type\":\"table\",\"name\": \"addStyle\"}]");
            this.mOperationQueue.put(operations.get(0));
        }
        catch (JSONException ex) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void addExceededTable(List<Integer> start, int columns, int rows, List<Integer> tableGrid, String context) {
        JSONObject newOperation = new JSONObject();
        if (!this.mIsTableExceededStyleAdded) {
            this.addTableExceededStyle();
            this.mIsTableExceededStyleAdded = true;
        }
        try {
            newOperation.put("name", (Object)"addTable");
            newOperation.put("start", JsonOperationProducer.incrementAll(start));
            if (context != null) {
                newOperation.put("context", (Object)context);
            }
            HashMap<String, Integer> sizeExceeded = new HashMap<String, Integer>();
            sizeExceeded.put("columns", columns);
            sizeExceeded.put("rows", rows);
            newOperation.put("sizeExceeded", sizeExceeded);
            HashMap<String, JSONObject> hardFormatations = new HashMap<String, JSONObject>();
            JSONObject tableAttrs = new JSONObject();
            tableAttrs.put("tableGrid", tableGrid);
            tableAttrs.put("style", (Object)"LightShading-Accent1");
            tableAttrs.put("width", (Object)"auto");
            ArrayList<String> exclude = new ArrayList<String>(3);
            exclude.add("lastRow");
            exclude.add("lastCol");
            exclude.add("bandsVert");
            tableAttrs.put("exclude", exclude);
            hardFormatations.put("table", tableAttrs);
            newOperation.put("attrs", hardFormatations);
            this.mOperationQueue.put((Object)newOperation);
            LOG.log(Level.FINEST, "addTable - component:{0}", newOperation);
        }
        catch (JSONException e) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void addField(List<Integer> start, String fieldType, String fieldContent, Map<String, Object> fieldAttributes, String context) {
        JSONObject newOperation = new JSONObject();
        try {
            newOperation.put("name", (Object)"addField");
            newOperation.put("start", JsonOperationProducer.incrementAll(start));
            if (context != null) {
                newOperation.put("context", (Object)context);
            }
            newOperation.put("type", (Object)fieldType);
            if (fieldAttributes != null && !fieldAttributes.isEmpty()) {
                JSONObject attrs = new JSONObject();
                JSONObject fieldAttrs = new JSONObject();
                for (Map.Entry<String, Object> entry : fieldAttributes.entrySet()) {
                    fieldAttrs.put(entry.getKey(), entry.getValue());
                }
                attrs.put("field", (Object)fieldAttrs);
                newOperation.put("attrs", (Object)attrs);
            }
            if (fieldContent != null) {
                newOperation.put("representation", (Object)fieldContent);
            } else {
                newOperation.put("representation", (Object)"");
            }
            this.mOperationQueue.put((Object)newOperation);
            LOG.log(Level.FINEST, "addField - component:{0}", newOperation);
        }
        catch (JSONException e) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    void addAutoFilterColumn(List<Integer> start, int sheet, List<String> entries) {
        JSONObject newOperation = new JSONObject();
        try {
            newOperation.put("name", (Object)"changeTableColumn");
            newOperation.put("col", (Object)start.get(0));
            newOperation.put("sheet", sheet);
            newOperation.put("table", (Object)"");
            JSONObject attrs = new JSONObject();
            JSONObject filterAttrs = new JSONObject();
            filterAttrs.put("type", (Object)(entries.isEmpty() ? "none" : "discrete"));
            if (!entries.isEmpty()) {
                JSONArray entryArray = new JSONArray();
                for (String entry : entries) {
                    entryArray.put((Object)entry);
                }
                filterAttrs.put("entries", (Object)entryArray);
            }
            attrs.put("filter", (Object)filterAttrs);
            newOperation.put("attrs", (Object)attrs);
            this.mOperationQueue.put((Object)newOperation);
            LOG.log(Level.FINEST, "changeTableColumn - component:{0}", newOperation);
        }
        catch (JSONException e) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void addStyleSheet(String styleId, String familyID, String displayName, Map<String, Object> componentProps, String parentStyle, String nextStyleId, Integer outlineLevel, boolean isDefaultStyle, boolean isHidden, String custom) {
        JSONObject newOperation = new JSONObject();
        try {
            newOperation.put("name", (Object)"addStyle");
            if (styleId != null && !styleId.isEmpty()) {
                newOperation.put("styleId", (Object)styleId);
            }
            newOperation.put("type", (Object)familyID);
            if (displayName != null && !displayName.isEmpty()) {
                newOperation.put("styleName", (Object)displayName);
            }
            if (familyID.equals("table")) {
                JSONObject tableStyleAttrs = new JSONObject();
                tableStyleAttrs.put("wholeTable", componentProps);
                newOperation.put("attrs", (Object)tableStyleAttrs);
            } else {
                newOperation.put("attrs", componentProps);
            }
            if (parentStyle != null && !parentStyle.isEmpty()) {
                newOperation.put("parent", (Object)parentStyle);
            }
            if (isDefaultStyle) {
                newOperation.put("default", isDefaultStyle);
            }
            if (isHidden) {
                newOperation.put("hidden", isHidden);
            }
            if (outlineLevel != null || nextStyleId != null) {
                JSONObject paraProps;
                if (componentProps.containsKey("paragraph")) {
                    paraProps = (JSONObject)componentProps.get("paragraph");
                } else {
                    paraProps = new JSONObject();
                    componentProps.put("paragraph", paraProps);
                }
                if (outlineLevel != null) {
                    paraProps.put("outlineLevel", (Object)outlineLevel);
                }
                if (nextStyleId != null && !nextStyleId.isEmpty()) {
                    paraProps.put("nextStyleId", (Object)nextStyleId);
                }
                componentProps.put("paragraph", paraProps);
                newOperation.put("attrs", componentProps);
            }
            if (null != custom && Boolean.parseBoolean(custom)) {
                newOperation.put("custom", true);
            }
            this.mOperationQueue.put((Object)newOperation);
            LOG.log(Level.FINEST, "addStyle - component:{0}", newOperation);
        }
        catch (JSONException e) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void addFontData(String fontName, String[] altNames, String family, String familyGeneric, String pitch, String panose1) {
        LinkedList<Integer> panose1_Integers = null;
        if (panose1 != null && !panose1.isEmpty()) {
            String[] result = null;
            if (panose1.contains("[")) {
                panose1 = panose1.substring(1, panose1.length() - 1);
            }
            result = panose1.contains(",") ? panose1.split(",") : panose1.split("\\s");
            panose1_Integers = new LinkedList<Integer>();
            for (String token : result) {
                try {
                    panose1_Integers.add(Integer.parseInt(token));
                }
                catch (NumberFormatException e) {
                    Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
                }
            }
        }
        this.addFontData(fontName, altNames, family, familyGeneric, pitch, panose1_Integers);
    }

    private void addFontData(String fontName, String[] altNames, String family, String familyGeneric, String pitch, List<Integer> panose1) {
        JSONObject newOperation = new JSONObject();
        JSONObject attrs = new JSONObject();
        try {
            newOperation.put("name", (Object)"addFontDecl");
            if (fontName != null && !fontName.isEmpty()) {
                newOperation.put("fontName", (Object)fontName);
            } else {
                LOG.fine("The font name is mandatory!");
            }
            newOperation.put("attrs", (Object)attrs);
            if (family != null && !family.isEmpty()) {
                attrs.put("family", (Object)family);
            }
            if (familyGeneric != null && !familyGeneric.isEmpty()) {
                attrs.put("familyGeneric", (Object)familyGeneric);
            }
            if (pitch != null && !pitch.isEmpty()) {
                attrs.put("pitch", (Object)pitch);
            }
            if (panose1 != null && !panose1.isEmpty()) {
                if (panose1.size() != 10) {
                    LOG.fine("Panose1 is not 10 digits long: " + panose1.toString());
                }
                attrs.put("panose1", panose1);
            }
            this.mOperationQueue.put((Object)newOperation);
            LOG.log(Level.FINEST, "addFontDecl - component:{0}", newOperation);
        }
        catch (JSONException e) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void addDocumentData(JSONObject componentProps) {
        try {
            this.mDocumentAttributes.put("attrs", (Object)componentProps);
            this.mDocumentAttributes.put("name", (Object)"documentLayout");
            LOG.log(Level.FINEST, "documentLayout - component:{0}", this.mDocumentAttributes);
        }
        catch (JSONException e) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private String getComponentPath(List<Integer> pathIntegers) {
        StringBuilder path = new StringBuilder();
        for (Integer pathInteger : pathIntegers) {
            path.append('/');
            path.append(pathInteger);
        }
        return path.toString();
    }

    public static String getListStyle(ArrayDeque<ParagraphListProperties> listStyleStack, TextParagraphElementBase p) {
        ParagraphListProperties paraListStyle;
        String listStyleId = null;
        Iterator<ParagraphListProperties> listStyles = listStyleStack.descendingIterator();
        while (listStyles.hasNext() && ((listStyleId = (paraListStyle = listStyles.next()).getListStyleName()) == null || listStyleId.isEmpty())) {
        }
        if (listStyleId == null || listStyleId.isEmpty()) {
            OdfStyle style = null;
            style = p.hasAutomaticStyle() ? p.getAutomaticStyle() : p.getDocumentStyle();
            if (style != null) {
                listStyleId = style.getStyleListStyleNameAttribute();
            }
        }
        return listStyleId;
    }

    static Map<String, Object> getAutomaticStyleHierarchyProps(OdfStylableElement styleElement) {
        Map<String, Object> allHardFormatting = null;
        HashMap<String, Map<String, String>> allOdfProps = null;
        if (styleElement.hasAutomaticStyle()) {
            try {
                Node n;
                OdfStyle style = styleElement.getAutomaticStyle();
                allOdfProps = new HashMap<String, Map<String, String>>();
                LinkedList<OdfStyleBase> parents = new LinkedList<OdfStyleBase>();
                parents.add(style);
                for (OdfStyleBase parent = ((OdfStyleBase)style).getParentStyle(); parent != null && !((n = parent.getParentNode()) instanceof OdfOfficeStyles); parent = parent.getParentStyle()) {
                    parents.add(parent);
                }
                boolean numberFormatInserted = false;
                OdfOfficeStyles officeStyles = null;
                OdfOfficeAutomaticStyles automaticStyles = null;
                OdfFileDom fileDom = (OdfFileDom)((Object)styleElement.getOwnerDocument());
                OdfDocument doc = (OdfDocument)fileDom.getDocument();
                officeStyles = doc.getStylesDom().getOfficeStyles();
                OdfStylesDom stylesDom = null;
                if (fileDom instanceof OdfStylesDom) {
                    stylesDom = (OdfStylesDom)fileDom;
                    automaticStyles = stylesDom.getAutomaticStyles();
                } else {
                    automaticStyles = doc.getContentDom().getAutomaticStyles();
                }
                for (int i = parents.size() - 1; i >= 0; --i) {
                    OdfStyleBase styleBase = (OdfStyleBase)parents.get(i);
                    MapHelper.getStyleProperties(styleBase, styleElement, allOdfProps);
                    numberFormatInserted |= MapHelper.putNumberFormat(null, allOdfProps, (OdfStyle)styleBase, automaticStyles, officeStyles);
                }
                allHardFormatting = MapHelper.mapStyleProperties(styleElement, allOdfProps);
                if (numberFormatInserted) {
                    Map cellProps = (Map)allOdfProps.get("cell");
                    JSONObject jsonCellProps = null;
                    jsonCellProps = allHardFormatting.containsKey("cell") ? (JSONObject)allHardFormatting.get("cell") : new JSONObject();
                    String formatCode = (String)cellProps.get("numberformat_code");
                    jsonCellProps.put("formatCode", (Object)formatCode);
                    allHardFormatting.put("cell", jsonCellProps);
                }
            }
            catch (SAXException ex) {
                Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return allHardFormatting;
    }

    public Map<String, Object> getHardStyles(OdfStylableElement styleElement) {
        Map<String, Object> allHardFormatting = null;
        if (styleElement.hasAutomaticStyle()) {
            allHardFormatting = JsonOperationProducer.getAutomaticStyleHierarchyProps(styleElement);
        }
        return allHardFormatting;
    }

    public void addListStyle(OdfSchemaDocument doc, Map<String, TextListStyleElement> autoListStyles, String styleId) {
        if (styleId != null & !styleId.isEmpty() && !this.knownListStyles.containsKey(styleId)) {
            try {
                TextListStyleElement listStyle = autoListStyles.get(styleId);
                if (listStyle != null) {
                    this.addListStyle(listStyle);
                } else {
                    OfficeAutomaticStylesElement autoStyles = doc.getStylesDom().getAutomaticStyles();
                    if (autoStyles != null) {
                        listStyle = autoStyles.getListStyle(styleId);
                        if (listStyle != null) {
                            this.addListStyle(listStyle);
                        }
                    } else {
                        OdfOfficeStyles templateStyles = doc.getStylesDom().getOfficeStyles();
                        if (templateStyles != null && (listStyle = templateStyles.getListStyle(styleId)) != null) {
                            this.addListStyle(listStyle);
                        }
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void addListStyle(TextListStyleElement listStyle) {
        String styleId;
        if (listStyle != null && !this.knownListStyles.containsKey(styleId = listStyle.getStyleNameAttribute())) {
            this.knownListStyles.put(styleId, Boolean.TRUE);
            this.addListStyle(listStyle.getStyleNameAttribute(), listStyle.getStyleDisplayNameAttribute(), listStyle.getTextConsecutiveNumberingAttribute(), this.getListLevelDefinitions(listStyle));
        }
    }

    private JSONObject getListLevelDefinitions(TextListStyleElement listStyle) {
        JSONObject listDefinition = new JSONObject((Object)9);
        NodeList listStyleChildren = listStyle.getChildNodes();
        int size = listStyleChildren.getLength();
        for (int i = 0; i < size; ++i) {
            Node child = listStyleChildren.item(i);
            if (!(child instanceof Element)) continue;
            TextListLevelStyleElementBase listLevelStyle = (TextListLevelStyleElementBase)((Object)child);
            String textLevel = listLevelStyle.getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "level");
            int listLevel = Integer.parseInt(textLevel) - 1;
            try {
                listDefinition.put("listLevel" + listLevel, (Object)this.createListLevelDefinition(listLevelStyle, listLevel));
                continue;
            }
            catch (JSONException ex) {
                Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return listDefinition;
    }

    private JSONObject createListLevelDefinition(TextListLevelStyleElementBase listLevelStyle, int listLevel) throws JSONException {
        StyleListLevelPropertiesElement styleListLevelProperties;
        NodeList listLevelProps;
        JSONObject listLevelDefinition = new JSONObject();
        if (listLevelStyle instanceof TextListLevelStyleNumberElement) {
            TextListLevelStyleNumberElement listLevelNumberStyle = (TextListLevelStyleNumberElement)listLevelStyle;
            listLevelDefinition.put("levelText", (Object)this.getLabel(listLevelNumberStyle, listLevel));
            if (listLevelStyle.hasAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "start-value")) {
                String listStartValue = this.getListStartValue(listLevelNumberStyle);
                listLevelDefinition.put("listStartValue", Integer.parseInt(listStartValue));
            }
            listLevelDefinition.put("numberFormat", (Object)this.getNumberFormat(listLevelNumberStyle));
        } else if (listLevelStyle instanceof TextListLevelStyleBulletElement) {
            TextListLevelStyleBulletElement listLevelBulletStyle = (TextListLevelStyleBulletElement)listLevelStyle;
            listLevelDefinition.put("levelText", (Object)this.getLabel(listLevelBulletStyle, listLevel));
            if (listLevelStyle.hasAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "bullet-relative-size")) {
                listLevelDefinition.put("bulletRelativeSize", (Object)listLevelStyle.getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "bullet-relative-size"));
            }
            listLevelDefinition.put("numberFormat", (Object)"bullet");
        } else if (listLevelStyle instanceof TextListLevelStyleImageElement) {
            listLevelDefinition.put("levelPicBulletUri", (Object)listLevelStyle.getAttributeNS(OdfDocumentNamespace.XLINK.getUri(), "href"));
            listLevelDefinition.put("numberFormat", (Object)"bullet");
        }
        if (listLevelStyle.hasAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "style-name")) {
            listLevelDefinition.put("styleId", (Object)listLevelStyle.getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "style-name"));
        }
        if ((listLevelProps = listLevelStyle.getElementsByTagNameNS(OdfDocumentNamespace.STYLE.getUri(), "list-level-properties")) != null && (styleListLevelProperties = (StyleListLevelPropertiesElement)((Object)listLevelProps.item(0))) != null) {
            NodeList nl;
            String minLabelDistanceValue;
            int width;
            String widthValue;
            String heightValue;
            if (styleListLevelProperties.hasAttributeNS(OdfDocumentNamespace.FO.getUri(), "height") && (heightValue = styleListLevelProperties.getAttributeNS(OdfDocumentNamespace.FO.getUri(), "height")) != null) {
                int height = MapHelper.normalizeLength(heightValue);
                listLevelDefinition.put("height", height);
            }
            if (styleListLevelProperties.hasAttributeNS(OdfDocumentNamespace.FO.getUri(), "text-align")) {
                listLevelDefinition.put("textAlign", (Object)MapHelper.mapFoTextAlign(styleListLevelProperties.getAttributeNS(OdfDocumentNamespace.FO.getUri(), "text-align")));
            }
            if (styleListLevelProperties.hasAttributeNS(OdfDocumentNamespace.FO.getUri(), "width") && (widthValue = styleListLevelProperties.getAttributeNS(OdfDocumentNamespace.FO.getUri(), "width")) != null) {
                width = MapHelper.normalizeLength(widthValue);
                listLevelDefinition.put("width", width);
            }
            if (styleListLevelProperties.hasAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "font-name")) {
                listLevelDefinition.put("fontName", (Object)styleListLevelProperties.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "font-name"));
            }
            if (styleListLevelProperties.hasAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "vertical-pos")) {
                listLevelDefinition.put("verticalPos", (Object)styleListLevelProperties.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "vertical-pos"));
            }
            if (styleListLevelProperties.hasAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "vertical-rel")) {
                listLevelDefinition.put("verticalRel", (Object)styleListLevelProperties.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "vertical-rel"));
            }
            if (styleListLevelProperties.hasAttributeNS(OdfDocumentNamespace.SVG.getUri(), "y")) {
                listLevelDefinition.put("y", (Object)styleListLevelProperties.getAttributeNS(OdfDocumentNamespace.SVG.getUri(), "y"));
            }
            if (styleListLevelProperties.hasAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "list-level-position-and-space-mode")) {
                listLevelDefinition.put("listLevelPositionAndSpaceMode", (Object)styleListLevelProperties.getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "list-level-position-and-space-mode"));
            }
            if (styleListLevelProperties.hasAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "min-label-distance") && (minLabelDistanceValue = styleListLevelProperties.getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "min-label-distance")) != null && !minLabelDistanceValue.isEmpty()) {
                int minLabelDistance = MapHelper.normalizeLength(minLabelDistanceValue);
                listLevelDefinition.put("minLabelDistance", minLabelDistance);
            }
            String minLabelWidthValue = null;
            if (styleListLevelProperties.hasAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "min-label-width") && (minLabelWidthValue = styleListLevelProperties.getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "min-label-width")) != null && !minLabelWidthValue.isEmpty()) {
                width = MapHelper.normalizeLength(minLabelWidthValue);
                listLevelDefinition.put("minLabelWidth", width);
            }
            String spaceBeforeValue = null;
            if (styleListLevelProperties.hasAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "space-before") && (spaceBeforeValue = styleListLevelProperties.getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "space-before")) != null && !spaceBeforeValue.isEmpty()) {
                int spaceBefore = MapHelper.normalizeLength(spaceBeforeValue);
                listLevelDefinition.put("spaceBefore", spaceBefore);
            }
            listLevelDefinition = JsonOperationProducer.mapIndent(minLabelWidthValue, spaceBeforeValue, listLevelDefinition);
            if (styleListLevelProperties.hasAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "list-level-position-and-space-mode") && "label-alignment".equals(styleListLevelProperties.getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "list-level-position-and-space-mode")) && (nl = styleListLevelProperties.getElementsByTagNameNS(OdfDocumentNamespace.STYLE.getUri(), "list-level-label-alignment")) != null && nl.getLength() == 1) {
                String tabPosition;
                StyleListLevelLabelAlignmentElement labelAlignmentElement = (StyleListLevelLabelAlignmentElement)((Object)nl.item(0));
                String marginLeft = labelAlignmentElement.getAttributeNS(OdfDocumentNamespace.FO.getUri(), "margin-left");
                int margin = 0;
                if (marginLeft != null && !marginLeft.isEmpty()) {
                    margin = MapHelper.normalizeLength(marginLeft);
                    listLevelDefinition.put("indentLeft", margin);
                } else {
                    listLevelDefinition = JsonOperationProducer.mapIndent(minLabelWidthValue, spaceBeforeValue, listLevelDefinition);
                }
                String textIndent = labelAlignmentElement.getAttributeNS(OdfDocumentNamespace.FO.getUri(), "text-indent");
                if (textIndent != null && !textIndent.isEmpty()) {
                    int indent = MapHelper.normalizeLength(textIndent);
                    listLevelDefinition.put("indentFirstLine", indent);
                }
                if (labelAlignmentElement.hasAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "list-tab-stop-position") && (tabPosition = labelAlignmentElement.getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "list-tab-stop-position")) != null && !tabPosition.isEmpty()) {
                    listLevelDefinition.put("tabStopPosition", MapHelper.normalizeLength(tabPosition));
                }
                if (labelAlignmentElement.hasAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "label-followed-by")) {
                    listLevelDefinition.put("labelFollowedBy", (Object)labelAlignmentElement.getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "label-followed-by"));
                }
            }
        }
        return listLevelDefinition;
    }

    private static JSONObject mapIndent(String minLabelWidthValue, String spaceBeforeValue, JSONObject listLevelDefinition) throws JSONException {
        int minLabelWidth = 0;
        boolean isValidMinLabelWidth = Length.isValid(minLabelWidthValue);
        if (isValidMinLabelWidth) {
            minLabelWidth = MapHelper.normalizeLength(minLabelWidthValue);
        }
        int spaceBefore = 0;
        boolean isValidSpaceBefore = Length.isValid(spaceBeforeValue);
        if (isValidSpaceBefore) {
            spaceBefore = MapHelper.normalizeLength(spaceBeforeValue);
        }
        if (isValidMinLabelWidth || isValidSpaceBefore) {
            listLevelDefinition.put("indentLeft", minLabelWidth + spaceBefore);
        }
        return listLevelDefinition;
    }

    private String getNumberFormat(TextListLevelStyleElementBase listLevelStyle) {
        String numberFormat = listLevelStyle.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "num-format");
        String numFormat = numberFormat == null || numberFormat.isEmpty() ? "none" : (numberFormat.equals("1") ? "decimal" : (numberFormat.equals("i") ? "lowerRoman" : (numberFormat.equals("I") ? "upperRoman" : (numberFormat.equals("a") ? "lowerLetter" : (numberFormat.equals("A") ? "upperLetter" : numberFormat)))));
        return numFormat;
    }

    private String getListStartValue(TextListLevelStyleElementBase listLevelStyle) {
        return listLevelStyle.getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "start-value");
    }

    private String getLabel(TextListLevelStyleElementBase listLevelStyle, int listLevel) {
        StringBuilder levelText = new StringBuilder();
        String labelPrefix = listLevelStyle.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "num-prefix");
        if (labelPrefix != null && !labelPrefix.isEmpty()) {
            levelText.append(labelPrefix);
        }
        if (listLevelStyle instanceof TextListLevelStyleNumberElement) {
            String displayLevels = listLevelStyle.getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "display-levels");
            if (displayLevels != null && !displayLevels.isEmpty()) {
                int showLevels;
                for (int i = showLevels = Integer.parseInt(displayLevels); i > 0; --i) {
                    levelText.append("%").append(listLevel + 2 - i);
                    if (i == 1) continue;
                    levelText.append('.');
                }
            } else {
                levelText.append("%").append(listLevel + 1);
            }
            String labelSuffix = listLevelStyle.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "num-suffix");
            if (labelSuffix != null && !labelSuffix.isEmpty()) {
                levelText.append(labelSuffix);
            }
        } else {
            String bulletChar = listLevelStyle.getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "bullet-char");
            if (bulletChar != null && !bulletChar.isEmpty()) {
                levelText.append(bulletChar);
            }
        }
        return levelText.toString();
    }

    private void addListStyle(String styleName, String displayName, boolean hasConsecutiveNumbering, JSONObject listDefinition) {
        JSONObject newOperation = new JSONObject();
        try {
            newOperation.put("name", (Object)"addListStyle");
            newOperation.put("listStyleId", (Object)styleName);
            if (hasConsecutiveNumbering) {
                newOperation.put("listUnifiedNumbering", hasConsecutiveNumbering);
            }
            newOperation.put("listDefinition", (Object)listDefinition);
            this.mOperationQueue.put((Object)newOperation);
            LOG.log(Level.FINEST, "addListStyle - component:{0}", newOperation);
        }
        catch (JSONException e) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public Integer triggerStyleHierarchyOps(OdfOfficeStyles officeStyles, OdfStyleFamily styleFamily, OdfStyleBase style) {
        Integer defaultTabStopWidth = null;
        if (style != null) {
            if (!(style instanceof OdfDefaultStyle)) {
                if (!this.knownStyles.containsKey(((OdfStyle)style).getStyleNameAttribute())) {
                    LinkedList<OdfStyleBase> parents = new LinkedList<OdfStyleBase>();
                    OdfStyleBase parent = style;
                    while (parent != null && (parent instanceof OdfDefaultStyle || !this.knownStyles.containsKey(((OdfStyle)parent).getStyleNameAttribute()))) {
                        if (parent instanceof OdfDefaultStyle) {
                            if (styleFamily.equals(OdfStyleFamily.Paragraph)) {
                                defaultTabStopWidth = this.triggerDefaultStyleOp(styleFamily, officeStyles.getDefaultStyle(styleFamily));
                                break;
                            }
                            this.triggerDefaultStyleOp(styleFamily, officeStyles.getDefaultStyle(styleFamily));
                            break;
                        }
                        if (parent == null) continue;
                        parents.add(parent);
                        Attr parentStyleName = parent.getAttributeNodeNS(OdfDocumentNamespace.STYLE.getUri(), "parent-style-name");
                        if (parentStyleName != null && parentStyleName.getValue().equals("default_" + Component.getFamilyID(styleFamily) + "_style")) {
                            parent.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "parent-style-name");
                            this.triggerDefaultStyleOp(styleFamily, style.getParentStyle());
                            break;
                        }
                        parent = parent.getParentStyle();
                    }
                    String lastWrittenStyleName = null;
                    boolean skippedEmptyParent = false;
                    HashMap<String, Map<String, String>> allOdfProps = new HashMap<String, Map<String, String>>();
                    Map<String, OdfStylePropertiesSet> familyPropertyGroups = Component.getAllStyleGroupingIdProperties(styleFamily);
                    Map<String, Object> mappedFormatting = null;
                    for (int i = parents.size() - 1; i >= 0; --i) {
                        style = (OdfStyleBase)parents.get(i);
                        MapHelper.getStyleProperties(style, familyPropertyGroups, allOdfProps);
                        mappedFormatting = MapHelper.mapStyleProperties(familyPropertyGroups, allOdfProps);
                        MapHelper.putNumberFormat(mappedFormatting, null, (OdfStyle)style, null, officeStyles);
                        String styleName = ((OdfStyle)style).getStyleNameAttribute();
                        OdfStyleBase parentStyle = style.getParentStyle();
                        String parentStyleName = null;
                        if (parentStyle != null && !(parentStyle instanceof OdfDefaultStyle)) {
                            parentStyleName = ((OdfStyle)parentStyle).getStyleNameAttribute();
                        }
                        String nextStyle = ((OdfStyle)style).getStyleNextStyleNameAttribute();
                        Integer outlineLevel = ((OdfStyle)style).getStyleDefaultOutlineLevelAttribute();
                        if (skippedEmptyParent) {
                            parentStyleName = lastWrittenStyleName;
                        }
                        String custom = style.getAttribute("custom");
                        String familyId = Component.getFamilyID(styleFamily);
                        if (parentStyleName != null && !parentStyleName.isEmpty()) {
                            this.addStyleSheet(styleName, familyId, ((OdfStyle)style).getStyleDisplayNameAttribute(), mappedFormatting, parentStyleName, nextStyle, outlineLevel, false, false, custom);
                        } else {
                            this.addStyleSheet(styleName, familyId, ((OdfStyle)style).getStyleDisplayNameAttribute(), mappedFormatting, "default_" + familyId + "_style", nextStyle, outlineLevel, false, false, custom);
                        }
                        lastWrittenStyleName = styleName;
                        mappedFormatting.clear();
                        allOdfProps.clear();
                        this.knownStyles.put(styleName, Boolean.TRUE);
                    }
                }
            } else if (styleFamily.equals(OdfStyleFamily.Paragraph)) {
                defaultTabStopWidth = this.triggerDefaultStyleOp(styleFamily, style);
            } else {
                this.triggerDefaultStyleOp(styleFamily, style);
            }
        }
        return defaultTabStopWidth;
    }

    public Integer triggerDefaultStyleOp(OdfStyleFamily styleFamily, OdfStyleBase style) {
        Integer defaultTabStopWidth = null;
        HashMap<String, Map<String, String>> allOdfProps = new HashMap<String, Map<String, String>>();
        Map<String, OdfStylePropertiesSet> familyPropertyGroups = Component.getAllStyleGroupingIdProperties(styleFamily);
        Map<String, Object> mappedFormatting = null;
        if (style instanceof OdfDefaultStyle && !this.knownStyles.containsKey("default_" + Component.getFamilyID(styleFamily) + "_style")) {
            JSONObject paraProps;
            MapHelper.getStyleProperties(style, familyPropertyGroups, allOdfProps);
            mappedFormatting = MapHelper.mapStyleProperties(familyPropertyGroups, allOdfProps);
            if (mappedFormatting.containsKey("paragraph") && (paraProps = (JSONObject)mappedFormatting.get("paragraph")).has("document")) {
                JSONObject documentProps = paraProps.optJSONObject("document");
                defaultTabStopWidth = documentProps.optInt("defaultTabStop");
            }
            String familyId = Component.getFamilyID(styleFamily);
            if (!mappedFormatting.isEmpty()) {
                String displayName = "Default " + Component.getFamilyDisplayName(styleFamily) + " Style";
                this.addStyleSheet("default_" + familyId + "_style", familyId, displayName, mappedFormatting, null, null, null, true, true, null);
            }
            String styleName = "default_" + Component.getFamilyID(styleFamily) + "_style";
            this.knownStyles.put(styleName, Boolean.TRUE);
        }
        return defaultTabStopWidth;
    }

    public JSONObject addPageProperties(OdfStylesDom stylesDom) {
        JSONObject defaultPageProperties = null;
        OfficeMasterStylesElement masterStyles = stylesDom.getMasterStyles();
        if (masterStyles != null) {
            for (StyleMasterPageElement masterPage : masterStyles.getMasterPages().values()) {
                OfficeAutomaticStylesElement autoStyles;
                String styleName = masterPage.getStyleNameAttribute();
                if (styleName == null || styleName.isEmpty()) continue;
                String pageLayoutName = masterPage.getStylePageLayoutNameAttribute();
                JSONObject pagePropsJson = null;
                if (pageLayoutName == null || pageLayoutName.isEmpty() || (autoStyles = stylesDom.getAutomaticStyles()) == null) continue;
                OdfStylePageLayout pageLayout = autoStyles.getPageLayout(pageLayoutName);
                Map<OdfStyleProperty, String> pageProperties = pageLayout.getStyleProperties();
                Map<String, String> pageProps = this.transformMap(pageProperties);
                pagePropsJson = MapHelper.mapProperties("page", pageProps);
                try {
                    pagePropsJson = pagePropsJson.getJSONObject("page");
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                if (pagePropsJson == null || pagePropsJson.length() == 0 || !styleName.equals(NUMBER_FORMAT_CODE_STANDARD) && !styleName.equals("MP0")) continue;
                defaultPageProperties = pagePropsJson;
            }
        }
        return defaultPageProperties;
    }

    public void addDocumentProperties(OdfStylesDom stylesDom, Integer defaultTabStopWidth, JSONObject defaultPageStyles) {
        try {
            JSONObject documentPropsObject = new JSONObject();
            JSONObject docPropsJson = new JSONObject();
            if (defaultTabStopWidth != null) {
                docPropsJson.putOpt("defaultTabStop", (Object)defaultTabStopWidth);
            }
            if (defaultPageStyles != null) {
                documentPropsObject.put("page", (Object)defaultPageStyles);
            }
            docPropsJson.putOpt("fileFormat", (Object)"odf");
            documentPropsObject.put("document", (Object)docPropsJson);
            this.addDocumentData(documentPropsObject);
        }
        catch (Exception ex) {
            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private Map<String, String> transformMap(Map<OdfStyleProperty, String> props) {
        HashMap<String, String> odfProps = new HashMap<String, String>();
        for (OdfStyleProperty styleProp : props.keySet()) {
            odfProps.put(styleProp.getName().getQName(), props.get(styleProp));
        }
        return odfProps;
    }

    public void addHeaderFooter(String contextName, PageArea pageArea, JSONObject attrs) {
        if (contextName != null) {
            JSONObject newOperation = new JSONObject((Object)4);
            try {
                newOperation.put("name", (Object)"addHeaderFooter");
                newOperation.put("id", (Object)contextName);
                newOperation.put("type", (Object)pageArea.getPageAreaName());
                if (attrs != null && attrs.length() != 0) {
                    newOperation.put("attrs", (Object)attrs);
                }
                this.mOperationQueue.put((Object)newOperation);
                LOG.log(Level.FINEST, "addHeaderFooter component:{0}", newOperation);
            }
            catch (JSONException e) {
                Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }

    public static void calculateCrops(OdfElement image, String href, JSONObject imageProps) {
        block22: {
            try {
                OdfPackage pkg = ((OdfFileDom)((Object)image.getOwnerDocument())).getDocument().getPackage();
                InputStream is = pkg.getInputStream(href);
                if (is != null) {
                    BufferedImage bimg = ImageIO.read(is);
                    if (bimg != null) {
                        double width = MapHelper.normalizeLength((double)bimg.getWidth() / 72.0 + "in");
                        double height = MapHelper.normalizeLength((double)bimg.getHeight() / 72.0 + "in");
                        try {
                            if (imageProps.has("cropRight")) {
                                Number cropRight = (Number)imageProps.get("cropRight");
                                LOG.log(Level.FINEST, "The clipRight is {0}", cropRight);
                                if (cropRight != null) {
                                    if (cropRight.doubleValue() != 0.0) {
                                        imageProps.put("cropRight", cropRight.doubleValue() * 100.0 / width);
                                        LOG.log(Level.FINEST, "The cropRight is {0}", cropRight.doubleValue() * 100.0 / width);
                                    } else {
                                        imageProps.remove("cropRight");
                                    }
                                }
                            }
                            if (imageProps.has("cropLeft")) {
                                Number cropLeft = (Number)imageProps.get("cropLeft");
                                LOG.log(Level.FINEST, "The clipLeft is {0}", cropLeft);
                                if (cropLeft != null) {
                                    if (cropLeft.doubleValue() != 0.0) {
                                        imageProps.put("cropLeft", cropLeft.doubleValue() * 100.0 / width);
                                        LOG.log(Level.FINEST, "The cropLeft is {0}", cropLeft.doubleValue() * 100.0 / width);
                                    } else {
                                        imageProps.remove("cropLeft");
                                    }
                                }
                            }
                            if (imageProps.has("cropTop")) {
                                Number cropTop = (Number)imageProps.get("cropTop");
                                LOG.log(Level.FINEST, "The clipTop is {0}", cropTop);
                                double d = cropTop.doubleValue();
                                if (cropTop != null) {
                                    if (cropTop.doubleValue() != 0.0) {
                                        imageProps.put("cropTop", cropTop.doubleValue() * 100.0 / height);
                                        LOG.log(Level.FINEST, "The cropTop is {0}", cropTop.doubleValue() * 100.0 / height);
                                    } else {
                                        imageProps.remove("cropTop");
                                    }
                                }
                            }
                            if (imageProps.has("cropBottom")) {
                                Number cropBottom = (Number)imageProps.get("cropBottom");
                                LOG.log(Level.FINEST, "The clipBottom is {0}", cropBottom);
                                if (cropBottom != null) {
                                    if (cropBottom.doubleValue() != 0.0) {
                                        imageProps.put("cropBottom", cropBottom.doubleValue() * 100.0 / height);
                                        LOG.log(Level.FINEST, "The cropBottom is {0}", cropBottom.doubleValue() * 100.0 / height);
                                    } else {
                                        imageProps.remove("cropBottom");
                                    }
                                }
                            }
                        }
                        catch (JSONException ex) {
                            Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        LOG.log(Level.FINEST, "Width: {0} Height: {1}", new Object[]{width, height});
                        break block22;
                    }
                    LOG.log(Level.WARNING, "The image ''{0}'' could not be loaded!", href);
                    break block22;
                }
                LOG.log(Level.WARNING, "The image ''{0}'' could not be loaded!", href);
            }
            catch (IOException ex) {
                Logger.getLogger(JsonOperationProducer.class.getName()).log(Level.SEVERE, "Image could not be found at " + href, ex);
            }
        }
    }

    private static List<Integer> incrementAll(List<Integer> position) {
        if (position != null) {
            for (int i = 0; i < position.size(); ++i) {
                position.set(i, position.get(i) + 1);
            }
        }
        return position;
    }
}

