/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.field;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.dom.element.text.TextTimeElement;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberTimeStyle;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.common.field.Field;
import org.w3c.dom.Node;

public class TimeField
extends Field {
    private static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    private static final String DEFAULT_TIME_VALUE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.S";
    private TextTimeElement timeElement;

    TimeField(OdfElement odfElement) {
        TextSpanElement spanElement = (TextSpanElement)((OdfFileDom)odfElement.getOwnerDocument()).newOdfElement(TextSpanElement.class);
        odfElement.appendChild((Node)spanElement);
        this.timeElement = spanElement.newTextTimeElement();
        OdfNumberTimeStyle timeStyle = this.newTimeStyle();
        String timeStyleName = timeStyle.getStyleNameAttribute();
        timeStyle.buildFromFormat(DEFAULT_TIME_FORMAT);
        timeStyle.setStyleNameAttribute(timeStyleName);
        this.timeElement.setStyleDataStyleNameAttribute(timeStyle.getStyleNameAttribute());
        Calendar calender = Calendar.getInstance();
        SimpleDateFormat simpleFormat = new SimpleDateFormat(DEFAULT_TIME_VALUE_FORMAT);
        Date time = calender.getTime();
        String svalue = simpleFormat.format(time);
        this.timeElement.setTextTimeValueAttribute(svalue);
        SimpleDateFormat contentFormat = new SimpleDateFormat(DEFAULT_TIME_FORMAT);
        this.timeElement.setTextContent(contentFormat.format(time));
        this.timeElement.setTextFixedAttribute(Boolean.valueOf(true));
        Component.registerComponent(this, (OdfElement)this.getOdfElement());
    }

    public void formatTime(String formatString) {
        SimpleDateFormat simpleFormat = new SimpleDateFormat(DEFAULT_TIME_VALUE_FORMAT);
        String sValue = this.timeElement.getTextTimeValueAttribute();
        try {
            Date simpleDate = simpleFormat.parse(sValue);
            SimpleDateFormat newFormat = new SimpleDateFormat(formatString);
            this.timeElement.setTextContent(newFormat.format(simpleDate));
            OdfFileDom dom = (OdfFileDom)this.timeElement.getOwnerDocument();
            OdfOfficeAutomaticStyles styles = null;
            if (dom instanceof OdfContentDom) {
                styles = ((OdfContentDom)dom).getAutomaticStyles();
            } else if (dom instanceof OdfStylesDom) {
                styles = ((OdfStylesDom)dom).getAutomaticStyles();
            }
            OdfNumberTimeStyle dataStyle = styles.getTimeStyle(this.timeElement.getStyleDataStyleNameAttribute());
            dataStyle.buildFromFormat(formatString);
        }
        catch (ParseException e) {
            Logger.getLogger(TimeField.class.getName()).log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void setFixed(boolean isFixed) {
        this.timeElement.setTextFixedAttribute(Boolean.valueOf(isFixed));
    }

    public TextTimeElement getOdfElement() {
        return this.timeElement;
    }

    private OdfNumberTimeStyle newTimeStyle() {
        OdfFileDom dom = (OdfFileDom)this.timeElement.getOwnerDocument();
        OdfOfficeAutomaticStyles styles = null;
        if (dom instanceof OdfContentDom) {
            styles = ((OdfContentDom)dom).getAutomaticStyles();
        } else if (dom instanceof OdfStylesDom) {
            styles = ((OdfStylesDom)dom).getAutomaticStyles();
        }
        OdfNumberTimeStyle newStyle = (OdfNumberTimeStyle)dom.newOdfElement(OdfNumberTimeStyle.class);
        newStyle.setStyleNameAttribute(this.newUniqueStyleName(styles));
        styles.appendChild((Node)newStyle);
        return newStyle;
    }

    private String newUniqueStyleName(OdfOfficeAutomaticStyles styles) {
        String unique_name;
        while (styles.getTimeStyle(unique_name = String.format("N%06x", (int)(Math.random() * 1.6777215E7))) != null) {
        }
        return unique_name;
    }

    @Override
    public Field.FieldType getFieldType() {
        return Field.FieldType.TIME_FIELD;
    }
}

