/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceRegistration;

public class OMAGViewServiceRegistration {
    private static Map<String, ViewServiceRegistration> viewServiceRegistrationMap = new HashMap<String, ViewServiceRegistration>();

    public static synchronized void registerViewService(ViewServiceRegistration registration) {
        String serviceName;
        if (registration != null && (serviceName = registration.getViewServiceName()) != null) {
            viewServiceRegistrationMap.put(serviceName, registration);
        }
    }

    public static synchronized List<ViewServiceRegistration> getViewServiceRegistrationList() {
        ArrayList<ViewServiceRegistration> registrationList = new ArrayList<ViewServiceRegistration>();
        for (ViewServiceRegistration viewServiceRegistration : viewServiceRegistrationMap.values()) {
            if (viewServiceRegistration == null) continue;
            registrationList.add(viewServiceRegistration);
        }
        return registrationList;
    }

    public static synchronized ViewServiceRegistration getViewServiceRegistration(String urlMarker) {
        if (urlMarker != null) {
            for (ViewServiceRegistration viewServiceRegistration : viewServiceRegistrationMap.values()) {
                if (viewServiceRegistration == null || !urlMarker.equals(viewServiceRegistration.getViewServiceURLMarker())) continue;
                return viewServiceRegistration;
            }
        }
        return null;
    }
}

