/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.eventtopic;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecord;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogStoreConnectorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;

public class EventTopicAuditLogStoreConnector
extends OMRSAuditLogStoreConnectorBase
implements VirtualConnectorExtension {
    private List<OpenMetadataTopicConnector> topicConnectors = new ArrayList<OpenMetadataTopicConnector>();

    public String storeLogRecord(OMRSAuditLogRecord logRecord) throws InvalidParameterException {
        String methodName = "storeLogRecord";
        super.validateLogRecord(logRecord, "storeLogRecord");
        if (super.isSupportedSeverity(logRecord)) {
            for (OpenMetadataTopicConnector topicConnector : this.topicConnectors) {
                if (topicConnector == null) continue;
                try {
                    topicConnector.sendEvent(super.getJSONLogRecord(logRecord, "storeLogRecord"));
                }
                catch (Exception exception) {}
            }
        }
        return logRecord.getGUID();
    }

    public void initializeEmbeddedConnectors(List<Connector> embeddedConnectors) {
        if (embeddedConnectors != null) {
            for (Connector embeddedConnector : embeddedConnectors) {
                if (embeddedConnector == null || !(embeddedConnector instanceof OpenMetadataTopicConnector)) continue;
                OpenMetadataTopicConnector realTopicConnector = (OpenMetadataTopicConnector)embeddedConnector;
                this.topicConnectors.add(realTopicConnector);
            }
        }
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        for (Connector connector : this.topicConnectors) {
            if (connector == null) continue;
            connector.start();
        }
    }

    public void disconnect() throws ConnectorCheckedException {
        for (Connector connector : this.topicConnectors) {
            if (connector == null) continue;
            connector.disconnect();
        }
        super.disconnect();
    }
}

