/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FormElement;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataManagerOMASAPIResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class FormsResponse
extends DataManagerOMASAPIResponse {
    private static final long serialVersionUID = 1L;
    private List<FormElement> elementList = null;

    public FormsResponse() {
    }

    public FormsResponse(FormsResponse template) {
        super(template);
        if (template != null) {
            this.elementList = template.getElementList();
        }
    }

    public List<FormElement> getElementList() {
        if (this.elementList == null) {
            return null;
        }
        if (this.elementList.isEmpty()) {
            return null;
        }
        return new ArrayList<FormElement>(this.elementList);
    }

    public void setElementList(List<FormElement> elementList) {
        this.elementList = elementList;
    }

    @Override
    public String toString() {
        return "FormsResponse{elementList=" + this.elementList + ", exceptionClassName='" + this.getExceptionClassName() + "', exceptionCausedBy='" + this.getExceptionCausedBy() + "', actionDescription='" + this.getActionDescription() + "', relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + "', exceptionErrorMessageId='" + this.getExceptionErrorMessageId() + "', exceptionErrorMessageParameters=" + Arrays.toString(this.getExceptionErrorMessageParameters()) + ", exceptionSystemAction='" + this.getExceptionSystemAction() + "', exceptionUserAction='" + this.getExceptionUserAction() + "', exceptionProperties=" + this.getExceptionProperties() + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        FormsResponse that = (FormsResponse)((Object)objectToCompare);
        return Objects.equals(this.elementList, that.elementList);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementList);
    }
}

