/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.client;

import org.odpi.openmetadata.accessservices.datamanager.api.MetadataSourceInterface;
import org.odpi.openmetadata.accessservices.datamanager.client.DataManagerBaseClient;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIManagerProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.ApplicationProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataProcessingEngineProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseManagerProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.EventBrokerProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.FileManagerProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.FileSystemProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.APIManagerRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.ApplicationRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataProcessingEngineRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.DatabaseManagerRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.EventBrokerRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileManagerRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileSystemRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class MetadataSourceClient
extends DataManagerBaseClient
implements MetadataSourceInterface {
    private final String urlTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources";

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, DataManagerRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, restClient, maxPageSize);
    }

    public String createAPIManager(String userId, String externalSourceGUID, String externalSourceName, APIManagerProperties apiManagerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAPIManager";
        String propertiesParameterName = "apiManagerProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createAPIManager");
        this.invalidParameterHandler.validateObject((Object)apiManagerProperties, "apiManagerProperties", "createAPIManager");
        this.invalidParameterHandler.validateName(apiManagerProperties.getQualifiedName(), "qualifiedName", "createAPIManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources/api-managers";
        APIManagerRequestBody requestBody = new APIManagerRequestBody(apiManagerProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createAPIManager", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createDatabaseManager(String userId, String externalSourceGUID, String externalSourceName, DatabaseManagerProperties databaseManagerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDatabaseManager";
        String propertiesParameterName = "databaseManagerProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createDatabaseManager");
        this.invalidParameterHandler.validateObject((Object)databaseManagerProperties, "databaseManagerProperties", "createDatabaseManager");
        this.invalidParameterHandler.validateName(databaseManagerProperties.getQualifiedName(), "qualifiedName", "createDatabaseManager");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources/database-managers";
        DatabaseManagerRequestBody requestBody = new DatabaseManagerRequestBody(databaseManagerProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDatabaseManager", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createEventBroker(String userId, String externalSourceGUID, String externalSourceName, EventBrokerProperties eventBrokerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEventBroker";
        String propertiesParameterName = "eventBrokerProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createEventBroker");
        this.invalidParameterHandler.validateObject((Object)eventBrokerProperties, "eventBrokerProperties", "createEventBroker");
        this.invalidParameterHandler.validateName(eventBrokerProperties.getQualifiedName(), "qualifiedName", "createEventBroker");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources/event-brokers";
        EventBrokerRequestBody requestBody = new EventBrokerRequestBody(eventBrokerProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createEventBroker", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createFileSystem(String userId, String externalSourceGUID, String externalSourceName, FileSystemProperties fileSystemProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createFileSystem";
        String propertiesParameterName = "fileSystemProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createFileSystem");
        this.invalidParameterHandler.validateObject((Object)fileSystemProperties, "fileSystemProperties", "createFileSystem");
        this.invalidParameterHandler.validateName(fileSystemProperties.getQualifiedName(), "qualifiedName", "createFileSystem");
        FileSystemRequestBody requestBody = new FileSystemRequestBody(fileSystemProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources/filesystems";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createFileSystem", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createFileManager(String userId, String externalSourceGUID, String externalSourceName, FileManagerProperties fileManagerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createFileManager";
        String propertiesParameterName = "fileManagerProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createFileManager");
        this.invalidParameterHandler.validateObject((Object)fileManagerProperties, "fileManagerProperties", "createFileManager");
        this.invalidParameterHandler.validateName(fileManagerProperties.getQualifiedName(), "qualifiedName", "createFileManager");
        FileManagerRequestBody requestBody = new FileManagerRequestBody(fileManagerProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources/file-managers";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createFileManager", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createApplication(String userId, String externalSourceGUID, String externalSourceName, ApplicationProperties applicationProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createApplication";
        String propertiesParameterName = "applicationProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createApplication");
        this.invalidParameterHandler.validateObject((Object)applicationProperties, "applicationProperties", "createApplication");
        this.invalidParameterHandler.validateName(applicationProperties.getQualifiedName(), "qualifiedName", "createApplication");
        ApplicationRequestBody requestBody = new ApplicationRequestBody(applicationProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources/applications";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createApplication", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createDataProcessingEngine(String userId, String externalSourceGUID, String externalSourceName, DataProcessingEngineProperties engineProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDataProcessingEngine";
        String propertiesParameterName = "engineProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createDataProcessingEngine");
        this.invalidParameterHandler.validateObject((Object)engineProperties, "engineProperties", "createDataProcessingEngine");
        this.invalidParameterHandler.validateName(engineProperties.getQualifiedName(), "qualifiedName", "createDataProcessingEngine");
        DataProcessingEngineRequestBody requestBody = new DataProcessingEngineRequestBody(engineProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources/data-processing-engines";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDataProcessingEngine", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String getMetadataSourceGUID(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataSourceGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataSourceGUID");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getMetadataSourceGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/metadata-sources/by-name";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(qualifiedName);
        requestBody.setNamePropertyName("qualifiedName");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("getMetadataSourceGUID", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }
}

