/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.api.FilesAndFoldersInterface;
import org.odpi.openmetadata.accessservices.datamanager.client.SchemaManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DataFileElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.FileFolderElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.ArchiveProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataFileProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.FileFolderProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.datamanager.rest.ArchiveRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataFileRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataFileResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataFilesResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.DataFolderRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileFolderResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.FileFoldersResponse;
import org.odpi.openmetadata.accessservices.datamanager.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.PathNameRequestBody;
import org.odpi.openmetadata.accessservices.datamanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class FilesAndFoldersClient
extends SchemaManagerClient
implements FilesAndFoldersInterface {
    private final String urlTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems";
    private static final String defaultSchemaAttributeName = "SchemaAttribute";

    public FilesAndFoldersClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, auditLog);
    }

    public FilesAndFoldersClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot);
    }

    public FilesAndFoldersClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public FilesAndFoldersClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, userId, password);
    }

    public FilesAndFoldersClient(String serverName, String serverPlatformURLRoot, DataManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(defaultSchemaAttributeName, serverName, serverPlatformURLRoot, restClient, maxPageSize, auditLog);
    }

    public List<String> createNestedFolders(String userId, String fileManagerCapabilityGUID, String fileManagerCapabilityName, String parentGUID, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createNestedFolders";
        String parentGUIDParameterName = "parentGUID";
        String pathNameParameterName = "pathName";
        this.invalidParameterHandler.validateUserId(userId, "createNestedFolders");
        this.invalidParameterHandler.validateGUID(parentGUID, "parentGUID", "createNestedFolders");
        this.invalidParameterHandler.validateName(pathName, "pathName", "createNestedFolders");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/folders/parent/{2}";
        PathNameRequestBody requestBody = new PathNameRequestBody();
        requestBody.setExternalSourceGUID(fileManagerCapabilityGUID);
        requestBody.setExternalSourceName(fileManagerCapabilityName);
        requestBody.setFullPath(pathName);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("createNestedFolders", urlTemplate, requestBody, new Object[]{this.serverName, userId, parentGUID});
        return restResult.getGUIDs();
    }

    public void attachTopLevelFolder(String userId, String fileManagerCapabilityGUID, String fileManagerCapabilityName, String fileSystemGUID, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachTopLevelFolder";
        String fileSystemGUIDParameterName = "fileSystemGUID";
        String folderGUIDParameterName = "folderGUID";
        this.invalidParameterHandler.validateUserId(userId, "attachTopLevelFolder");
        this.invalidParameterHandler.validateGUID(fileSystemGUID, "fileSystemGUID", "attachTopLevelFolder");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "attachTopLevelFolder");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/{2}/folders/{3}/attach";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(fileManagerCapabilityGUID);
        requestBody.setExternalSourceName(fileManagerCapabilityName);
        this.restClient.callVoidPostRESTCall("attachTopLevelFolder", urlTemplate, requestBody, new Object[]{this.serverName, userId, fileSystemGUID, folderGUID});
    }

    public void detachTopLevelFolder(String userId, String fileManagerCapabilityGUID, String fileManagerCapabilityName, String fileSystemGUID, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachTopLevelFolder";
        String fileSystemGUIDParameterName = "fileSystemGUID";
        String folderGUIDParameterName = "folderGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachTopLevelFolder");
        this.invalidParameterHandler.validateGUID(fileSystemGUID, "fileSystemGUID", "detachTopLevelFolder");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "detachTopLevelFolder");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/{2}/folders/{3}/detach";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(fileManagerCapabilityGUID);
        requestBody.setExternalSourceName(fileManagerCapabilityName);
        this.restClient.callVoidPostRESTCall("detachTopLevelFolder", urlTemplate, requestBody, new Object[]{this.serverName, userId, fileSystemGUID, folderGUID});
    }

    public List<String> addDataFileToCatalog(String userId, String fileManagerCapabilityGUID, String fileManagerCapabilityName, DataFileProperties dataFileProperties, String connectorProviderName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addDataFileToCatalog";
        String propertiesParameterName = "dataFileProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "addDataFileToCatalog");
        this.invalidParameterHandler.validateObject((Object)dataFileProperties, "dataFileProperties", "addDataFileToCatalog");
        this.invalidParameterHandler.validateName(dataFileProperties.getQualifiedName(), "qualifiedName", "addDataFileToCatalog");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/data-files";
        DataFileRequestBody requestBody = new DataFileRequestBody(dataFileProperties);
        requestBody.setConnectorProviderClassName(connectorProviderName);
        requestBody.setExternalSourceGUID(fileManagerCapabilityGUID);
        requestBody.setExternalSourceName(fileManagerCapabilityName);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("addDataFileToCatalog", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUIDs();
    }

    public List<String> addDataFileToCatalogFromTemplate(String userId, String fileManagerCapabilityGUID, String fileManagerCapabilityName, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addDataFileToCatalogFromTemplate";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "addDataFileToCatalogFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "addDataFileToCatalogFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "addDataFileToCatalogFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/data-files/from-template/{2}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(fileManagerCapabilityGUID);
        requestBody.setExternalSourceName(fileManagerCapabilityName);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("addDataFileToCatalogFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUIDs();
    }

    public void updateDataFileInCatalog(String userId, String fileManagerCapabilityGUID, String fileManagerCapabilityName, String dataFileGUID, boolean isMergeUpdate, DataFileProperties dataFileProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDataFileInCatalog";
        String dataFileGUIDParameterName = "dataFileGUID";
        String propertiesParameterName = "dataFileProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateDataFileInCatalog");
        this.invalidParameterHandler.validateGUID(dataFileGUID, "dataFileGUID", "updateDataFileInCatalog");
        this.invalidParameterHandler.validateObject((Object)dataFileProperties, "dataFileProperties", "updateDataFileInCatalog");
        this.invalidParameterHandler.validateName(dataFileProperties.getQualifiedName(), "qualifiedName", "updateDataFileInCatalog");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/data-files/{2}?isMergeUpdate={3}";
        DataFileRequestBody requestBody = new DataFileRequestBody(dataFileProperties);
        requestBody.setExternalSourceGUID(fileManagerCapabilityGUID);
        requestBody.setExternalSourceName(fileManagerCapabilityName);
        this.restClient.callVoidPostRESTCall("updateDataFileInCatalog", urlTemplate, requestBody, new Object[]{this.serverName, userId, dataFileGUID, isMergeUpdate});
    }

    public void archiveDataFileInCatalog(String userId, String fileManagerCapabilityGUID, String fileManagerCapabilityName, String dataFileGUID, ArchiveProperties archiveProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "archiveDataFileInCatalog";
        String dataFileGUIDParameterName = "dataFileGUID";
        String propertiesParameterName = "archiveProperties";
        this.invalidParameterHandler.validateUserId(userId, "archiveDataFileInCatalog");
        this.invalidParameterHandler.validateGUID(dataFileGUID, "dataFileGUID", "archiveDataFileInCatalog");
        this.invalidParameterHandler.validateObject((Object)archiveProperties, "archiveProperties", "archiveDataFileInCatalog");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/data-files/{2}/archive";
        ArchiveRequestBody requestBody = new ArchiveRequestBody(archiveProperties);
        requestBody.setExternalSourceGUID(fileManagerCapabilityGUID);
        requestBody.setExternalSourceName(fileManagerCapabilityName);
        this.restClient.callVoidPostRESTCall("archiveDataFileInCatalog", urlTemplate, requestBody, new Object[]{this.serverName, userId, dataFileGUID});
    }

    public void deleteDataFileFromCatalog(String userId, String fileManagerCapabilityGUID, String fileManagerCapabilityName, String dataFileGUID, String fullPathname) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteDataFileFromCatalog";
        String dataFileGUIDParameterName = "dataFileGUID";
        String qualifiedNameParameterName = "fullPathname";
        this.invalidParameterHandler.validateUserId(userId, "deleteDataFileFromCatalog");
        this.invalidParameterHandler.validateGUID(dataFileGUID, "dataFileGUID", "deleteDataFileFromCatalog");
        this.invalidParameterHandler.validateName(fullPathname, "fullPathname", "deleteDataFileFromCatalog");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/data-files/{2}/delete";
        PathNameRequestBody requestBody = new PathNameRequestBody();
        requestBody.setExternalSourceGUID(fileManagerCapabilityGUID);
        requestBody.setExternalSourceName(fileManagerCapabilityName);
        requestBody.setFullPath(fullPathname);
        this.restClient.callVoidPostRESTCall("deleteDataFileFromCatalog", urlTemplate, requestBody, new Object[]{this.serverName, userId, dataFileGUID});
    }

    public List<String> addDataFolderToCatalog(String userId, String fileManagerCapabilityGUID, String fileManagerCapabilityName, FileFolderProperties fileFolderProperties, String connectorProviderName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addDataFolderToCatalog";
        String propertiesParameterName = "fileFolderProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "addDataFolderToCatalog");
        this.invalidParameterHandler.validateObject((Object)fileFolderProperties, "fileFolderProperties", "addDataFolderToCatalog");
        this.invalidParameterHandler.validateName(fileFolderProperties.getQualifiedName(), "qualifiedName", "addDataFolderToCatalog");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/data-folders";
        DataFolderRequestBody requestBody = new DataFolderRequestBody(fileFolderProperties);
        requestBody.setExternalSourceGUID(fileManagerCapabilityGUID);
        requestBody.setExternalSourceName(fileManagerCapabilityName);
        requestBody.setConnectorProviderClassName(connectorProviderName);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("addDataFolderToCatalog", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUIDs();
    }

    public List<String> addDataFolderToCatalogFromTemplate(String userId, String fileManagerCapabilityGUID, String fileManagerCapabilityName, String templateGUID, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addDataFolderToCatalogFromTemplate";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "templateProperties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "addDataFolderToCatalogFromTemplate");
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", "addDataFolderToCatalogFromTemplate");
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "templateProperties.qualifiedName", "addDataFolderToCatalogFromTemplate");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/data-folders/from-template/{2}";
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(fileManagerCapabilityGUID);
        requestBody.setExternalSourceName(fileManagerCapabilityName);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("addDataFolderToCatalogFromTemplate", urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUIDs();
    }

    public void updateDataFolderInCatalog(String userId, String fileManagerCapabilityGUID, String fileManagerCapabilityName, String dataFolderGUID, boolean isMergeUpdate, FileFolderProperties fileFolderProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDataFolderInCatalog";
        String dataFileGUIDParameterName = "dataFolderGUID";
        String propertiesParameterName = "fileFolderProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateDataFolderInCatalog");
        this.invalidParameterHandler.validateGUID(dataFolderGUID, "dataFolderGUID", "updateDataFolderInCatalog");
        this.invalidParameterHandler.validateObject((Object)fileFolderProperties, "fileFolderProperties", "updateDataFolderInCatalog");
        this.invalidParameterHandler.validateName(fileFolderProperties.getQualifiedName(), "qualifiedName", "updateDataFolderInCatalog");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/data-folders/{2}?isMergeUpdate={3}";
        DataFolderRequestBody requestBody = new DataFolderRequestBody(fileFolderProperties);
        requestBody.setExternalSourceGUID(fileManagerCapabilityGUID);
        requestBody.setExternalSourceName(fileManagerCapabilityName);
        this.restClient.callVoidPostRESTCall("updateDataFolderInCatalog", urlTemplate, requestBody, new Object[]{this.serverName, userId, dataFolderGUID, isMergeUpdate});
    }

    public void archiveDataFolderInCatalog(String userId, String fileManagerCapabilityGUID, String fileManagerCapabilityName, String dataFolderGUID, ArchiveProperties archiveProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "archiveDataFileInCatalog";
        String dataFileGUIDParameterName = "dataFolderGUID";
        this.invalidParameterHandler.validateUserId(userId, "archiveDataFileInCatalog");
        this.invalidParameterHandler.validateGUID(dataFolderGUID, "dataFolderGUID", "archiveDataFileInCatalog");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/data-folders/{2}/archive";
        ArchiveRequestBody requestBody = new ArchiveRequestBody(archiveProperties);
        requestBody.setExternalSourceGUID(fileManagerCapabilityGUID);
        requestBody.setExternalSourceName(fileManagerCapabilityName);
        this.restClient.callVoidPostRESTCall("archiveDataFileInCatalog", urlTemplate, requestBody, new Object[]{this.serverName, userId, dataFolderGUID});
    }

    public void deleteDataFolderFromCatalog(String userId, String fileManagerCapabilityGUID, String fileManagerCapabilityName, String dataFolderGUID, String fullPathname) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteDataFolderFromCatalog";
        String guidParameterName = "dataFolderGUID";
        String qualifiedNameParameterName = "fullPathname";
        this.invalidParameterHandler.validateUserId(userId, "deleteDataFolderFromCatalog");
        this.invalidParameterHandler.validateGUID(dataFolderGUID, "dataFolderGUID", "deleteDataFolderFromCatalog");
        this.invalidParameterHandler.validateName(fullPathname, "fullPathname", "deleteDataFolderFromCatalog");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/data-folders/{2}/delete";
        PathNameRequestBody requestBody = new PathNameRequestBody();
        requestBody.setExternalSourceGUID(fileManagerCapabilityGUID);
        requestBody.setExternalSourceName(fileManagerCapabilityName);
        requestBody.setFullPath(fullPathname);
        this.restClient.callVoidPostRESTCall("deleteDataFolderFromCatalog", urlTemplate, requestBody, new Object[]{this.serverName, userId, dataFolderGUID});
    }

    public void attachDataFileAssetToFolder(String userId, String fileManagerCapabilityGUID, String fileManagerCapabilityName, String folderGUID, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachDataFileAssetToFolder";
        String folderGUIDParameterName = "folderGUID";
        String fileGUIDParameterName = "fileGUID";
        this.invalidParameterHandler.validateUserId(userId, "attachDataFileAssetToFolder");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "attachDataFileAssetToFolder");
        this.invalidParameterHandler.validateGUID(fileGUID, "fileGUID", "attachDataFileAssetToFolder");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/folders/{4}/data-files/{5}/attach";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(fileManagerCapabilityGUID);
        requestBody.setExternalSourceName(fileManagerCapabilityName);
        this.restClient.callVoidPostRESTCall("attachDataFileAssetToFolder", urlTemplate, requestBody, new Object[]{this.serverName, userId, folderGUID, fileGUID});
    }

    public void detachDataFileAssetFromFolder(String userId, String fileManagerCapabilityGUID, String fileManagerCapabilityName, String folderGUID, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachDataFileAssetFromFolder";
        String folderGUIDParameterName = "folderGUID";
        String fileGUIDParameterName = "fileGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachDataFileAssetFromFolder");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "detachDataFileAssetFromFolder");
        this.invalidParameterHandler.validateGUID(fileGUID, "fileGUID", "detachDataFileAssetFromFolder");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/folders/{4}/data-files/{5}/detach";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(fileManagerCapabilityGUID);
        requestBody.setExternalSourceName(fileManagerCapabilityName);
        this.restClient.callVoidPostRESTCall("detachDataFileAssetFromFolder", urlTemplate, requestBody, new Object[]{this.serverName, userId, folderGUID, fileGUID});
    }

    public void moveDataFileInCatalog(String userId, String fileManagerCapabilityGUID, String fileManagerCapabilityName, String folderGUID, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "moveDataFileInCatalog";
        String folderGUIDParameterName = "folderGUID";
        String fileGUIDParameterName = "fileGUID";
        this.invalidParameterHandler.validateUserId(userId, "moveDataFileInCatalog");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "moveDataFileInCatalog");
        this.invalidParameterHandler.validateGUID(fileGUID, "fileGUID", "moveDataFileInCatalog");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/folders/{4}/data-files/{5}/move-to";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(fileManagerCapabilityGUID);
        requestBody.setExternalSourceName(fileManagerCapabilityName);
        this.restClient.callVoidPostRESTCall("moveDataFileInCatalog", urlTemplate, requestBody, new Object[]{this.serverName, userId, folderGUID, fileGUID});
    }

    public void moveDataFolderInCatalog(String userId, String fileManagerCapabilityGUID, String fileManagerCapabilityName, String folderGUID, String dataFolderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "moveDataFileInCatalog";
        String folderGUIDParameterName = "folderGUID";
        String dataFolderGUIDParameterName = "dataFolderGUID";
        this.invalidParameterHandler.validateUserId(userId, "moveDataFileInCatalog");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "moveDataFileInCatalog");
        this.invalidParameterHandler.validateGUID(dataFolderGUID, "dataFolderGUID", "moveDataFileInCatalog");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/folders/{4}/data-folders/{5}/move-to";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setExternalSourceGUID(fileManagerCapabilityGUID);
        requestBody.setExternalSourceName(fileManagerCapabilityName);
        this.restClient.callVoidPostRESTCall("moveDataFileInCatalog", urlTemplate, requestBody, new Object[]{this.serverName, userId, folderGUID, dataFolderGUID});
    }

    public FileFolderElement getFolderByGUID(String userId, String folderGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFolderByGUID";
        String guidParameterName = "folderGUID";
        this.invalidParameterHandler.validateUserId(userId, "getFolderByGUID");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "getFolderByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/folders/{2}";
        FileFolderResponse restResult = this.restClient.callFileFolderGetRESTCall("getFolderByGUID", urlTemplate, this.serverName, userId, folderGUID);
        return restResult.getFolder();
    }

    public FileFolderElement getFolderByPathName(String userId, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFolderByPathName";
        String nameParameterName = "pathName";
        this.invalidParameterHandler.validateUserId(userId, "getFolderByPathName");
        this.invalidParameterHandler.validateName(pathName, "pathName", "getFolderByPathName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/folders/by-path-name";
        PathNameRequestBody requestBody = new PathNameRequestBody();
        requestBody.setFullPath(pathName);
        FileFolderResponse restResult = this.restClient.callFileFolderPostRESTCall("getFolderByPathName", urlTemplate, requestBody, this.serverName, userId);
        return restResult.getFolder();
    }

    public List<FileFolderElement> getTopLevelFolders(String userId, String fileSystemGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTopLevelFolders";
        String fileSystemGUIDParameterName = "fileSystemGUID";
        this.invalidParameterHandler.validateUserId(userId, "getTopLevelFolders");
        this.invalidParameterHandler.validateGUID(fileSystemGUID, "fileSystemGUID", "getTopLevelFolders");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getTopLevelFolders");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/{2}/folders?startFrom={3}&pageSize={4}";
        FileFoldersResponse restResult = this.restClient.callFileFoldersGetRESTCall("getTopLevelFolders", urlTemplate, this.serverName, userId, fileSystemGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<FileFolderElement> getNestedFolders(String userId, String parentFolderGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNestedFolders";
        String guidParameterName = "parentFolderGUID";
        this.invalidParameterHandler.validateUserId(userId, "getNestedFolders");
        this.invalidParameterHandler.validateGUID(parentFolderGUID, "parentFolderGUID", "getNestedFolders");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getNestedFolders");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/folders/{2}/folders?startFrom={3}&pageSize={4}";
        FileFoldersResponse restResult = this.restClient.callFileFoldersGetRESTCall("getNestedFolders", urlTemplate, this.serverName, userId, parentFolderGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<DataFileElement> getTopLevelDataFiles(String userId, String fileSystemGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTopLevelDataFiles";
        String fileSystemGUIDParameterName = "fileSystemGUID";
        this.invalidParameterHandler.validateUserId(userId, "getTopLevelDataFiles");
        this.invalidParameterHandler.validateGUID(fileSystemGUID, "fileSystemGUID", "getTopLevelDataFiles");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getTopLevelDataFiles");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/{2}/data-files?startFrom={3}&pageSize={4}";
        DataFilesResponse restResult = this.restClient.callDataFilesGetRESTCall("getTopLevelDataFiles", urlTemplate, this.serverName, userId, fileSystemGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public List<DataFileElement> getFolderFiles(String userId, String folderGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFolderFiles";
        String guidParameterName = "folderGUID";
        this.invalidParameterHandler.validateUserId(userId, "getFolderFiles");
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", "getFolderFiles");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getFolderFiles");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/folders/{2}/data-files?startFrom={3}&pageSize={4}";
        DataFilesResponse restResult = this.restClient.callDataFilesGetRESTCall("getFolderFiles", urlTemplate, this.serverName, userId, folderGUID, startFrom, validatedPageSize);
        return restResult.getElementList();
    }

    public DataFileElement getFileByGUID(String userId, String fileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFileByGUID";
        String guidParameterName = "fileGUID";
        this.invalidParameterHandler.validateUserId(userId, "getFileByGUID");
        this.invalidParameterHandler.validateGUID(fileGUID, "fileGUID", "getFileByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/data-files/{2}";
        DataFileResponse restResult = this.restClient.callDataFileGetRESTCall("getFileByGUID", urlTemplate, this.serverName, userId, fileGUID);
        return restResult.getDataFile();
    }

    public DataFileElement getFileByPathName(String userId, String pathName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getFileByPathName";
        String nameParameterName = "pathName";
        this.invalidParameterHandler.validateUserId(userId, "getFileByPathName");
        this.invalidParameterHandler.validateName(pathName, "pathName", "getFileByPathName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/data-files/by-path-name";
        PathNameRequestBody requestBody = new PathNameRequestBody();
        requestBody.setFullPath(pathName);
        DataFileResponse restResult = this.restClient.callDataFilePostRESTCall("getFileByPathName", urlTemplate, requestBody, this.serverName, userId, pathName);
        return restResult.getDataFile();
    }

    public List<DataFileElement> findFilesByPathName(String userId, String pathName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findFilesByPathName";
        String nameParameterName = "pathName";
        this.invalidParameterHandler.validateUserId(userId, "findFilesByPathName");
        this.invalidParameterHandler.validateName(pathName, "pathName", "findFilesByPathName");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findFilesByPathName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/filesystems/data-files/by-search-path-name?startFrom={3}&pageSize={4}";
        PathNameRequestBody requestBody = new PathNameRequestBody();
        requestBody.setFullPath(pathName);
        DataFilesResponse restResult = this.restClient.callDataFilesPostRESTCall("findFilesByPathName", urlTemplate, requestBody, this.serverName, userId, pathName, startFrom, validatedPageSize);
        return restResult.getElementList();
    }
}

