/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ffdc.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.Objects;
import org.odpi.openmetadata.commonservices.ffdc.properties.ConnectorReport;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ConnectorTypeResponse
extends FFDCResponseBase {
    private static final long serialVersionUID = 1L;
    private ComponentDescription componentDescription = null;
    private ConnectorType connectorType = null;
    private long refreshTimeInterval = 0L;
    private boolean usesBlockingCalls = false;

    public ConnectorTypeResponse() {
    }

    public ConnectorTypeResponse(ConnectorTypeResponse template) {
        super(template);
        if (template != null) {
            this.componentDescription = template.getComponentDescription();
            this.connectorType = template.getConnectorType();
            this.refreshTimeInterval = template.getRefreshTimeInterval();
            this.usesBlockingCalls = template.getUsesBlockingCalls();
        }
    }

    public ConnectorTypeResponse(ConnectorReport template) {
        if (template != null) {
            this.componentDescription = template.getComponentDescription();
            this.connectorType = template.getConnectorType();
            this.refreshTimeInterval = template.getRefreshTimeInterval();
            this.usesBlockingCalls = template.getUsesBlockingCalls();
        }
    }

    public ComponentDescription getComponentDescription() {
        return this.componentDescription;
    }

    public void setComponentDescription(ComponentDescription componentDescription) {
        this.componentDescription = componentDescription;
    }

    public ConnectorType getConnectorType() {
        return this.connectorType;
    }

    public void setConnectorType(ConnectorType connectorType) {
        this.connectorType = connectorType;
    }

    public long getRefreshTimeInterval() {
        return this.refreshTimeInterval;
    }

    public void setRefreshTimeInterval(long refreshTimeInterval) {
        this.refreshTimeInterval = refreshTimeInterval;
    }

    public boolean getUsesBlockingCalls() {
        return this.usesBlockingCalls;
    }

    public void setUsesBlockingCalls(boolean usesBlockingCalls) {
        this.usesBlockingCalls = usesBlockingCalls;
    }

    @Override
    public String toString() {
        return "ConnectorTypeResponse{componentDescription=" + this.componentDescription + ", connectorType=" + this.connectorType + ", refreshTimeInterval=" + this.refreshTimeInterval + ", usesBlockingCalls=" + this.usesBlockingCalls + ", exceptionClassName='" + this.getExceptionClassName() + "', exceptionCausedBy='" + this.getExceptionCausedBy() + "', actionDescription='" + this.getActionDescription() + "', relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + "', exceptionErrorMessageId='" + this.getExceptionErrorMessageId() + "', exceptionErrorMessageParameters=" + Arrays.toString(this.getExceptionErrorMessageParameters()) + ", exceptionSystemAction='" + this.getExceptionSystemAction() + "', exceptionUserAction='" + this.getExceptionUserAction() + "', exceptionProperties=" + this.getExceptionProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ConnectorTypeResponse that = (ConnectorTypeResponse)objectToCompare;
        return this.refreshTimeInterval == that.refreshTimeInterval && this.usesBlockingCalls == that.usesBlockingCalls && Objects.equals(this.componentDescription, that.componentDescription) && Objects.equals(this.connectorType, that.connectorType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.componentDescription, this.connectorType, this.refreshTimeInterval, this.usesBlockingCalls);
    }
}

