/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration;

import java.io.Serializable;
import org.odpi.openmetadata.adminservices.configuration.properties.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;

public enum IntegrationServiceDescription implements Serializable
{
    CATALOG_INTEGRATOR_OMIS(600, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Catalog Integrator", "Catalog Integrator OMIS", "catalog-integrator", "Exchange metadata with third party data catalogs.", "https://egeria-project.org/services/omis/catalog-integrator/overview/", "Asset Manager OMAS", PermittedSynchronization.BOTH_DIRECTIONS),
    API_INTEGRATOR_OMIS(601, ComponentDevelopmentStatus.TECHNICAL_PREVIEW, "API Integrator", "API Integrator OMIS", "api-integrator", "Exchange metadata with third party API Gateways.", "https://egeria-project.org/services/omis/api-integrator/overview/", "Data Manager OMAS", PermittedSynchronization.FROM_THIRD_PARTY),
    TOPIC_INTEGRATOR_OMIS(602, ComponentDevelopmentStatus.TECHNICAL_PREVIEW, "Topic Integrator", "Topic Integrator OMIS", "topic-integrator", "Exchange metadata with third party event-based brokers.", "https://egeria-project.org/services/omis/topic-integrator/overview/", "Data Manager OMAS", PermittedSynchronization.FROM_THIRD_PARTY),
    DISPLAY_INTEGRATOR_OMIS(603, ComponentDevelopmentStatus.TECHNICAL_PREVIEW, "Display Integrator", "Display Integrator OMIS", "display-integrator", "Exchange metadata with applications that display data to users.", "https://egeria-project.org/services/omis/display-integrator/overview/", "Data Manager OMAS", PermittedSynchronization.FROM_THIRD_PARTY),
    DATABASE_INTEGRATOR_OMIS(604, ComponentDevelopmentStatus.TECHNICAL_PREVIEW, "Database Integrator", "Database Integrator OMIS", "database-integrator", "Extract metadata such as schema, tables and columns from database managers.", "https://egeria-project.org/services/omis/database-integrator/overview/", "Data Manager OMAS", PermittedSynchronization.FROM_THIRD_PARTY),
    FILES_INTEGRATOR_OMIS(605, ComponentDevelopmentStatus.TECHNICAL_PREVIEW, "Files Integrator", "Files Integrator OMIS", "files-integrator", "Extract metadata about files stored in a file system or file manager.", "https://egeria-project.org/services/omis/files-integrator/overview/", "Data Manager OMAS", PermittedSynchronization.FROM_THIRD_PARTY),
    LINEAGE_INTEGRATOR_OMIS(606, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Lineage Integrator", "Lineage Integrator OMIS", "lineage-integrator", "Manage capture of lineage from a third party tool.", "https://egeria-project.org/services/omis/lineage-integrator/overview/", "Asset Manager OMAS", PermittedSynchronization.FROM_THIRD_PARTY),
    ORGANIZATION_INTEGRATOR_OMIS(607, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Organization Integrator", "Organization Integrator OMIS", "organization-integrator", "Load information about the teams and people in an organization and return collaboration activity.", "https://egeria-project.org/services/omis/organization-integrator/overview/", "Community Profile OMAS", PermittedSynchronization.FROM_THIRD_PARTY),
    SECURITY_INTEGRATOR_OMIS(608, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Security Integrator", "Security Integrator OMIS", "security-integrator", "Distribute security properties to security enforcement points.", "https://egeria-project.org/services/omis/security-integrator/overview/", "Security Manager OMAS", PermittedSynchronization.TO_THIRD_PARTY),
    ANALYTICS_INTEGRATOR_OMIS(609, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Analytics Integrator", "Analytics Integrator OMIS", "analytics-integrator", "Exchange metadata with third party analytics tools.", "https://egeria-project.org/services/omis/analytics-integrator/overview/", "Analytics Modeling OMAS", PermittedSynchronization.BOTH_DIRECTIONS),
    SEARCH_INTEGRATOR_OMIS(610, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Search Integrator", "Search Integrator OMIS", "search-integrator", "Store metadata with a third party technology that is focused on search efficiency.", "https://egeria-project.org/services/omis/search-integrator/overview/", "Asset Catalog OMAS", PermittedSynchronization.BOTH_DIRECTIONS),
    INFRASTRUCTURE_INTEGRATOR_OMIS(611, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Infrastructure Integrator", "Infrastructure Integrator OMIS", "infrastructure-integrator", "Exchange information relating to IT infrastructure such as hosts, platforms, servers, server capabilities and services.", "https://egeria-project.org/services/omis/infrastructure-integrator/overview/", "IT infrastructure OMAS", PermittedSynchronization.BOTH_DIRECTIONS);

    private static final long serialVersionUID = 1L;
    private int integrationServiceCode;
    private ComponentDevelopmentStatus integrationServiceDevelopmentStatus = null;
    private String integrationServiceName;
    private String integrationServiceFullName;
    private String integrationServiceURLMarker;
    private String integrationServiceDescription;
    private String integrationServiceWiki;
    private String integrationServicePartnerOMAS;
    private PermittedSynchronization defaultPermittedSynchronization;

    private IntegrationServiceDescription(int integrationServiceCode, ComponentDevelopmentStatus integrationServiceDevelopmentStatus, String integrationServiceName, String integrationServiceFullName, String integrationServiceURLMarker, String integrationServiceDescription, String integrationServiceWiki, String integrationServicePartnerOMAS, PermittedSynchronization defaultPermittedSynchronization) {
        this.integrationServiceCode = integrationServiceCode;
        this.integrationServiceDevelopmentStatus = integrationServiceDevelopmentStatus;
        this.integrationServiceName = integrationServiceName;
        this.integrationServiceFullName = integrationServiceFullName;
        this.integrationServiceURLMarker = integrationServiceURLMarker;
        this.integrationServiceDescription = integrationServiceDescription;
        this.integrationServiceWiki = integrationServiceWiki;
        this.integrationServicePartnerOMAS = integrationServicePartnerOMAS;
        this.defaultPermittedSynchronization = defaultPermittedSynchronization;
    }

    public static IntegrationServiceDescription getIntegrationServiceDefinition(int integrationServiceCode) {
        for (IntegrationServiceDescription description : IntegrationServiceDescription.values()) {
            if (integrationServiceCode != description.getIntegrationServiceCode()) continue;
            return description;
        }
        return null;
    }

    public int getIntegrationServiceCode() {
        return this.integrationServiceCode;
    }

    public ComponentDevelopmentStatus getIntegrationServiceDevelopmentStatus() {
        return this.integrationServiceDevelopmentStatus;
    }

    public String getIntegrationServiceName() {
        return this.integrationServiceName;
    }

    public String getIntegrationServiceFullName() {
        return this.integrationServiceFullName;
    }

    public String getIntegrationServiceURLMarker() {
        return this.integrationServiceURLMarker;
    }

    public String getIntegrationServiceDescription() {
        return this.integrationServiceDescription;
    }

    public String getIntegrationServiceWiki() {
        return this.integrationServiceWiki;
    }

    public String getIntegrationServicePartnerOMAS() {
        return this.integrationServicePartnerOMAS;
    }

    public PermittedSynchronization getDefaultPermittedSynchronization() {
        return this.defaultPermittedSynchronization;
    }
}

