/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.ServiceOperationalStatus;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.ffdc.IntegrationDaemonServicesErrorCode;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceDescription;

public class IntegrationServiceRegistry {
    private static Map<String, IntegrationServiceDescription> serviceDescriptions = new HashMap<String, IntegrationServiceDescription>();
    private static Map<String, String> serviceContextManagers = new HashMap<String, String>();

    public static void registerIntegrationService(IntegrationServiceDescription serviceDescription, String contextManagerClass) {
        serviceDescriptions.put(serviceDescription.getIntegrationServiceURLMarker(), serviceDescription);
        serviceContextManagers.put(serviceDescription.getIntegrationServiceURLMarker(), contextManagerClass);
    }

    public static IntegrationServiceConfig getIntegrationServiceConfig(String serviceURLMarker, String serverName, String methodName) throws InvalidParameterException {
        IntegrationServiceDescription serviceDescription = serviceDescriptions.get(serviceURLMarker);
        String contextManagerClass = serviceContextManagers.get(serviceURLMarker);
        if (serviceDescription != null && contextManagerClass != null) {
            IntegrationServiceConfig config = new IntegrationServiceConfig();
            config.setIntegrationServiceId(serviceDescription.getIntegrationServiceCode());
            config.setIntegrationServiceDevelopmentStatus(serviceDescription.getIntegrationServiceDevelopmentStatus());
            config.setIntegrationServiceName(serviceDescription.getIntegrationServiceName());
            config.setIntegrationServiceFullName(serviceDescription.getIntegrationServiceFullName());
            config.setIntegrationServiceURLMarker(serviceDescription.getIntegrationServiceURLMarker());
            config.setIntegrationServiceDescription(serviceDescription.getIntegrationServiceDescription());
            config.setIntegrationServiceWiki(serviceDescription.getIntegrationServiceWiki());
            config.setIntegrationServicePartnerOMAS(serviceDescription.getIntegrationServicePartnerOMAS());
            config.setDefaultPermittedSynchronization(serviceDescription.getDefaultPermittedSynchronization());
            config.setIntegrationServiceOperationalStatus(ServiceOperationalStatus.ENABLED);
            config.setIntegrationServiceContextManagerClass(contextManagerClass);
            return config;
        }
        String actionDescription = "getIntegrationServiceConfig";
        throw new InvalidParameterException(IntegrationDaemonServicesErrorCode.UNKNOWN_INTEGRATION_SERVICE.getMessageDefinition(new String[]{serviceURLMarker, serverName}), IntegrationServiceRegistry.class.getName(), "getIntegrationServiceConfig", methodName);
    }

    public static List<RegisteredOMAGService> getRegisteredIntegrationServices() {
        ArrayList<RegisteredOMAGService> response = new ArrayList<RegisteredOMAGService>();
        Collection<IntegrationServiceDescription> integrationServiceDescriptions = serviceDescriptions.values();
        if (!integrationServiceDescriptions.isEmpty()) {
            for (IntegrationServiceDescription serviceDescription : integrationServiceDescriptions) {
                if (serviceDescription == null) continue;
                RegisteredOMAGService service = new RegisteredOMAGService();
                service.setServiceId(serviceDescription.getIntegrationServiceCode());
                service.setServiceName(serviceDescription.getIntegrationServiceFullName());
                service.setServiceDevelopmentStatus(serviceDescription.getIntegrationServiceDevelopmentStatus());
                service.setServiceURLMarker(serviceDescription.getIntegrationServiceURLMarker());
                service.setServiceDescription(serviceDescription.getIntegrationServiceDescription());
                service.setServiceWiki(serviceDescription.getIntegrationServiceWiki());
                response.add(service);
            }
        }
        return response;
    }
}

