/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.metadatasecurity.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum OpenMetadataSecurityAuditCode implements AuditLogMessageSet
{
    PLATFORM_INITIALIZING("OPEN-METADATA-SECURITY-0001", OMRSAuditLogRecordSeverity.STARTUP, "The Open Metadata Security Service {0} for OMAG Server Platform {1} is initializing", "The local server has started up a new instance of the Open Metadata Platform Security Service Connector.", "No action is required.  This is part of the normal operation of the service."),
    PLATFORM_SHUTDOWN("OPEN-METADATA-SECURITY-0002", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Open Metadata Security Service {0} for OMAG Server Platform {1} is shutting down", "The local administrator has requested shut down of the Open Metadata Platform Security Service Connector.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INITIALIZING("OPEN-METADATA-SECURITY-0003", OMRSAuditLogRecordSeverity.STARTUP, "The Open Metadata Security Service {0} for server {1} is initializing", "The local server has started up a new instance of the Open Metadata Server Security Service Connector.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_SHUTDOWN("OPEN-METADATA-SECURITY-0004", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Open Metadata Security Service {0} for server {1} is shutting down", "The local administrator has requested shut down of the Open Metadata Server Security Service Connector.", "No action is required.  This is part of the normal operation of the service."),
    UNAUTHORIZED_PLATFORM_ACCESS("OPEN-METADATA-SECURITY-0005", OMRSAuditLogRecordSeverity.SECURITY, "User {0} is not authorized to issue a request to this OMAG Server Platform", "The security service detected an unauthorized access to an OMAG Server Platform.", "Review the security policies and settings to determine if this access should be allowed or not.  Take action to either change the security sessions or determine the reason for the unauthorized request."),
    UNAUTHORIZED_SERVER_ACCESS("OPEN-METADATA-SECURITY-0006", OMRSAuditLogRecordSeverity.SECURITY, "User {0} is not authorized to issue a request to server {1}", "The security service detected an unauthorized access to a service.", "Review the security policies and settings to determine if this access should be allowed or not.  Take action to either change the security sessions or determine the reason for the unauthorized request."),
    UNAUTHORIZED_SERVICE_ACCESS("OPEN-METADATA-SECURITY-0007", OMRSAuditLogRecordSeverity.SECURITY, "User {0} is not authorized to issue {1} requests for service {2} on server {3}", "The security service detected an unauthorized access to a service.", "Review the security policies and settings to determine if this access should be allowed or not.  Take action to either change the security sessions or determine the reason for the unauthorized request."),
    UNAUTHORIZED_ASSET_FEEDBACK("OPEN-METADATA-SECURITY-0008", OMRSAuditLogRecordSeverity.SECURITY, "User {0} is not authorized to attach feedback to asset {1}", "The security service detected an unauthorized change to an asset.", "Review the security policies and settings to determine if this access should be allowed or not.  Take action to either change the security sessions or determine the reason for the unauthorized request."),
    UNAUTHORIZED_ZONE_CHANGE("OPEN-METADATA-SECURITY-0009", OMRSAuditLogRecordSeverity.SECURITY, "User {0} is not authorized to change the zone membership of asset {1} from {2} to {3}", "The security service detected an unauthorized change to an asset.", "Review the security policies and settings to determine if this access should be allowed or not.  Take action to either change the security sessions or determine the reason for the unauthorized request."),
    UNAUTHORIZED_CONNECTION_ACCESS("OPEN-METADATA-SECURITY-0010", OMRSAuditLogRecordSeverity.SECURITY, "User {0} is not authorized to use connection {1}", "The security service detected an unauthorized access to an asset.", "Review the security policies and settings to determine if this access should be allowed or not.  Take action to either change the security sessions or determine the reason for the unauthorized request."),
    UNAUTHORIZED_ASSET_ACCESS("OPEN-METADATA-SECURITY-0011", OMRSAuditLogRecordSeverity.SECURITY, "User {0} is not authorized to access asset {1}", "The security service detected an unauthorized access to an asset.", "Review the security policies and settings to determine if this access should be allowed or not.  Take action to either change the security sessions or determine the reason for the unauthorized request."),
    UNAUTHORIZED_ASSET_CREATE("OPEN-METADATA-SECURITY-0012", OMRSAuditLogRecordSeverity.SECURITY, "User {0} is not authorized to create an asset of type {1}", "The security service detected an unauthorized create of an asset.", "Review the security policies and settings to determine if this create should be allowed or not.  Take action to either change the security sessions or determine the reason for the unauthorized request."),
    UNAUTHORIZED_ASSET_CHANGE("OPEN-METADATA-SECURITY-0013", OMRSAuditLogRecordSeverity.SECURITY, "User {0} is not authorized to change asset {1}", "The security service detected an unauthorized access to an asset.", "Review the security policies and settings to determine if this access should be allowed or not.  Take action to either change the security sessions or determine the reason for the unauthorized request."),
    INCOMPLETE_ASSET("OPEN-METADATA-SECURITY-0014", OMRSAuditLogRecordSeverity.SECURITY, "User {0} is not authorized to change asset {1} because it has missing properties: {2}", "The system is unable to process a request from the user because the asset is not correctly or completely filled out.", "The request fails with a UserNotAuthorizedException exception."),
    UNAUTHORIZED_TYPE_ACCESS("OPEN-METADATA-SECURITY-0015", OMRSAuditLogRecordSeverity.SECURITY, "User {0} is not authorized to access open metadata type {1} ({2}) on server {3}", "The security service detected an unauthorized access of an open metadata type.", "Review the security policies and settings to determine if this access should be allowed or not.  Take action to either change the security sessions or determine the reason for the unauthorized request."),
    UNAUTHORIZED_TYPE_CHANGE("OPEN-METADATA-SECURITY-0016", OMRSAuditLogRecordSeverity.SECURITY, "User {0} is not authorized to change open metadata type {1} ({2}) on server {3}", "The security service detected an unauthorized change of an open metadata type.", "Review the security policies and settings to determine if this access should be allowed or not.  Take action to either change the security sessions or determine the reason for the unauthorized request."),
    UNAUTHORIZED_INSTANCE_CREATE("OPEN-METADATA-SECURITY-0017", OMRSAuditLogRecordSeverity.SECURITY, "User {0} is not authorized to create an open metadata instance of type {1} on server {2}", "The security service detected an unauthorized access of an open metadata type.", "Review the security policies and settings to determine if this access should be allowed or not.  Take action to either change the security sessions or determine the reason for the unauthorized request."),
    UNAUTHORIZED_INSTANCE_ACCESS("OPEN-METADATA-SECURITY-0018", OMRSAuditLogRecordSeverity.SECURITY, "User {0} is not authorized to access open metadata instance {1} of type {2} on server {3}", "The security service detected an unauthorized access of an open metadata type.", "Review the security policies and settings to determine if this access should be allowed or not.  Take action to either change the security sessions or determine the reason for the unauthorized request."),
    UNAUTHORIZED_INSTANCE_CHANGE("OPEN-METADATA-SECURITY-0019", OMRSAuditLogRecordSeverity.SECURITY, "User {0} is not authorized to change open metadata type {1} of type {2} on server {3} using method {4}", "The security service detected an unauthorized change of an open metadata instance.", "Review the security policies and settings to determine if this access should be allowed or not.  Take action to either change the security sessions or determine the reason for the unauthorized request.");

    private final String logMessageId;
    private final OMRSAuditLogRecordSeverity severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private OpenMetadataSecurityAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "OpenMetadataSecurityAuditCode{logMessageId='" + this.logMessageId + "', severity=" + this.severity + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

