/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.multitenant;

import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.multitenant.OMAGServerPlatformInstanceMap;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.OMAGServerInstanceErrorCode;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.platformservices.properties.ServerInstanceStatus;

public abstract class OMAGServerServiceInstance {
    protected String serverName;
    protected String serviceName;
    private ServerInstanceStatus serviceInstanceStatus = ServerInstanceStatus.UNKNOWN;
    protected int maxPageSize;
    protected InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final OMAGServerPlatformInstanceMap platformInstanceMap = new OMAGServerPlatformInstanceMap();
    protected OpenMetadataServerSecurityVerifier securityVerifier = new OpenMetadataServerSecurityVerifier();

    public OMAGServerServiceInstance(String serverName, String serverType, String serviceName, int maxPageSize) {
        this.serverName = serverName;
        this.serviceName = serviceName;
        this.maxPageSize = maxPageSize;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        if (serverName != null) {
            this.platformInstanceMap.addServiceInstanceToPlatform(serverName, serverType, serviceName, this);
        }
    }

    public OMAGServerServiceInstance(String serverName, String serviceName, int maxPageSize) {
        this(serverName, null, serviceName, maxPageSize);
    }

    protected void setServerName(String serverName) {
        this.serverName = serverName;
        if (serverName != null) {
            this.platformInstanceMap.addServiceInstanceToPlatform(serverName, null, this.serviceName, this);
        }
    }

    public void setServiceInstanceStatus(ServerInstanceStatus serviceInstanceStatus) {
        this.serviceInstanceStatus = serviceInstanceStatus;
    }

    public ServerInstanceStatus getServiceInstanceStatus() {
        return this.serviceInstanceStatus;
    }

    public void setSecurityVerifier(OpenMetadataServerSecurityVerifier securityVerifier) {
        if (securityVerifier != null) {
            this.securityVerifier = securityVerifier;
        }
    }

    public void setMaxPageSize(int maxPageSize) {
        this.maxPageSize = maxPageSize;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
    }

    public String getServerName() throws NewInstanceException {
        String methodName = "getServerName";
        if (this.serverName != null) {
            return this.serverName;
        }
        throw new NewInstanceException(OMAGServerInstanceErrorCode.SERVER_NAME_NOT_AVAILABLE.getMessageDefinition("getServerName"), this.getClass().getName(), "getServerName");
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public InvalidParameterHandler getInvalidParameterHandler() {
        return this.invalidParameterHandler;
    }

    public void shutdown() {
        this.platformInstanceMap.removeServiceInstanceFromPlatform(this.serverName, this.serviceName);
    }
}

