/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.properties.GlossaryTerm;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GlossaryTermListResponse
extends FFDCResponseBase {
    private static final long serialVersionUID = 1L;
    private List<GlossaryTerm> meanings = null;
    private int startingFromElement = 0;

    public GlossaryTermListResponse() {
    }

    public GlossaryTermListResponse(GlossaryTermListResponse template) {
        super((FFDCResponseBase)template);
        if (template != null) {
            this.startingFromElement = template.getStartingFromElement();
            this.meanings = template.getMeanings();
        }
    }

    public List<GlossaryTerm> getMeanings() {
        if (this.meanings == null) {
            return null;
        }
        if (this.meanings.isEmpty()) {
            return null;
        }
        ArrayList<GlossaryTerm> clonedList = new ArrayList<GlossaryTerm>();
        for (GlossaryTerm existingElement : this.meanings) {
            clonedList.add(new GlossaryTerm(existingElement));
        }
        return clonedList;
    }

    public void setMeanings(List<GlossaryTerm> meanings) {
        this.meanings = meanings;
    }

    public int getStartingFromElement() {
        return this.startingFromElement;
    }

    public void setStartingFromElement(int startingFromElement) {
        this.startingFromElement = startingFromElement;
    }

    public String toString() {
        return "GlossaryTermListResponse{meanings=" + this.meanings + ", startingFromElement=" + this.startingFromElement + ", exceptionClassName='" + this.getExceptionClassName() + "', exceptionCausedBy='" + this.getExceptionCausedBy() + "', actionDescription='" + this.getActionDescription() + "', relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + "', exceptionErrorMessageId='" + this.getExceptionErrorMessageId() + "', exceptionErrorMessageParameters=" + Arrays.toString(this.getExceptionErrorMessageParameters()) + ", exceptionSystemAction='" + this.getExceptionSystemAction() + "', exceptionUserAction='" + this.getExceptionUserAction() + "', exceptionProperties=" + this.getExceptionProperties() + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        GlossaryTermListResponse that = (GlossaryTermListResponse)((Object)objectToCompare);
        return this.getStartingFromElement() == that.getStartingFromElement() && Objects.equals(this.getMeanings(), that.getMeanings());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMeanings(), this.getStartingFromElement());
    }
}

