/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import java.util.HashSet;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Differences;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;

public class InstancePropertiesDifferences
extends Differences {
    public void check(InstanceProperties left, InstanceProperties right) {
        if (left != null || right != null) {
            if (left == null) {
                this.setOnlyOnOne(this.onlyOnRight, right.getInstanceProperties());
            } else if (right == null) {
                this.setOnlyOnOne(this.onlyOnLeft, left.getInstanceProperties());
            } else {
                Map<String, InstancePropertyValue> propertiesLeft = left.getInstanceProperties();
                Map<String, InstancePropertyValue> propertiesRight = right.getInstanceProperties();
                if (propertiesLeft != null || propertiesRight != null) {
                    if (propertiesLeft == null) {
                        this.setOnlyOnOne(this.onlyOnRight, propertiesRight);
                    } else if (propertiesRight == null) {
                        this.setOnlyOnOne(this.onlyOnLeft, left.getInstanceProperties());
                    } else if (!propertiesLeft.isEmpty() || !propertiesRight.isEmpty()) {
                        if (propertiesLeft.isEmpty()) {
                            this.setOnlyOnOne(this.onlyOnRight, propertiesRight);
                        } else if (propertiesRight.isEmpty()) {
                            this.setOnlyOnOne(this.onlyOnLeft, left.getInstanceProperties());
                        } else {
                            this.calculateDifferences(propertiesLeft, propertiesRight);
                        }
                    }
                }
            }
        }
    }

    private void setOnlyOnOne(Map<String, Object> map, Map<String, InstancePropertyValue> properties) {
        if (!properties.isEmpty()) {
            for (Map.Entry<String, InstancePropertyValue> entry : properties.entrySet()) {
                String propertyName = entry.getKey();
                map.put(propertyName, entry.getValue());
            }
        }
    }

    private void calculateDifferences(Map<String, InstancePropertyValue> left, Map<String, InstancePropertyValue> right) {
        HashSet<String> propertiesHandled = new HashSet<String>();
        for (Map.Entry<String, InstancePropertyValue> entryLeft : left.entrySet()) {
            String propertyNameLeft = entryLeft.getKey();
            this.check(propertyNameLeft, entryLeft.getValue(), right.getOrDefault(propertyNameLeft, null));
            propertiesHandled.add(propertyNameLeft);
        }
        for (Map.Entry<String, InstancePropertyValue> entryRight : right.entrySet()) {
            String propertyNameRight = entryRight.getKey();
            if (propertiesHandled.contains(propertyNameRight)) continue;
            this.check(propertyNameRight, left.getOrDefault(propertyNameRight, null), entryRight.getValue());
        }
    }
}

