/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.rest.properties.InstanceFindRequest;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EntityFindRequest
extends InstanceFindRequest {
    private static final long serialVersionUID = 1L;
    private SearchClassifications matchClassifications = null;

    public EntityFindRequest() {
    }

    public EntityFindRequest(EntityFindRequest template) {
        super(template);
        if (template != null) {
            this.matchClassifications = new SearchClassifications(template.getMatchClassifications());
        }
    }

    public SearchClassifications getMatchClassifications() {
        return this.matchClassifications;
    }

    public void setMatchClassifications(SearchClassifications matchClassifications) {
        this.matchClassifications = matchClassifications;
    }

    @Override
    public String toString() {
        return "EntityFindRequest{matchClassifications=" + this.matchClassifications + ", matchProperties=" + this.getMatchProperties() + ", typeGUID='" + this.getTypeGUID() + "', sequencingProperty='" + this.getSequencingProperty() + "', sequencingOrder=" + this.getSequencingOrder() + ", offset=" + this.getOffset() + ", pageSize=" + this.getPageSize() + ", limitResultsByStatus=" + this.getLimitResultsByStatus() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof EntityFindRequest)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        EntityFindRequest that = (EntityFindRequest)objectToCompare;
        return Objects.equals(this.getMatchClassifications(), that.getMatchClassifications());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMatchClassifications());
    }
}

