/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OpenMetadataArchiveProperties
extends OpenMetadataArchiveElementHeader {
    private static final long serialVersionUID = 1L;
    private String archiveGUID = null;
    private String archiveName = null;
    private String archiveDescription = null;
    private OpenMetadataArchiveType archiveType = null;
    private String archiveVersion = null;
    private String originatorName = null;
    private String originatorOrganization = null;
    private String originatorLicense = null;
    private Date creationDate = null;
    private List<String> dependsOnArchives = null;

    public OpenMetadataArchiveProperties() {
    }

    public OpenMetadataArchiveProperties(OpenMetadataArchiveProperties template) {
        super(template);
        if (template != null) {
            this.archiveGUID = template.getArchiveGUID();
            this.archiveName = template.getArchiveName();
            this.archiveDescription = template.getArchiveDescription();
            this.archiveType = template.getArchiveType();
            this.archiveVersion = template.getArchiveVersion();
            this.originatorName = template.getOriginatorName();
            this.originatorOrganization = template.getOriginatorOrganization();
            this.originatorLicense = template.getOriginatorLicense();
            this.creationDate = template.getCreationDate();
            this.dependsOnArchives = template.getDependsOnArchives();
        }
    }

    public String getArchiveGUID() {
        return this.archiveGUID;
    }

    public void setArchiveGUID(String archiveGUID) {
        this.archiveGUID = archiveGUID;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    public String getArchiveDescription() {
        return this.archiveDescription;
    }

    public void setArchiveDescription(String archiveDescription) {
        this.archiveDescription = archiveDescription;
    }

    public OpenMetadataArchiveType getArchiveType() {
        return this.archiveType;
    }

    public void setArchiveType(OpenMetadataArchiveType archiveType) {
        this.archiveType = archiveType;
    }

    public String getArchiveVersion() {
        return this.archiveVersion;
    }

    public void setArchiveVersion(String archiveVersion) {
        this.archiveVersion = archiveVersion;
    }

    public String getOriginatorName() {
        return this.originatorName;
    }

    public void setOriginatorName(String originatorName) {
        this.originatorName = originatorName;
    }

    public String getOriginatorOrganization() {
        return this.originatorOrganization;
    }

    public void setOriginatorOrganization(String originatorOrganization) {
        this.originatorOrganization = originatorOrganization;
    }

    public String getOriginatorLicense() {
        return this.originatorLicense;
    }

    public void setOriginatorLicense(String originatorLicense) {
        this.originatorLicense = originatorLicense;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public List<String> getDependsOnArchives() {
        if (this.dependsOnArchives == null) {
            return null;
        }
        if (this.dependsOnArchives.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.dependsOnArchives);
    }

    public void setDependsOnArchives(List<String> dependsOnArchives) {
        this.dependsOnArchives = dependsOnArchives;
    }

    public String toString() {
        return "OpenMetadataArchiveProperties{archiveGUID='" + this.archiveGUID + "', archiveName='" + this.archiveName + "', archiveDescription='" + this.archiveDescription + "', archiveType=" + this.archiveType + ", archiveVersion=" + this.archiveVersion + ", originatorName='" + this.originatorName + "', originatorOrganization='" + this.originatorOrganization + "', originatorLicense='" + this.originatorLicense + "', creationDate=" + this.creationDate + ", dependsOnArchives=" + this.dependsOnArchives + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        OpenMetadataArchiveProperties that = (OpenMetadataArchiveProperties)objectToCompare;
        return Objects.equals(this.getArchiveGUID(), that.getArchiveGUID()) && Objects.equals(this.getArchiveName(), that.getArchiveName()) && Objects.equals(this.getArchiveDescription(), that.getArchiveDescription()) && this.getArchiveType() == that.getArchiveType() && Objects.equals(this.getArchiveVersion(), that.getArchiveVersion()) && Objects.equals(this.getOriginatorName(), that.getOriginatorName()) && Objects.equals(this.getOriginatorOrganization(), that.getOriginatorOrganization()) && Objects.equals(this.getOriginatorLicense(), that.getOriginatorLicense()) && Objects.equals(this.getCreationDate(), that.getCreationDate()) && Objects.equals(this.getDependsOnArchives(), that.getDependsOnArchives());
    }

    public int hashCode() {
        return Objects.hash(this.getArchiveGUID(), this.getArchiveName(), this.getArchiveDescription(), this.getArchiveType(), this.getArchiveVersion(), this.getOriginatorName(), this.getOriginatorOrganization(), this.getOriginatorLicense(), this.getCreationDate(), this.getDependsOnArchives());
    }
}

