/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ExternalStandardMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefInUseException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public abstract class OMRSMetadataCollectionBase
extends OMRSMetadataCollection {
    public OMRSMetadataCollectionBase(OMRSRepositoryConnector parentConnector, String repositoryName, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String metadataCollectionId) {
        super(parentConnector, repositoryName, metadataCollectionId, repositoryHelper, repositoryValidator);
    }

    @Override
    public String getMetadataCollectionId(String userId) throws RepositoryErrorException {
        String methodName = "getMetadataCollectionId";
        this.validateRepositoryConnector("getMetadataCollectionId");
        this.parentConnector.validateRepositoryIsActive("getMetadataCollectionId");
        return this.metadataCollectionId;
    }

    protected void typeGUIDParameterValidation(String userId, String guid, String guidParameterName, String methodName) throws InvalidParameterException, RepositoryErrorException {
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateGUID(this.repositoryName, guidParameterName, guid, methodName);
    }

    protected void typeNameParameterValidation(String userId, String name, String nameParameterName, String methodName) throws InvalidParameterException, RepositoryErrorException {
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateTypeName(this.repositoryName, nameParameterName, name, methodName);
    }

    protected void typeDefCategoryParameterValidation(String userId, TypeDefCategory category, String categoryParameterName, String methodName) throws InvalidParameterException, RepositoryErrorException {
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateTypeDefCategory(this.repositoryName, categoryParameterName, category, methodName);
    }

    protected void attributeTypeDefCategoryParameterValidation(String userId, AttributeTypeDefCategory category, String categoryParameterName, String methodName) throws InvalidParameterException, RepositoryErrorException {
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateAttributeTypeDefCategory(this.repositoryName, categoryParameterName, category, methodName);
    }

    protected void typeDefPropertyParameterValidation(String userId, TypeDefProperties matchCriteria, String matchCriteriaParameterName, String methodName) throws InvalidParameterException, RepositoryErrorException {
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateMatchCriteria(this.repositoryName, matchCriteriaParameterName, matchCriteria, methodName);
    }

    protected void typeDefSearchParameterValidation(String userId, String searchCriteria, String searchCriteriaParameterName, String methodName) throws InvalidParameterException, RepositoryErrorException {
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateSearchCriteria(this.repositoryName, searchCriteriaParameterName, searchCriteria, methodName);
    }

    protected void typeDefExternalIDParameterValidation(String userId, String standard, String organization, String identifier, String methodName) throws InvalidParameterException, RepositoryErrorException {
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateExternalId(this.repositoryName, standard, organization, identifier, methodName);
    }

    protected void typeDefParameterValidation(String userId, TypeDef typeDef, String typeDefParameterName, String methodName) throws InvalidParameterException, InvalidTypeDefException, RepositoryErrorException {
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateTypeDef(this.repositoryName, typeDefParameterName, typeDef, methodName);
    }

    protected void attributeTypeDefParameterValidation(String userId, AttributeTypeDef attributeTypeDef, String typeDefParameterName, String methodName) throws InvalidParameterException, InvalidTypeDefException, RepositoryErrorException {
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateAttributeTypeDef(this.repositoryName, typeDefParameterName, attributeTypeDef, methodName);
    }

    protected void newTypeDefParameterValidation(String userId, TypeDef typeDef, String typeDefParameterName, String methodName) throws InvalidParameterException, InvalidTypeDefException, TypeDefConflictException, TypeDefKnownException, RepositoryErrorException {
        this.typeDefParameterValidation(userId, typeDef, typeDefParameterName, methodName);
        this.repositoryValidator.validateUnknownTypeDef(this.repositoryName, typeDefParameterName, typeDef, methodName);
    }

    protected void newAttributeTypeDefParameterValidation(String userId, AttributeTypeDef attributeTypeDef, String typeDefParameterName, String methodName) throws InvalidParameterException, InvalidTypeDefException, TypeDefConflictException, TypeDefKnownException, RepositoryErrorException {
        this.attributeTypeDefParameterValidation(userId, attributeTypeDef, typeDefParameterName, methodName);
        this.repositoryValidator.validateUnknownAttributeTypeDef(this.repositoryName, typeDefParameterName, attributeTypeDef, methodName);
    }

    protected TypeDef updateTypeDefParameterValidation(String userId, TypeDefPatch typeDefPatch, String methodName) throws InvalidParameterException, PatchErrorException, TypeDefNotKnownException, RepositoryErrorException {
        super.basicRequestValidation(userId, methodName);
        return this.repositoryValidator.validateTypeDefPatch(this.repositoryName, typeDefPatch, methodName);
    }

    protected TypeDef manageTypeDefParameterValidation(String userId, String guidParameterName, String nameParameterName, String typeDefGUID, String typeDefName, String methodName) throws InvalidParameterException, RepositoryErrorException {
        super.basicRequestValidation(userId, methodName);
        return this.repositoryValidator.getValidTypeDefFromIds(this.repositoryName, guidParameterName, nameParameterName, typeDefGUID, typeDefName, methodName);
    }

    protected AttributeTypeDef manageAttributeTypeDefParameterValidation(String userId, String guidParameterName, String nameParameterName, String attributeTypeDefGUID, String attributeTypeDefName, String methodName) throws InvalidParameterException, RepositoryErrorException {
        super.basicRequestValidation(userId, methodName);
        return this.repositoryValidator.getValidAttributeTypeDefFromIds(this.repositoryName, guidParameterName, nameParameterName, attributeTypeDefGUID, attributeTypeDefName, methodName);
    }

    @Override
    public TypeDefGallery getAllTypes(String userId) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "getAllTypes";
        super.basicRequestValidation(userId, "getAllTypes");
        return this.repositoryHelper.getActiveTypeDefGallery();
    }

    public TypeDefGallery filterTypesByWildCardName(List<TypeDef> allTypeDefs, List<AttributeTypeDef> allAttributeTypeDefs, String typeDefName) {
        if (typeDefName != null) {
            ArrayList<TypeDef> matchedTypeDefs = new ArrayList<TypeDef>();
            if (allTypeDefs != null) {
                for (TypeDef typeDef : allTypeDefs) {
                    if (typeDef == null || !typeDef.getName().matches(typeDefName)) continue;
                    matchedTypeDefs.add(typeDef);
                }
            }
            ArrayList<AttributeTypeDef> matchedAttributeTypeDefs = new ArrayList<AttributeTypeDef>();
            if (allAttributeTypeDefs != null) {
                for (AttributeTypeDef attributeTypeDef : allAttributeTypeDefs) {
                    if (attributeTypeDef == null || !attributeTypeDef.getName().matches(typeDefName)) continue;
                    matchedAttributeTypeDefs.add(attributeTypeDef);
                }
            }
            if (!matchedTypeDefs.isEmpty() || !matchedAttributeTypeDefs.isEmpty()) {
                TypeDefGallery typeDefGallery = new TypeDefGallery();
                if (!matchedTypeDefs.isEmpty()) {
                    typeDefGallery.setTypeDefs(matchedTypeDefs);
                } else {
                    typeDefGallery.setTypeDefs(null);
                }
                if (!matchedAttributeTypeDefs.isEmpty()) {
                    typeDefGallery.setAttributeTypeDefs(matchedAttributeTypeDefs);
                } else {
                    typeDefGallery.setAttributeTypeDefs(null);
                }
                return typeDefGallery;
            }
        }
        return null;
    }

    @Override
    public TypeDefGallery findTypesByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypesByName";
        String nameParameterName = "name";
        this.typeNameParameterValidation(userId, name, "name", "findTypesByName");
        return this.filterTypesByWildCardName(this.repositoryHelper.getActiveTypeDefs(), this.repositoryHelper.getActiveAttributeTypeDefs(), name);
    }

    protected List<TypeDef> filterTypeDefsByCategory(List<TypeDef> allTypes, TypeDefCategory category) {
        if (allTypes != null) {
            ArrayList<TypeDef> typesForCategory = new ArrayList<TypeDef>();
            for (TypeDef typeDef : allTypes) {
                if (typeDef == null || typeDef.getCategory() != category) continue;
                typesForCategory.add(typeDef);
            }
            if (typesForCategory.isEmpty()) {
                typesForCategory = null;
            }
            return typesForCategory;
        }
        return null;
    }

    @Override
    public List<TypeDef> findTypeDefsByCategory(String userId, TypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByCategory";
        String categoryParameterName = "category";
        this.typeDefCategoryParameterValidation(userId, category, "category", "findTypeDefsByCategory");
        return this.filterTypeDefsByCategory(this.repositoryHelper.getActiveTypeDefs(), category);
    }

    protected List<AttributeTypeDef> filterAttributeTypeDefsByCategory(List<AttributeTypeDef> allTypes, AttributeTypeDefCategory category) {
        if (allTypes != null) {
            ArrayList<AttributeTypeDef> typesForCategory = new ArrayList<AttributeTypeDef>();
            for (AttributeTypeDef attributeTypeDef : allTypes) {
                if (attributeTypeDef == null || attributeTypeDef.getCategory() != category) continue;
                typesForCategory.add(attributeTypeDef);
            }
            if (typesForCategory.isEmpty()) {
                typesForCategory = null;
            }
            return typesForCategory;
        }
        return null;
    }

    @Override
    public List<AttributeTypeDef> findAttributeTypeDefsByCategory(String userId, AttributeTypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findAttributeTypeDefsByCategory";
        String categoryParameterName = "category";
        this.attributeTypeDefCategoryParameterValidation(userId, category, "category", "findAttributeTypeDefsByCategory");
        return this.filterAttributeTypeDefsByCategory(this.repositoryHelper.getActiveAttributeTypeDefs(), category);
    }

    protected List<TypeDef> filterTypeDefsByProperty(List<TypeDef> allTypes, TypeDefProperties matchCriteria) {
        if (allTypes != null) {
            ArrayList<TypeDef> typesMatchProperties = new ArrayList<TypeDef>();
            Set<String> propertyNames = matchCriteria.getTypeDefProperties().keySet();
            for (TypeDef typeDef : allTypes) {
                if (typeDef == null) continue;
                List<TypeDefAttribute> typeDefAttributes = typeDef.getPropertiesDefinition();
                boolean allPropertiesMatch = true;
                for (String propertyName : propertyNames) {
                    boolean thisPropertyMatches = false;
                    if (propertyName == null) continue;
                    for (TypeDefAttribute attribute : typeDefAttributes) {
                        if (attribute == null || !propertyName.equals(attribute.getAttributeName())) continue;
                        thisPropertyMatches = true;
                        break;
                    }
                    if (thisPropertyMatches) continue;
                    allPropertiesMatch = false;
                    break;
                }
                if (!allPropertiesMatch) continue;
                typesMatchProperties.add(typeDef);
            }
            if (typesMatchProperties.isEmpty()) {
                typesMatchProperties = null;
            }
            return typesMatchProperties;
        }
        return null;
    }

    @Override
    public List<TypeDef> findTypeDefsByProperty(String userId, TypeDefProperties matchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByProperty";
        String matchCriteriaParameterName = "matchCriteria";
        this.typeDefPropertyParameterValidation(userId, matchCriteria, "matchCriteria", "findTypeDefsByProperty");
        return this.filterTypeDefsByProperty(this.repositoryHelper.getActiveTypeDefs(), matchCriteria);
    }

    public List<TypeDef> filterTypesByExternalID(List<TypeDef> allTypes, String standard, String organization, String identifier) {
        if (allTypes != null) {
            ArrayList<TypeDef> matchingTypes = new ArrayList<TypeDef>();
            for (TypeDef activeTypeDef : allTypes) {
                List<TypeDefAttribute> typeDefAttributes;
                ArrayList<ExternalStandardMapping> externalStandardMappings = new ArrayList<ExternalStandardMapping>();
                if (activeTypeDef.getExternalStandardMappings() != null) {
                    externalStandardMappings.addAll(activeTypeDef.getExternalStandardMappings());
                }
                if ((typeDefAttributes = activeTypeDef.getPropertiesDefinition()) != null) {
                    for (TypeDefAttribute typeDefAttribute : typeDefAttributes) {
                        if (typeDefAttribute == null || typeDefAttribute.getExternalStandardMappings() == null) continue;
                        externalStandardMappings.addAll(activeTypeDef.getExternalStandardMappings());
                    }
                }
                for (ExternalStandardMapping externalStandardMapping : externalStandardMappings) {
                    String activeTypeDefStandardName = externalStandardMapping.getStandardName();
                    String activeTypeDefStandardOrgName = externalStandardMapping.getStandardOrganization();
                    String activeTypeDefStandardIdentifier = externalStandardMapping.getStandardTypeName();
                    if (activeTypeDefStandardName != null && activeTypeDefStandardName.equals(standard)) {
                        matchingTypes.add(activeTypeDef);
                        continue;
                    }
                    if (activeTypeDefStandardOrgName != null && activeTypeDefStandardOrgName.equals(organization)) {
                        matchingTypes.add(activeTypeDef);
                        continue;
                    }
                    if (activeTypeDefStandardIdentifier == null || !activeTypeDefStandardIdentifier.equals(identifier)) continue;
                    matchingTypes.add(activeTypeDef);
                }
            }
            if (matchingTypes.isEmpty()) {
                return null;
            }
            return matchingTypes;
        }
        return null;
    }

    @Override
    public List<TypeDef> findTypesByExternalID(String userId, String standard, String organization, String identifier) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypesByExternalID";
        this.typeDefExternalIDParameterValidation(userId, standard, organization, identifier, "findTypesByExternalID");
        return this.filterTypesByExternalID(this.repositoryHelper.getActiveTypeDefs(), standard, organization, identifier);
    }

    public List<TypeDef> filterTypeDefsBySearchCriteria(List<TypeDef> allTypes, String searchCriteria) {
        if (allTypes != null) {
            ArrayList<TypeDef> matchedTypeDefs = new ArrayList<TypeDef>();
            for (TypeDef typeDef : allTypes) {
                if (typeDef == null || !typeDef.getName().matches(searchCriteria)) continue;
                matchedTypeDefs.add(typeDef);
            }
            if (matchedTypeDefs.isEmpty()) {
                matchedTypeDefs = null;
            }
            return matchedTypeDefs;
        }
        return null;
    }

    @Override
    public List<TypeDef> searchForTypeDefs(String userId, String searchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "searchForTypeDefs";
        String searchCriteriaParameterName = "searchCriteria";
        this.typeDefSearchParameterValidation(userId, searchCriteria, "searchCriteria", "searchForTypeDefs");
        return this.filterTypeDefsBySearchCriteria(this.repositoryHelper.getActiveTypeDefs(), searchCriteria);
    }

    public TypeDef filterTypeDefsByGUID(List<TypeDef> allTypes, String guid) {
        if (allTypes != null) {
            for (TypeDef typeDef : allTypes) {
                if (typeDef == null || !typeDef.getGUID().equals(guid)) continue;
                return typeDef;
            }
        }
        return null;
    }

    @Override
    public TypeDef getTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByGUID";
        String guidParameterName = "guid";
        this.typeGUIDParameterValidation(userId, guid, "guid", "getTypeDefByGUID");
        TypeDef result = this.filterTypeDefsByGUID(this.repositoryHelper.getActiveTypeDefs(), guid);
        if (result == null) {
            this.reportUnknownTypeGUID(guid, "guid", "getTypeDefByGUID");
        }
        return result;
    }

    public AttributeTypeDef filterAttributeTypeDefsByGUID(List<AttributeTypeDef> allTypes, String guid) {
        if (allTypes != null) {
            for (AttributeTypeDef attributeTypeDef : allTypes) {
                if (attributeTypeDef == null || !attributeTypeDef.getGUID().equals(guid)) continue;
                return attributeTypeDef;
            }
        }
        return null;
    }

    @Override
    public AttributeTypeDef getAttributeTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByGUID";
        String guidParameterName = "guid";
        this.typeGUIDParameterValidation(userId, guid, "guid", "getAttributeTypeDefByGUID");
        AttributeTypeDef result = this.filterAttributeTypeDefsByGUID(this.repositoryHelper.getActiveAttributeTypeDefs(), guid);
        if (result == null) {
            this.reportUnknownTypeGUID(guid, "guid", "getAttributeTypeDefByGUID");
        }
        return result;
    }

    public TypeDef filterTypeDefsByName(List<TypeDef> allTypes, String name) {
        if (allTypes != null) {
            for (TypeDef typeDef : allTypes) {
                if (typeDef == null || !typeDef.getName().equals(name)) continue;
                return typeDef;
            }
        }
        return null;
    }

    @Override
    public TypeDef getTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByName";
        String nameParameterName = "name";
        this.typeNameParameterValidation(userId, name, "name", "getTypeDefByName");
        TypeDef result = this.filterTypeDefsByName(this.repositoryHelper.getActiveTypeDefs(), name);
        if (result == null) {
            this.reportUnknownTypeName(name, "getTypeDefByName");
        }
        return result;
    }

    public AttributeTypeDef filterAttributeTypeDefsByName(List<AttributeTypeDef> allTypes, String name) {
        if (allTypes != null) {
            for (AttributeTypeDef attributeTypeDef : allTypes) {
                if (attributeTypeDef == null || !attributeTypeDef.getName().equals(name)) continue;
                return attributeTypeDef;
            }
        }
        return null;
    }

    @Override
    public AttributeTypeDef getAttributeTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByName";
        String nameParameterName = "name";
        this.typeNameParameterValidation(userId, name, "name", "getAttributeTypeDefByName");
        AttributeTypeDef result = this.filterAttributeTypeDefsByName(this.repositoryHelper.getActiveAttributeTypeDefs(), name);
        if (result == null) {
            this.reportUnknownTypeName(name, "getAttributeTypeDefByName");
        }
        return result;
    }

    @Override
    public void addTypeDefGallery(String userId, TypeDefGallery newTypes) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addTypeDefGallery";
        String galleryParameterName = "newTypes";
        super.basicRequestValidation(userId, "addTypeDefGallery");
        this.repositoryValidator.validateTypeDefGallery(this.repositoryName, "newTypes", newTypes, "addTypeDefGallery");
        List<AttributeTypeDef> attributeTypeDefs = newTypes.getAttributeTypeDefs();
        ArrayList<TypeDef> typeDefs = newTypes.getTypeDefs();
        if (attributeTypeDefs != null) {
            for (AttributeTypeDef attributeTypeDef : attributeTypeDefs) {
                this.addAttributeTypeDef(userId, attributeTypeDef);
            }
        }
        if (typeDefs != null) {
            for (TypeDef typeDef : typeDefs) {
                this.addTypeDef(userId, typeDef);
            }
        }
    }

    @Override
    public void addTypeDef(String userId, TypeDef newTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addTypeDef";
        String typeDefParameterName = "newTypeDef";
        this.newTypeDefParameterValidation(userId, newTypeDef, "newTypeDef", "addTypeDef");
        this.reportUnsupportedOptionalFunction("addTypeDef");
    }

    @Override
    public void addAttributeTypeDef(String userId, AttributeTypeDef newAttributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addAttributeTypeDef";
        String typeDefParameterName = "newAttributeTypeDef";
        this.newAttributeTypeDefParameterValidation(userId, newAttributeTypeDef, "newAttributeTypeDef", "addAttributeTypeDef");
        this.reportUnsupportedOptionalFunction("addAttributeTypeDef");
    }

    @Override
    public boolean verifyTypeDef(String userId, TypeDef typeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyTypeDef";
        String typeDefParameterName = "typeDef";
        this.typeDefParameterValidation(userId, typeDef, "typeDef", "verifyTypeDef");
        this.reportUnsupportedMandatoryFunction("verifyTypeDef");
        return false;
    }

    @Override
    public boolean verifyAttributeTypeDef(String userId, AttributeTypeDef attributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyAttributeTypeDef";
        String typeDefParameterName = "attributeTypeDef";
        this.attributeTypeDefParameterValidation(userId, attributeTypeDef, "attributeTypeDef", "verifyAttributeTypeDef");
        this.reportUnsupportedMandatoryFunction("verifyAttributeTypeDef");
        return false;
    }

    @Override
    public TypeDef updateTypeDef(String userId, TypeDefPatch typeDefPatch) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, PatchErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateTypeDef";
        this.updateTypeDefParameterValidation(userId, typeDefPatch, "updateTypeDef");
        this.reportUnsupportedOptionalFunction("updateTypeDef");
        return null;
    }

    @Override
    public void deleteTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteTypeDef";
        String guidParameterName = "obsoleteTypeDefGUID";
        String nameParameterName = "obsoleteTypeDefName";
        this.manageTypeDefParameterValidation(userId, "obsoleteTypeDefGUID", "obsoleteTypeDefName", obsoleteTypeDefGUID, obsoleteTypeDefName, "deleteTypeDef");
        this.reportUnsupportedOptionalFunction("deleteTypeDef");
    }

    @Override
    public void deleteAttributeTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteAttributeTypeDef";
        String guidParameterName = "obsoleteTypeDefGUID";
        String nameParameterName = "obsoleteTypeDefName";
        this.manageAttributeTypeDefParameterValidation(userId, "obsoleteTypeDefGUID", "obsoleteTypeDefName", obsoleteTypeDefGUID, obsoleteTypeDefName, "deleteAttributeTypeDef");
        this.reportUnsupportedOptionalFunction("deleteAttributeTypeDef");
    }

    @Override
    public TypeDef reIdentifyTypeDef(String userId, String originalTypeDefGUID, String originalTypeDefName, String newTypeDefGUID, String newTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyTypeDef";
        String originalGUIDParameterName = "originalTypeDefGUID";
        String originalNameParameterName = "originalTypeDefName";
        String newGUIDParameterName = "newTypeDefGUID";
        String newNameParameterName = "newTypeDefName";
        this.manageTypeDefParameterValidation(userId, "originalTypeDefGUID", "originalTypeDefName", originalTypeDefGUID, originalTypeDefName, "reIdentifyTypeDef");
        this.manageTypeDefParameterValidation(userId, "newTypeDefGUID", "newTypeDefName", newTypeDefGUID, newTypeDefName, "reIdentifyTypeDef");
        this.reportUnsupportedOptionalFunction("reIdentifyTypeDef");
        return null;
    }

    @Override
    public AttributeTypeDef reIdentifyAttributeTypeDef(String userId, String originalAttributeTypeDefGUID, String originalAttributeTypeDefName, String newAttributeTypeDefGUID, String newAttributeTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyAttributeTypeDef";
        String originalGUIDParameterName = "originalAttributeTypeDefGUID";
        String originalNameParameterName = "originalAttributeTypeDefName";
        String newGUIDParameterName = "newAttributeTypeDefGUID";
        String newNameParameterName = "newAttributeTypeDefName";
        this.manageAttributeTypeDefParameterValidation(userId, "originalAttributeTypeDefGUID", "originalAttributeTypeDefName", originalAttributeTypeDefGUID, originalAttributeTypeDefName, "reIdentifyAttributeTypeDef");
        this.manageAttributeTypeDefParameterValidation(userId, "newAttributeTypeDefGUID", "newAttributeTypeDefName", newAttributeTypeDefGUID, newAttributeTypeDefName, "reIdentifyAttributeTypeDef");
        this.reportUnsupportedOptionalFunction("reIdentifyAttributeTypeDef");
        return null;
    }

    protected void getInstanceParameterValidation(String userId, String guid, String methodName) throws InvalidParameterException, RepositoryErrorException {
        String guidParameterName = "guid";
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateGUID(this.repositoryName, "guid", guid, methodName);
    }

    protected void getInstanceParameterValidation(String userId, String guid, Date asOfTime, String methodName) throws InvalidParameterException, RepositoryErrorException {
        String guidParameterName = "guid";
        String asOfTimeParameter = "asOfTime";
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateGUID(this.repositoryName, "guid", guid, methodName);
        this.repositoryValidator.validateAsOfTimeNotNull(this.repositoryName, "asOfTime", asOfTime, methodName);
    }

    protected void getInstanceHistoryParameterValidation(String userId, String guid, Date fromTime, Date toTime, String methodName) throws InvalidParameterException, RepositoryErrorException {
        String guidParameterName = "guid";
        String timeRangeParameterNames = "fromTime/toTime";
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateGUID(this.repositoryName, "guid", guid, methodName);
        this.repositoryValidator.validateDateRange(this.repositoryName, "fromTime/toTime", fromTime, toTime, methodName);
    }

    protected void getRelationshipsForEntityParameterValidation(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PagingErrorException, UserNotAuthorizedException {
        String methodName = "getRelationshipsForEntity";
        String guidParameterName = "entityGUID";
        String typeGUIDParameter = "relationshipTypeGUID";
        String asOfTimeParameter = "asOfTime";
        String pageSizeParameter = "pageSize";
        super.basicRequestValidation(userId, "getRelationshipsForEntity");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "getRelationshipsForEntity");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "getRelationshipsForEntity");
        this.repositoryValidator.validateOptionalTypeGUID(this.repositoryName, "relationshipTypeGUID", relationshipTypeGUID, "getRelationshipsForEntity");
        this.repositoryValidator.validatePageSize(this.repositoryName, "pageSize", pageSize, "getRelationshipsForEntity");
    }

    protected void findEntitiesByPropertyParameterValidation(String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        String methodName = "findEntitiesByProperty";
        String matchCriteriaParameterName = "matchCriteria";
        String matchPropertiesParameterName = "matchProperties";
        String typeGUIDParameterName = "entityTypeGUID";
        String asOfTimeParameter = "asOfTime";
        String pageSizeParameter = "pageSize";
        super.basicRequestValidation(userId, "findEntitiesByProperty");
        this.repositoryValidator.validateOptionalTypeGUID(this.repositoryName, "entityTypeGUID", entityTypeGUID, "findEntitiesByProperty");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "findEntitiesByProperty");
        this.repositoryValidator.validatePageSize(this.repositoryName, "pageSize", pageSize, "findEntitiesByProperty");
        this.repositoryValidator.validateMatchCriteria(this.repositoryName, "matchCriteria", "matchProperties", matchCriteria, matchProperties, "findEntitiesByProperty");
    }

    protected void findEntitiesParameterValidation(String userId, String entityTypeGUID, List<String> entitySubtypeGUIDs, SearchProperties matchProperties, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PagingErrorException {
        String methodName = "findEntities";
        String typeGUIDParameterName = "entityTypeGUID";
        String subtypeGUIDsParameterName = "entitySubtypeGUIDs";
        String asOfTimeParameter = "asOfTime";
        String pageSizeParameter = "pageSize";
        String matchPropertiesParameterName = "matchProperties";
        String matchClassificationsParameterName = "matchClassifications";
        super.basicRequestValidation(userId, "findEntities");
        this.repositoryValidator.validateOptionalTypeGUIDs(this.repositoryName, "entityTypeGUID", entityTypeGUID, "entitySubtypeGUIDs", entitySubtypeGUIDs, "findEntities");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "findEntities");
        this.repositoryValidator.validatePageSize(this.repositoryName, "pageSize", pageSize, "findEntities");
        this.repositoryValidator.validateSearchProperties(this.repositoryName, "matchProperties", matchProperties, "findEntities");
        this.repositoryValidator.validateSearchClassifications(this.repositoryName, "matchClassifications", matchClassifications, "findEntities");
    }

    protected void findEntitiesByClassificationParameterValidation(String userId, String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        String methodName = "findEntitiesByClassification";
        String classificationParameterName = "classificationName";
        String entityTypeGUIDParameterName = "entityTypeGUID";
        String matchCriteriaParameterName = "matchCriteria";
        String matchPropertiesParameterName = "matchClassificationProperties";
        String asOfTimeParameter = "asOfTime";
        String pageSizeParameter = "pageSize";
        super.basicRequestValidation(userId, "findEntitiesByClassification");
        this.repositoryValidator.validateOptionalTypeGUID(this.repositoryName, "entityTypeGUID", entityTypeGUID, "findEntitiesByClassification");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "findEntitiesByClassification");
        this.repositoryValidator.validatePageSize(this.repositoryName, "pageSize", pageSize, "findEntitiesByClassification");
        if (entityTypeGUID != null) {
            TypeDef entityTypeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "entityTypeGUID", entityTypeGUID, "findEntitiesByClassification");
            this.repositoryValidator.validateTypeDefForInstance(this.repositoryName, "entityTypeGUID", entityTypeDef, "findEntitiesByClassification");
            this.repositoryValidator.validateClassification(this.repositoryName, "classificationName", classificationName, entityTypeDef.getName(), "findEntitiesByClassification");
        }
        this.repositoryValidator.validateMatchCriteria(this.repositoryName, "matchCriteria", "matchClassificationProperties", matchCriteria, matchClassificationProperties, "findEntitiesByClassification");
    }

    protected void findEntitiesByPropertyValueParameterValidation(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        String methodName = "findEntitiesByPropertyValue";
        String searchCriteriaParameterName = "searchCriteria";
        String typeGUIDParameter = "entityTypeGUID";
        String asOfTimeParameter = "asOfTime";
        String pageSizeParameter = "pageSize";
        super.basicRequestValidation(userId, "findEntitiesByPropertyValue");
        this.repositoryValidator.validateSearchCriteria(this.repositoryName, "searchCriteria", searchCriteria, "findEntitiesByPropertyValue");
        this.repositoryValidator.validateOptionalTypeGUID(this.repositoryName, "entityTypeGUID", entityTypeGUID, "findEntitiesByPropertyValue");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "findEntitiesByPropertyValue");
        this.repositoryValidator.validatePageSize(this.repositoryName, "pageSize", pageSize, "findEntitiesByPropertyValue");
    }

    protected void findRelationshipsParameterValidation(String userId, String relationshipTypeGUID, List<String> relationshipSubtypeGUIDs, SearchProperties matchProperties, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PagingErrorException {
        String methodName = "findRelationships";
        String matchPropertiesParameterName = "matchProperties";
        String guidParameterName = "relationshipTypeGUID";
        String subtypeGuidsParameterName = "relationshipSubtypeGUIDs";
        String asOfTimeParameter = "asOfTime";
        String pageSizeParameter = "pageSize";
        super.basicRequestValidation(userId, "findRelationships");
        this.repositoryValidator.validateOptionalTypeGUIDs(this.repositoryName, "relationshipTypeGUID", relationshipTypeGUID, "relationshipSubtypeGUIDs", relationshipSubtypeGUIDs, "findRelationships");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "findRelationships");
        this.repositoryValidator.validatePageSize(this.repositoryName, "pageSize", pageSize, "findRelationships");
        this.repositoryValidator.validateSearchProperties(this.repositoryName, "matchProperties", matchProperties, "findRelationships");
    }

    protected void findRelationshipsByPropertyParameterValidation(String userId, String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByProperty";
        String matchCriteriaParameterName = "matchCriteria";
        String matchPropertiesParameterName = "matchProperties";
        String guidParameterName = "relationshipTypeGUID";
        String asOfTimeParameter = "asOfTime";
        String pageSizeParameter = "pageSize";
        super.basicRequestValidation(userId, "findRelationshipsByProperty");
        this.repositoryValidator.validateOptionalTypeGUID(this.repositoryName, "relationshipTypeGUID", relationshipTypeGUID, "findRelationshipsByProperty");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "findRelationshipsByProperty");
        this.repositoryValidator.validatePageSize(this.repositoryName, "pageSize", pageSize, "findRelationshipsByProperty");
        this.repositoryValidator.validateMatchCriteria(this.repositoryName, "matchCriteria", "matchProperties", matchCriteria, matchProperties, "findRelationshipsByProperty");
    }

    protected void findRelationshipsByPropertyValueParameterValidation(String userId, String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByPropertyName";
        String searchCriteriaParameterName = "searchCriteria";
        String asOfTimeParameter = "asOfTime";
        String typeGUIDParameter = "relationshipTypeGUID";
        String pageSizeParameter = "pageSize";
        super.basicRequestValidation(userId, "findRelationshipsByPropertyName");
        this.repositoryValidator.validateOptionalTypeGUID(this.repositoryName, "relationshipTypeGUID", relationshipTypeGUID, "findRelationshipsByPropertyName");
        this.repositoryValidator.validateSearchCriteria(this.repositoryName, "searchCriteria", searchCriteria, "findRelationshipsByPropertyName");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "findRelationshipsByPropertyName");
        this.repositoryValidator.validatePageSize(this.repositoryName, "pageSize", pageSize, "findRelationshipsByPropertyName");
    }

    protected void getEntityNeighborhoodParameterValidation(String userId, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityNeighborhood";
        String entityGUIDParameterName = "entityGUID";
        String entityTypeGUIDParameterName = "entityTypeGUIDs";
        String relationshipTypeGUIDParameterName = "relationshipTypeGUIDs";
        String limitedResultsByClassificationParameterName = "limitResultsByClassification";
        String asOfTimeParameter = "asOfTime";
        super.basicRequestValidation(userId, "getEntityNeighborhood");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "getEntityNeighborhood");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "getEntityNeighborhood");
        if (entityTypeGUIDs != null) {
            for (String guid : entityTypeGUIDs) {
                this.repositoryValidator.validateTypeGUID(this.repositoryName, "entityTypeGUIDs", guid, "getEntityNeighborhood");
            }
        }
        if (relationshipTypeGUIDs != null) {
            for (String guid : relationshipTypeGUIDs) {
                this.repositoryValidator.validateTypeGUID(this.repositoryName, "relationshipTypeGUIDs", guid, "getEntityNeighborhood");
            }
        }
        if (limitResultsByClassification != null) {
            for (String classificationName : limitResultsByClassification) {
                this.repositoryValidator.validateClassificationName(this.repositoryName, "limitResultsByClassification", classificationName, "getEntityNeighborhood");
            }
        }
    }

    protected void getLinkingEntitiesParameterValidation(String userId, String startEntityGUID, String endEntityGUID, List<InstanceStatus> limitResultsByStatus, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, PropertyErrorException, UserNotAuthorizedException {
        String methodName = "getLinkingEntities";
        String startEntityGUIDParameterName = "startEntityGUID";
        String endEntityGUIDParameterName = "entityGUID";
        String asOfTimeParameter = "asOfTime";
        super.basicRequestValidation(userId, "getLinkingEntities");
        this.repositoryValidator.validateGUID(this.repositoryName, "startEntityGUID", startEntityGUID, "getLinkingEntities");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", endEntityGUID, "getLinkingEntities");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "getLinkingEntities");
    }

    protected void getRelatedEntitiesParameterValidation(String userId, String startEntityGUID, List<String> entityTypeGUIDs, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        String methodName = "getRelatedEntities";
        String entityGUIDParameterName = "startEntityGUID";
        String instanceTypesParameter = "instanceTypes";
        String asOfTimeParameter = "asOfTime";
        String pageSizeParameter = "pageSize";
        super.basicRequestValidation(userId, "getRelatedEntities");
        this.repositoryValidator.validateGUID(this.repositoryName, "startEntityGUID", startEntityGUID, "getRelatedEntities");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "getRelatedEntities");
        this.repositoryValidator.validatePageSize(this.repositoryName, "pageSize", pageSize, "getRelatedEntities");
        if (entityTypeGUIDs != null) {
            for (String guid : entityTypeGUIDs) {
                this.repositoryValidator.validateTypeGUID(this.repositoryName, "instanceTypes", guid, "getRelatedEntities");
            }
        }
    }

    @Override
    public EntityDetail isEntityKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isEntityKnown";
        this.getInstanceParameterValidation(userId, guid, "isEntityKnown");
        this.reportUnsupportedMandatoryFunction("isEntityKnown");
        return null;
    }

    @Override
    public EntitySummary getEntitySummary(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        String methodName = "getEntitySummary";
        this.getInstanceParameterValidation(userId, guid, "getEntitySummary");
        this.reportUnsupportedMandatoryFunction("getEntitySummary");
        return null;
    }

    @Override
    public EntityDetail getEntityDetail(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        this.getInstanceParameterValidation(userId, guid, "getEntityDetail");
        this.reportUnsupportedMandatoryFunction("getEntityDetail");
        return null;
    }

    @Override
    public EntityDetail getEntityDetail(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        this.getInstanceParameterValidation(userId, guid, asOfTime, "getEntityDetail");
        this.reportUnsupportedAsOfTimeFunction("getEntityDetail", asOfTime);
        return null;
    }

    @Override
    public List<EntityDetail> getEntityDetailHistory(String userId, String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityDetailHistory";
        this.getInstanceHistoryParameterValidation(userId, guid, fromTime, toTime, "getEntityDetailHistory");
        this.reportUnsupportedOptionalFunction("getEntityDetailHistory");
        return null;
    }

    @Override
    public List<Relationship> getRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationshipsForEntity";
        this.getRelationshipsForEntityParameterValidation(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        this.reportUnsupportedAsOfTimeFunction("getRelationshipsForEntity", asOfTime);
        return null;
    }

    @Override
    public List<EntityDetail> findEntities(String userId, String entityTypeGUID, List<String> entitySubtypeGUIDs, SearchProperties matchProperties, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntities";
        this.findEntitiesParameterValidation(userId, entityTypeGUID, entitySubtypeGUIDs, matchProperties, fromEntityElement, limitResultsByStatus, matchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        this.reportUnsupportedOptionalFunction("findEntities");
        return null;
    }

    @Override
    public List<EntityDetail> findEntitiesByProperty(String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByProperty";
        this.findEntitiesByPropertyParameterValidation(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        this.reportUnsupportedAsOfTimeFunction("findEntitiesByProperty", asOfTime);
        return null;
    }

    @Override
    public List<EntityDetail> findEntitiesByClassification(String userId, String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByClassification";
        this.findEntitiesByClassificationParameterValidation(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        this.reportUnsupportedAsOfTimeFunction("findEntitiesByClassification", asOfTime);
        return null;
    }

    @Override
    public List<EntityDetail> findEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByPropertyValue";
        this.findEntitiesByPropertyValueParameterValidation(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        this.reportUnsupportedAsOfTimeFunction("findEntitiesByPropertyValue", asOfTime);
        return null;
    }

    @Override
    public Relationship isRelationshipKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isRelationshipKnown";
        this.getInstanceParameterValidation(userId, guid, "isRelationshipKnown");
        this.reportUnsupportedMandatoryFunction("isRelationshipKnown");
        return null;
    }

    @Override
    public Relationship getRelationship(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        this.getInstanceParameterValidation(userId, guid, "getRelationship");
        this.reportUnsupportedMandatoryFunction("getRelationship");
        return null;
    }

    @Override
    public Relationship getRelationship(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        this.getInstanceParameterValidation(userId, guid, asOfTime, "getRelationship");
        this.reportUnsupportedAsOfTimeFunction("getRelationship", asOfTime);
        return null;
    }

    @Override
    public List<Relationship> getRelationshipHistory(String userId, String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationshipHistory";
        this.getInstanceHistoryParameterValidation(userId, guid, fromTime, toTime, "getRelationshipHistory");
        this.reportUnsupportedOptionalFunction("getRelationshipHistory");
        return null;
    }

    @Override
    public List<Relationship> findRelationships(String userId, String relationshipTypeGUID, List<String> relationshipSubtypeGUIDs, SearchProperties matchProperties, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationships";
        this.findRelationshipsParameterValidation(userId, relationshipTypeGUID, relationshipSubtypeGUIDs, matchProperties, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        this.reportUnsupportedOptionalFunction("findRelationships");
        return null;
    }

    @Override
    public List<Relationship> findRelationshipsByProperty(String userId, String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByProperty";
        this.findRelationshipsByPropertyParameterValidation(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        this.reportUnsupportedOptionalFunction("findRelationshipsByProperty");
        return null;
    }

    @Override
    public List<Relationship> findRelationshipsByPropertyValue(String userId, String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByPropertyName";
        this.findRelationshipsByPropertyValueParameterValidation(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        this.reportUnsupportedOptionalFunction("findRelationshipsByPropertyName");
        return null;
    }

    @Override
    public InstanceGraph getLinkingEntities(String userId, String startEntityGUID, String endEntityGUID, List<InstanceStatus> limitResultsByStatus, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getLinkingEntities";
        this.getLinkingEntitiesParameterValidation(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
        this.reportUnsupportedOptionalFunction("getLinkingEntities");
        return null;
    }

    @Override
    public InstanceGraph getEntityNeighborhood(String userId, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityNeighborhood";
        this.getEntityNeighborhoodParameterValidation(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
        this.reportUnsupportedOptionalFunction("getEntityNeighborhood");
        return null;
    }

    @Override
    public List<EntityDetail> getRelatedEntities(String userId, String startEntityGUID, List<String> entityTypeGUIDs, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelatedEntities";
        this.getRelatedEntitiesParameterValidation(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        this.reportUnsupportedOptionalFunction("getRelatedEntities");
        return null;
    }

    protected TypeDef addEntityParameterValidation(String userId, String entityTypeGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus, String methodName) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException {
        String entityGUIDParameterName = "entityTypeGUID";
        String propertiesParameterName = "initialProperties";
        String classificationsParameterName = "initialClassifications";
        String initialStatusParameterName = "initialStatus";
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateTypeGUID(this.repositoryName, "entityTypeGUID", entityTypeGUID, methodName);
        TypeDef typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "entityTypeGUID", entityTypeGUID, methodName);
        this.repositoryValidator.validateTypeDefForInstance(this.repositoryName, "entityTypeGUID", typeDef, methodName);
        this.repositoryValidator.validateClassificationList(this.repositoryName, "initialClassifications", initialClassifications, typeDef.getName(), methodName);
        this.repositoryValidator.validatePropertiesForType(this.repositoryName, "initialProperties", typeDef, initialProperties, methodName);
        this.repositoryValidator.validateInstanceStatus(this.repositoryName, "initialStatus", initialStatus, typeDef, methodName);
        return typeDef;
    }

    @Deprecated
    protected TypeDef addEntityParameterValidation(String userId, String entityTypeGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, UserNotAuthorizedException {
        String methodName = "addEntity";
        return this.addEntityParameterValidation(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus, "addEntity");
    }

    protected TypeDef addExternalEntityParameterValidation(String userId, String entityTypeGUID, String externalSourceGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus, String methodName) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, UserNotAuthorizedException {
        String guidParameterName = "entityTypeGUID";
        this.repositoryValidator.validateGUID(this.repositoryName, "entityTypeGUID", externalSourceGUID, methodName);
        return this.addEntityParameterValidation(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus, methodName);
    }

    protected void addEntityProxyParameterValidation(String userId, EntityProxy entityProxy) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "addEntityProxy";
        String proxyParameterName = "entityProxy";
        super.basicRequestValidation(userId, "addEntityProxy");
        this.repositoryValidator.validateEntityProxy(this.repositoryName, this.metadataCollectionId, "entityProxy", entityProxy, "addEntityProxy");
    }

    protected void updateInstanceStatusParameterValidation(String userId, String entityGUID, InstanceStatus newStatus, String methodName) throws InvalidParameterException, RepositoryErrorException {
        String entityGUIDParameterName = "entityGUID";
        String statusParameterName = "newStatus";
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, methodName);
        if (newStatus == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_INSTANCE_STATUS.getMessageDefinition("newStatus", methodName, this.repositoryName), this.getClass().getName(), methodName, "newStatus");
        }
    }

    protected void updateInstancePropertiesPropertyValidation(String userId, String instanceGUID, InstanceProperties properties, String methodName) throws InvalidParameterException, RepositoryErrorException {
        String guidParameterName = "instanceGUID";
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateGUID(this.repositoryName, "instanceGUID", instanceGUID, methodName);
    }

    protected void manageInstanceParameterValidation(String userId, String instanceGUID, String instanceGUIDParameterName, String methodName) throws InvalidParameterException, RepositoryErrorException {
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateGUID(this.repositoryName, instanceGUIDParameterName, instanceGUID, methodName);
    }

    @Deprecated
    protected void manageInstanceParameterValidation(String userId, String instanceGUID, String methodName) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String instanceGUIDParameterName = "instanceGUID";
        this.manageInstanceParameterValidation(userId, instanceGUID, "instanceGUID", methodName);
    }

    protected void manageInstanceParameterValidation(String userId, String typeDefGUID, String typeDefName, String instanceGUID, String instanceGUIDParameterName, String methodName) throws InvalidParameterException, RepositoryErrorException {
        String typeDefGUIDParameterName = "typeDefGUID";
        String typeDefNameParameterName = "typeDefName";
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, methodName);
        this.repositoryValidator.validateGUID(this.repositoryName, instanceGUIDParameterName, instanceGUID, methodName);
    }

    @Deprecated
    protected void removeInstanceParameterValidation(String userId, String typeDefGUID, String typeDefName, String instanceGUID, String methodName) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String instanceGUIDParameterName = "instanceGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, instanceGUID, "instanceGUID", methodName);
    }

    protected TypeDef classifyEntityParameterValidation(String userId, String entityGUID, String classificationName, InstanceProperties classificationProperties, String methodName) throws InvalidParameterException, RepositoryErrorException, PropertyErrorException {
        String entityGUIDParameterName = "entityGUID";
        String classificationParameterName = "classificationName";
        String propertiesParameterName = "classificationProperties";
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateUserId(this.repositoryName, userId, methodName);
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, methodName);
        TypeDef typeDef = this.repositoryValidator.validateClassificationName(this.repositoryName, "classificationName", classificationName, methodName);
        this.repositoryValidator.validateClassificationProperties(this.repositoryName, classificationName, "classificationProperties", classificationProperties, methodName);
        return typeDef;
    }

    @Deprecated
    protected TypeDef classifyEntityParameterValidation(String userId, String entityGUID, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, PropertyErrorException, UserNotAuthorizedException {
        String methodName = "classifyEntity";
        return this.classifyEntityParameterValidation(userId, entityGUID, classificationName, classificationProperties, "classifyEntity");
    }

    protected TypeDef classifyEntityParameterValidation(String userId, EntityProxy entityProxy, String classificationName, InstanceProperties classificationProperties, String methodName) throws InvalidParameterException, RepositoryErrorException, PropertyErrorException, UserNotAuthorizedException {
        if (entityProxy == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_ENTITY_PROXY.getMessageDefinition(this.repositoryName, "entityProxy", methodName), this.getClass().getName(), methodName, "entityProxy");
        }
        return this.classifyEntityParameterValidation(userId, entityProxy.getGUID(), classificationName, classificationProperties, methodName);
    }

    protected void declassifyEntityParameterValidation(String userId, String entityGUID, String classificationName, String methodName) throws InvalidParameterException, RepositoryErrorException {
        String entityGUIDParameterName = "entityGUID";
        String classificationParameterName = "classificationName";
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, methodName);
        this.repositoryValidator.validateClassificationName(this.repositoryName, "classificationName", classificationName, methodName);
    }

    protected void declassifyEntityParameterValidation(String userId, EntityProxy entityProxy, String classificationName, String methodName) throws InvalidParameterException, RepositoryErrorException {
        String entityGUIDParameterName = "entityGUID";
        String classificationParameterName = "classificationName";
        super.basicRequestValidation(userId, methodName);
        if (entityProxy == null) {
            this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", null, methodName);
        } else {
            this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityProxy.getGUID(), methodName);
        }
        this.repositoryValidator.validateClassificationName(this.repositoryName, "classificationName", classificationName, methodName);
    }

    @Deprecated
    protected void declassifyEntityParameterValidation(String userId, String entityGUID, String classificationName) throws InvalidParameterException, RepositoryErrorException {
        String methodName = "declassifyEntity";
        this.declassifyEntityParameterValidation(userId, entityGUID, classificationName, "declassifyEntity");
    }

    @Deprecated
    protected TypeDef updateEntityClassificationParameterValidation(String userId, String entityGUID, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, PropertyErrorException, UserNotAuthorizedException {
        String methodName = "updateEntityClassification";
        return this.classifyEntityParameterValidation(userId, entityGUID, classificationName, properties, "updateEntityClassification");
    }

    @Deprecated
    protected TypeDef updateEntityClassificationParameterValidation(String userId, EntityProxy entityProxy, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, PropertyErrorException, UserNotAuthorizedException {
        String methodName = "updateEntityClassification";
        return this.classifyEntityParameterValidation(userId, entityProxy, classificationName, properties, "updateEntityClassification");
    }

    protected TypeDef addRelationshipParameterValidation(String userId, String relationshipTypeGUID, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus, String methodName) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, StatusNotSupportedException, UserNotAuthorizedException {
        String guidParameterName = "relationshipTypeGUID";
        String entityOneParameterName = "entityOneGUID";
        String entityTwoParameterName = "entityTwoGUID";
        String propertiesParameterName = "initialProperties";
        String initialStatusParameterName = "initialStatus";
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateTypeGUID(this.repositoryName, "relationshipTypeGUID", relationshipTypeGUID, methodName);
        this.repositoryValidator.validateGUID(this.repositoryName, "entityOneGUID", entityOneGUID, methodName);
        this.repositoryValidator.validateGUID(this.repositoryName, "entityTwoGUID", entityTwoGUID, methodName);
        TypeDef typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "relationshipTypeGUID", relationshipTypeGUID, methodName);
        this.repositoryValidator.validateTypeDefForInstance(this.repositoryName, "relationshipTypeGUID", typeDef, methodName);
        this.repositoryValidator.validatePropertiesForType(this.repositoryName, "initialProperties", typeDef, initialProperties, methodName);
        this.repositoryValidator.validateInstanceStatus(this.repositoryName, "initialStatus", initialStatus, typeDef, methodName);
        return typeDef;
    }

    @Deprecated
    protected TypeDef addRelationshipParameterValidation(String userId, String relationshipTypeGUID, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, StatusNotSupportedException, UserNotAuthorizedException {
        String methodName = "addRelationship";
        return this.addRelationshipParameterValidation(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus, "addRelationship");
    }

    protected TypeDef addExternalRelationshipParameterValidation(String userId, String relationshipTypeGUID, String externalSourceGUID, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus, String methodName) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, StatusNotSupportedException, UserNotAuthorizedException {
        String guidParameterName = "relationshipTypeGUID";
        this.repositoryValidator.validateGUID(this.repositoryName, "relationshipTypeGUID", externalSourceGUID, methodName);
        return this.addRelationshipParameterValidation(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus, methodName);
    }

    @Override
    public EntityDetail addEntity(String userId, String entityTypeGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addEntity";
        this.addEntityParameterValidation(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus, "addEntity");
        this.reportUnsupportedOptionalFunction("addEntity");
        return null;
    }

    @Override
    public EntityDetail addExternalEntity(String userId, String entityTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addExternalEntity";
        this.addExternalEntityParameterValidation(userId, entityTypeGUID, externalSourceGUID, initialProperties, initialClassifications, initialStatus, "addExternalEntity");
        this.reportUnsupportedOptionalFunction("addExternalEntity");
        return null;
    }

    @Override
    public void addEntityProxy(String userId, EntityProxy entityProxy) throws InvalidParameterException, RepositoryErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addEntityProxy";
        this.addEntityProxyParameterValidation(userId, entityProxy);
        this.reportUnsupportedOptionalFunction("addEntityProxy");
    }

    @Override
    public EntityDetail updateEntityStatus(String userId, String entityGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityStatus";
        this.updateInstanceStatusParameterValidation(userId, entityGUID, newStatus, "updateEntityStatus");
        this.reportUnsupportedOptionalFunction("updateEntityStatus");
        return null;
    }

    @Override
    public EntityDetail updateEntityProperties(String userId, String entityGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityProperties";
        this.updateInstancePropertiesPropertyValidation(userId, entityGUID, properties, "updateEntityProperties");
        this.reportUnsupportedOptionalFunction("updateEntityProperties");
        return null;
    }

    @Override
    public EntityDetail undoEntityUpdate(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "undoEntityUpdate";
        String parameterName = "entityGUID";
        this.manageInstanceParameterValidation(userId, entityGUID, "entityGUID", "undoEntityUpdate");
        this.reportUnsupportedOptionalFunction("undoEntityUpdate");
        return null;
    }

    @Override
    public EntityDetail deleteEntity(String userId, String typeDefGUID, String typeDefName, String obsoleteEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteEntity";
        String entityParameterName = "obsoleteEntityGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, obsoleteEntityGUID, "obsoleteEntityGUID", "deleteEntity");
        this.reportUnsupportedOptionalFunction("deleteEntity");
        return null;
    }

    @Override
    public void purgeEntity(String userId, String typeDefGUID, String typeDefName, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeEntity";
        String guidParameterName = "deletedEntityGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, deletedEntityGUID, "deletedEntityGUID", "purgeEntity");
        this.reportUnsupportedOptionalFunction("purgeEntity");
    }

    @Override
    public EntityDetail restoreEntity(String userId, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "restoreEntity";
        String guidParameterName = "deletedEntityGUID";
        this.manageInstanceParameterValidation(userId, deletedEntityGUID, "deletedEntityGUID", "restoreEntity");
        this.reportUnsupportedOptionalFunction("restoreEntity");
        return null;
    }

    @Override
    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "classifyEntity";
        this.classifyEntityParameterValidation(userId, entityGUID, classificationName, classificationProperties, "classifyEntity");
        this.reportUnsupportedOptionalFunction("classifyEntity");
        return null;
    }

    @Override
    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, String externalSourceGUID, String externalSourceName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "classifyEntity (detailed)";
        this.classifyEntityParameterValidation(userId, entityGUID, classificationName, classificationProperties, "classifyEntity (detailed)");
        this.reportUnsupportedOptionalFunction("classifyEntity (detailed)");
        return null;
    }

    @Override
    public EntityDetail declassifyEntity(String userId, String entityGUID, String classificationName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "declassifyEntity";
        this.declassifyEntityParameterValidation(userId, entityGUID, classificationName, "declassifyEntity");
        this.reportUnsupportedOptionalFunction("declassifyEntity");
        return null;
    }

    @Override
    public EntityDetail updateEntityClassification(String userId, String entityGUID, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityClassification";
        this.classifyEntityParameterValidation(userId, entityGUID, classificationName, properties, "updateEntityClassification");
        this.reportUnsupportedOptionalFunction("updateEntityClassification");
        return null;
    }

    protected EntityProxy getEntityProxy(String userId, String entityGUID, String methodName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        EntitySummary entitySummary = this.getEntitySummary(userId, entityGUID);
        if (entitySummary != null) {
            return new EntityProxy(entitySummary);
        }
        this.reportEntityNotKnown(entityGUID, methodName);
        return null;
    }

    @Override
    public Relationship addRelationship(String userId, String relationshipTypeGUID, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addRelationship";
        this.addRelationshipParameterValidation(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus, "addRelationship");
        this.reportUnsupportedOptionalFunction("addRelationship");
        return null;
    }

    @Override
    public Relationship addExternalRelationship(String userId, String relationshipTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "addExternalRelationship";
        this.addExternalRelationshipParameterValidation(userId, relationshipTypeGUID, externalSourceGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus, "addExternalRelationship");
        this.reportUnsupportedOptionalFunction("addExternalRelationship");
        return null;
    }

    @Override
    public Relationship updateRelationshipStatus(String userId, String relationshipGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateRelationshipStatus";
        this.updateInstanceStatusParameterValidation(userId, relationshipGUID, newStatus, "updateRelationshipStatus");
        this.reportUnsupportedOptionalFunction("updateRelationshipStatus");
        return null;
    }

    @Override
    public Relationship updateRelationshipProperties(String userId, String relationshipGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateRelationshipProperties";
        this.updateInstancePropertiesPropertyValidation(userId, relationshipGUID, properties, "updateRelationshipProperties");
        this.reportUnsupportedOptionalFunction("updateRelationshipProperties");
        return null;
    }

    @Override
    public Relationship undoRelationshipUpdate(String userId, String relationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "undoRelationshipUpdate";
        String parameterName = "relationshipGUID";
        this.manageInstanceParameterValidation(userId, relationshipGUID, "relationshipGUID", "undoRelationshipUpdate");
        this.reportUnsupportedOptionalFunction("undoRelationshipUpdate");
        return null;
    }

    @Override
    public Relationship deleteRelationship(String userId, String typeDefGUID, String typeDefName, String obsoleteRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteRelationship";
        String relationshipParameterName = "obsoleteRelationshipGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, obsoleteRelationshipGUID, "obsoleteRelationshipGUID", "deleteRelationship");
        this.reportUnsupportedOptionalFunction("deleteRelationship");
        return null;
    }

    @Override
    public void purgeRelationship(String userId, String typeDefGUID, String typeDefName, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeRelationship";
        String relationshipParameterName = "deletedRelationshipGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, deletedRelationshipGUID, "deletedRelationshipGUID", "purgeRelationship");
        this.reportUnsupportedOptionalFunction("purgeRelationship");
    }

    @Override
    public Relationship restoreRelationship(String userId, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "restoreRelationship";
        String parameterName = "deletedRelationshipGUID";
        this.manageInstanceParameterValidation(userId, deletedRelationshipGUID, "deletedRelationshipGUID", "restoreRelationship");
        this.reportUnsupportedOptionalFunction("restoreRelationship");
        return null;
    }

    protected void reIdentifyInstanceParameterValidation(String userId, String typeDefGUID, String typeDefName, String instanceGUID, String instanceParameterName, String newInstanceGUID, String newInstanceParameterName, String methodName) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String guidParameterName = "typeDefGUID";
        String nameParameterName = "typeDefName";
        super.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateUserId(this.repositoryName, userId, methodName);
        this.repositoryValidator.validateGUID(this.repositoryName, instanceParameterName, instanceGUID, methodName);
        this.repositoryValidator.validateGUID(this.repositoryName, newInstanceParameterName, newInstanceGUID, methodName);
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, methodName);
    }

    protected void reTypeInstanceParameterValidation(String userId, String instanceGUID, String instanceParameterName, TypeDefCategory expectedTypeDefCategory, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary, String methodName) throws InvalidParameterException, RepositoryErrorException, TypeErrorException {
        String currentTypeDefParameterName = "currentTypeDefSummary";
        String newTypeDefParameterName = "newTypeDefSummary";
        this.manageInstanceParameterValidation(userId, instanceGUID, instanceParameterName, methodName);
        this.repositoryValidator.validateActiveType(this.repositoryName, "currentTypeDefSummary", currentTypeDefSummary, expectedTypeDefCategory, methodName);
        this.repositoryValidator.validateActiveType(this.repositoryName, "newTypeDefSummary", newTypeDefSummary, expectedTypeDefCategory, methodName);
    }

    protected void reHomeInstanceParameterValidation(String userId, String instanceGUID, String instanceParameterName, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String methodName) throws InvalidParameterException, RepositoryErrorException {
        String guidParameterName = "typeDefGUID";
        String nameParameterName = "typeDefName";
        String homeParameterName = "homeMetadataCollectionId";
        String newHomeParameterName = "newHomeMetadataCollectionId";
        this.manageInstanceParameterValidation(userId, instanceGUID, instanceParameterName, methodName);
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, methodName);
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, "homeMetadataCollectionId", homeMetadataCollectionId, methodName);
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, "newHomeMetadataCollectionId", newHomeMetadataCollectionId, methodName);
    }

    @Override
    public EntityDetail reIdentifyEntity(String userId, String typeDefGUID, String typeDefName, String entityGUID, String newEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyEntity";
        String instanceParameterName = "entityGUID";
        String newInstanceParameterName = "newEntityGUID";
        this.reIdentifyInstanceParameterValidation(userId, typeDefGUID, typeDefName, entityGUID, "entityGUID", newEntityGUID, "newEntityGUID", "reIdentifyEntity");
        this.reportUnsupportedOptionalFunction("reIdentifyEntity");
        return null;
    }

    @Override
    public EntityDetail reTypeEntity(String userId, String entityGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reTypeEntity";
        String entityParameterName = "entityGUID";
        this.reTypeInstanceParameterValidation(userId, entityGUID, "entityGUID", TypeDefCategory.ENTITY_DEF, currentTypeDefSummary, newTypeDefSummary, "reTypeEntity");
        this.reportUnsupportedOptionalFunction("reTypeEntity");
        return null;
    }

    @Override
    public EntityDetail reHomeEntity(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reHomeEntity";
        String entityParameterName = "entityGUID";
        this.reHomeInstanceParameterValidation(userId, entityGUID, "entityGUID", typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, "reHomeEntity");
        this.reportUnsupportedOptionalFunction("reHomeEntity");
        return null;
    }

    @Override
    public Relationship reIdentifyRelationship(String userId, String typeDefGUID, String typeDefName, String relationshipGUID, String newRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyRelationship";
        String instanceParameterName = "relationshipGUID";
        String newInstanceParameterName = "newRelationshipGUID";
        this.reIdentifyInstanceParameterValidation(userId, typeDefGUID, typeDefName, relationshipGUID, "relationshipGUID", newRelationshipGUID, "newRelationshipGUID", "reIdentifyRelationship");
        this.reportUnsupportedOptionalFunction("reIdentifyRelationship");
        return null;
    }

    @Override
    public Relationship reTypeRelationship(String userId, String relationshipGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reTypeRelationship";
        String relationshipParameterName = "relationshipGUID";
        this.reTypeInstanceParameterValidation(userId, relationshipGUID, "relationshipGUID", TypeDefCategory.RELATIONSHIP_DEF, currentTypeDefSummary, newTypeDefSummary, "reTypeRelationship");
        this.reportUnsupportedOptionalFunction("reTypeRelationship");
        return null;
    }

    @Override
    public Relationship reHomeRelationship(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reHomeRelationship";
        String relationshipParameterName = "relationshipGUID";
        this.reHomeInstanceParameterValidation(userId, relationshipGUID, "relationshipGUID", typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, "reHomeRelationship");
        this.reportUnsupportedOptionalFunction("reHomeRelationship");
        return null;
    }

    protected void manageReferenceInstanceParameterValidation(String userId, String typeDefGUID, String typeDefName, String instanceGUID, String instanceGUIDParameterName, String homeMetadataCollectionId, String homeParameterName, String methodName) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, instanceGUID, instanceGUIDParameterName, methodName);
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, homeParameterName, homeMetadataCollectionId, methodName);
    }

    protected void referenceInstanceParameterValidation(String userId, InstanceHeader instanceHeader, String instanceParameterName, String methodName) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        this.basicRequestValidation(userId, methodName);
        this.repositoryValidator.validateReferenceInstanceHeader(this.repositoryName, this.metadataCollectionId, instanceParameterName, instanceHeader, this.auditLog, methodName);
    }

    @Override
    public void saveEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "saveEntityReferenceCopy";
        String instanceParameterName = "entity";
        this.referenceInstanceParameterValidation(userId, entity, "entity", "saveEntityReferenceCopy");
        this.reportUnsupportedOptionalFunction("saveEntityReferenceCopy");
    }

    @Override
    public List<Classification> getHomeClassifications(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "getHomeClassifications";
        this.reportUnsupportedOptionalFunction("getHomeClassifications");
        return null;
    }

    @Override
    public List<Classification> getHomeClassifications(String userId, String entityGUID, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "getHomeClassifications (with history)";
        this.reportUnsupportedOptionalFunction("getHomeClassifications (with history)");
        return null;
    }

    @Override
    public void deleteEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteEntityReferenceCopy";
        String instanceParameterName = "entity";
        this.referenceInstanceParameterValidation(userId, entity, "entity", "deleteEntityReferenceCopy");
        this.saveEntityReferenceCopy(userId, entity);
    }

    @Override
    public void purgeEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeEntityReferenceCopy";
        String instanceParameterName = "entity";
        this.referenceInstanceParameterValidation(userId, entity, "entity", "purgeEntityReferenceCopy");
        super.purgeEntityReferenceCopy(userId, entity);
    }

    @Override
    public void purgeEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, HomeEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeEntityReferenceCopy";
        String entityParameterName = "entityGUID";
        String homeParameterName = "homeMetadataCollectionId";
        this.manageReferenceInstanceParameterValidation(userId, entityGUID, typeDefGUID, typeDefName, "entityGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "purgeEntityReferenceCopy");
        this.reportUnsupportedOptionalFunction("purgeEntityReferenceCopy");
    }

    @Override
    public void refreshEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, HomeEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "refreshEntityReferenceCopy";
        String entityParameterName = "entityGUID";
        String homeParameterName = "homeMetadataCollectionId";
        this.manageReferenceInstanceParameterValidation(userId, entityGUID, typeDefGUID, typeDefName, "entityGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "refreshEntityReferenceCopy");
        this.reportUnsupportedOptionalFunction("refreshEntityReferenceCopy");
    }

    @Override
    public void saveClassificationReferenceCopy(String userId, EntityDetail entity, Classification classification) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityConflictException, InvalidEntityException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        super.saveClassificationReferenceCopy(userId, entity, classification);
    }

    @Override
    public void saveClassificationReferenceCopy(String userId, EntityProxy entity, Classification classification) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityConflictException, InvalidEntityException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        super.saveClassificationReferenceCopy(userId, entity, classification);
    }

    @Override
    public void purgeClassificationReferenceCopy(String userId, EntityDetail entity, Classification classification) throws InvalidParameterException, TypeErrorException, PropertyErrorException, EntityConflictException, InvalidEntityException, RepositoryErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        super.purgeClassificationReferenceCopy(userId, entity, classification);
    }

    @Override
    public void saveRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "saveRelationshipReferenceCopy";
        String instanceParameterName = "relationship";
        this.referenceInstanceParameterValidation(userId, relationship, "relationship", "saveRelationshipReferenceCopy");
        this.reportUnsupportedOptionalFunction("saveRelationshipReferenceCopy");
    }

    @Override
    public void deleteRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteRelationshipReferenceCopy";
        String instanceParameterName = "relationship";
        this.referenceInstanceParameterValidation(userId, relationship, "relationship", "deleteRelationshipReferenceCopy");
        super.deleteRelationshipReferenceCopy(userId, relationship);
    }

    @Override
    public void purgeRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeRelationshipReferenceCopy";
        String instanceParameterName = "relationship";
        this.referenceInstanceParameterValidation(userId, relationship, "relationship", "purgeRelationshipReferenceCopy");
        super.purgeRelationshipReferenceCopy(userId, relationship);
    }

    @Override
    public void purgeRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, HomeRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeRelationshipReferenceCopy";
        String relationshipParameterName = "relationshipGUID";
        String homeParameterName = "homeMetadataCollectionId";
        this.manageReferenceInstanceParameterValidation(userId, relationshipGUID, typeDefGUID, typeDefName, "relationshipGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "purgeRelationshipReferenceCopy");
        this.reportUnsupportedOptionalFunction("purgeRelationshipReferenceCopy");
    }

    @Override
    public void refreshRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, HomeRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "refreshRelationshipReferenceCopy";
        String relationshipParameterName = "relationshipGUID";
        String homeParameterName = "homeMetadataCollectionId";
        this.manageReferenceInstanceParameterValidation(userId, relationshipGUID, typeDefGUID, typeDefName, "relationshipGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "refreshRelationshipReferenceCopy");
        this.reportUnsupportedOptionalFunction("refreshRelationshipReferenceCopy");
    }

    protected TypeDef getTypeDefForInstance(InstanceHeader header, String methodName) throws RepositoryErrorException {
        TypeDef typeDef;
        try {
            String typeGUIDParameterName = "getType.getTypeDefGUID";
            String instanceTypeGUID = header.getType().getTypeDefGUID();
            typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "getType.getTypeDefGUID", instanceTypeGUID, methodName);
        }
        catch (TypeErrorException error) {
            throw new RepositoryErrorException(OMRSErrorCode.TYPEDEF_NOT_KNOWN.getMessageDefinition(methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName);
        }
        catch (Throwable error) {
            throw new RepositoryErrorException(OMRSErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.getClass().getName(), methodName, this.repositoryName), this.getClass().getName(), methodName);
        }
        return typeDef;
    }

    protected void reportUnsupportedAsOfTimeFunction(String methodName, Date asOfTime) throws FunctionNotSupportedException, RepositoryErrorException {
        if (asOfTime == null) {
            this.reportUnsupportedMandatoryFunction(methodName);
        } else {
            this.reportUnsupportedOptionalFunction(methodName);
        }
    }

    private void reportUnsupportedMandatoryFunction(String methodName) throws RepositoryErrorException {
        throw new RepositoryErrorException(OMRSErrorCode.METHOD_NOT_IMPLEMENTED.getMessageDefinition(methodName, this.getClass().getName(), this.repositoryName), this.getClass().getName(), methodName);
    }

    protected void reportUnknownTypeGUID(String guid, String guidParameterName, String methodName) throws TypeDefNotKnownException {
        throw new TypeDefNotKnownException(OMRSErrorCode.TYPEDEF_ID_NOT_KNOWN.getMessageDefinition(guid, guidParameterName, methodName, this.repositoryName), this.getClass().getName(), methodName);
    }

    protected void reportUnknownTypeName(String name, String methodName) throws TypeDefNotKnownException {
        throw new TypeDefNotKnownException(OMRSErrorCode.TYPEDEF_NAME_NOT_KNOWN.getMessageDefinition(name, methodName, this.repositoryName), this.getClass().getName(), methodName);
    }

    protected void reportEntityNotKnown(String entityGUID, String methodName) throws EntityNotKnownException {
        throw new EntityNotKnownException(OMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(entityGUID, methodName, this.repositoryName), this.getClass().getName(), methodName);
    }

    protected void reportRelationshipNotKnown(String relationshipGUID, String methodName) throws RelationshipNotKnownException {
        throw new RelationshipNotKnownException(OMRSErrorCode.RELATIONSHIP_NOT_KNOWN.getMessageDefinition(relationshipGUID, methodName, this.repositoryName), this.getClass().getName(), methodName);
    }

    protected void reportTypeDefNotSupported(String typeName, String methodName) throws TypeDefNotSupportedException {
        throw new TypeDefNotSupportedException(OMRSErrorCode.TYPE_NOT_IMPLEMENTED.getMessageDefinition(this.repositoryName, typeName), this.getClass().getName(), methodName);
    }

    protected void reportTypeDefAlreadyDefined(String typeGUID, String typeName, String methodName) throws TypeDefKnownException {
        throw new TypeDefKnownException(OMRSErrorCode.TYPEDEF_ALREADY_DEFINED.getMessageDefinition(typeName, typeGUID, this.repositoryName), this.getClass().getName(), methodName);
    }

    protected void reportTypeDefConflict(String typeGUID, String typeName, String methodName) throws TypeDefConflictException {
        throw new TypeDefConflictException(OMRSErrorCode.VERIFY_CONFLICT_DETECTED.getMessageDefinition(typeGUID, typeName, this.repositoryName), this.getClass().getName(), methodName);
    }

    protected void reportTypeDefInUse(String typeGUID, String typeName, String methodName) throws TypeDefInUseException {
        throw new TypeDefInUseException(OMRSErrorCode.TYPEDEF_IN_USE.getMessageDefinition(typeName, typeGUID, this.repositoryName), this.getClass().getName(), methodName);
    }

    protected void reportEntityProxyOnly(String guid, String guidParameterName, String methodName) throws EntityProxyOnlyException {
        throw new EntityProxyOnlyException(OMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(guid, this.repositoryName, guidParameterName, methodName), this.getClass().getName(), methodName);
    }
}

