/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.archiveutilities;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSArchiveGUIDMap {
    private static final Logger log = LoggerFactory.getLogger(OMRSArchiveGUIDMap.class);
    private final String guidMapFileName;
    private Map<String, String> idToGUIDMap;

    public OMRSArchiveGUIDMap(String guidMapFileName) {
        this.guidMapFileName = guidMapFileName;
        this.loadGUIDs();
    }

    private void loadGUIDs() {
        File idFile = new File(this.guidMapFileName);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            log.debug("Retrieving Id to GUID Map");
            String idFileContents = FileUtils.readFileToString((File)idFile, (String)"UTF-8");
            this.idToGUIDMap = (Map)objectMapper.readValue(idFileContents, Map.class);
        }
        catch (Exception error) {
            this.idToGUIDMap = new HashMap<String, String>();
        }
        log.debug("Id to GUID Map contains: " + this.idToGUIDMap);
    }

    public void setGUID(String id, String guid) {
        this.idToGUIDMap.put(id, guid);
    }

    public String getGUID(String id) {
        String guid = this.idToGUIDMap.get(id);
        if (guid == null) {
            guid = UUID.randomUUID().toString();
            this.idToGUIDMap.put(id, guid);
        }
        return guid;
    }

    public String queryGUID(String id) {
        return this.idToGUIDMap.get(id);
    }

    public void saveGUIDs() {
        File idFile = new File(this.guidMapFileName);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            if (this.idToGUIDMap.isEmpty()) {
                log.debug("Deleting id file because map is empty: " + this.guidMapFileName);
                idFile.delete();
            } else {
                log.debug("Writing id file " + this.guidMapFileName);
                String mapContents = objectMapper.writeValueAsString(this.idToGUIDMap);
                FileUtils.writeStringToFile((File)idFile, (String)mapContents, (String)null, (boolean)false);
            }
        }
        catch (Exception exc) {
            log.error("Unusable Map Store :(", (Throwable)exc);
        }
    }

    public int getSize() {
        if (this.idToGUIDMap != null) {
            return this.idToGUIDMap.size();
        }
        return 0;
    }
}

