/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.QueryAccumulatorBase;

public class TypesAccumulator
extends QueryAccumulatorBase {
    private volatile Map<String, AttributeTypeDef> accumulatedAttributeTypeDefs = new HashMap<String, AttributeTypeDef>();
    private volatile Map<String, TypeDef> accumulatedTypeDefs = new HashMap<String, TypeDef>();

    public TypesAccumulator(String localMetadataCollectionId, AuditLog auditLog, OMRSRepositoryValidator repositoryValidator) {
        super(localMetadataCollectionId, auditLog, repositoryValidator);
    }

    private void addAttributeTypeDef(AttributeTypeDef incomingAttributeTypeDef, String metadataCollectionId) {
        if (incomingAttributeTypeDef != null && incomingAttributeTypeDef.getGUID() != null && metadataCollectionId != null) {
            String typeGUID = incomingAttributeTypeDef.getGUID();
            String typeVersion = incomingAttributeTypeDef.getVersionName();
            if (typeVersion != null) {
                this.accumulatedAttributeTypeDefs.put(typeGUID + typeVersion, incomingAttributeTypeDef);
            } else {
                this.accumulatedAttributeTypeDefs.put(typeGUID, incomingAttributeTypeDef);
            }
        }
    }

    private void addTypeDef(TypeDef incomingTypeDef, String metadataCollectionId) {
        if (incomingTypeDef != null && incomingTypeDef.getGUID() != null && metadataCollectionId != null) {
            String typeGUID = incomingTypeDef.getGUID();
            String typeVersion = incomingTypeDef.getVersionName();
            if (typeVersion != null) {
                this.accumulatedTypeDefs.put(typeGUID + typeVersion, incomingTypeDef);
            } else {
                this.accumulatedTypeDefs.put(typeGUID, incomingTypeDef);
            }
        }
    }

    public synchronized void addTypeDefGallery(TypeDefGallery types, String metadataCollectionId) {
        int numberOrAttributeTypeDefs = 0;
        int numberOfTypeDefs = 0;
        if (types != null) {
            ArrayList typeDefs;
            List attributeTypeDefs = types.getAttributeTypeDefs();
            if (attributeTypeDefs != null) {
                for (AttributeTypeDef type : attributeTypeDefs) {
                    this.addAttributeTypeDef(type, metadataCollectionId);
                }
            }
            if ((typeDefs = types.getTypeDefs()) != null) {
                for (TypeDef type : typeDefs) {
                    this.addTypeDef(type, metadataCollectionId);
                }
            }
        }
        super.setResultsReturned(metadataCollectionId, numberOrAttributeTypeDefs + numberOfTypeDefs);
    }

    public synchronized TypeDefGallery getResults() {
        if (this.accumulatedAttributeTypeDefs.isEmpty() && this.accumulatedTypeDefs.isEmpty()) {
            return null;
        }
        TypeDefGallery results = new TypeDefGallery();
        if (!this.accumulatedAttributeTypeDefs.isEmpty()) {
            results.setAttributeTypeDefs(new ArrayList<AttributeTypeDef>(this.accumulatedAttributeTypeDefs.values()));
        }
        if (!this.accumulatedTypeDefs.isEmpty()) {
            results.setTypeDefs(new ArrayList<TypeDef>(this.accumulatedTypeDefs.values()));
        }
        return results;
    }
}

