/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.control;

import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.control.FederationControl;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutor;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public abstract class FederationControlBase
implements FederationControl {
    protected String userId;
    protected List<OMRSRepositoryConnector> cohortConnectors;
    protected AuditLog auditLog;
    protected String methodName;

    public FederationControlBase(String userId, List<OMRSRepositoryConnector> cohortConnectors, AuditLog auditLog, String methodName) {
        this.userId = userId;
        this.cohortConnectors = cohortConnectors;
        this.auditLog = auditLog;
        this.methodName = methodName;
    }

    @Override
    public abstract void executeCommand(RepositoryExecutor var1) throws RepositoryErrorException;

    String validateMetadataCollection(OMRSRepositoryConnector cohortConnector, OMRSMetadataCollection cohortMetadataCollection, String methodName) throws RepositoryErrorException {
        if (cohortMetadataCollection == null) {
            throw new RepositoryErrorException(OMRSErrorCode.NULL_ENTERPRISE_METADATA_COLLECTION.getMessageDefinition(), this.getClass().getName(), methodName);
        }
        try {
            return cohortMetadataCollection.getMetadataCollectionId(this.userId);
        }
        catch (Exception error) {
            this.auditLog.logException(methodName, OMRSAuditCode.SKIPPING_METADATA_COLLECTION.getMessageDefinition(new String[]{cohortConnector.getRepositoryName(), error.getClass().getName(), error.getMessage()}), (Throwable)error);
            return null;
        }
    }
}

