/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.control;

import java.util.Iterator;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.control.FederationControlBase;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutor;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public class SequentialFederationControl
extends FederationControlBase {
    public SequentialFederationControl(String userId, List<OMRSRepositoryConnector> cohortConnectors, AuditLog auditLog, String methodName) {
        super(userId, cohortConnectors, auditLog, methodName);
    }

    @Override
    public void executeCommand(RepositoryExecutor executor) throws RepositoryErrorException {
        if (this.cohortConnectors != null) {
            OMRSMetadataCollection metadataCollection;
            String metadataCollectionId;
            OMRSRepositoryConnector cohortConnector;
            Iterator iterator = this.cohortConnectors.iterator();
            while (iterator.hasNext() && ((cohortConnector = (OMRSRepositoryConnector)iterator.next()) == null || (metadataCollectionId = this.validateMetadataCollection(cohortConnector, metadataCollection = cohortConnector.getMetadataCollection(), this.methodName)) == null || !executor.issueRequestToRepository(metadataCollectionId, metadataCollection))) {
            }
            List<String> resultGUIDs = executor.getResultsForAugmentation();
            if (resultGUIDs != null) {
                for (String resultGUID : resultGUIDs) {
                    for (OMRSRepositoryConnector cohortConnector2 : this.cohortConnectors) {
                        OMRSMetadataCollection metadataCollection2;
                        String metadataCollectionId2;
                        if (cohortConnector2 == null || (metadataCollectionId2 = this.validateMetadataCollection(cohortConnector2, metadataCollection2 = cohortConnector2.getMetadataCollection(), this.methodName)) == null) continue;
                        executor.augmentResultFromRepository(resultGUID, metadataCollectionId2, metadataCollection2);
                    }
                }
            }
        }
    }
}

