/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.RelationshipsAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.CloneableRepositoryExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.PageableRepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class GetRelationshipsForEntityExecutor
extends PageableRepositoryExecutorBase {
    private final String entityGUID;
    private final RelationshipsAccumulator accumulator;

    public GetRelationshipsForEntityExecutor(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String localMetadataCollectionId, AuditLog auditLog, OMRSRepositoryValidator repositoryValidator, String methodName) {
        this(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize, new RelationshipsAccumulator(localMetadataCollectionId, auditLog, repositoryValidator), methodName);
    }

    private GetRelationshipsForEntityExecutor(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, RelationshipsAccumulator accumulator, String methodName) {
        super(userId, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, sequencingProperty, sequencingOrder, pageSize, asOfTime, accumulator, methodName);
        this.entityGUID = entityGUID;
        this.accumulator = accumulator;
    }

    @Override
    public CloneableRepositoryExecutor getClone() {
        return new GetRelationshipsForEntityExecutor(this.userId, this.entityGUID, this.instanceTypeGUID, this.startingElement, this.limitResultsByStatus, this.asOfTime, this.sequencingProperty, this.sequencingOrder, this.pageSize, this.accumulator, this.methodName);
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        try {
            List results = metadataCollection.getRelationshipsForEntity(this.userId, this.entityGUID, this.instanceTypeGUID, this.startingElement, this.limitResultsByStatus, this.asOfTime, this.sequencingProperty, this.sequencingOrder, this.pageSize);
            this.accumulator.addRelationships(results, metadataCollectionId);
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (EntityNotKnownException error) {
            this.accumulator.addRelationships(null, metadataCollectionId);
        }
        catch (FunctionNotSupportedException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (PropertyErrorException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (TypeErrorException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (PagingErrorException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (Exception error) {
            this.accumulator.captureGenericException(this.methodName, metadataCollectionId, error);
        }
        return false;
    }

    public List<Relationship> getResults(EnterpriseOMRSRepositoryConnector repositoryConnector) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        if (this.accumulator.resultsReturned()) {
            return this.accumulator.getResults(repositoryConnector);
        }
        this.handleCommonPagingRequestExceptions();
        this.accumulator.throwCapturedEntityNotKnownException();
        return null;
    }
}

