/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.font;

import java.io.IOException;
import java.util.function.Consumer;
import org.ofdrw.converter.font.TTFDataStream;
import org.ofdrw.converter.font.TrueTypeFont;

public class TrueTypeCollection {
    private TTFDataStream stream;
    private int numFonts;
    private long[] fontOffsets;

    public TrueTypeCollection parse(TTFDataStream stream) throws IOException {
        this.stream = stream;
        String tag = stream.readTag();
        if (!tag.equals("ttcf")) {
            throw new IOException("Missing TTC header");
        }
        float version = stream.read32Fixed();
        this.numFonts = (int)stream.readUnsignedInt();
        this.fontOffsets = new long[this.numFonts];
        for (int i = 0; i < this.numFonts; ++i) {
            this.fontOffsets[i] = stream.readUnsignedInt();
        }
        if (version >= 2.0f) {
            int ulDsigTag = stream.readUnsignedShort();
            int ulDsigLength = stream.readUnsignedShort();
            int n = stream.readUnsignedShort();
        }
        return this;
    }

    public TrueTypeFont getFontAtIndex(int idx) throws IOException {
        if (idx < 0 || idx >= this.numFonts) {
            throw new IllegalArgumentException("\u7d22\u5f15\u53f7 \u4e0d\u5b58\u5728" + idx);
        }
        this.stream.seek(this.fontOffsets[idx]);
        return new TrueTypeFont().parse(this.stream);
    }

    public void foreach(Consumer<TrueTypeFont> cn) throws IOException {
        for (int i = 0; i < this.numFonts; ++i) {
            TrueTypeFont font = this.getFontAtIndex(i);
            cn.accept(font);
        }
    }

    public int getNumFonts() {
        return this.numFonts;
    }
}

