/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.ofdconverter;

import java.awt.Graphics2D;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.ofdrw.converter.GeneralConvertException;
import org.ofdrw.converter.ofdconverter.DocConverter;
import org.ofdrw.graphics2d.OFDGraphicsDocument;
import org.ofdrw.graphics2d.OFDPageGraphics2D;

public class PDFConverter
implements DocConverter {
    private boolean closed = false;
    final OFDGraphicsDocument ofdDoc;
    final double UUPMM = 2.8346;

    public PDFConverter(Path ofdPath) throws IOException {
        if (ofdPath == null) {
            throw new IllegalArgumentException("\u8f6c\u6362\u540e\u7684OFD\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        if (!Files.exists(ofdPath = ofdPath.toAbsolutePath(), new LinkOption[0])) {
            Path parent = ofdPath.getParent();
            if (Files.exists(parent, new LinkOption[0])) {
                if (!Files.isDirectory(parent, new LinkOption[0])) {
                    throw new IllegalArgumentException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u6587\u4ef6: " + parent);
                }
            } else {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.createFile(ofdPath, new FileAttribute[0]);
        }
        this.ofdDoc = new OFDGraphicsDocument(ofdPath);
    }

    @Override
    public void convert(Path filepath, int ... indexes) throws GeneralConvertException {
        if (filepath == null || !Files.exists(filepath, new LinkOption[0]) || Files.isDirectory(filepath, new LinkOption[0])) {
            return;
        }
        try (PDDocument pdfDoc = PDDocument.load((File)filepath.toFile());){
            int total = pdfDoc.getNumberOfPages();
            LinkedList<Integer> targetPages = new LinkedList<Integer>();
            if (indexes == null || indexes.length == 0) {
                for (int i = 0; i < total; ++i) {
                    targetPages.add(i);
                }
            } else {
                for (int index : indexes) {
                    if (index < 0 || index >= total) continue;
                    targetPages.add(index);
                }
            }
            PDFRenderer pdfRender = new PDFRenderer(pdfDoc);
            for (Integer index : targetPages) {
                PDRectangle pdfPageSize = pdfDoc.getPage(index.intValue()).getBBox();
                OFDPageGraphics2D ofdPageG2d = this.ofdDoc.newPage((double)pdfPageSize.getWidth(), (double)pdfPageSize.getHeight());
                pdfRender.renderPageToGraphics(index.intValue(), (Graphics2D)ofdPageG2d);
            }
        }
        catch (IOException e) {
            throw new GeneralConvertException("PDF\u8f6c\u6362OFD\u5f02\u5e38", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.ofdDoc != null) {
            this.ofdDoc.close();
        }
    }
}

