/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;
import org.ofdrw.converter.FontLoader;
import org.ofdrw.converter.point.PathPoint;
import org.ofdrw.converter.point.TextCodePoint;
import org.ofdrw.converter.utils.CommonUtil;
import org.ofdrw.converter.utils.PointUtil;
import org.ofdrw.core.annotation.pageannot.Annot;
import org.ofdrw.core.attachment.CT_Attachment;
import org.ofdrw.core.basicStructure.pageObj.layer.CT_Layer;
import org.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CompositeObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.ImageObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.PathObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.TextObject;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_Pos;
import org.ofdrw.core.basicType.ST_RefID;
import org.ofdrw.core.compositeObj.CT_VectorG;
import org.ofdrw.core.graph.pathObj.FillColor;
import org.ofdrw.core.graph.pathObj.StrokeColor;
import org.ofdrw.core.pageDescription.CT_GraphicUnit;
import org.ofdrw.core.pageDescription.color.color.CT_AxialShd;
import org.ofdrw.core.pageDescription.color.color.CT_Color;
import org.ofdrw.core.pageDescription.color.color.Segment;
import org.ofdrw.core.pageDescription.drawParam.CT_DrawParam;
import org.ofdrw.core.signatures.appearance.StampAnnot;
import org.ofdrw.core.text.font.CT_Font;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.PageInfo;
import org.ofdrw.reader.ResourceManage;
import org.ofdrw.reader.model.AnnotionEntity;
import org.ofdrw.reader.model.StampAnnotEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfboxMaker {
    private static final Logger logger = LoggerFactory.getLogger(PdfboxMaker.class);
    private final OFDReader reader;
    private final PDDocument pdf;
    private final ResourceManage resMgt;
    private Map<String, PDFont> fontCache = new HashMap<String, PDFont>();

    public PdfboxMaker(OFDReader reader, PDDocument pdf) throws IOException {
        this.reader = reader;
        this.pdf = pdf;
        this.resMgt = reader.getResMgt();
    }

    public PDPage makePage(PageInfo pageInfo) throws IOException {
        ST_Box pageBox = pageInfo.getSize();
        double pageWidthPixel = CommonUtil.converterDpi(pageBox.getWidth());
        double pageHeightPixel = CommonUtil.converterDpi(pageBox.getHeight());
        PDRectangle pageSize = new PDRectangle((float)pageWidthPixel, (float)pageHeightPixel);
        PDPage pdfPage = new PDPage(pageSize);
        this.pdf.addPage(pdfPage);
        List annotationEntities = this.reader.getAnnotationEntities();
        List stampAnnots = this.reader.getStampAnnots();
        try (PDPageContentStream contentStream = new PDPageContentStream(this.pdf, pdfPage);){
            List layerList = pageInfo.getAllLayer();
            this.writeLayer(this.resMgt, contentStream, layerList, pageBox, null);
            this.writeStamp(contentStream, pageInfo, stampAnnots);
            this.writeAnnoAppearance(this.resMgt, pageInfo, annotationEntities, contentStream, pageBox);
        }
        return pdfPage;
    }

    private void writeStamp(PDPageContentStream contentStream, PageInfo parent, List<StampAnnotEntity> stampAnnotEntityList) throws IOException {
        String pageID = parent.getId().toString();
        for (StampAnnotEntity stampAnnotVo : stampAnnotEntityList) {
            List stampAnnots = stampAnnotVo.getStampAnnots();
            for (StampAnnot stampAnnot : stampAnnots) {
                if (!stampAnnot.getPageRef().toString().equals(pageID)) continue;
                ST_Box pageBox = parent.getSize();
                ST_Box sealBox = stampAnnot.getBoundary();
                ST_Box clipBox = stampAnnot.getClip();
                if (stampAnnotVo.getImgType().equalsIgnoreCase("ofd")) {
                    OFDReader sealOfdReader = new OFDReader((InputStream)new ByteArrayInputStream(stampAnnotVo.getImageByte()));
                    Throwable throwable = null;
                    try {
                        ResourceManage sealResMgt = sealOfdReader.getResMgt();
                        for (PageInfo ofdPageVo : sealOfdReader.getPageList()) {
                            List layerList = ofdPageVo.getAllLayer();
                            this.writeLayer(sealResMgt, contentStream, layerList, pageBox, sealBox);
                            this.writeAnnoAppearance(sealResMgt, ofdPageVo, sealOfdReader.getAnnotationEntities(), contentStream, pageBox);
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (sealOfdReader == null) continue;
                        if (throwable != null) {
                            try {
                                sealOfdReader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        sealOfdReader.close();
                        continue;
                    }
                }
                this.writeSealImage(contentStream, pageBox, stampAnnotVo.getImageByte(), sealBox, clipBox);
            }
        }
    }

    private void writeLayer(ResourceManage resMgt, PDPageContentStream contentStream, List<CT_Layer> layerList, ST_Box box, ST_Box sealBox) throws IOException {
        for (CT_Layer layer : layerList) {
            List pageBlockTypeList = layer.getPageBlocks();
            this.writePageBlock(resMgt, contentStream, box, sealBox, pageBlockTypeList, layer.getDrawParam(), null, null, null, null);
        }
    }

    private void writeAnnoAppearance(ResourceManage resMgt, PageInfo pageInfo, List<AnnotionEntity> annotionEntities, PDPageContentStream contentStream, ST_Box box) throws IOException {
        String pageId = pageInfo.getId().toString();
        for (AnnotionEntity annotionEntity : annotionEntities) {
            List annotList = annotionEntity.getAnnots();
            if (annotList == null || !pageId.equalsIgnoreCase(annotionEntity.getPageId())) continue;
            for (Annot annot : annotList) {
                List pageBlockTypeList = annot.getAppearance().getPageBlocks();
                ST_Box annotBox = annot.getAppearance().getBoundary();
                this.writePageBlock(resMgt, contentStream, box, null, pageBlockTypeList, null, annotBox, null, null, null);
            }
        }
    }

    private void writePageBlock(ResourceManage resMgt, PDPageContentStream contentStream, ST_Box box, ST_Box sealBox, List<PageBlockType> pageBlockTypeList, ST_RefID drawparam, ST_Box annotBox, Integer compositeObjectAlpha, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM) throws IOException {
        PDColor defaultFillColor = new PDColor(new float[]{0.0f, 0.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
        PDColor defaultStrokeColor = new PDColor(new float[]{0.0f, 0.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
        float defaultLineWidth = 0.353f;
        CT_DrawParam ctDrawParam = null;
        if (drawparam != null) {
            ctDrawParam = resMgt.getDrawParamFinal(drawparam.toString());
        }
        if (ctDrawParam != null) {
            if (ctDrawParam.getLineWidth() != null) {
                defaultLineWidth = ctDrawParam.getLineWidth().floatValue();
            }
            if (ctDrawParam.getStrokeColor() != null) {
                defaultStrokeColor = CommonUtil.convertPDColor(ctDrawParam.getStrokeColor().getValue());
            }
            if (ctDrawParam.getFillColor() != null) {
                defaultFillColor = CommonUtil.convertPDColor(ctDrawParam.getFillColor().getValue());
            }
        }
        for (PageBlockType block : pageBlockTypeList) {
            if (block instanceof TextObject) {
                PDColor fillColor = defaultFillColor;
                TextObject textObject = (TextObject)block;
                int alpha = 255;
                if (textObject.getFillColor() != null) {
                    if (textObject.getFillColor().getValue() != null) {
                        fillColor = CommonUtil.convertPDColor(textObject.getFillColor().getValue());
                    } else if (textObject.getFillColor().getColorByType() != null) {
                        CT_AxialShd ctAxialShd = (CT_AxialShd)textObject.getFillColor().getColorByType();
                        fillColor = CommonUtil.convertPDColor(((Segment)ctAxialShd.getSegments().get(0)).getColor().getValue());
                    }
                    alpha = textObject.getFillColor().getAlpha();
                }
                this.writeText(resMgt, contentStream, box, sealBox, textObject, fillColor, alpha);
                continue;
            }
            if (block instanceof ImageObject) {
                ImageObject imageObject = (ImageObject)block;
                resMgt.superDrawParam((CT_GraphicUnit)imageObject);
                this.writeImage(resMgt, contentStream, box, imageObject, annotBox);
                continue;
            }
            if (block instanceof PathObject) {
                PathObject pathObject = (PathObject)block;
                resMgt.superDrawParam((CT_GraphicUnit)pathObject);
                this.writePath(resMgt, contentStream, box, sealBox, annotBox, pathObject, defaultFillColor, defaultStrokeColor, defaultLineWidth, compositeObjectAlpha, compositeObjectBoundary, compositeObjectCTM);
                continue;
            }
            if (block instanceof CompositeObject) {
                CompositeObject compositeObject = (CompositeObject)block;
                CT_VectorG vectorG = resMgt.getCompositeGraphicUnit(compositeObject.getResourceID().toString());
                Integer currentCompositeObjectAlpha = compositeObject.getAlpha();
                ST_Box currentCompositeObjectBoundary = compositeObject.getBoundary();
                ST_Array currentCompositeObjectCTM = compositeObject.getCTM();
                this.writePageBlock(resMgt, contentStream, box, sealBox, vectorG.getContent().getPageBlocks(), drawparam, annotBox, currentCompositeObjectAlpha, currentCompositeObjectBoundary, currentCompositeObjectCTM);
                continue;
            }
            if (!(block instanceof CT_PageBlock)) continue;
            this.writePageBlock(resMgt, contentStream, box, sealBox, ((CT_PageBlock)block).getPageBlocks(), drawparam, annotBox, compositeObjectAlpha, compositeObjectBoundary, compositeObjectCTM);
        }
    }

    private void writePath(ResourceManage resMgt, PDPageContentStream contentStream, ST_Box box, ST_Box sealBox, ST_Box annotBox, PathObject pathObject, PDColor defaultFillColor, PDColor defaultStrokeColor, float defaultLineWidth, Integer compositeObjectAlpha, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM) throws IOException {
        PDExtendedGraphicsState graphicsState;
        float lineWidth;
        StrokeColor strokeColor;
        contentStream.saveGraphicsState();
        CT_DrawParam ctDrawParam = resMgt.superDrawParam((CT_GraphicUnit)pathObject);
        if (ctDrawParam != null) {
            if (pathObject.getStrokeColor() == null && ctDrawParam.getStrokeColor() != null) {
                pathObject.setStrokeColor(ctDrawParam.getStrokeColor());
            }
            if (pathObject.getFillColor() == null && ctDrawParam.getFillColor() != null) {
                pathObject.setFillColor((CT_Color)ctDrawParam.getFillColor());
            }
        }
        if ((strokeColor = pathObject.getStrokeColor()) != null) {
            if (strokeColor.getValue() != null) {
                contentStream.setStrokingColor(CommonUtil.convertPDColor(strokeColor.getValue()));
            } else {
                this.setShadingFill(contentStream, (CT_Color)strokeColor, false);
            }
        } else {
            contentStream.setStrokingColor(defaultStrokeColor);
        }
        float f = lineWidth = pathObject.getLineWidth() != null ? pathObject.getLineWidth().floatValue() : defaultLineWidth;
        if (pathObject.getCTM() != null && pathObject.getLineWidth() != null) {
            Double[] ctm = pathObject.getCTM().toDouble();
            double a = ctm[0];
            double b = ctm[1];
            double c = ctm[2];
            double d = ctm[3];
            double e = ctm[4];
            double f2 = ctm[5];
            double sx = Math.signum(a) * Math.sqrt(a * a + c * c);
            double sy = Math.signum(d) * Math.sqrt(b * b + d * d);
            lineWidth = (float)((double)lineWidth * sx);
        }
        if (pathObject.getStroke().booleanValue()) {
            if (compositeObjectAlpha != null) {
                graphicsState = new PDExtendedGraphicsState();
                graphicsState.setStrokingAlphaConstant(Float.valueOf((float)compositeObjectAlpha.intValue() * 1.0f / 255.0f));
                contentStream.setGraphicsStateParameters(graphicsState);
            }
            if (pathObject.getDashPattern() != null) {
                float unitsOn = (float)CommonUtil.converterDpi(pathObject.getDashPattern().toDouble()[0].floatValue());
                float unitsOff = (float)CommonUtil.converterDpi(pathObject.getDashPattern().toDouble()[1].floatValue());
                float phase = (float)CommonUtil.converterDpi(pathObject.getDashOffset().floatValue());
                contentStream.setLineDashPattern(new float[]{unitsOn, unitsOff}, phase);
            }
            contentStream.setLineJoinStyle(pathObject.getJoin().ordinal());
            contentStream.setLineCapStyle(pathObject.getCap().ordinal());
            contentStream.setMiterLimit(pathObject.getMiterLimit().floatValue());
            this.path(contentStream, box, sealBox, annotBox, pathObject, compositeObjectBoundary, compositeObjectCTM);
            contentStream.setLineWidth((float)CommonUtil.converterDpi(lineWidth));
            contentStream.stroke();
            contentStream.restoreGraphicsState();
        }
        if (pathObject.getFill().booleanValue()) {
            FillColor fillColor;
            contentStream.saveGraphicsState();
            if (compositeObjectAlpha != null) {
                graphicsState = new PDExtendedGraphicsState();
                graphicsState.setNonStrokingAlphaConstant(Float.valueOf((float)compositeObjectAlpha.intValue() * 1.0f / 255.0f));
                contentStream.setGraphicsStateParameters(graphicsState);
            }
            if ((fillColor = (FillColor)pathObject.getFillColor()) != null) {
                if (fillColor.getValue() != null) {
                    contentStream.setNonStrokingColor(CommonUtil.convertPDColor(fillColor.getValue()));
                } else {
                    this.setShadingFill(contentStream, (CT_Color)fillColor, true);
                }
            } else {
                contentStream.setNonStrokingColor(defaultFillColor);
            }
            this.path(contentStream, box, sealBox, annotBox, pathObject, compositeObjectBoundary, compositeObjectCTM);
            contentStream.fill();
            contentStream.restoreGraphicsState();
        }
    }

    private void setShadingFill(PDPageContentStream contentStream, CT_Color ctColor, boolean isFill) throws IOException {
        CT_AxialShd ctAxialShd = (CT_AxialShd)ctColor.getColorByType();
        if (ctAxialShd == null) {
            return;
        }
        ST_Array start = ((Segment)ctAxialShd.getSegments().get(0)).getColor().getValue();
        ST_Array end = ((Segment)ctAxialShd.getSegments().get(ctAxialShd.getSegments().size() - 1)).getColor().getValue();
        ST_Pos startPos = ctAxialShd.getStartPoint();
        ST_Pos endPos = ctAxialShd.getEndPoint();
        if (isFill) {
            contentStream.setNonStrokingColor(CommonUtil.convertPDColor(end));
        } else {
            contentStream.setStrokingColor(CommonUtil.convertPDColor(end));
        }
    }

    private void path(PDPageContentStream contentStream, ST_Box box, ST_Box sealBox, ST_Box annotBox, PathObject pathObject, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM) throws IOException {
        if (pathObject.getBoundary() == null) {
            return;
        }
        if (sealBox != null) {
            pathObject.setBoundary(pathObject.getBoundary().getTopLeftX() + sealBox.getTopLeftX(), pathObject.getBoundary().getTopLeftY() + sealBox.getTopLeftY(), pathObject.getBoundary().getWidth().doubleValue(), pathObject.getBoundary().getHeight().doubleValue());
        }
        if (annotBox != null) {
            pathObject.setBoundary(pathObject.getBoundary().getTopLeftX() + annotBox.getTopLeftX(), pathObject.getBoundary().getTopLeftY() + annotBox.getTopLeftY(), pathObject.getBoundary().getWidth().doubleValue(), pathObject.getBoundary().getHeight().doubleValue());
        }
        List<PathPoint> listPoint = PointUtil.calPdfPathPoint(box.getWidth(), box.getHeight(), pathObject.getBoundary(), PointUtil.convertPathAbbreviatedDatatoPoint(pathObject.getAbbreviatedData()), pathObject.getCTM() != null, pathObject.getCTM(), compositeObjectBoundary, compositeObjectCTM, true);
        for (int i = 0; i < listPoint.size(); ++i) {
            if (listPoint.get((int)i).type.equals("M") || listPoint.get((int)i).type.equals("S")) {
                contentStream.moveTo(listPoint.get((int)i).x1, listPoint.get((int)i).y1);
                continue;
            }
            if (listPoint.get((int)i).type.equals("L")) {
                contentStream.lineTo(listPoint.get((int)i).x1, listPoint.get((int)i).y1);
                continue;
            }
            if (listPoint.get((int)i).type.equals("B")) {
                contentStream.curveTo(listPoint.get((int)i).x1, listPoint.get((int)i).y1, listPoint.get((int)i).x2, listPoint.get((int)i).y2, listPoint.get((int)i).x3, listPoint.get((int)i).y3);
                continue;
            }
            if (listPoint.get((int)i).type.equals("Q")) {
                contentStream.curveTo1(listPoint.get((int)i).x1, listPoint.get((int)i).y1, listPoint.get((int)i).x2, listPoint.get((int)i).y2);
                continue;
            }
            if (!listPoint.get((int)i).type.equals("C")) continue;
            contentStream.closePath();
        }
    }

    private void writeImage(ResourceManage resMgt, PDPageContentStream contentStream, ST_Box box, ImageObject imageObject, ST_Box annotBox) throws IOException {
        ST_RefID resourceID = imageObject.getResourceID();
        if (resourceID == null) {
            return;
        }
        BufferedImage bufferedImage = resMgt.getImage(resourceID.toString());
        if (bufferedImage == null) {
            return;
        }
        contentStream.saveGraphicsState();
        PDImageXObject pdfImageObject = LosslessFactory.createFromImage((PDDocument)this.pdf, (BufferedImage)bufferedImage);
        if (annotBox != null) {
            float x = annotBox.getTopLeftX().floatValue();
            float y = box.getHeight().floatValue() - (annotBox.getTopLeftY().floatValue() + annotBox.getHeight().floatValue());
            float width = annotBox.getWidth().floatValue();
            float height = annotBox.getHeight().floatValue();
            contentStream.drawImage(pdfImageObject, (float)CommonUtil.converterDpi(x), (float)CommonUtil.converterDpi(y), (float)CommonUtil.converterDpi(width), (float)CommonUtil.converterDpi(height));
        } else {
            Matrix matrix = CommonUtil.toPFMatrix(CommonUtil.getImageMatrixFromOfd(imageObject, box));
            contentStream.drawImage(pdfImageObject, matrix);
        }
        contentStream.restoreGraphicsState();
    }

    private void writeSealImage(PDPageContentStream contentStream, ST_Box box, byte[] image, ST_Box sealBox, ST_Box clipBox) throws IOException {
        if (image == null) {
            return;
        }
        contentStream.saveGraphicsState();
        PDImageXObject pdfImageObject = LosslessFactory.createFromImage((PDDocument)this.pdf, (BufferedImage)ImageIO.read(new ByteArrayInputStream(image)));
        float x = sealBox.getTopLeftX().floatValue();
        float y = box.getHeight().floatValue() - (sealBox.getTopLeftY().floatValue() + sealBox.getHeight().floatValue());
        float width = sealBox.getWidth().floatValue();
        float height = sealBox.getHeight().floatValue();
        if (clipBox != null) {
            contentStream.addRect((float)CommonUtil.converterDpi(x) + (float)CommonUtil.converterDpi(clipBox.getTopLeftX()), (float)CommonUtil.converterDpi(y) + (float)(CommonUtil.converterDpi(height) - (CommonUtil.converterDpi(clipBox.getTopLeftY()) + CommonUtil.converterDpi(clipBox.getHeight()))), (float)CommonUtil.converterDpi(clipBox.getWidth()), (float)CommonUtil.converterDpi(clipBox.getHeight()));
            contentStream.closePath();
            contentStream.clip();
            contentStream.stroke();
        }
        contentStream.drawImage(pdfImageObject, (float)CommonUtil.converterDpi(x), (float)CommonUtil.converterDpi(y), (float)CommonUtil.converterDpi(width), (float)CommonUtil.converterDpi(height));
        contentStream.restoreGraphicsState();
    }

    private void writeText(ResourceManage resMgt, PDPageContentStream contentStream, ST_Box box, ST_Box sealBox, TextObject textObject, PDColor fillColor, int alpha) throws IOException {
        float fontSize = textObject.getSize().floatValue();
        if (sealBox != null && textObject.getBoundary() != null) {
            textObject.setBoundary(textObject.getBoundary().getTopLeftX() + sealBox.getTopLeftX(), textObject.getBoundary().getTopLeftY() + sealBox.getTopLeftY(), textObject.getBoundary().getWidth().doubleValue(), textObject.getBoundary().getHeight().doubleValue());
        }
        if (textObject.getCTM() != null) {
            Double[] ctm = textObject.getCTM().toDouble();
            double a = ctm[0];
            double b = ctm[1];
            double c = ctm[2];
            double d = ctm[3];
            double sx = a > 0.0 ? Math.signum(a) * Math.sqrt(a * a + c * c) : Math.sqrt(a * a + c * c);
            double sy = Math.signum(d) * Math.sqrt(b * b + d * d);
            double angel = Math.atan2(-b, d);
            if (angel != 0.0 || a == 0.0 || d != 1.0) {
                fontSize = (float)((double)fontSize * sx);
            }
        }
        CT_Font ctFont = resMgt.getFont(textObject.getFont().toString());
        PDFont font = this.getFont(ctFont);
        List<TextCodePoint> textCodePointList = PointUtil.calPdfTextCoordinate(box.getWidth(), box.getHeight(), textObject.getBoundary(), fontSize, textObject.getTextCodes(), textObject.getCTM() != null, textObject.getCTM(), true);
        double rx = 0.0;
        double ry = 0.0;
        for (int i = 0; i < textCodePointList.size(); ++i) {
            TextCodePoint textCodePoint = textCodePointList.get(i);
            if (i == 0) {
                rx = textCodePoint.x;
                ry = textCodePoint.y;
            }
            contentStream.saveGraphicsState();
            contentStream.beginText();
            contentStream.setNonStrokingColor(fillColor);
            contentStream.newLineAtOffset((float)textCodePoint.getX(), (float)textCodePoint.getY());
            if (textObject.getCTM() != null) {
                Double[] ctm = textObject.getCTM().toDouble();
                double a = ctm[0];
                double b = ctm[1];
                double c = ctm[2];
                double d = ctm[3];
                AffineTransform transform = new AffineTransform();
                double angel = Math.atan2(-b, d);
                transform.rotate(angel, rx, ry);
                contentStream.concatenate2CTM(transform);
                if (angel == 0.0 && a != 0.0 && d == 1.0) {
                    textObject.setHScale(Double.valueOf(a));
                }
            }
            if (textObject.getHScale().floatValue() < 1.0f) {
                AffineTransform transform = new AffineTransform();
                transform.setTransform(textObject.getHScale().floatValue(), 0.0, 0.0, 1.0, (double)(1.0f - textObject.getHScale().floatValue()) * textCodePoint.getX(), 0.0);
                contentStream.concatenate2CTM(transform);
            }
            contentStream.setFont(font, (float)CommonUtil.converterDpi(fontSize));
            try {
                contentStream.showText(textCodePoint.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            contentStream.endText();
            contentStream.restoreGraphicsState();
        }
    }

    public void addAttachments(OFDReader ofdReader) throws IOException {
        List attachmentList = ofdReader.getAttachmentList();
        if (attachmentList == null || attachmentList.isEmpty()) {
            return;
        }
        PDEmbeddedFilesNameTreeNode efTree = new PDEmbeddedFilesNameTreeNode();
        HashMap<String, PDComplexFileSpecification> efMap = new HashMap<String, PDComplexFileSpecification>();
        for (CT_Attachment attachment : attachmentList) {
            PDComplexFileSpecification fs = new PDComplexFileSpecification();
            Path attFile = ofdReader.getAttachmentFile(attachment);
            fs.setFile(attFile.getFileName().toString());
            PDEmbeddedFile ef = new PDEmbeddedFile(this.pdf, Files.newInputStream(attFile, new OpenOption[0]));
            ef.setSubtype(attachment.getFormat());
            ef.setSize((int)Files.size(attFile));
            LocalDateTime creationDate = attachment.getCreationDateTime();
            Date date = Date.from(creationDate.atZone(ZoneId.systemDefault()).toInstant());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            ef.setCreationDate(calendar);
            fs.setEmbeddedFile(ef);
            efMap.put(attachment.getAttachmentName(), fs);
        }
        efTree.setNames(efMap);
        PDDocumentNameDictionary names = new PDDocumentNameDictionary(this.pdf.getDocumentCatalog());
        names.setEmbeddedFiles(efTree);
        this.pdf.getDocumentCatalog().setNames(names);
    }

    private PDFont getFont(CT_Font ctFont) {
        String key = String.format("%s_%s_%s", ctFont.getFamilyName(), ctFont.getFontName(), ctFont.getFontFile());
        if (this.fontCache.containsKey(key)) {
            return this.fontCache.get(key);
        }
        try {
            InputStream in = FontLoader.getInstance().loadFontSimilarStream(this.reader.getResourceLocator(), ctFont);
            PDType0Font font = PDType0Font.load((PDDocument)this.pdf, (InputStream)in, (boolean)true);
            this.fontCache.put(key, (PDFont)font);
            return font;
        }
        catch (Exception e) {
            logger.info("\u65e0\u6cd5\u4f7f\u7528\u5b57\u4f53: {} {} {}", new Object[]{ctFont.getFamilyName(), ctFont.getFontName(), ctFont.getFontFile().toString()});
            return PDType1Font.HELVETICA_BOLD;
        }
    }
}

