/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.ofdrw.core.basicStructure.pageObj.layer.block.TextObject;
import org.ofdrw.core.text.CT_CGTransform;

public class CGTransformMap {
    List<CT_CGTransform> data;

    private CGTransformMap() {
    }

    public CGTransformMap(TextObject textObject) {
        this.data = textObject.getCGTransforms().stream().filter(item -> {
            if (item.getCodePosition() == null) {
                item.setCodePosition(Integer.valueOf(0));
            }
            return true;
        }).sorted(Comparator.comparingInt(CT_CGTransform::getCodePosition)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Nullable
    public CT_CGTransform get(int globalOffset) {
        if (globalOffset < 0) {
            return null;
        }
        CT_CGTransform res = null;
        for (CT_CGTransform datum : this.data) {
            if (datum.getCodePosition() != globalOffset) continue;
            res = datum;
        }
        return res;
    }
}

