/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter;

import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ofdrw.converter.font.FontWrapper;
import org.ofdrw.converter.font.MemoryTTFDataStream;
import org.ofdrw.converter.font.TrueTypeCollection;
import org.ofdrw.converter.font.TrueTypeFont;
import org.ofdrw.converter.utils.OSinfo;
import org.ofdrw.core.Holder;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.text.font.CT_Font;
import org.ofdrw.reader.ResourceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FontLoader {
    private static final Logger log = LoggerFactory.getLogger(FontLoader.class);
    public static boolean DEBUG = false;
    private final Map<String, String> fontNamePathMapping = new ConcurrentHashMap<String, String>();
    private final Map<String, String> fontNameAliasMapping = new ConcurrentHashMap<String, String>();
    private final Map<Pattern, String> similarFontReplaceRegexMapping = new ConcurrentHashMap<Pattern, String>();
    private static final String DEFAULT_FONT_DIR_MAC = "/System/Library/Fonts";
    private static final String DEFAULT_FONT_DIR_WINDOWS = "C:/Windows/Fonts";
    private static final String DEFAULT_FONT_DIR_LINUX = "/usr/share/fonts";
    private static TrueTypeFont defaultFont;
    private static com.itextpdf.io.font.TrueTypeFont iTextDefaultFont;
    private static Path DefaultFontPath;
    private static FontLoader instance;
    private boolean enableSimilarFontReplace = true;

    private FontLoader() {
    }

    private static synchronized void syncInit() {
        if (instance == null) {
            instance = new FontLoader();
            instance.init();
        }
    }

    @Deprecated
    public static FontLoader enableSimilarFontReplace() {
        FontLoader instance = FontLoader.getInstance();
        instance.enableSimilarFontReplace = true;
        return instance;
    }

    public static FontLoader setSimilarFontReplace(boolean enable) {
        FontLoader instance = FontLoader.getInstance();
        instance.enableSimilarFontReplace = enable;
        return instance;
    }

    public static FontLoader getInstance() {
        if (instance == null) {
            FontLoader.syncInit();
        }
        return instance;
    }

    public static FontLoader Preload() {
        return FontLoader.getInstance();
    }

    public void init() {
        String name;
        if (OSinfo.isWindows()) {
            this.scanFontDir(new File(DEFAULT_FONT_DIR_WINDOWS));
            String username = System.getProperties().getProperty("user.name");
            this.scanFontDir(new File(String.format("C:\\Users\\%s\\AppData\\Local\\Microsoft\\Windows\\Fonts", username)));
        } else if (OSinfo.isMacOS()) {
            this.scanFontDir(new File(DEFAULT_FONT_DIR_MAC));
        } else if (OSinfo.isMacOSX()) {
            this.scanFontDir(new File(DEFAULT_FONT_DIR_MAC));
        } else if (OSinfo.isLinux()) {
            this.scanFontDir(new File(DEFAULT_FONT_DIR_LINUX));
        }
        this.addAliasMapping("\u5c0f\u6807\u5b8b\u4f53", "\u65b9\u6b63\u5c0f\u6807\u5b8b\u7b80\u4f53");
        this.addAliasMapping("KaiTi_GB2312", "\u6977\u4f53");
        this.addAliasMapping("\u6977\u4f53", "KaiTi");
        this.addAliasMapping("\u5b8b\u4f53", "SimSun");
        this.addSimilarFontReplaceRegexMapping(".*Kai.*", "\u6977\u4f53");
        this.addSimilarFontReplaceRegexMapping(".*Kai.*", "\u6977\u4f53");
        this.addSimilarFontReplaceRegexMapping(".*MinionPro.*", "SimSun");
        this.addSimilarFontReplaceRegexMapping(".*SimSun.*", "SimSun");
        this.addSimilarFontReplaceRegexMapping(".*Song.*", "\u5b8b\u4f53");
        this.addSimilarFontReplaceRegexMapping(".*MinionPro.*", "SimSun");
        String[] arr = new String[]{"\u5b8b\u4f53", "\u6977\u4f53", "\u4eff\u5b8b"};
        String defFt = null;
        String[] stringArray = arr;
        int n = stringArray.length;
        for (int i = 0; i < n && !FontLoader.loadAsDefaultFont(defFt = this.getReplaceSimilarFontPath(name = stringArray[i], "")); ++i) {
            defFt = null;
        }
        if (defFt == null) {
            Iterator<String> it = this.fontNamePathMapping.keySet().iterator();
            while (it.hasNext() && defFt == null) {
                defFt = this.fontNamePathMapping.get(it.next());
                if (FontLoader.loadAsDefaultFont(defFt)) continue;
                defFt = null;
            }
        }
        if (defFt == null) {
            throw new IllegalArgumentException("\u7cfb\u7edf\u4e2d\u65e0\u53ef\u7528\u5b57\u4f53");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadAsDefaultFont(String path) {
        InputStream in = null;
        try {
            Path loc = Paths.get(path, new String[0]);
            in = Files.newInputStream(loc, new OpenOption[0]);
            byte[] buf = IOUtils.toByteArray((InputStream)in);
            DefaultFontPath = loc;
            defaultFont = new TrueTypeFont().parse(buf);
            iTextDefaultFont = new com.itextpdf.io.font.TrueTypeFont(buf);
        }
        catch (IOException ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    @Deprecated
    public FontLoader addAliasMapping(@Nullable String familyName, String fontName, @Nullable String aliasFamilyName, String aliasFontName) {
        this.addAliasMapping(familyName, aliasFamilyName);
        this.addAliasMapping(fontName, aliasFontName);
        return this;
    }

    public FontLoader addAliasMapping(String fontName, String alias) {
        if (fontName == null || fontName.length() == 0) {
            return this;
        }
        if (alias == null || alias.length() == 0) {
            return this;
        }
        this.fontNameAliasMapping.put(fontName, alias);
        return this;
    }

    @Deprecated
    public FontLoader addSimilarFontReplaceRegexMapping(@Nullable String familyNameRegex, String fontNameRegex, @Nullable String aliasFamilyName, String aliasFontName) {
        this.addSimilarFontReplaceRegexMapping(familyNameRegex, aliasFamilyName);
        this.addSimilarFontReplaceRegexMapping(fontNameRegex, aliasFontName);
        return this;
    }

    public FontLoader addSimilarFontReplaceRegexMapping(String fontNameRegex, String fontName) {
        if (fontNameRegex == null || fontNameRegex.length() == 0) {
            return this;
        }
        if (fontName == null || fontName.length() == 0) {
            return this;
        }
        try {
            Pattern pattern = Pattern.compile(fontNameRegex);
            this.similarFontReplaceRegexMapping.put(pattern, fontName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    @Deprecated
    public FontLoader addSystemFontMapping(@Nullable String familyName, String fontName, String fontFilePath) {
        this.addSystemFontMapping(familyName, fontFilePath);
        this.addSystemFontMapping(fontName, fontFilePath);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontLoader addSystemFontMapping(String fontName, String fontFilePath) {
        if (fontName == null || fontName.length() == 0) {
            return this;
        }
        File file = new File(fontFilePath);
        if (!file.exists() || file.isDirectory()) {
            log.info("\u5b57\u4f53\u6620\u5c04\u6dfb\u52a0\u5931\u8d25\uff0c\u5b57\u4f53\u6587\u4ef6 {} \u4e0d\u5b58\u5728", (Object)fontFilePath);
            return this;
        }
        String name = file.getName().toLowerCase();
        if (!(name.endsWith("otf") || name.endsWith("ttf") || name.endsWith("ttc"))) {
            log.info("\u5b57\u4f53\u6620\u5c04\u6dfb\u52a0\u5931\u8d25 {} \u4e0d\u662f\u4e00\u4e2aOpenType\u5b57\u4f53", (Object)fontFilePath);
            return this;
        }
        Map<String, String> map = this.fontNamePathMapping;
        synchronized (map) {
            String p = this.fontNamePathMapping.get(fontName);
            if (p != null && p.equals(fontFilePath)) {
                return this;
            }
            this.fontNamePathMapping.put(fontName, fontFilePath);
            if (DEBUG) {
                log.info("\u5efa\u7acb\u5b57\u4f53\u6620\u5c04 {} --> {}", (Object)fontName, (Object)fontFilePath);
            }
        }
        return this;
    }

    public String getSystemFontPath(@Nullable String familyName, String fontName) {
        if (fontName == null && familyName == null) {
            return null;
        }
        String fontPath = null;
        if (fontName != null) {
            fontPath = this.fontNamePathMapping.get(fontName);
        }
        if (fontPath == null && familyName != null) {
            fontPath = this.fontNamePathMapping.get(familyName);
        }
        if (fontPath != null) {
            return fontPath;
        }
        String name = this.fontNameAliasMapping.get(fontName);
        if (name != null && this.fontNamePathMapping.containsKey(name)) {
            return this.fontNamePathMapping.get(name);
        }
        name = this.fontNameAliasMapping.get(familyName);
        if (name != null && this.fontNamePathMapping.containsKey(name)) {
            return this.fontNamePathMapping.get(name);
        }
        return null;
    }

    public String getReplaceSimilarFontPath(@Nullable String familyName, String fontName) {
        if (fontName == null && familyName == null) {
            return null;
        }
        String fontPath = this.getSystemFontPath(familyName, fontName);
        if (fontPath != null) {
            return fontPath;
        }
        String name = null;
        for (Map.Entry<Pattern, String> entry : this.similarFontReplaceRegexMapping.entrySet()) {
            Pattern pattern = entry.getKey();
            if (fontName != null && pattern.matcher(fontName).matches()) {
                name = entry.getValue();
                break;
            }
            if (familyName == null || !pattern.matcher(familyName).matches()) continue;
            name = entry.getValue();
            break;
        }
        if (name != null) {
            fontPath = this.getSystemFontPath(null, name);
        }
        return fontPath;
    }

    public TrueTypeFont loadSystemFont(String familyName, String fontName) {
        String fontFilePath = this.getSystemFontPath(familyName, fontName);
        if (fontFilePath == null) {
            return null;
        }
        return this.loadExternalFont(fontFilePath, familyName, fontName);
    }

    @Deprecated
    public TrueTypeFont loadExternalFont(String absPath) {
        return this.loadExternalFont(absPath, null, null);
    }

    public TrueTypeFont loadExternalFont(@NotNull String absPath, @Nullable String familyName, @Nullable String fontName) {
        block12: {
            try {
                String suffix;
                MemoryTTFDataStream raf = new MemoryTTFDataStream(new FileInputStream(absPath));
                int offset = absPath.toLowerCase().lastIndexOf(46);
                switch (suffix = offset == -1 ? ".ttf" : absPath.toLowerCase().substring(offset)) {
                    case ".ttf": 
                    case ".otf": {
                        return new TrueTypeFont().parse(raf);
                    }
                    case ".ttc": {
                        Holder holder = new Holder();
                        TrueTypeCollection ttc = new TrueTypeCollection().parse(raf);
                        ttc.foreach(font -> {
                            if (font.psName.equals(fontName)) {
                                holder.value = font;
                            }
                        });
                        if (holder.value == null) {
                            holder.value = ttc.getFontAtIndex(0);
                        }
                        return (TrueTypeFont)holder.value;
                    }
                }
            }
            catch (IOException e) {
                if (!DEBUG) break block12;
                log.warn("\u5b57\u4f53" + absPath + " \u52a0\u8f7d\u5931\u8d25", (Throwable)e);
            }
        }
        return null;
    }

    public TrueTypeFont loadFont(ResourceLocator rl, CT_Font ctFont) {
        return this.loadFontSimilar(rl, ctFont).getFont();
    }

    public FontWrapper<TrueTypeFont> loadFontSimilar(ResourceLocator rl, CT_Font ctFont) {
        TrueTypeFont trueTypeFont;
        boolean hasReplace;
        block7: {
            if (ctFont == null) {
                return null;
            }
            hasReplace = false;
            trueTypeFont = null;
            try {
                ST_Loc fontFileLoc = ctFont.getFontFile();
                if (fontFileLoc != null) {
                    String fontAbsPath = rl.getFile(ctFont.getFontFile()).toAbsolutePath().toString();
                    trueTypeFont = this.loadExternalFont(fontAbsPath, ctFont.getFamilyName(), ctFont.getFontName());
                }
                if (trueTypeFont == null) {
                    String similarFontPath = this.getReplaceSimilarFontPath(ctFont.getFamilyName(), ctFont.getFontName());
                    if (similarFontPath != null) {
                        trueTypeFont = this.loadExternalFont(similarFontPath, null, null);
                    }
                    hasReplace = true;
                }
            }
            catch (Exception e) {
                if (!DEBUG) break block7;
                log.warn("\u65e0\u6cd5\u52a0\u8f7d\u5b57\u4f53: " + ctFont.getFamilyName() + " " + ctFont.getFontName() + " " + ctFont.getFontFile(), (Throwable)e);
            }
        }
        if (trueTypeFont == null) {
            trueTypeFont = defaultFont;
            hasReplace = true;
        }
        return new FontWrapper<TrueTypeFont>(trueTypeFont, hasReplace);
    }

    public InputStream loadFontSimilarStream(ResourceLocator rl, CT_Font ctFont) {
        byte[] buf;
        block9: {
            buf = null;
            try {
                if (ctFont != null) {
                    ST_Loc fontFileLoc = ctFont.getFontFile();
                    if (fontFileLoc != null) {
                        String fontAbsPath = rl.getFile(ctFont.getFontFile()).toAbsolutePath().toString();
                        buf = Files.readAllBytes(Paths.get(fontAbsPath, new String[0]));
                    } else {
                        String similarFontPath = this.getReplaceSimilarFontPath(ctFont.getFamilyName(), ctFont.getFontName());
                        if (similarFontPath != null) {
                            buf = Files.readAllBytes(Paths.get(similarFontPath, new String[0]));
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!DEBUG) break block9;
                log.warn("\u65e0\u6cd5\u52a0\u8f7d\u5b57\u4f53: " + ctFont.getFamilyName() + " " + ctFont.getFontName() + " " + ctFont.getFontFile(), (Throwable)e);
            }
        }
        if (buf == null || buf.length == 0) {
            try {
                buf = Files.readAllBytes(DefaultFontPath);
            }
            catch (IOException e) {
                throw new RuntimeException("\u9ed8\u8ba4\u5b57\u4f53\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38", e);
            }
        }
        return new ByteArrayInputStream(buf);
    }

    public PdfFont loadPDFFont(ResourceLocator rl, CT_Font ctFont) {
        return this.loadPDFFontSimilar(rl, ctFont).getFont();
    }

    public FontWrapper<PdfFont> loadPDFFontSimilar(ResourceLocator rl, CT_Font ctFont) {
        if (ctFont == null) {
            return null;
        }
        String fontName = ctFont.attributeValue("FontName");
        String familyName = ctFont.getFamilyName();
        try {
            String fontAbsPath;
            ST_Loc fontFileLoc = ctFont.getFontFile();
            FontProgram fontProgram = null;
            boolean hasReplace = false;
            if (fontFileLoc != null) {
                fontAbsPath = rl.getFile(fontFileLoc).toAbsolutePath().toString();
                fontProgram = this.getFontProgram(fontAbsPath);
            }
            if (fontProgram == null) {
                fontAbsPath = this.getSystemFontPath(familyName, fontName);
                if (fontAbsPath == null && this.enableSimilarFontReplace) {
                    hasReplace = true;
                    fontAbsPath = this.getReplaceSimilarFontPath(familyName, fontName);
                }
                fontProgram = this.getFontProgram(fontAbsPath);
            }
            if (fontProgram == null) {
                log.info("\u65e0\u6cd5\u5185\u5d4c\u52a0\u8f7d\u5b57\u4f53 {} {} {}", new Object[]{familyName, fontName, ctFont.getFontFile()});
                fontProgram = iTextDefaultFont;
                hasReplace = true;
            }
            return new FontWrapper<PdfFont>(PdfFontFactory.createFont((FontProgram)fontProgram, (String)"Identity-H", (boolean)false), hasReplace);
        }
        catch (Exception e) {
            if (DEBUG) {
                log.warn("\u52a0\u8f7d\u5b57\u4f53\u5f02\u5e38 " + familyName + " " + fontName + " " + ctFont.getFontFile(), (Throwable)e);
            }
            return new FontWrapper<PdfFont>(PdfFontFactory.createFont((FontProgram)iTextDefaultFont, (String)"Identity-H", (boolean)false), true);
        }
    }

    private FontProgram getFontProgram(String fontAbsPath) {
        if (fontAbsPath == null) {
            return null;
        }
        Object fontProgram = null;
        String fileName = fontAbsPath.toLowerCase();
        byte[] fontRaw = new byte[]{};
        try {
            fontRaw = Files.readAllBytes(Paths.get(fontAbsPath, new String[0]));
            fontProgram = fileName.endsWith(".ttc") ? FontProgramFactory.createFont((byte[])fontRaw, (int)0, (boolean)false) : (fileName.endsWith(".ttf") || fileName.endsWith(".otf") ? new com.itextpdf.io.font.TrueTypeFont(fontRaw) : FontProgramFactory.createFont((byte[])fontRaw));
            return fontProgram;
        }
        catch (Exception e) {
            if (DEBUG) {
                log.info("\u5b57\u4f53\u52a0\u8f7d\u5931\u8d25 " + fontAbsPath, (Throwable)e);
            }
            return null;
        }
    }

    public TrueTypeFont loadDefaultFont() {
        return defaultFont;
    }

    public void scanFontDir(File dir) {
        this.scanFontDir(dir.toPath());
    }

    public void scanFontDir(Path dirPath) {
        block15: {
            if (dirPath == null || Files.notExists(dirPath, new LinkOption[0]) || Files.isRegularFile(dirPath, new LinkOption[0])) {
                return;
            }
            dirPath = dirPath.toAbsolutePath();
            try (Stream<Path> walk = Files.walk(dirPath, new FileVisitOption[0]);){
                walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> this.loadFont(p.toFile()));
            }
            catch (IOException e) {
                if (!DEBUG) break block15;
                log.warn("\u5b57\u4f53\u52a0\u8f7d\u5f02\u5e38\uff0c{}", (Throwable)e);
            }
        }
    }

    public void loadFont(Path file) {
        this.loadFont(file.toFile());
    }

    public void loadFont(File file) {
        block5: {
            try {
                Font awtFont = Font.createFont(0, file);
                String family = awtFont.getFamily();
                String fontName = awtFont.getFontName();
                if (family != null && family.equals(fontName)) {
                    this.addSystemFontMapping(family, file.getAbsolutePath());
                } else if (family != null) {
                    this.addSystemFontMapping(fontName, file.getAbsolutePath());
                }
            }
            catch (Exception e) {
                if (!DEBUG) break block5;
                log.warn("\u65e0\u6cd5\u52a0\u8f7dAWT\u5b57\u4f53 " + file.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    public static void FixOS2(String src) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(new File(src), "rws");){
            int v1 = raf.readUnsignedShort();
            int v2 = raf.readUnsignedShort();
            int numberOfTables = raf.readUnsignedShort();
            int searchRange = raf.readUnsignedShort();
            int entrySelector = raf.readUnsignedShort();
            int rangeShift = raf.readUnsignedShort();
            for (int i = 0; i < numberOfTables; ++i) {
                byte[] buff = new byte[4];
                raf.read(buff);
                String tag = new String(buff, StandardCharsets.ISO_8859_1);
                int checkSum = raf.readInt();
                int offset = raf.readInt();
                int length = raf.readInt();
                if (!tag.equals("os/2")) continue;
                long before = raf.getFilePointer();
                long p = before - 16L;
                raf.seek(p);
                raf.write(new byte[]{79, 83, 47, 50});
                raf.seek(before);
                break;
            }
        }
    }

    public TrueTypeFont getDefaultFont() {
        return defaultFont;
    }

    public com.itextpdf.io.font.TrueTypeFont getITextDefaultFont() {
        return iTextDefaultFont;
    }

    public Path getDefaultFontPath() {
        return DefaultFontPath;
    }

    static {
        instance = null;
    }
}

