/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.PatternColor;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.colorspace.PdfDeviceCs;
import com.itextpdf.kernel.pdf.colorspace.PdfPattern;
import com.itextpdf.kernel.pdf.colorspace.PdfShading;
import com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import com.itextpdf.kernel.pdf.filespec.PdfFileSpec;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.Canvas;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.pdfbox.util.Matrix;
import org.dom4j.Element;
import org.ofdrw.converter.ColorConvert;
import org.ofdrw.converter.FontLoader;
import org.ofdrw.converter.font.FontWrapper;
import org.ofdrw.converter.point.PathPoint;
import org.ofdrw.converter.point.TextCodePoint;
import org.ofdrw.converter.utils.CommonUtil;
import org.ofdrw.converter.utils.PointUtil;
import org.ofdrw.converter.utils.StringUtils;
import org.ofdrw.core.annotation.pageannot.Annot;
import org.ofdrw.core.annotation.pageannot.Appearance;
import org.ofdrw.core.attachment.CT_Attachment;
import org.ofdrw.core.basicStructure.pageObj.layer.CT_Layer;
import org.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CompositeObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.ImageObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.PathObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.TextObject;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_Pos;
import org.ofdrw.core.basicType.ST_RefID;
import org.ofdrw.core.compositeObj.CT_VectorG;
import org.ofdrw.core.graph.pathObj.CT_Path;
import org.ofdrw.core.graph.pathObj.FillColor;
import org.ofdrw.core.graph.pathObj.Rule;
import org.ofdrw.core.graph.pathObj.StrokeColor;
import org.ofdrw.core.pageDescription.CT_GraphicUnit;
import org.ofdrw.core.pageDescription.clips.Area;
import org.ofdrw.core.pageDescription.clips.CT_Clip;
import org.ofdrw.core.pageDescription.color.color.CT_AxialShd;
import org.ofdrw.core.pageDescription.color.color.CT_Color;
import org.ofdrw.core.pageDescription.color.color.CT_RadialShd;
import org.ofdrw.core.pageDescription.color.color.Segment;
import org.ofdrw.core.pageDescription.drawParam.CT_DrawParam;
import org.ofdrw.core.signatures.appearance.StampAnnot;
import org.ofdrw.core.text.font.CT_Font;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.PageInfo;
import org.ofdrw.reader.ResourceLocator;
import org.ofdrw.reader.ResourceManage;
import org.ofdrw.reader.model.AnnotionEntity;
import org.ofdrw.reader.model.StampAnnotEntity;
import org.ofdrw.reader.tools.ImageUtils;

public class ItextMaker {
    private Map<String, FontWrapper<PdfFont>> fontCache = new HashMap<String, FontWrapper<PdfFont>>();
    private final OFDReader ofdReader;
    private final ResourceManage resMgt;

    public ItextMaker(OFDReader ofdReader) throws IOException {
        this.ofdReader = ofdReader;
        this.resMgt = ofdReader.getResMgt();
    }

    public PdfPage makePage(PdfDocument pdf, PageInfo pageInfo) throws IOException {
        ST_Box pageBox = pageInfo.getSize();
        double pageWidthPixel = CommonUtil.converterDpi(pageBox.getWidth());
        double pageHeightPixel = CommonUtil.converterDpi(pageBox.getHeight());
        PageSize pageSize = new PageSize((float)pageWidthPixel, (float)pageHeightPixel);
        PdfPage pdfPage = pdf.addNewPage(pageSize);
        pdfPage.setMediaBox(new Rectangle((float)CommonUtil.converterDpi(pageBox.getTopLeftX()), (float)CommonUtil.converterDpi(pageBox.getTopLeftY()), (float)CommonUtil.converterDpi(pageBox.getWidth()), (float)CommonUtil.converterDpi(pageBox.getHeight())));
        List annotationEntities = this.ofdReader.getAnnotationEntities();
        List stampAnnots = this.ofdReader.getStampAnnots();
        PdfCanvas pdfCanvas = new PdfCanvas(pdfPage);
        List layerList = pageInfo.getAllLayer();
        this.writeLayer(this.resMgt, pdfCanvas, layerList, pageBox, null);
        this.writeStamp(pdf, pdfCanvas, pageInfo, stampAnnots);
        this.writeAnnoAppearance(this.resMgt, pdfCanvas, pageInfo, annotationEntities, pageBox);
        return pdfPage;
    }

    public void addAttachments(PdfDocument pdf, OFDReader ofdReader) throws IOException {
        List attachmentList = ofdReader.getAttachmentList();
        for (CT_Attachment attachment : attachmentList) {
            Path attFile = ofdReader.getAttachmentFile(attachment);
            byte[] fileBytes = Files.readAllBytes(attFile);
            String fileName = attFile.getFileName().toString();
            String attachmentName = attachment.getAttachmentName();
            String displayFileName = StringUtils.isBlank(attachmentName) ? fileName : attachmentName.concat(fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(".")) : "");
            PdfFileSpec fs = PdfFileSpec.createEmbeddedFileSpec((PdfDocument)pdf, (byte[])fileBytes, null, (String)displayFileName, null);
            pdf.addFileAttachment(displayFileName, fs);
        }
    }

    private void writeStamp(PdfDocument pdf, PdfCanvas pdfCanvas, PageInfo parent, List<StampAnnotEntity> stampAnnotEntityList) throws IOException {
        String pageID = parent.getId().toString();
        for (StampAnnotEntity stampAnnotVo : stampAnnotEntityList) {
            List stampAnnots = stampAnnotVo.getStampAnnots();
            for (StampAnnot stampAnnot : stampAnnots) {
                if (!stampAnnot.getPageRef().toString().equals(pageID)) continue;
                ST_Box pageBox = parent.getSize();
                ST_Box sealBox = stampAnnot.getBoundary();
                ST_Box clipBox = stampAnnot.getClip();
                if (stampAnnotVo.getImgType().equalsIgnoreCase("ofd")) {
                    OFDReader sealOfdReader = new OFDReader((InputStream)new ByteArrayInputStream(stampAnnotVo.getImageByte()));
                    Throwable throwable = null;
                    try {
                        ResourceManage sealResMgt = sealOfdReader.getResMgt();
                        for (PageInfo ofdPageVo : sealOfdReader.getPageList()) {
                            List layerList = ofdPageVo.getAllLayer();
                            this.writeLayer(sealResMgt, pdfCanvas, layerList, pageBox, sealBox);
                            this.writeAnnoAppearance(sealResMgt, pdfCanvas, ofdPageVo, sealOfdReader.getAnnotationEntities(), pageBox);
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (sealOfdReader == null) continue;
                        if (throwable != null) {
                            try {
                                sealOfdReader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        sealOfdReader.close();
                        continue;
                    }
                }
                this.writeSealImage(pdf, pdfCanvas, pageBox, stampAnnotVo.getImageByte(), sealBox, clipBox);
            }
        }
    }

    private void writeLayer(ResourceManage resMgt, PdfCanvas pdfCanvas, List<CT_Layer> layerList, ST_Box box, ST_Box sealBox) throws IOException {
        for (CT_Layer layer : layerList) {
            this.writePageBlock(resMgt, pdfCanvas, box, sealBox, layer.getPageBlocks(), layer.getDrawParam(), null, null, null, null);
        }
    }

    private void writeAnnoAppearance(ResourceManage resMgt, PdfCanvas pdfCanvas, PageInfo pageInfo, List<AnnotionEntity> annotionEntities, ST_Box box) throws IOException {
        String pageId = pageInfo.getId().toString();
        for (AnnotionEntity annotionEntity : annotionEntities) {
            List annotList = annotionEntity.getAnnots();
            if (annotList == null || !pageId.equalsIgnoreCase(annotionEntity.getPageId())) continue;
            for (Annot annot : annotList) {
                Appearance appearance = annot.getAppearance();
                if (appearance == null) continue;
                List pageBlockTypeList = appearance.getPageBlocks();
                ST_Box annotBox = appearance.getBoundary();
                this.writePageBlock(resMgt, pdfCanvas, box, null, pageBlockTypeList, null, annotBox, null, null, null);
            }
        }
    }

    private void writePageBlock(ResourceManage resMgt, PdfCanvas pdfCanvas, ST_Box box, ST_Box sealBox, List<PageBlockType> pageBlockTypeList, ST_RefID drawparam, ST_Box annotBox, Integer compositeObjectAlpha, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM) throws IOException {
        Color defaultStrokeColor = ColorConstants.BLACK;
        Color defaultFillColor = ColorConstants.BLACK;
        float defaultLineWidth = 0.353f;
        CT_DrawParam ctDrawParam = null;
        if (drawparam != null) {
            ctDrawParam = resMgt.getDrawParamFinal(drawparam.toString());
        }
        if (ctDrawParam != null) {
            if (ctDrawParam.getLineWidth() != null) {
                defaultLineWidth = ctDrawParam.getLineWidth().floatValue();
            }
            if (ctDrawParam.getStrokeColor() != null) {
                defaultStrokeColor = ColorConvert.pdfRGB(resMgt, ctDrawParam.getStrokeColor());
            }
            if (ctDrawParam.getFillColor() != null) {
                defaultFillColor = ColorConvert.pdfRGB(resMgt, (CT_Color)ctDrawParam.getFillColor());
            }
        }
        for (PageBlockType block : pageBlockTypeList) {
            if (block instanceof TextObject) {
                Color fillColor = defaultFillColor;
                TextObject textObject = (TextObject)block;
                int alpha = 255;
                FillColor ctFillColor = textObject.getFillColor();
                if (ctFillColor != null) {
                    if (ctFillColor.getValue() != null) {
                        fillColor = ColorConvert.pdfRGB(resMgt, (CT_Color)ctFillColor);
                    } else if (ctFillColor.getColorByType() != null) {
                        CT_AxialShd ctAxialShd = (CT_AxialShd)ctFillColor.getColorByType();
                        fillColor = ColorConvert.pdfRGB(resMgt, ((Segment)ctAxialShd.getSegments().get(0)).getColor());
                    }
                    alpha = ctFillColor.getAlpha();
                }
                this.writeText(resMgt, pdfCanvas, box, sealBox, annotBox, textObject, fillColor, alpha, compositeObjectAlpha, compositeObjectBoundary, compositeObjectCTM);
                continue;
            }
            if (block instanceof ImageObject) {
                ImageObject imageObject = (ImageObject)block;
                resMgt.superDrawParam((CT_GraphicUnit)imageObject);
                this.writeImage(resMgt, pdfCanvas, box, imageObject, annotBox, compositeObjectAlpha, compositeObjectBoundary, compositeObjectCTM);
                continue;
            }
            if (block instanceof PathObject) {
                PathObject pathObject = (PathObject)block;
                resMgt.superDrawParam((CT_GraphicUnit)pathObject);
                this.writePath(resMgt, pdfCanvas, box, sealBox, annotBox, pathObject, defaultFillColor, defaultStrokeColor, defaultLineWidth, compositeObjectAlpha, compositeObjectBoundary, compositeObjectCTM);
                continue;
            }
            if (block instanceof CompositeObject) {
                CompositeObject compositeObject = (CompositeObject)block;
                CT_VectorG vectorG = resMgt.getCompositeGraphicUnit(compositeObject.getResourceID().toString());
                Integer currentCompositeObjectAlpha = compositeObject.getAlpha();
                ST_Box currentCompositeObjectBoundary = compositeObject.getBoundary();
                ST_Array currentCompositeObjectCTM = compositeObject.getCTM();
                this.writePageBlock(resMgt, pdfCanvas, box, sealBox, vectorG.getContent().getPageBlocks(), drawparam, annotBox, currentCompositeObjectAlpha, currentCompositeObjectBoundary, currentCompositeObjectCTM);
                continue;
            }
            if (!(block instanceof CT_PageBlock)) continue;
            this.writePageBlock(resMgt, pdfCanvas, box, sealBox, ((CT_PageBlock)block).getPageBlocks(), drawparam, annotBox, compositeObjectAlpha, compositeObjectBoundary, compositeObjectCTM);
        }
    }

    private Color parseAxial(Element eleAxialShd, ResourceManage resMgt, ST_Box box, PathObject pathObject) {
        PatternColor result = null;
        if (eleAxialShd == null) {
            return result;
        }
        CT_AxialShd ctAxialShd = new CT_AxialShd(eleAxialShd);
        Color startColor = ColorConvert.pdfRGB(resMgt, ((Segment)ctAxialShd.getSegments().get(0)).getColor());
        Color endColor = ColorConvert.pdfRGB(resMgt, ((Segment)ctAxialShd.getSegments().get(ctAxialShd.getSegments().size() - 1)).getColor());
        ST_Pos startPos = ctAxialShd.getStartPoint();
        ST_Pos endPos = ctAxialShd.getEndPoint();
        double x1 = startPos.getX();
        double y1 = startPos.getY();
        double x2 = endPos.getX();
        double y2 = endPos.getY();
        double[] realPos = PointUtil.adjustPos(box.getWidth(), box.getHeight(), x1, y1, pathObject.getBoundary());
        x1 = realPos[0];
        y1 = box.getHeight() - realPos[1];
        realPos = PointUtil.adjustPos(box.getWidth(), box.getHeight(), x2, y2, pathObject.getBoundary());
        x2 = realPos[0];
        y2 = box.getHeight() - realPos[1];
        PdfShading.Axial axial = new PdfShading.Axial((PdfColorSpace)new PdfDeviceCs.Rgb(), (float)CommonUtil.converterDpi(x1), (float)CommonUtil.converterDpi(y1), startColor.getColorValue(), (float)CommonUtil.converterDpi(x2), (float)CommonUtil.converterDpi(y2), endColor.getColorValue());
        PdfPattern.Shading shading = new PdfPattern.Shading((PdfShading)axial);
        result = new PatternColor((PdfPattern)shading);
        return result;
    }

    private Color parseRadial(Element eleRadialShd, ResourceManage resMgt, ST_Box box, PathObject pathObject) {
        PatternColor result = null;
        if (eleRadialShd == null) {
            return result;
        }
        CT_RadialShd ctRadialShd = new CT_RadialShd(eleRadialShd);
        Color startColor = ColorConvert.pdfRGB(resMgt, ((Segment)ctRadialShd.getSegments().get(0)).getColor());
        Color endColor = ColorConvert.pdfRGB(resMgt, ((Segment)ctRadialShd.getSegments().get(ctRadialShd.getSegments().size() - 1)).getColor());
        ST_Pos startPos = ctRadialShd.getStartPoint();
        ST_Pos endPos = ctRadialShd.getEndPoint();
        double x1 = startPos.getX();
        double y1 = startPos.getY();
        double x2 = endPos.getX();
        double y2 = endPos.getY();
        double[] realPos = PointUtil.adjustPos(box.getWidth(), box.getHeight(), x1, y1, pathObject.getBoundary());
        x1 = realPos[0];
        y1 = box.getHeight() - realPos[1];
        realPos = PointUtil.adjustPos(box.getWidth(), box.getHeight(), x2, y2, pathObject.getBoundary());
        x2 = realPos[0];
        y2 = box.getHeight() - realPos[1];
        PdfShading.Radial radial = new PdfShading.Radial((PdfColorSpace)new PdfDeviceCs.Rgb(), (float)CommonUtil.converterDpi(x1), (float)CommonUtil.converterDpi(y1), (float)CommonUtil.converterDpi(ctRadialShd.getStartRadius()), startColor.getColorValue(), (float)CommonUtil.converterDpi(x2), (float)CommonUtil.converterDpi(y2), (float)CommonUtil.converterDpi(ctRadialShd.getEndRadius()), endColor.getColorValue());
        PdfPattern.Shading shading = new PdfPattern.Shading((PdfShading)radial);
        result = new PatternColor((PdfPattern)shading);
        return result;
    }

    private void writePath(ResourceManage resMgt, PdfCanvas pdfCanvas, ST_Box box, ST_Box sealBox, ST_Box annotBox, PathObject pathObject, Color defaultFillColor, Color defaultStrokeColor, float defaultLineWidth, Integer compositeObjectAlpha, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM) {
        pdfCanvas.saveState();
        double scale = this.scaling(sealBox, pathObject.getBoundary());
        CT_DrawParam ctDrawParam = resMgt.superDrawParam((CT_GraphicUnit)pathObject);
        if (ctDrawParam != null) {
            if (pathObject.getStrokeColor() == null && ctDrawParam.getStrokeColor() != null) {
                pathObject.setStrokeColor(new CT_Color().setValue(ctDrawParam.getStrokeColor().getValue()));
            }
            if (pathObject.getFillColor() == null && ctDrawParam.getFillColor() != null) {
                pathObject.setFillColor(new CT_Color().setValue(ctDrawParam.getFillColor().getValue()));
            }
            if (pathObject.getLineWidth() == null && ctDrawParam.getLineWidth() != null) {
                pathObject.setLineWidth(ctDrawParam.getLineWidth());
            }
        }
        if (pathObject.getStrokeColor() != null) {
            Color radialShdColor;
            Color axialShdColor;
            StrokeColor strokeColor = pathObject.getStrokeColor();
            if (strokeColor.getValue() != null) {
                pdfCanvas.setStrokeColor(ColorConvert.pdfRGB(resMgt, (CT_Color)strokeColor));
            }
            if ((axialShdColor = this.parseAxial(strokeColor.getOFDElement("AxialShd"), resMgt, box, pathObject)) != null) {
                pdfCanvas.setStrokeColor(axialShdColor);
            }
            if ((radialShdColor = this.parseRadial(strokeColor.getOFDElement("RadialShd"), resMgt, box, pathObject)) != null) {
                pdfCanvas.setStrokeColor(radialShdColor);
            }
        } else {
            pdfCanvas.setStrokeColor(defaultStrokeColor);
        }
        float lineWidth = defaultLineWidth;
        if (pathObject.getLineWidth() != null && pathObject.getLineWidth() > 0.0) {
            lineWidth = Double.valueOf(CommonUtil.converterDpi(pathObject.getLineWidth()) * scale).floatValue();
        }
        pdfCanvas.setLineWidth(lineWidth);
        if (pathObject.getCTM() != null && pathObject.getLineWidth() != null) {
            Double[] ctm = pathObject.getCTM().toDouble();
            double a = ctm[0];
            double b = ctm[1];
            double c = ctm[2];
            double d = ctm[3];
            double e = ctm[4];
            double f = ctm[5];
            double sx = Math.signum(a) * Math.sqrt(a * a + c * c);
            double sy = Math.signum(d) * Math.sqrt(b * b + d * d);
            lineWidth = (float)((double)lineWidth * sx);
        }
        if (pathObject.getStroke().booleanValue()) {
            if (pathObject.getDashPattern() != null) {
                float unitsOn = (float)CommonUtil.converterDpi(pathObject.getDashPattern().toDouble()[0].floatValue());
                float unitsOff = (float)CommonUtil.converterDpi(pathObject.getDashPattern().toDouble()[1].floatValue());
                float phase = (float)CommonUtil.converterDpi(pathObject.getDashOffset().floatValue());
                pdfCanvas.setLineDash(unitsOn, unitsOff, phase);
            }
            pdfCanvas.setLineJoinStyle(pathObject.getJoin().ordinal());
            pdfCanvas.setLineCapStyle(pathObject.getCap().ordinal());
            pdfCanvas.setMiterLimit(pathObject.getMiterLimit().floatValue());
            this.path(pdfCanvas, box, sealBox, annotBox, pathObject, compositeObjectBoundary, compositeObjectCTM);
            pdfCanvas.stroke();
            pdfCanvas.restoreState();
        }
        if (pathObject.getFill().booleanValue()) {
            FillColor fillColor;
            pdfCanvas.saveState();
            if (compositeObjectAlpha != null) {
                PdfExtGState gs1 = new PdfExtGState();
                gs1.setFillOpacity((float)compositeObjectAlpha.intValue() * 1.0f / 255.0f);
                pdfCanvas.setExtGState(gs1);
            }
            if ((fillColor = (FillColor)pathObject.getFillColor()) != null) {
                Color radialShdColor;
                Color axialShdColor;
                if (fillColor.getValue() != null) {
                    pdfCanvas.setFillColor(ColorConvert.pdfRGB(resMgt, (CT_Color)fillColor));
                }
                if ((axialShdColor = this.parseAxial(fillColor.getOFDElement("AxialShd"), resMgt, box, pathObject)) != null) {
                    pdfCanvas.setFillColor(axialShdColor);
                }
                if ((radialShdColor = this.parseRadial(fillColor.getOFDElement("RadialShd"), resMgt, box, pathObject)) != null) {
                    pdfCanvas.setFillColor(radialShdColor);
                }
            } else {
                pdfCanvas.setFillColor(defaultFillColor);
            }
            this.path(pdfCanvas, box, sealBox, annotBox, pathObject, compositeObjectBoundary, compositeObjectCTM);
            if (null != pathObject.getRule() && pathObject.getRule().equals((Object)Rule.Even_Odd)) {
                pdfCanvas.eoFill();
            } else {
                pdfCanvas.fill();
            }
            pdfCanvas.restoreState();
        }
    }

    private void path(PdfCanvas pdfCanvas, ST_Box box, ST_Box sealBox, ST_Box annotBox, PathObject pathObject, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM) {
        if (pathObject.getBoundary() == null) {
            return;
        }
        double scale = this.scaling(sealBox, pathObject.getBoundary());
        if (sealBox != null) {
            pathObject.setBoundary(pathObject.getBoundary().getTopLeftX() + sealBox.getTopLeftX(), pathObject.getBoundary().getTopLeftY() + sealBox.getTopLeftY(), pathObject.getBoundary().getWidth().doubleValue(), pathObject.getBoundary().getHeight().doubleValue());
        }
        if (annotBox != null) {
            pathObject.setBoundary(pathObject.getBoundary().getTopLeftX() + CommonUtil.converterDpi(annotBox.getTopLeftX()), pathObject.getBoundary().getTopLeftY() + CommonUtil.converterDpi(annotBox.getTopLeftY()), pathObject.getBoundary().getWidth().doubleValue(), pathObject.getBoundary().getHeight().doubleValue());
        }
        this.clip(pdfCanvas, box, pathObject);
        List<PathPoint> listPoint = PointUtil.calPdfPathPoint(box.getWidth(), box.getHeight(), pathObject.getBoundary(), PointUtil.convertPathAbbreviatedDatatoPoint(pathObject.getAbbreviatedData()), pathObject.getCTM() != null, pathObject.getCTM(), compositeObjectBoundary, compositeObjectCTM, true, scale);
        for (int i = 0; i < listPoint.size(); ++i) {
            if (listPoint.get((int)i).type.equals("M") || listPoint.get((int)i).type.equals("S")) {
                pdfCanvas.moveTo((double)listPoint.get((int)i).x1, (double)listPoint.get((int)i).y1);
                continue;
            }
            if (listPoint.get((int)i).type.equals("L")) {
                pdfCanvas.lineTo((double)listPoint.get((int)i).x1, (double)listPoint.get((int)i).y1);
                continue;
            }
            if (listPoint.get((int)i).type.equals("B")) {
                pdfCanvas.curveTo((double)listPoint.get((int)i).x1, (double)listPoint.get((int)i).y1, (double)listPoint.get((int)i).x2, (double)listPoint.get((int)i).y2, (double)listPoint.get((int)i).x3, (double)listPoint.get((int)i).y3);
                continue;
            }
            if (listPoint.get((int)i).type.equals("Q")) {
                pdfCanvas.curveTo((double)listPoint.get((int)i).x1, (double)listPoint.get((int)i).y1, (double)listPoint.get((int)i).x2, (double)listPoint.get((int)i).y2);
                continue;
            }
            if (!listPoint.get((int)i).type.equals("C")) continue;
            pdfCanvas.closePath();
        }
    }

    private void clip(PdfCanvas pdfCanvas, ST_Box box, PathObject pathObject) {
        if (pathObject.getClips() == null) {
            return;
        }
        List clips = pathObject.getClips().getClips();
        for (int k = 0; k < clips.size(); ++k) {
            CT_Clip clip = (CT_Clip)clips.get(k);
            for (Area area : clip.getAreas()) {
                Element elePath = area.getOFDElement("Path");
                CT_Path path = new CT_Path(elePath);
                List<PathPoint> points = PointUtil.calPdfPathPoint(box.getWidth(), box.getHeight(), pathObject.getBoundary(), PointUtil.convertPathAbbreviatedDatatoPoint(path.getAbbreviatedData()), area.getCTM() != null, area.getCTM(), null, null, true, 1.0);
                pdfCanvas.clip();
                for (int i = 0; i < points.size(); ++i) {
                    PathPoint pathPoint = points.get(i);
                    if (pathPoint.type.equals("M") || pathPoint.type.equals("S")) {
                        pdfCanvas.moveTo((double)pathPoint.x1, (double)pathPoint.y1);
                        continue;
                    }
                    if (pathPoint.type.equals("L")) {
                        pdfCanvas.lineTo((double)pathPoint.x1, (double)pathPoint.y1);
                        continue;
                    }
                    if (pathPoint.type.equals("B")) {
                        pdfCanvas.curveTo((double)pathPoint.x1, (double)pathPoint.y1, (double)pathPoint.x2, (double)pathPoint.y2, (double)pathPoint.x3, (double)pathPoint.y3);
                        continue;
                    }
                    if (pathPoint.type.equals("Q")) {
                        pdfCanvas.curveTo((double)pathPoint.x1, (double)pathPoint.y1, (double)pathPoint.x2, (double)pathPoint.y2);
                        continue;
                    }
                    if (!pathPoint.type.equals("C")) continue;
                    pdfCanvas.closePath();
                }
                pdfCanvas.endPath();
            }
        }
    }

    private double scaling(ST_Box targetBox, ST_Box currentBox) {
        double scale = 1.0;
        if (targetBox != null && currentBox != null) {
            scale = Math.min(targetBox.getWidth() / currentBox.getWidth(), targetBox.getHeight() / currentBox.getHeight());
        }
        return scale;
    }

    private boolean equals(ST_Box box1, ST_Box box2) {
        if (null == box1 || null == box2) {
            return false;
        }
        return box1.getTopLeftX().equals(box2.getTopLeftX()) && box1.getTopLeftY().equals(box2.getTopLeftY()) && box1.getWidth().equals(box2.getWidth()) && box1.getHeight().equals(box2.getHeight());
    }

    private void writeImage(ResourceManage resMgt, PdfCanvas pdfCanvas, ST_Box box, ImageObject imageObject, ST_Box annotBox, Integer compositeObjectAlpha, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM) throws IOException {
        ST_RefID resourceID = imageObject.getResourceID();
        if (resourceID == null) {
            return;
        }
        byte[] imageByteArray = null;
        try {
            imageByteArray = resMgt.getImageByteArray(resourceID.toString());
        }
        catch (Exception e) {
            System.err.println("\u56fe\u7247ID: " + resourceID + " \u89e3\u6790\u5931\u8d25 \u8df3\u8fc7\uff0c\u539f\u56e0 " + e.getMessage());
        }
        if (imageByteArray == null) {
            return;
        }
        pdfCanvas.saveState();
        PdfImageXObject pdfImageObject = new PdfImageXObject(ImageDataFactory.create((byte[])imageByteArray));
        if (annotBox != null && !this.equals(annotBox, imageObject.getBoundary())) {
            float x = annotBox.getTopLeftX().floatValue();
            float y = box.getHeight().floatValue() - (annotBox.getTopLeftY().floatValue() + annotBox.getHeight().floatValue());
            float width = annotBox.getWidth().floatValue();
            float height = annotBox.getHeight().floatValue();
            Rectangle rect = new Rectangle((float)CommonUtil.converterDpi(x), (float)CommonUtil.converterDpi(y), (float)CommonUtil.converterDpi(width), (float)CommonUtil.converterDpi(height));
            pdfCanvas.addXObject((PdfXObject)pdfImageObject, rect);
        } else {
            Matrix matrix = CommonUtil.toPFMatrix(CommonUtil.getImageMatrixFromOfd(imageObject, box, compositeObjectCTM));
            float a = matrix.getValue(0, 0);
            float b = matrix.getValue(0, 1);
            float c = matrix.getValue(1, 0);
            float d = matrix.getValue(1, 1);
            float e = matrix.getValue(2, 0);
            float f = matrix.getValue(2, 1);
            pdfCanvas.addXObject((PdfXObject)pdfImageObject, a, b, c, d, e, f);
        }
        pdfCanvas.restoreState();
    }

    private void writeSealImage(PdfDocument pdfDocument, PdfCanvas pdfCanvas, ST_Box box, byte[] image, ST_Box sealBox, ST_Box clipBox) throws IOException {
        if (image == null) {
            return;
        }
        float x = sealBox.getTopLeftX().floatValue();
        float y = box.getHeight().floatValue() - (sealBox.getTopLeftY().floatValue() + sealBox.getHeight().floatValue());
        float width = sealBox.getWidth().floatValue();
        float height = sealBox.getHeight().floatValue();
        Rectangle rect = new Rectangle((float)CommonUtil.converterDpi(x), (float)CommonUtil.converterDpi(y), (float)CommonUtil.converterDpi(width), (float)CommonUtil.converterDpi(height));
        BufferedImage bImg = ImageUtils.clearWhiteBackground((BufferedImage)ImageIO.read(new ByteArrayInputStream(image)), (int)244);
        ImageData img = ImageDataFactory.create((Image)bImg, null);
        PdfFormXObject xObject = new PdfFormXObject(new Rectangle(rect.getWidth(), rect.getHeight()));
        PdfCanvas xObjectCanvas = new PdfCanvas(xObject, pdfDocument);
        if (clipBox != null) {
            xObjectCanvas.rectangle(CommonUtil.converterDpi(clipBox.getTopLeftX()), (double)rect.getHeight() - (CommonUtil.converterDpi(clipBox.getTopLeftY()) + CommonUtil.converterDpi(clipBox.getHeight())), CommonUtil.converterDpi(clipBox.getWidth()), CommonUtil.converterDpi(clipBox.getHeight()));
            xObjectCanvas.clip();
            xObjectCanvas.endPath();
        }
        xObjectCanvas.addImage(img, rect.getWidth(), 0.0f, 0.0f, rect.getHeight(), 0.0f, 0.0f);
        com.itextpdf.layout.element.Image clipped = new com.itextpdf.layout.element.Image(xObject);
        Canvas canvas = new Canvas(pdfCanvas, pdfDocument, rect);
        canvas.add(clipped);
        canvas.close();
    }

    private double getTextObjectSize(TextObject textObject) {
        double fontSize = 0.353;
        if (textObject == null) {
            return fontSize;
        }
        try {
            fontSize = textObject.getSize();
        }
        catch (Exception e) {
            fontSize = 0.353;
        }
        return fontSize;
    }

    private void writeText(ResourceManage resMgt, PdfCanvas pdfCanvas, ST_Box box, ST_Box sealBox, ST_Box annotBox, TextObject textObject, Color fillColor, int alpha, Integer compositeObjectAlpha, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM) throws IOException {
        double f;
        double e;
        double d;
        double c;
        Double[] ctm;
        Element e2;
        double scale = this.scaling(sealBox, textObject.getBoundary());
        float fontSize = Double.valueOf(textObject.getSize() * scale).floatValue();
        pdfCanvas.setFillColor(fillColor);
        if (textObject.getFillColor() != null && (e2 = textObject.getFillColor().getOFDElement("AxialShd")) != null) {
            CT_AxialShd ctAxialShd = new CT_AxialShd(e2);
            CT_Color startColor = ((Segment)ctAxialShd.getSegments().get(0)).getColor();
            CT_Color endColor = ((Segment)ctAxialShd.getSegments().get(ctAxialShd.getSegments().size() - 1)).getColor();
            ST_Array start = startColor.getValue();
            ST_Array end = endColor.getValue();
            ST_Pos startPos = ctAxialShd.getStartPoint();
            ST_Pos endPos = ctAxialShd.getEndPoint();
            double x1 = startPos.getX();
            double y1 = startPos.getY();
            double x2 = endPos.getX();
            double y2 = endPos.getY();
            if (textObject.getCTM() != null) {
                double[] newPoint = PointUtil.ctmCalPoint(startPos.getX(), startPos.getY(), textObject.getCTM().toDouble());
                x1 = newPoint[0];
                y1 = newPoint[1];
                newPoint = PointUtil.ctmCalPoint(x2, y2, textObject.getCTM().toDouble());
                x2 = newPoint[0];
                y2 = newPoint[1];
            }
            double[] realPos = PointUtil.adjustPos(box.getWidth(), box.getHeight(), x1, y1, textObject.getBoundary());
            x1 = realPos[0];
            y1 = box.getHeight() - realPos[1];
            realPos = PointUtil.adjustPos(box.getWidth(), box.getHeight(), x2, y2, textObject.getBoundary());
            x2 = realPos[0];
            y2 = box.getHeight() - realPos[1];
            PdfShading.Axial axial = new PdfShading.Axial((PdfColorSpace)new PdfDeviceCs.Rgb(), (float)x1, (float)y1, ColorConvert.pdfRGB(resMgt, startColor).getColorValue(), (float)x2, (float)y2, ColorConvert.pdfRGB(resMgt, endColor).getColorValue());
            PdfPattern.Shading shading = new PdfPattern.Shading((PdfShading)axial);
            pdfCanvas.setFillColorShading(shading);
        }
        PdfExtGState gs1 = new PdfExtGState();
        gs1.setFillOpacity((float)alpha / 255.0f);
        pdfCanvas.setExtGState(gs1);
        if (sealBox != null && textObject.getBoundary() != null) {
            textObject.setBoundary(textObject.getBoundary().getTopLeftX() + sealBox.getTopLeftX(), textObject.getBoundary().getTopLeftY() + sealBox.getTopLeftY(), textObject.getBoundary().getWidth().doubleValue(), textObject.getBoundary().getHeight().doubleValue());
        }
        if (annotBox != null && textObject.getBoundary() != null) {
            textObject.setBoundary(textObject.getBoundary().getTopLeftX() + annotBox.getTopLeftX(), textObject.getBoundary().getTopLeftY() + annotBox.getTopLeftY(), textObject.getBoundary().getWidth().doubleValue(), textObject.getBoundary().getHeight().doubleValue());
        }
        double lineWidth = 0.0;
        if (textObject.getLineWidth() != null) {
            lineWidth = textObject.getLineWidth();
        }
        if (textObject.getCTM() != null) {
            ctm = textObject.getCTM().toDouble();
            double a = ctm[0];
            double b = ctm[1];
            c = ctm[2];
            d = ctm[3];
            e = ctm[4];
            f = ctm[5];
            double sx = a > 0.0 ? Math.signum(a) * Math.sqrt(a * a + c * c) : Math.sqrt(a * a + c * c);
            double angel = Math.atan2(-b, d);
            if (angel != 0.0 || a == 0.0 || d != 1.0) {
                fontSize = (float)((double)fontSize * sx);
                lineWidth *= sx;
            }
        }
        if (compositeObjectCTM != null) {
            ctm = compositeObjectCTM.toDouble();
            double a = ctm[0];
            double b = ctm[1];
            c = ctm[2];
            d = ctm[3];
            e = ctm[4];
            f = ctm[5];
            double sx = a > 0.0 ? Math.signum(a) * Math.sqrt(a * a + c * c) : Math.sqrt(a * a + c * c);
            double angel = Math.atan2(-b, d);
            if (angel != 0.0 || a == 0.0 || d != 1.0) {
                fontSize = (float)((double)fontSize * sx);
                lineWidth *= sx;
            }
        }
        CT_Font ctFont = resMgt.getFont(textObject.getFont().toString());
        FontWrapper<PdfFont> pdfFontWrapper = this.getFont(resMgt.getOfdReader().getResourceLocator(), ctFont);
        PdfFont font = pdfFontWrapper.getFont();
        List<TextCodePoint> textCodePointList = PointUtil.calPdfTextCoordinate(box.getWidth(), box.getHeight(), textObject.getBoundary(), fontSize, textObject.getTextCodes(), textObject.getCGTransforms(), compositeObjectBoundary, compositeObjectCTM, textObject.getCTM() != null, textObject.getCTM(), true, scale);
        double rx = 0.0;
        double ry = 0.0;
        for (int i = 0; i < textCodePointList.size(); ++i) {
            TextCodePoint textCodePoint = textCodePointList.get(i);
            if (i == 0) {
                rx = textCodePoint.x;
                ry = textCodePoint.y;
            }
            pdfCanvas.saveState();
            pdfCanvas.beginText();
            if (textObject.getMiterLimit() > 0.0) {
                pdfCanvas.setMiterLimit(textObject.getMiterLimit().floatValue());
            }
            pdfCanvas.moveText(textCodePoint.getX(), textCodePoint.getY());
            if (textObject.getCTM() != null) {
                Double[] ctm2 = textObject.getCTM().toDouble();
                double a = ctm2[0];
                double b = ctm2[1];
                double c2 = ctm2[2];
                double d2 = ctm2[3];
                double e3 = ctm2[4];
                double f2 = ctm2[5];
                AffineTransform transform = new AffineTransform();
                double angel = Math.atan2(-b, d2);
                transform.rotate(angel, rx, ry);
                pdfCanvas.concatMatrix(transform);
                if (angel == 0.0 && a != 0.0 && d2 == 1.0) {
                    textObject.setHScale(Double.valueOf(a));
                }
            }
            if (textObject.getHScale().floatValue() < 1.0f) {
                AffineTransform transform = new AffineTransform();
                transform.setTransform((double)textObject.getHScale().floatValue(), 0.0, 0.0, 1.0, (double)(1.0f - textObject.getHScale().floatValue()) * textCodePoint.getX(), 0.0);
                pdfCanvas.concatMatrix(transform);
            }
            pdfCanvas.setFontAndSize(font, (float)CommonUtil.converterDpi(fontSize));
            if (textObject.getLineWidth() != null) {
                pdfCanvas.setLineWidth((float)lineWidth);
                pdfCanvas.setFillColor(ColorConstants.BLACK);
                pdfCanvas.setTextRenderingMode(2);
            }
            if (!StringUtils.isBlank(textCodePoint.getGlyph()) && !pdfFontWrapper.isEnableSimilarFontReplace()) {
                String[] glys;
                ArrayList<Glyph> glyphs = new ArrayList<Glyph>();
                for (String gly : glys = textCodePoint.getGlyph().split(" ")) {
                    Glyph g = font.getFontProgram().getGlyphByCode(Integer.parseInt(gly));
                    if (g == null) continue;
                    glyphs.add(g);
                }
                if (glyphs.size() > 0) {
                    pdfCanvas.showText(new GlyphLine(glyphs));
                } else {
                    pdfCanvas.showText(textCodePoint.getText());
                }
            } else {
                pdfCanvas.showText(textCodePoint.getText());
            }
            pdfCanvas.endText();
            pdfCanvas.restoreState();
        }
    }

    private FontWrapper<PdfFont> getFont(ResourceLocator rl, CT_Font ctFont) {
        String key = String.format("%s_%s_%s", ctFont.getFamilyName(), ctFont.attributeValue("FontName"), ctFont.getFontFile());
        if (this.fontCache.containsKey(key)) {
            return this.fontCache.get(key);
        }
        FontWrapper<PdfFont> font = FontLoader.getInstance().loadPDFFontSimilar(rl, ctFont);
        this.fontCache.put(key, font);
        return font;
    }
}

